/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.ScheduleAlerter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.server.util.snmp.SnmpUtil;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class AlertUtil {
    private static final String CLASSNAME;
    public static final String ADAPTER_HOST = "adapter_host";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageID";
    public static final String ALERT_NAME = "alertName";
    public static final String ORIGIN = "origin";
    public static final String HOSTNAME = "hostname";

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.AlertUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
    }

    public static AlertLog getAlertLog(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getAlertLog", (String)"alert");
        }
        AlertLog alertLog = new AlertLog();
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        alertLog.alAlertID = alertDefinition.aldAlertID;
        alertLog.alNotifyUser = alertDefinition.aldNotifyOnLogin;
        alertLog.alProductID = alertDefinition.aldProductID;
        alertLog.alAlertCondition = alertDefinition.aldCondition;
        alertLog.alThresholdType = alertDefinition.aldThresholdType;
        alertLog.alThresholdValue = alertDefinition.aldThresholdValue;
        alertLog.alDbmsType = alert.getDbmsType();
        alertLog.alComputerID = alert.getComputerID();
        alertLog.alResourceID = alert.getResourceID();
        alertLog.alParentID = alert.getParentID();
        alertLog.alResourceType = alert.getResourceType();
        alertLog.alViolatingValue = alert.getViolatingValue();
        alertLog.alPreviousValue = alert.getPreviousValue();
        alertLog.alViolatorID = alert.getViolatorID();
        alertLog.alViolatorType = alert.getViolatorType();
        alertLog.alLastAlertTime = alert.getAlertTime();
        alertLog.alMessage = AlertUtil.getLogMsg(alert, false);
        AlertLog alertLog2 = alertLog;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getAlertLog", (Object)alertLog2);
        }
        return alertLog2;
    }

    public static String getLogMsg(Alert alert) {
        return AlertUtil.getLogMsg(alert, true);
    }

    public static String getLogMsg(Alert alert, boolean bl) {
        String string;
        Object[] objectArray;
        String string2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getLogMsg", (String)"alert, includeAffectedResources");
        }
        if (alert instanceof FabricAlert) {
            string2 = alert.getMessageID();
        } else {
            objectArray = alert.getAlertDefinition();
            string2 = objectArray.getLogMsgID();
        }
        objectArray = alert.getParameters();
        if (string2 != null && string2.equals("ALR0021W")) {
            objectArray[0] = Util.getTranslatedName((String)objectArray[0]);
        }
        if (string2.length() > 0) {
            string = MessageLog.getMessageNoTS((String)string2, (Object[])objectArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append((String)objectArray[n]);
                stringBuffer.append(MessageLog.lineSeparator);
                ++n;
            }
            string = stringBuffer.toString();
        }
        if (alert instanceof FabricAlert && bl && alert.hasAffectedResources()) {
            string = String.valueOf(string) + "\n" + alert.getAffectedHosts();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getLogMsg", (Object)string);
        }
        return string;
    }

    public static TECEvent getTecEvent(Alert alert) throws LocalizableException {
        Object object;
        TECEvent tECEvent;
        block14: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"getTecEvent", (String)"alert");
            }
            String string = HardwareID.getLocalHostName();
            tECEvent = new TECEvent();
            try {
                Object object2;
                AlertDefinition alertDefinition;
                Object object3;
                if (alert instanceof FabricAlert) {
                    tECEvent.setClassName(alert.getTecClass());
                    object = alert.getTecAttributes();
                    object3 = ((Hashtable)object).keys();
                    while (object3.hasMoreElements()) {
                        alertDefinition = (String)object3.nextElement();
                        object2 = (String)((Hashtable)object).get(alertDefinition);
                        tECEvent.setSlot((String)alertDefinition, "\"" + (String)object2 + "\"");
                    }
                } else {
                    object = AlertUtil.getTecClass(alert);
                    if (object == null) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent");
                        }
                        throw new LocalizableException("SRV0207E", null);
                    }
                    tECEvent.setClassName((String)object);
                    object3 = alert.getTecSlotNames();
                    alertDefinition = alert.getParameters();
                    int n = 0;
                    while (n < ((String[])object3).length && n < ((String[])alertDefinition).length) {
                        if (object3[n] != null && alertDefinition[n] != null) {
                            tECEvent.setSlot(object3[n], "'" + alertDefinition[n] + "'");
                        }
                        ++n;
                    }
                    object2 = Server.getAgentManager();
                    String string2 = ((AgentManager)object2).getHostAddress(alert.getComputerID());
                    String string3 = InetAddress.getByName(string2).getHostAddress();
                    tECEvent.setSlot(HOSTNAME, string2);
                    tECEvent.setSlot(ORIGIN, string3);
                }
                tECEvent.setSlot(ADAPTER_HOST, string);
                object = AlertUtil.getTecEventMsg(alert);
                tECEvent.setSlot(MSG, "'" + (String)object + "'");
                object3 = AlertUtil.getTecEventMsgID(alert);
                tECEvent.setSlot(MSG_ID, (String)object3);
                alertDefinition = alert.getAlertDefinition();
                object2 = String.valueOf(alertDefinition.aldCreator) + '.' + alertDefinition.getAldName();
                tECEvent.setSlot(ALERT_NAME, "'" + (String)object2 + "'");
            }
            catch (UnknownHostException unknownHostException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CLASSNAME, (String)"getTecEvent", (Throwable)unknownHostException);
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent");
                }
                throw new NestableException("GEN0106E", null, (Exception)unknownHostException);
            }
            catch (Exception exception) {
                if (!TraceLogger.enableTrace) break block14;
                TraceLogger.exception((String)CLASSNAME, (String)"getTecEvent", (Throwable)exception);
            }
        }
        object = tECEvent;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEvent", (Object)object);
        }
        return object;
    }

    private static String getTecClass(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecClass", (String)"alert");
        }
        String string = null;
        int n = alert.getTrapType();
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        if (n == 20) {
            string = "JobFailure";
        } else if (alertDefinition.aldProductID == 0 || alertDefinition.aldProductID == 3) {
            string = StormAlerter.tecClassNames[n];
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecClass", (Object)string2);
        }
        return string2;
    }

    private static String getTecEventMsg(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecEventMsg", (String)"alert");
        }
        String string = null;
        if (alert instanceof FabricAlert) {
            string = MessageLog.getMessageNoID((String)alert.getMessageID(), (Object[])alert.getMessageParameters());
        } else {
            int n = alert.getTrapType();
            AlertDefinition alertDefinition = alert.getAlertDefinition();
            if (n == 20) {
                string = ScheduleAlerter.FAILED_JOB_EVENT_MSG;
            } else if (alertDefinition.aldProductID == 0 || alertDefinition.aldProductID == 3) {
                string = StormAlerter.tecEventMsgs[n];
            }
        }
        if (string == null) {
            string = "";
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEventMsg", (Object)string2);
        }
        return string2;
    }

    private static String getTecEventMsgID(Alert alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTecEventMsgID", (String)"alert");
        }
        String string = null;
        if (alert instanceof FabricAlert) {
            string = alert.getMessageID();
        } else {
            int n = alert.getTrapType();
            AlertDefinition alertDefinition = alert.getAlertDefinition();
            if (n == 20) {
                string = "ALR1339W";
            } else if (alertDefinition.aldProductID == 0 || alertDefinition.aldProductID == 3) {
                string = StormAlerter.tecEventMsgIDs[n];
            }
        }
        if (string == null) {
            string = "";
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTecEventMsgID", (Object)string2);
        }
        return string2;
    }

    public static SnmpTrap getTrapPdu(Alert alert) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getTrapPdu", (String)"alert");
        }
        SnmpTrap snmpTrap = new SnmpTrap();
        try {
            String string = InetAddress.getLocalHost().getHostAddress();
            snmpTrap.agentAddr = new IPAddress(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CLASSNAME, (String)"getTrapPdu", (Throwable)unknownHostException);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CLASSNAME, (String)"getTrapPdu");
            }
            throw new NestableException("GEN0106E", null, (Exception)unknownHostException);
        }
        snmpTrap.genericTrap = 6;
        snmpTrap.specificTrap = alert.getTrapType();
        long l = alert.getAlertTime() - Server.startTime.getTime();
        snmpTrap.timeStamp = new TimeTicks(l / 10L);
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        if (alert instanceof FabricAlert) {
            boolean bl = false;
            if (alertDefinition.aldProductID == 3) {
                bl = true;
            }
            snmpTrap.enterprise = bl ? SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)0)) : SnmpUtil.tpcFabricOID(alert.getEnterprise());
            Hashtable hashtable = alert.getVarBinds();
            if (hashtable != null && !hashtable.isEmpty()) {
                Object object;
                int[] nArray;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    nArray = (int[])enumeration.nextElement();
                    object = (String)hashtable.get(nArray);
                    if (bl) {
                        snmpTrap.addVarBind(SnmpUtil.tivoliSRMOID(nArray), (Serializable)new OctetString((String)object, true));
                        continue;
                    }
                    snmpTrap.addVarBind(SnmpUtil.tpcFabricOID(nArray), (Serializable)new OctetString((String)object, true));
                }
                nArray = new int[]{1, 1};
                object = new int[]{1, 9};
                int[] nArray2 = new int[]{1, 1, 2};
                String string = alert.getMessageID();
                Object[] objectArray = alert.getMessageParameters();
                String string2 = MessageLog.getMessageNoID((String)string, (Object[])objectArray);
                if (bl) {
                    String string3 = String.valueOf(alertDefinition.aldCreator) + '.' + alertDefinition.getAldName();
                    snmpTrap.addVarBind(SnmpUtil.tivoliSRMOID(nArray2), (Serializable)new OctetString(string3, true));
                } else {
                    snmpTrap.addVarBind(SnmpUtil.tpcFabricOID(nArray), (Serializable)new OctetString(string2, true));
                    snmpTrap.addVarBind(SnmpUtil.tpcFabricOID((int[])object), (Serializable)new OctetString(string, true));
                }
            }
        } else {
            snmpTrap.enterprise = alertDefinition.aldProductID == 3 ? SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)0)) : SnmpUtil.tivoliSRMOID(AlertProductManager.getSnmpOid((short)alertDefinition.aldProductID));
            int[][] nArray = alert.getVarBindOID();
            String[] stringArray = alert.getParameters();
            int n = 0;
            while (n < nArray.length && n < stringArray.length) {
                if (nArray[n] != null && nArray[n].length != 0 && stringArray[n] != null) {
                    snmpTrap.addVarBind(SnmpUtil.tivoliSRMOID(nArray[n]), (Serializable)new OctetString(stringArray[n], true));
                }
                ++n;
            }
        }
        SnmpTrap snmpTrap2 = snmpTrap;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getTrapPdu", (Object)snmpTrap2);
        }
        return snmpTrap2;
    }

    public static Email getEmail(Alert alert) {
        ConfigSettings configSettings;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"getEmail", (String)"alert");
        }
        Email email = null;
        Object[] objectArray = alert.getParameters();
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        AlertEmail alertEmail = alertDefinition.aldEmailDef;
        if (alertEmail != null) {
            String string;
            String string2;
            String string3;
            configSettings = Server.getSettings();
            if (SQLUtil.isNullString(alertEmail.aleSubject)) {
                string3 = alertDefinition.getEmailSubjectID();
                string2 = MessageLog.getMessageNoID((String)string3);
            } else {
                string2 = alertEmail.aleSubject;
            }
            StringBuffer stringBuffer = new StringBuffer(2048);
            if (SQLUtil.isNullString(alertEmail.aleText)) {
                string = alert instanceof FabricAlert ? alert.getMessageID() : alertDefinition.getEmailMsgID();
                string3 = MessageLog.getMessageNoID((String)string, (Object[])objectArray);
                if (alert instanceof FabricAlert && alert.hasAffectedResources()) {
                    string3 = String.valueOf(string3) + "\n" + alert.getAffectedHosts();
                }
            } else {
                Util.formatLine((String)alertEmail.aleText, (StringBuffer)stringBuffer, (Object[])objectArray);
                string3 = stringBuffer.toString();
            }
            string = MessageLog.getMessageNoID((String)"ALR1200L", (Object)AlertProductManager.getName((short)alertDefinition.aldProductID), (Object)Server.getServerHostName());
            email = new Email(string2, string3, string, configSettings.csSmtp.ssReplyTo, configSettings.csSmtp.ssReturn, configSettings.csSmtp.ssDfltDomain);
            AlertUtil.addRecipients(email, alertEmail);
        }
        configSettings = email;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"getEmail", (Object)configSettings);
        }
        return configSettings;
    }

    private static void addRecipients(Email email, AlertEmail alertEmail) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"addRecipients", (String)"email, emailDef");
        }
        ArrayList arrayList = alertEmail.parseRecipients();
        int n = 0;
        while (n < arrayList.size()) {
            email.addRecipient((String)arrayList.get(n));
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"addRecipients");
        }
    }
}

