/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.aperi.logging.TraceLogger;

public class ComputerHashTable {
    private int hashTableSize;
    private HashAnchor[] hashTable;
    private static final int DEFAULT_HASH_TABLE_SIZE = 53;

    public ComputerHashTable() {
        this(53);
    }

    public ComputerHashTable(int n) {
        this.hashTableSize = n;
        this.hashTable = new HashAnchor[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.hashTable[n2] = new HashAnchor();
            --n2;
        }
    }

    public HashedComputer get(int n) {
        HashAnchor hashAnchor;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"get", (String)"computerID");
        }
        Object object = null;
        if (n >= 0) {
            hashAnchor = this.getHashAnchor(n);
            HashedComputer hashedComputer = hashAnchor.head;
            int n2 = hashAnchor.count;
            while (n2 > 0) {
                if (hashedComputer.computerID == n) {
                    object = hashedComputer;
                    break;
                }
                hashedComputer = hashedComputer.nextElement;
                --n2;
            }
        }
        hashAnchor = object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"get", (Object)hashAnchor);
        }
        return hashAnchor;
    }

    public synchronized void add(HashedComputer hashedComputer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"add", (String)"computer");
        }
        HashAnchor hashAnchor = this.getHashAnchor(hashedComputer.computerID);
        hashedComputer.nextElement = null;
        if (hashAnchor.tail == null) {
            hashAnchor.head = hashedComputer;
        } else {
            hashAnchor.tail.nextElement = hashedComputer;
        }
        hashAnchor.tail = hashedComputer;
        ++hashAnchor.count;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int n) {
        HashedComputer hashedComputer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"computerID");
        }
        if ((hashedComputer = this.get(n)) != null) {
            HashedComputer hashedComputer2 = hashedComputer;
            synchronized (hashedComputer2) {
                hashedComputer.computerID = Integer.MIN_VALUE;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }

    private HashAnchor getHashAnchor(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getHashAnchor", (String)"computerID");
        }
        int n2 = n % this.hashTableSize;
        HashAnchor hashAnchor = this.hashTable[n2];
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getHashAnchor", (Object)hashAnchor);
        }
        return hashAnchor;
    }

    public Iterator getIterator() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIterator", (String)"");
        }
        ComputerIterator computerIterator = new ComputerIterator();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ComputerHashTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIterator", (Object)computerIterator);
        }
        return computerIterator;
    }

    public static class HashedComputer {
        public HashedComputer nextElement;
        public int computerID;
    }

    private static class HashAnchor {
        public int count;
        public HashedComputer head;
        public HashedComputer tail;

        private HashAnchor() {
        }
    }

    private class ComputerIterator
    implements Iterator {
        int hashIndex = -1;
        int computerCount = 0;
        HashedComputer nextComputer = null;

        private ComputerIterator() {
        }

        public boolean hasNext() {
            if (this.computerCount > 0) {
                return true;
            }
            while (++this.hashIndex < ComputerHashTable.this.hashTableSize && ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].count == 0) {
            }
            if (this.hashIndex < ComputerHashTable.this.hashTableSize) {
                this.computerCount = ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].count;
                this.nextComputer = ((ComputerHashTable)ComputerHashTable.this).hashTable[this.hashIndex].head;
                return true;
            }
            return false;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.computerCount;
            HashedComputer hashedComputer = this.nextComputer;
            this.nextComputer = hashedComputer.nextElement;
            return hashedComputer;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

