/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupDefHndlr
implements RequestHandler,
ThrowAway {
    private static final String RESOURCE_TYPE = "GROUP";
    public static short MONITORING_GROUP = 1;
    public static short REPORTING_GROUP = (short)2;
    private GroupDefinition requestData;
    private Response response;
    private Connection dbc;
    private String objectType;

    private NameList getCurrentMembers() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCurrentMembers", (String)"");
        }
        NameList nameList = null;
        if (GroupDefHndlr.whichGroup(this.requestData.groupType) == MONITORING_GROUP) {
            object = new GuiListReq();
            ((GuiListReq)object).groupID = this.requestData.ID;
            NameListQueryable nameListQueryable = this.getAccessor(ResourceTypeManager.getGroupAcessor((short)this.requestData.groupType), this.dbc);
            if (this.requestData.groupType == 0) {
                ((GuiListReq)object).includeUnmanaged = true;
            }
            ((GuiListReq)object).listRequested = this.requestData.groupType + 1;
            nameList = nameListQueryable.selectNames((GuiListReq)object);
        } else {
            object = new TGroup2Res(this.dbc);
            nameList = ((TGroup2Res)object).getMembers(this.requestData.ID, this.requestData.groupType);
        }
        object = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCurrentMembers", (Object)object);
        }
        return object;
    }

    private NameList getCurrentMasks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCurrentMasks", (String)"");
        }
        TGroup2Mask tGroup2Mask = new TGroup2Mask(this.dbc);
        NameList nameList = tGroup2Mask.retrieveMasksByGID(this.requestData.ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCurrentMasks", (Object)nameList);
        }
        return nameList;
    }

    private void retrieve(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"subtype");
        }
        TGroup tGroup = new TGroup(this.dbc);
        tGroup.retrieve((CreateHeader)this.requestData, this.objectType);
        tGroup = null;
        if (string.equals("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Information")) {
            TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
            this.requestData.members = tGroup2Res.getFSforComputer(this.requestData.members, this.requestData.ID, this.requestData.groupType);
        } else {
            this.requestData.members = this.getCurrentMembers();
            if ((GroupDefHndlr.whichGroup(this.requestData.groupType) == REPORTING_GROUP || this.requestData.groupType == 98) && this.requestData.groupType != 99) {
                this.requestData.maskList = this.getCurrentMasks();
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        Object object;
        Object object2;
        NameList nameList;
        NameList nameList2;
        Object object3;
        MutableInteger mutableInteger;
        RaceConditionChecker raceConditionChecker;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
        }
        String string = null;
        Object object4 = null;
        NameList nameList3 = null;
        Object object5 = null;
        NameList nameList4 = null;
        if (this.requestData.ID <= 0) {
            this.requestData.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            bl = false;
        } else {
            raceConditionChecker = new RaceConditionChecker(this.dbc, "t_group", "group_id", (CreateHeader)this.requestData, this.objectType);
            raceConditionChecker.check();
            string = raceConditionChecker.message;
            bl = !raceConditionChecker.wasDeleted;
            raceConditionChecker = null;
            if (bl) {
                object4 = this.getCurrentMembers();
                if (GroupDefHndlr.whichGroup(this.requestData.groupType) == REPORTING_GROUP) {
                    nameList4 = this.getCurrentMasks();
                }
            }
        }
        raceConditionChecker = this.requestData.members;
        HashMap<MutableInteger, NameList> hashMap = new HashMap<MutableInteger, NameList>();
        while (object4 != null) {
            mutableInteger = new MutableInteger(object4.nlID);
            hashMap.put(mutableInteger, (NameList)object4);
            object4 = object4.nlNext;
        }
        NameList nameList5 = null;
        mutableInteger = new MutableInteger();
        object4 = raceConditionChecker;
        while (object4 != null) {
            mutableInteger.value = object4.nlID;
            if (hashMap.remove(mutableInteger) == null) {
                object3 = (NameList)object4.clone();
                ((NameList)object3).nlNext = nameList5;
                nameList5 = object3;
                if (nameList5.nlNext == null) {
                    nameList3 = nameList5;
                }
            }
            object4 = object4.nlNext;
        }
        object3 = hashMap.values().iterator();
        while (object3.hasNext()) {
            nameList2 = (NameList)object3.next();
            nameList2.nlNext = object4;
            object4 = nameList2;
            if (object4.nlNext != null) continue;
            object5 = object4;
        }
        hashMap = null;
        NameList nameList6 = nameList = nameList5;
        while (nameList6 != null) {
            int n = 0;
            while (nameList != null) {
                if (nameList6.nlID == nameList.nlID) {
                    ++n;
                }
                nameList = nameList.nlNext;
            }
            if (n > 1) {
                String string2 = MessageLog.getMessage((String)"SRV0162E");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"save");
                }
                throw new GeneralException(string2);
            }
            nameList6 = nameList6.nlNext;
        }
        nameList2 = null;
        NameList nameList7 = null;
        Object object6 = null;
        NameList nameList8 = null;
        hashMap = new HashMap();
        nameList2 = nameList4;
        while (nameList2 != null) {
            object2 = nameList2.nlName;
            mutableInteger = new MutableInteger(((String)object2).hashCode());
            hashMap.put(mutableInteger, nameList2);
            nameList2 = nameList2.nlNext;
        }
        mutableInteger = new MutableInteger();
        nameList2 = this.requestData.maskList;
        while (nameList2 != null) {
            object2 = nameList2.nlName;
            mutableInteger = new MutableInteger(((String)object2).hashCode());
            if (hashMap.remove(mutableInteger) == null) {
                object = (NameList)nameList2.clone();
                ((NameList)object).nlNext = nameList7;
                nameList7 = object;
            } else {
                object = (NameList)nameList2.clone();
                ((NameList)object).nlNext = nameList8;
                nameList8 = object;
            }
            nameList2 = nameList2.nlNext;
        }
        object3 = hashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (NameList)object3.next();
            ((NameList)object2).nlNext = object6;
            object6 = object2;
        }
        hashMap = null;
        object2 = new TGroup(this.dbc);
        if (bl) {
            ((TGroup)object2).deleteByID(this.requestData.ID, this.objectType);
        }
        ((TGroup)object2).insert((CreateHeader)this.requestData, this.requestData.groupType, this.objectType);
        if (GroupDefHndlr.whichGroup(this.requestData.groupType) == MONITORING_GROUP) {
            if (object4 != null) {
                ((TGroup)object2).setGroup(ResourceTypeManager.getGroupTable((short)this.requestData.groupType), ResourceTypeManager.getGroupIdColumn((short)this.requestData.groupType), ResourceTypeManager.getDefaultGroup((short)this.requestData.groupType), (NameList)object4);
            }
            if (nameList5 != null) {
                ((TGroup)object2).setGroup(ResourceTypeManager.getGroupTable((short)this.requestData.groupType), ResourceTypeManager.getGroupIdColumn((short)this.requestData.groupType), this.requestData.ID, nameList5);
            }
            if (this.requestData.groupType == 77 || this.requestData.groupType == 113 || this.requestData.groupType == 133) {
                ((RepositoryAccessor)object2).commit();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"save");
                }
                return;
            }
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz;
            object = bl ? "Modify group" : "Create group";
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz.getName(), (String)"save()", (String)("\n Username=" + this.requestData.creator + " " + (String)object + ".  Group name='" + this.requestData.getName() + "'"));
        }
        object = new TGroup2Mask(this.dbc);
        ((TGroup2Mask)object).handleInsertDelete(this.requestData.ID, nameList7, (NameList)object6, false);
        if (nameList7 != null) {
            if (nameList5 != null) {
                nameList3.nlNext = this.resolveMaskMembers(nameList8, nameList7);
            } else {
                nameList5 = this.resolveMaskMembers(nameList8, nameList7);
            }
        }
        if (object6 != null) {
            if (object4 != null) {
                object5.nlNext = this.resolveMaskMembers(nameList8, (NameList)object6);
            } else {
                object4 = this.resolveMaskMembers(nameList8, (NameList)object6);
            }
        }
        try {
            TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
            tGroup2Res.addRemoveResources(this.requestData.ID, this.requestData.groupType, nameList5, (NameList)object4, true);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
            }
            if (!bl) {
                ((TGroup)object2).deleteByID(this.requestData.ID, this.objectType);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"save");
            }
            throw generalException;
        }
        ((RepositoryAccessor)object2).commit();
        if (this.requestData.groupType == 0 || this.requestData.groupType == 2) {
            ScheduleQueue.routine.rebuild();
        }
        if (string != null) {
            this.response.status = (short)4;
            this.response.errorMessage = string;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    private NameList resolveMaskMembers(NameList nameList, NameList nameList2) throws GeneralException {
        NameList nameList3;
        MutableInteger mutableInteger;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resolveMaskMembers", (String)"currMasks, newMasks");
        }
        NameList nameList4 = null;
        NameList nameList5 = null;
        NameList nameList6 = null;
        TGroup2Mask tGroup2Mask = new TGroup2Mask(this.dbc);
        nameList4 = tGroup2Mask.getResourcesForList(nameList);
        nameList5 = tGroup2Mask.getResourcesForList(nameList2);
        HashMap<MutableInteger, NameList> hashMap = new HashMap<MutableInteger, NameList>();
        while (nameList5 != null) {
            mutableInteger = new MutableInteger(nameList5.nlID);
            hashMap.put(mutableInteger, nameList5);
            nameList5 = nameList5.nlNext;
        }
        mutableInteger = new MutableInteger();
        nameList6 = nameList4;
        while (nameList6 != null) {
            mutableInteger.value = nameList6.nlID;
            hashMap.remove(mutableInteger);
            nameList6 = nameList6.nlNext;
        }
        nameList6 = null;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            nameList3 = (NameList)iterator.next();
            nameList3.nlNext = nameList6;
            nameList6 = nameList3;
        }
        hashMap = null;
        nameList3 = nameList6;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resolveMaskMembers", (Object)nameList3);
        }
        return nameList3;
    }

    public static String translateGroup(short s, Response response) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"translateIndex", (String)"groupType, response");
        }
        if ((string = ResourceTypeManager.getGroupLabel((short)s)) == null) {
            Server.setResponseError(response, "STS0105E", new Object[]{s});
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"translateIndex", (Object)string);
        }
        return string;
    }

    public static short whichGroup(short s) {
        short s2 = 0;
        if (s == 2 || s == 0 || s == 77 || s == 113 || s == 133) {
            s2 = MONITORING_GROUP;
        } else if (s == 89 || s == 90 || s == 99) {
            s2 = REPORTING_GROUP;
        }
        return s2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createGroupWithMembers(GroupDefinition groupDefinition, String string) throws GeneralException {
        block15: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"createGroupWithMembers", (String)"def, groupName");
            }
            this.requestData = groupDefinition;
            String string2 = Integer.toString(this.requestData.ID);
            LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)string2, (byte)1, (boolean)true);
            this.dbc = Server.getConnection();
            try {
                block14: {
                    try {
                        TGroup tGroup = new TGroup(this.dbc);
                        tGroup.insert((CreateHeader)this.requestData, this.requestData.groupType, string);
                        TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
                        tGroup2Res.addRemoveResources(this.requestData.ID, this.requestData.groupType, this.requestData.members, null, true);
                        tGroup.commit();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block14;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"createGroupWithMembers", (Throwable)generalException);
                    }
                }
                Object var6_9 = null;
                if (string2 == null) break block15;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (string2 != null) {
                    LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string2);
                }
                Server.returnConnection(this.dbc);
                throw throwable;
            }
            LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string2);
        }
        Server.returnConnection(this.dbc);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createGroupWithMembers");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        block32: {
            String string;
            boolean bl;
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
            }
            this.response = Response.getResponse((short)0, null);
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.GroupDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            this.requestData = (GroupDefinition)request.requestData;
            this.objectType = GroupDefHndlr.translateGroup(this.requestData.groupType, this.response);
            if (this.objectType == null) {
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            this.dbc = Server.getConnection();
            if (request.subType.equals("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Information")) {
                bl = true;
            } else {
                boolean bl2 = bl = this.requestData.members == null && this.requestData.maskList == null && this.requestData.ID > 0;
            }
            if (this.requestData.ID <= 0) {
                string = null;
            } else {
                string = Integer.toString(this.requestData.ID);
                byte by = bl ? (byte)2 : 1;
                LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)string, (byte)by, (boolean)true);
            }
            try {
                try {
                    if (bl) {
                        this.retrieve(request.subType);
                    } else {
                        this.save();
                    }
                    this.response.responseData = this.requestData;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)generalException);
                    }
                    if (this.response.status <= 4) {
                        this.response.status = (short)12;
                    }
                    this.response.errorMessage = generalException.getMessage();
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (string != null) {
                    LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string);
                }
                Server.returnConnection(this.dbc);
                throw throwable;
            }
            {
                Object var6_12 = null;
                if (string == null) break block32;
            }
            LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string);
        }
        Server.returnConnection(this.dbc);
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private NameListQueryable getAccessor(Class clazz, Connection connection) throws GeneralException {
        try {
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor2 = constructorArray[n];
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length == 1) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("java.sql.Connection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    if (classArray[0].equals(clazz2)) {
                        constructor = constructor2;
                        break;
                    }
                }
                ++n;
            }
            if (constructor != null) {
                return (NameListQueryable)constructor.newInstance(connection);
            }
            return (NameListQueryable)clazz.newInstance();
        }
        catch (Exception exception) {
            GeneralException generalException = new GeneralException();
            generalException.initCause((Throwable)exception);
            throw generalException;
        }
    }
}

