/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.server.jobs.Aggregator;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupDeleteHndlr
implements RequestHandler,
ThrowAway,
Runnable {
    private int groupID;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.common.NameList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        NameList nameList = (NameList)request.requestData;
        String string = GroupDefHndlr.translateGroup(nameList.nlInfo, response);
        if (string == null) {
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response3);
            }
            return response3;
        }
        this.groupID = nameList.nlID;
        LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)1, (boolean)true);
        Connection connection = Server.getConnection();
        try {
            try {
                int n;
                RepositoryAccessor repositoryAccessor;
                if (GroupDefHndlr.whichGroup(nameList.nlInfo) == GroupDefHndlr.MONITORING_GROUP) {
                    repositoryAccessor = new TGroup(connection);
                    ((TGroup)repositoryAccessor).revertToDefaultGroup(ResourceTypeManager.getGroupTable((short)nameList.nlInfo), this.groupID, ResourceTypeManager.getDefaultGroup((short)nameList.nlInfo));
                    repositoryAccessor = new TGroup(connection);
                    ((TGroup)repositoryAccessor).deleteByID(this.groupID, string);
                    repositoryAccessor = null;
                    TGroup2Res tGroup2Res = new TGroup2Res(connection);
                    tGroup2Res.deleteResources(this.groupID, nameList.nlInfo, true);
                    TResAttr tResAttr = new TResAttr(connection);
                    tResAttr.prepDelete();
                    ResourceAttribute resourceAttribute = new ResourceAttribute();
                    resourceAttribute.raResourceID = this.groupID;
                    resourceAttribute.raResourceType = nameList.nlInfo;
                    tResAttr.delete(resourceAttribute);
                } else {
                    repositoryAccessor = new TGroup2Res(connection);
                    ((TGroup2Res)repositoryAccessor).deleteResources(this.groupID, nameList.nlInfo, true);
                    TGroup2Mask tGroup2Mask = new TGroup2Mask(connection);
                    tGroup2Mask.deleteMasksByGID(this.groupID, false);
                    TGroup tGroup = new TGroup(connection);
                    tGroup.deleteByID(this.groupID, string);
                    tGroup.commit();
                }
                if (TraceLogger.enableAudit) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.auditMessage((String)clazz5.getName(), (String)"handle()", (String)("\n Username=" + request.userName + "Delete Group.  Group name='" + nameList.nlName + "'"));
                }
                if ((n = ResourceTypeManager.getDefaultGroup((short)nameList.nlInfo)) == 3 || n == 4) {
                    ScheduleQueue.routine.rebuild();
                }
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz6.getName(), (String)"handle", (Throwable)generalException);
                }
                Server.setResponseError(response, (Exception)((Object)generalException));
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            Server.returnConnection(connection);
            LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
            throw throwable;
        }
        {
            Object var11_21 = null;
        }
        Server.returnConnection(connection);
        LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
        if ((nameList.nlInfo == 2 || nameList.nlInfo == 0) && response.status <= 4) {
            TSThread tSThread = new TSThread(Thread.currentThread().getThreadGroup(), (Runnable)this);
            tSThread.start();
        }
        Response response4 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)response4);
        }
        return response4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        String string = " WHERE filesystem_id = " + Integer.toString(this.groupID);
        Connection connection = Server.getConnection();
        try {
            try {
                StorageRepositoryAccessor storageRepositoryAccessor = new StorageRepositoryAccessor(connection);
                int n = 0;
                while (n < Aggregator.AGGREGATED_FS_HISTORY.length) {
                    storageRepositoryAccessor.delete(Aggregator.AGGREGATED_FS_HISTORY[n], string);
                    ++n;
                }
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)generalException);
                }
                MessageLog.getThreadLog().println(generalException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        Server.returnConnection(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GroupDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }
}

