/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CommunitiesSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResIpAddresses;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiDiscoveryHndlr
implements RequestHandler,
ThrowAway {
    private String scheduleType;
    private ProbePing requestData;
    private Connection dbc;
    private Response response;
    private final String RES_CIMOM_DISCOVERY_KEY = "SLP Directory agent IP";
    private final String RES_SNMP_DISCOVERY_KEY = "SNMP TRAP IP";

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"");
        }
        TSchedule tSchedule = new TSchedule(this.dbc);
        tSchedule.retrieve((ScheduleHeader)this.requestData, this.scheduleType);
        tSchedule = null;
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        tAlertDefinition.prepSelectByID(false, false);
        this.requestData.pbAlert = tAlertDefinition.getByID(this.requestData.ID);
        tAlertDefinition.closeSelect();
        switch (this.requestData.jobType) {
            case 32: {
                try {
                    TStormSettings tStormSettings = new TStormSettings(this.dbc);
                    Settings settings = tStormSettings.getSettings();
                    this.requestData.pbAllComputers = !settings.seNoWkstaDiscovery;
                    TSnmpCommunity tSnmpCommunity = new TSnmpCommunity(this.dbc);
                    this.requestData.pbSnmpCommunities = tSnmpCommunity.getCommunities();
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
            case 104: {
                try {
                    NameList nameList;
                    GuiListReq guiListReq = new GuiListReq();
                    String string = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SLP Directory agent IP");
                    guiListReq.listRequested = Integer.parseInt(string);
                    TResIpAddresses tResIpAddresses = new TResIpAddresses();
                    this.requestData.pbManualSlpDAs = nameList = tResIpAddresses.selectNames(guiListReq);
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
            case 105: {
                try {
                    NameList nameList;
                    GuiListReq guiListReq = new GuiListReq();
                    String string = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
                    guiListReq.listRequested = Integer.parseInt(string);
                    TResIpAddresses tResIpAddresses = new TResIpAddresses();
                    this.requestData.pbSnmpIPAddresses = nameList = tResIpAddresses.selectNames(guiListReq);
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
        }
        String string = null;
        RaceConditionChecker raceConditionChecker = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.requestData, this.scheduleType);
        raceConditionChecker.check();
        string = raceConditionChecker.message;
        boolean bl = !raceConditionChecker.wasDeleted;
        raceConditionChecker = null;
        this.requestData.alertID = this.requestData.ID;
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        if (bl) {
            tAlertDefinition.deleteByID(this.requestData.ID);
        }
        tAlertDefinition.insert((CreateHeader)this.requestData, this.requestData.pbAlert);
        tAlertDefinition = null;
        TSchedule tSchedule = new TSchedule(this.dbc);
        if (bl) {
            tSchedule.deleteByID(this.requestData.ID, this.scheduleType);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.requestData);
        tSchedule.insert((ScheduleHeader)this.requestData, this.scheduleType);
        tSchedule.commit();
        tSchedule = null;
        switch (this.requestData.jobType) {
            case 32: {
                try {
                    Settings settings = new Settings();
                    settings.seNoWkstaDiscovery = !this.requestData.pbAllComputers;
                    TStormSettings tStormSettings = new TStormSettings(this.dbc);
                    tStormSettings.updateDiscovery(settings);
                    CommunitiesSaver.save(this.dbc, this.requestData.pbSnmpCommunities);
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
            case 104: {
                try {
                    TResIpAddresses tResIpAddresses = new TResIpAddresses();
                    String string2 = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SLP Directory agent IP");
                    tResIpAddresses.update(this.requestData.pbManualSlpDAs, Integer.parseInt(string2));
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
            case 105: {
                try {
                    TResIpAddresses tResIpAddresses = new TResIpAddresses();
                    String string3 = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
                    tResIpAddresses.update(this.requestData.pbSnmpIPAddresses, Integer.parseInt(string3));
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)generalException);
                    }
                    throw generalException;
                }
            }
        }
        if (bl) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.requestData);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.requestData);
        }
        if (string != null) {
            this.response.status = (short)4;
            this.response.errorMessage = string;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.common.ProbePing");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
            Response response = this.response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        this.requestData = (ProbePing)request.requestData;
        boolean bl = this.requestData.ID == 0;
        boolean bl2 = false;
        switch (this.requestData.jobType) {
            case 32: {
                this.requestData.ID = 100;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0122L");
                break;
            }
            case 104: {
                if (!bl && this.requestData.validateIPs) {
                    bl2 = this.validateIPs(this.requestData.pbManualSlpDAs, this.response, "SLP Directory agent IP");
                    break;
                }
                this.requestData.ID = 110;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0182L");
                break;
            }
            case 105: {
                this.requestData.ID = 111;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0183L");
                break;
            }
            case 31: {
                this.requestData.ID = 101;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0127L");
                break;
            }
            default: {
                Server.setResponseError(this.response, "STS0136E", Integer.toString(this.requestData.jobType));
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
        }
        if (this.requestData.jobType == 104 && !bl && this.requestData.validateIPs && !bl2) {
            this.response.responseData = this.requestData;
            Response response = this.response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        this.dbc = Server.getConnection();
        try {
            try {
                if (bl) {
                    this.retrieve();
                } else {
                    this.save();
                }
                this.response.responseData = this.requestData;
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz6.getName(), (String)"handle", (Throwable)generalException);
                }
                Server.setResponseError(this.response, (Exception)((Object)generalException));
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            Server.returnConnection(this.dbc);
            throw throwable;
        }
        {
            Object var6_12 = null;
        }
        Server.returnConnection(this.dbc);
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private boolean validateIPs(NameList nameList, Response response, String string) {
        String string2;
        boolean bl = false;
        NameList nameList2 = null;
        NameList nameList3 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"validateIPs", (String)"ipList, response, key");
        }
        if ((nameList3 = this.removeDuplicateIPs(nameList2 = this.readIPs(string), nameList)) != null) {
            NameList nameList4 = nameList3;
            while (nameList4 != null) {
                n = this.pingHostByName(nameList4.nlName);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        string2 = new NameList();
                        ((NameList)string2).nlName = nameList4.nlName;
                        ((NameList)string2).nlNext = string3;
                        string3 = string2;
                        break;
                    }
                    default: {
                        string2 = new NameList();
                        ((NameList)string2).nlName = nameList4.nlName;
                        ((NameList)string2).nlNext = string4;
                        string4 = string2;
                    }
                }
                nameList4 = nameList4.nlNext;
            }
        }
        if (string4 != null) {
            string2 = this.getMachineNames((NameList)string4);
            Server.setResponseError(response, string2.indexOf(44) == -1 ? "SRV0752E" : "SRV0753E", string2);
        } else if (string3 != null) {
            string2 = this.getMachineNames((NameList)string3);
            Server.setResponseWarning(response, string2.indexOf(44) == -1 ? "SRV0750W" : "SRV0751W", string2);
        } else {
            bl = true;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"validateIPs", (boolean)bl);
        }
        return bl;
    }

    private NameList readIPs(String string) {
        NameList nameList = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"readIPs", (String)string);
        }
        if (string != null) {
            try {
                GuiListReq guiListReq = new GuiListReq();
                TResIpAddresses tResIpAddresses = new TResIpAddresses();
                String string2 = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)string);
                guiListReq.listRequested = Integer.parseInt(string2);
                nameList = tResIpAddresses.selectNames(guiListReq);
            }
            catch (GeneralException generalException) {
                MessageLog.logException((StorageException)((Object)generalException));
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"readIPs", nameList);
        }
        return nameList;
    }

    private NameList removeDuplicateIPs(NameList nameList, NameList nameList2) {
        NameList nameList3 = NameList.cloneNameList((NameList)nameList2);
        NameList nameList4 = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeDuplicateIPs", (String)"readIPs, passedIPs");
        }
        if (nameList != null) {
            nameList3 = null;
            while (nameList2 != null) {
                nameList4 = NameList.cloneNameList((NameList)nameList2);
                NameList nameList5 = nameList;
                while (nameList5 != null) {
                    if (nameList4.nlName.compareTo(nameList5.nlName) == 0) {
                        nameList4 = null;
                        break;
                    }
                    nameList5 = nameList5.nlNext;
                }
                if (nameList4 != null) {
                    nameList4.nlNext = nameList3;
                    nameList3 = nameList4;
                }
                nameList2 = nameList2.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeDuplicateIPs", (Object)nameList3);
        }
        return nameList3;
    }

    private int pingHostByName(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pingHostByName", (String)string);
        }
        int n = Ping.pingHostByName(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pingHostByName", (int)n);
        }
        return n;
    }

    private String getMachineNames(NameList nameList) {
        String string = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMachineNames", (String)"ipList");
        }
        if (nameList != null) {
            NameList nameList2 = nameList;
            while (nameList2 != null) {
                string = string == null ? nameList2.nlName : String.valueOf(string) + nameList2.nlName;
                if (nameList2.nlNext != null) {
                    string = String.valueOf(string) + ", ";
                }
                nameList2 = nameList2.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMachineNames", (Object)string);
        }
        return string;
    }
}

