/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Renamer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class RenameHndlr
implements RequestHandler,
ThrowAway {
    private static final String T_SCHEDULE = "t_schedule";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Renamer renamer;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.common.Rename");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        Rename rename = (Rename)request.requestData;
        String string = ResourceTypeManager.getRenameLabel((short)rename.rnObjectType);
        String string2 = ResourceTypeManager.getRenameTable((short)rename.rnObjectType);
        String string3 = ResourceTypeManager.getRenameIdColumn((short)rename.rnObjectType);
        if (string == null || string2 == null || string3 == null) {
            Object[] objectArray = new Object[]{new Integer(rename.rnObjectType)};
            Server.setResponseError(response, "SRV0099E", objectArray);
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response3);
            }
            return response3;
        }
        Connection connection = Server.getConnection();
        try {
            try {
                if (ResourceTypeManager.getRenameHasAlert((short)rename.rnObjectType)) {
                    new Renamer(connection, "t_alert_definition", "alert_id", MessageLog.getMessageNoID((String)"STS0109L")).rename(rename, false);
                }
                renamer = new Renamer(connection, string2, string3, string);
                response.responseData = renamer.rename(rename, true);
                if (TraceLogger.enableAudit) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.auditMessage((String)clazz5.getName(), (String)"handle()", (String)("\n Username=" + rename.rnModifyingUser + " Rename. " + "Definition type='" + string + "'.  Old name='" + rename.rnOldName + "' New name='" + rename.rnNewName + "'."));
                }
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz6.getName(), (String)"handle", (Throwable)generalException);
                }
                Server.setResponseError(response, (Exception)((Object)generalException));
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        Server.returnConnection(connection);
        if (string2.equals(T_SCHEDULE)) {
            ScheduleQueue.routine.addRename(rename.rnID, rename.rnNewName);
        }
        renamer = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.server.RenameHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)renamer);
        }
        return renamer;
    }
}

