/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.ProbeLock;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbeTape
implements ServerJob {
    private static final String DEVICE_METHOD = "probeTapeLibraries";
    private Connection dbc;
    private JobRun jobRun;

    public ExecProbeTape(Connection connection) {
        this.initialize(connection);
    }

    public ExecProbeTape() {
    }

    public void initialize(Connection connection) {
        this.dbc = connection;
    }

    public int run(VMJobResults vMJobResults, String[] stringArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"job, parms");
        }
        this.jobRun = vMJobResults.getJobRun();
        int n = this.doProbe(this.jobRun.getSchedID());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n);
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doProbe(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"doProbe", (String)"scheduleID");
        }
        int n2 = 0;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Server.getServerHostName();
        request.userName = null;
        request.flags = 0;
        Response response = null;
        ScanDefReq scanDefReq = new ScanDefReq();
        scanDefReq.scheduleID = n;
        scanDefReq.computerID = new ComputerID(Server.getServerComputerID());
        request.requestData = scanDefReq;
        response = ProbeDefHndlr.getTapeLibraryProbeDef(scanDefReq, this.dbc);
        if (response == null || response.status > 4 || !(response.responseData instanceof ProbeDefResp)) {
            MessageLog.logMessage((String)"GEN0403E");
            int n3 = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"doProbe", (int)n3);
            }
            return n3;
        }
        ProbeDefResp probeDefResp = (ProbeDefResp)response.responseData;
        probeDefResp.pdProbeLocal = false;
        LinkedInteger linkedInteger = ProbeLock.lock((ProbeDefResp)probeDefResp, null);
        if (linkedInteger == null) {
            int n4 = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"doProbe", (int)n4);
            }
            return n4;
        }
        try {
            MessageLog.logMessage((String)"GEN0404I");
            n2 = this.probeAll(probeDefResp);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            ProbeLock.unlock((LinkedInteger)linkedInteger);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        ProbeLock.unlock((LinkedInteger)linkedInteger);
        if (n2 == 0) {
            MessageLog.logMessage((String)"GEN0401I");
        } else if (n2 > 4) {
            MessageLog.logMessage((String)"GEN0400I");
        } else {
            MessageLog.logMessage((String)"GEN0402I");
        }
        int n5 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeTape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"doProbe", (int)n5);
        }
        return n5;
    }

    private int probeAll(ProbeDefResp probeDefResp) {
        AsyncResult asyncResult;
        String string;
        Class<?> clazz;
        Class<?> clazz2;
        int n = 0;
        NasFiler nasFiler = probeDefResp.pdNasFiler;
        while (nasFiler != null) {
            ++n;
            nasFiler = nasFiler.nfNext;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        nasFiler = probeDefResp.pdNasFiler;
        while (nasFiler != null) {
            stringArray[n2++] = nasFiler.nfName;
            nasFiler = nasFiler.nfNext;
        }
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IJobMgmtService iJobMgmtService = (IJobMgmtService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz2, (String)"FabricManagerService");
        if (iJobMgmtService == null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz3.getName());
            return 8;
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiscover iDiscover = (IDiscover)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiscoverService");
        if (iDiscover == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz4.getName());
            return 8;
        }
        try {
            Class<?> clazz5;
            String string2 = this.jobRun.getSchedCreator();
            string = this.jobRun.getSchedName();
            String string3 = this.jobRun.getFormattedRunNumberSchedID();
            String string4 = this.jobRun.getJobName();
            try {
                clazz5 = Class.forName("org.eclipse.aperi.tape.api.ITapeManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            asyncResult = (AsyncResult)iDiscover.invoke(string2, string, string3, string4, "TapeManagerService", clazz5.getName(), DEVICE_METHOD, new Object[]{stringArray, new Integer(3)});
        }
        catch (Exception exception) {
            MessageLog.logException((String)"SRV0451E", (Exception)exception, (Object)DEVICE_METHOD);
            exception.printStackTrace();
            return 8;
        }
        catch (Throwable throwable) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(throwable), (Object)DEVICE_METHOD);
            throwable.printStackTrace();
            return 8;
        }
        int n3 = DeviceJobHndlr.completeDeviceJob(iJobMgmtService, asyncResult, DEVICE_METHOD, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), deviceRequest.deviceServerID);
        string = new RemoveMissingProcessor();
        string.performScheduledTapeDeletion();
        return n3;
    }
}

