/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.messaging.impl;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.TESTopicExtensionMgr;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopic;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicConnectionFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryInvalidException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.InvalidTopicClassException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.impl.TESTopicImpl;

public class MSFactoryImpl
implements Factory {
    private static String className = null;
    static ILogger traceLogger = null;
    static ILogger msgLogger = null;
    private static final String TRACE_NAME = "aperi.logger.trace.tes";
    private static final String MESSAGE_NAME = "aperi.logger.message.tes";
    private static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.messaging.resources.TESMessages";
    MSTopicConnectionFactory topicFactory;
    TopicConnection connection;
    TopicSession session;
    ExceptionListener exceptionListener = null;

    public MSFactoryImpl(String string, String string2, String string3) throws Exception {
        int n;
        className = this.getClass().getName();
        String string4 = "MSFactoryImpl(String serverURL, String messageLoggerName, String traceLoggerName)";
        if (string2 == null) {
            string2 = MESSAGE_NAME;
        }
        if (string3 == null) {
            string3 = TRACE_NAME;
        }
        try {
            msgLogger = LogManagerFactory.getMessageLogger((String)string2);
            msgLogger.setMessageFile(BUNDLENAME);
            traceLogger = LogManagerFactory.getTraceLogger((String)string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        this.topicFactory = new MSTopicConnectionFactory();
        String string5 = null;
        if (string != null) {
            string5 = this.getServerName(string);
            n = this.getPortNumber(string);
        } else {
            IConfigService iConfigService = null;
            iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            string5 = iConfigService.getProperty("manager.loc", "setup");
            String string6 = iConfigService.getProperty("manager.port", "setup");
            n = Integer.parseInt(string6);
        }
        this.topicFactory.setHostName(string5);
        this.topicFactory.setPort(n);
        this.connection = this.topicFactory.createTopicConnection();
        this.session = this.connection.createTopicSession(false, 0);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public TopicPublisher createPublisher(String string, Message message) throws JMSException, FactoryInvalidException {
        String string2 = "createPublisher(String tesTopicToPublish, Message template)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        TopicPublisher topicPublisher = this.createPublisher(string, null, message);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return topicPublisher;
    }

    public TopicPublisher createPublisher(String string, String string2, Message message) throws JMSException, FactoryInvalidException {
        String string3 = "createPublisher(String tesTopicToPublish, String topicSuffix, Message template)";
        TopicPublisher topicPublisher = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        try {
            MSTopic mSTopic = new MSTopic(this.makeTopic(string));
            topicPublisher = this.session.createPublisher((Topic)mSTopic);
        }
        catch (JMSException jMSException) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, "createPublisher_failed", (Object)string);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)jMSException);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jMSException);
            }
            throw new JMSException("createPublisher failed due to: " + jMSException.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return topicPublisher;
    }

    public TopicSubscriber createSubscriber(String string, String string2, String string3, MessageListener messageListener) throws JMSException, FactoryInvalidException {
        String string4 = "createSubscriber(String tesTopic, String subscriberID, String selector, MessageListener listener)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        TopicSubscriber topicSubscriber = this.createSubscriber(string, "", string2, string3, messageListener);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return topicSubscriber;
    }

    public TopicSubscriber createSubscriber(String string, String string2, String string3, String string4, MessageListener messageListener) throws JMSException, FactoryInvalidException {
        String string5 = "createSubscriber(String tesTopic, String topicSuffix, String subscriberID, String selector, MessageListener listener)";
        TopicSubscriber topicSubscriber = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string5);
        }
        try {
            MSTopic mSTopic = new MSTopic(String.valueOf(this.makeTopic(string)) + "*");
            topicSubscriber = this.session.createSubscriber((Topic)mSTopic);
            topicSubscriber.setMessageListener(messageListener);
            this.connection.start();
        }
        catch (JMSException jMSException) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, "createSubscriber_failed", (Object)string);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)jMSException);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jMSException);
            }
            throw new JMSException("createSubscriber failed due to: " + jMSException.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
        return topicSubscriber;
    }

    public void unsubscribe(String string) throws JMSException, FactoryInvalidException {
    }

    public String getReconnectionString() {
        return null;
    }

    public ObjectMessage createMessage(Serializable serializable) throws JMSException {
        String string = "createMessage(Serializable object)";
        ObjectMessage objectMessage = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setObject(serializable);
        }
        catch (JMSException jMSException) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "createMessage_failed");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)jMSException);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jMSException);
            }
            throw new JMSException("createMessage failed due to: " + jMSException.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return objectMessage;
    }

    public Message createPlainMessage() throws JMSException {
        return null;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return null;
    }

    public MapMessage createMapMessage() throws JMSException {
        return null;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return null;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        String string = "setExceptionListener(ExceptionListener exceptionlistener)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.exceptionListener = exceptionListener;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void setLogging(boolean bl) {
    }

    public void close() throws JMSException {
        String string = "close()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.topicFactory = null;
        this.connection.close();
        this.session.close();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private String makeTopic(String string) throws InvalidTopicClassException {
        String string2 = "makeTopic(String topicName)";
        String string3 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        try {
            TESTopicExtensionMgr tESTopicExtensionMgr = TESTopicExtensionMgr.getExtensionMgr();
            TESTopicImpl tESTopicImpl = (TESTopicImpl)tESTopicExtensionMgr.getExtensionImpl(string);
            Class<?> clazz = tESTopicImpl.getClass();
            string3 = clazz.getName();
            Class<?> clazz2 = clazz;
            while (clazz2 != null) {
                if ((clazz2 = clazz2.getSuperclass()) == null) continue;
                string3 = String.valueOf(clazz2.getName()) + "/" + string3;
            }
        }
        catch (Exception exception) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, "makeTopic_failed", (Object)string);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            throw new InvalidTopicClassException(string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string3;
    }

    protected final String getServerName(String string) {
        int n;
        String string2 = "getServerName(String url)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        String string3 = (n = string.indexOf(58)) == -1 ? string : string.substring(0, n);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string3;
    }

    protected final int getPortNumber(String string) throws NumberFormatException {
        int n;
        int n2;
        String string2 = "getPortNumber(String url)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        if ((n2 = string.indexOf(58)) == -1) {
            IConfigService iConfigService = null;
            iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            String string3 = iConfigService.getProperty("manager.port", "setup");
            n = Integer.parseInt(string3);
        } else {
            n = Integer.parseInt(string.substring(n2 + 1));
            if (n <= 0) {
                throw new NumberFormatException("Invalid port number: " + n);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }
}

