/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.StreamHandler;
import com.ibm.log.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class FileHandler
extends StreamHandler {
    static final long serialVersionUID = 8245488785648540818L;
    public static final String DEFAULT_FILE_NAME = "log.txt";
    public static final String FILE_PERM_RWD = "read,write,delete";
    public static final String SYSTEM_FILE_ENCODING = "SYSTEM.FILE.ENCODING";
    protected static final int DEFAULT_FILES = 3;
    protected static final int DEFAULT_FILE_SIZE = 1024;
    protected static final int FILE_SIZE_UNKNOWN = -1;
    protected static final String DEFAULT_ENCODING = "UTF8";
    private boolean appending = true;
    protected transient long fileSize = -1L;
    private int maxFiles = 3;
    private long maxFileSize = 0x100000L;
    private String encoding = "UTF8";
    private String fileDir = "";
    private String fileName = "log.txt";
    private FileNameParts fileParts = new FileNameParts();
    private File actualFile = new File("log.txt");

    public FileHandler() {
    }

    public FileHandler(String string) {
        super(string);
    }

    public FileHandler(String string, String string2) throws AccessControlException {
        super(string);
        this.setFileName(string2);
    }

    public FileHandler(String string, String string2, String string3) throws AccessControlException {
        this(string, string2);
        this.setEncoding(string3);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("fileName", this.fileName);
        if (!this.fileDir.equals("")) {
            properties.put("fileDir", this.fileDir);
        }
        properties.put("encoding", this.getEncoding());
        properties.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        properties.put("maxFileBytes", new Long(this.getMaxFileBytes()).toString());
        properties.put("appending", new Boolean(this.appending).toString());
        return properties;
    }

    public void setConfig(Properties properties) throws AccessControlException {
        super.setConfig(properties);
        String string = this.fileName;
        String string2 = this.fileDir;
        boolean bl = false;
        String string3 = properties.getProperty("fileName");
        if (string3 != null) {
            string = string3;
            bl = true;
        }
        if ((string3 = properties.getProperty("fileDir")) != null) {
            string2 = string3;
            bl = true;
        }
        if (bl) {
            this.setFileNameAndDir(string, string2);
        }
        if ((string3 = properties.getProperty("encoding")) != null) {
            this.setEncoding(string3);
        }
        if ((string3 = properties.getProperty("maxFiles")) != null) {
            this.setMaxFiles(new Integer(string3));
        }
        if ((string3 = properties.getProperty("maxFileSize")) != null) {
            this.setMaxFileSize(new Long(string3));
        }
        if ((string3 = properties.getProperty("maxFileBytes")) != null) {
            this.setMaxFileBytes(new Long(string3));
        }
        if ((string3 = properties.getProperty("appending")) != null) {
            this.setAppending(new Boolean(string3));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) throws AccessControlException {
        if (string != null) {
            this.setFileNameAndDir(string, this.fileDir);
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setFileName");
            LogUtil.errorMsg(string2);
        }
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String string) throws AccessControlException {
        if (string != null) {
            this.setFileNameAndDir(this.fileName, string);
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setFileName");
            LogUtil.errorMsg(string2);
        }
    }

    public void setFileNameAndDir(String string, String string2) throws AccessControlException {
        if (string != null) {
            this.close();
            FileNameParts fileNameParts = this.buildWorkingFileParts(string, string2);
            String string3 = fileNameParts.getWorkingName();
            if (fileNameParts == null || string3 == null) {
                Object[] objectArray = new String[]{this.getName(), string, string2};
                String string4 = LogUtil.getLogMsg("ERR_BAD_FILENAME", objectArray);
                LogUtil.errorMsg(string4);
                return;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new FilePermission(string3, FILE_PERM_RWD));
            }
            if (string2 != null) {
                this.fileDir = string2;
            }
            this.fileName = string;
            this.fileParts = fileNameParts;
        } else {
            String string5 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setFileNameAndDir");
            LogUtil.errorMsg(string5);
        }
        this.actualFile = new File(this.fileParts.getWorkingName());
    }

    protected FileNameParts buildWorkingFileParts(String string, String string2) {
        String string3;
        int n;
        Object object;
        String string4 = string;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (!string2.equals("")) {
            object = string2.replace('/', File.separatorChar);
            if (!((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + File.separator;
            }
            string4 = String.valueOf(object) + string4;
        }
        string4 = string4.replace('/', File.separatorChar);
        object = new File(string4 = new File(string4).getAbsolutePath());
        string5 = ((File)object).getParent();
        if (string5 != null && !string5.endsWith(File.separator)) {
            string5 = String.valueOf(string5) + File.separator;
        }
        if ((n = (string3 = ((File)object).getName()).lastIndexOf(46)) == -1) {
            string6 = string3;
            string7 = null;
        } else {
            string6 = string3.substring(0, n);
            string7 = string3.substring(n);
        }
        FileNameParts fileNameParts = new FileNameParts();
        fileNameParts.setWorkingName(string4);
        fileNameParts.setDirectory(string5);
        fileNameParts.setBaseName(string6);
        fileNameParts.setExtension(string7);
        return fileNameParts;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        if (SYSTEM_FILE_ENCODING.equals(string) && (string = System.getProperty("file.encoding")) == null) {
            string = DEFAULT_ENCODING;
        }
        if (string != null) {
            this.close();
            this.encoding = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setEncoding");
            LogUtil.errorMsg(string2);
        }
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int n) {
        if (n >= 0) {
            this.maxFiles = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setMaxFiles");
            LogUtil.errorMsg(string);
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize / 1024L;
    }

    public long getMaxFileBytes() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long l) {
        if (l > 0L) {
            this.maxFileSize = l * 1024L;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Long(l), String.valueOf(this.getClass().getName()) + ".setMaxFileSize");
            LogUtil.errorMsg(string);
        }
    }

    public void setMaxFileBytes(long l) {
        if (l > 0L) {
            this.maxFileSize = l;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Long(l), String.valueOf(this.getClass().getName()) + ".setMaxFileBytes");
            LogUtil.errorMsg(string);
        }
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending(boolean bl) {
        this.close();
        this.appending = bl;
    }

    protected final boolean makePath() {
        File file;
        String string = this.fileParts.getWorkingName();
        File file2 = new File(string = string.replace('/', File.separatorChar));
        String string2 = file2.getParent();
        if (string2 != null && !(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        return true;
    }

    protected final String getWorkingName() {
        return this.fileParts.getWorkingName();
    }

    protected final String getWorkingDir() {
        return this.fileParts.getDirectory();
    }

    protected final String getWorkingBase() {
        return this.fileParts.getBaseName();
    }

    protected final String getWorkingExt() {
        return this.fileParts.getExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile(boolean bl) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            Object object2;
            this.close();
            this.makePath();
            if (bl) {
                object2 = this.getDirList();
                object2 = this.deleteExtraFiles((Vector)object2);
                this.renameFiles((Vector)object2);
            }
            object2 = this.fileParts.getWorkingName();
            this.actualFile = new File((String)object2);
            this.fileSize = this.actualFile.length();
            FileOutputStream fileOutputStream = new FileOutputStream((String)object2, this.isAppending());
            this.setOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.getEncoding());
            this.bWriter = new BufferedWriter(outputStreamWriter);
            this.open = true;
        }
    }

    public void open() throws Exception, AccessControlException {
        boolean bl;
        Object object;
        boolean bl2 = false;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            if (this.actualFile == null) {
                this.actualFile = new File(this.fileParts.getWorkingName());
            }
            bl2 = this.actualFile.exists();
            if (this.fileSize == -1L) {
                this.fileSize = this.actualFile.length();
            }
        } else {
            try {
                Boolean bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new Boolean(FileHandler.this.actualFile.exists());
                    }
                });
                bl2 = bl3;
                if (this.fileSize == -1L) {
                    object = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            long l = FileHandler.this.actualFile != null ? FileHandler.this.actualFile.length() : 0L;
                            return new Long(l);
                        }
                    });
                    this.fileSize = (Long)object;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        boolean bl4 = bl = this.getMaxFiles() != 1 && this.fileSize >= this.maxFileSize;
        if (!this.open || bl || !bl2) {
            object = this.fileParts.getWorkingName();
            if (object == null) {
                this.setFileNameAndDir(DEFAULT_FILE_NAME, "");
            }
            if (securityManager == null) {
                this.openFile(bl);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            FileHandler.this.openFile(bl);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            this.writeHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open();
            String string = this.getFormatter().format(logEvent);
            this.bWriter.write(string, 0, string.length());
            if (addLineSep) {
                this.bWriter.write(lineSeparator, 0, lineSeparatorLength);
            }
            this.bWriter.flush();
            this.fileSize += (long)string.length();
        }
    }

    protected void writeHeader() throws Exception {
        String string = this.getFormatter().getHeader();
        if (string != null) {
            this.bWriter.write(string, 0, string.length());
            this.bWriter.flush();
            this.fileSize += (long)string.length();
        }
    }

    protected final Vector getDirList() {
        LogFilenameFilter logFilenameFilter = new LogFilenameFilter();
        Vector<String> vector = new Vector<String>();
        File file = new File(this.fileParts.getDirectory());
        String[] stringArray = file.list(logFilenameFilter);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return this.sortFiles(vector);
    }

    protected final void renameFiles(Vector vector) {
        File file;
        File file2;
        String string;
        String string2 = this.fileParts.getWorkingName();
        String string3 = this.fileParts.getDirectory();
        String string4 = this.fileParts.getBaseName();
        String string5 = this.fileParts.getExtension();
        String string6 = null;
        int n = vector.size() + 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string6 = String.valueOf(string3) + (String)enumeration.nextElement();
            string = string5 == null ? String.valueOf(string3) + string4 + n : String.valueOf(string3) + string4 + n + string5;
            file2 = new File(string6);
            file = new File(string);
            file2.renameTo(file);
            --n;
        }
        string = string5 == null ? String.valueOf(string3) + string4 + "1" : String.valueOf(string3) + string4 + "1" + string5;
        file2 = new File(string2);
        file = new File(string);
        file2.renameTo(file);
    }

    protected final Vector sortFiles(Vector vector) {
        String string = this.fileParts.getBaseName();
        String string2 = this.fileParts.getExtension();
        int n = string.length();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string3 = (String)vector.elementAt(n2);
            int n3 = n2 + 1;
            while (n3 < vector.size()) {
                int n4;
                int n5;
                String string4 = (String)vector.elementAt(n3);
                if (string2 == null) {
                    n5 = Integer.parseInt(string3.substring(n));
                    n4 = Integer.parseInt(string4.substring(n));
                } else {
                    n5 = Integer.parseInt(string3.substring(n, string3.lastIndexOf(string2)));
                    n4 = Integer.parseInt(string4.substring(n, string4.lastIndexOf(string2)));
                }
                if (n5 < n4) {
                    vector.setElementAt(string4, n2);
                    vector.setElementAt(string3, n3);
                    string3 = string4;
                }
                ++n3;
            }
            ++n2;
        }
        return vector;
    }

    protected final Vector deleteExtraFiles(Vector vector) {
        String string = this.fileParts.getDirectory();
        int n = this.getMaxFiles();
        if (n > 0) {
            --n;
            while (vector.size() >= n) {
                File file = new File(String.valueOf(string) + (String)vector.firstElement());
                file.delete();
                vector.removeElement(vector.firstElement());
            }
        }
        return vector;
    }

    private void deleteIfFileExists() {
        String string = this.fileParts.getWorkingName();
        String string2 = this.fileParts.getDirectory();
        if (string != null) {
            File file;
            Enumeration enumeration = this.getDirList().elements();
            while (enumeration.hasMoreElements()) {
                file = new File(string2, (String)enumeration.nextElement());
                if (!file.exists() || file.delete()) continue;
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_DELETE_FILE", file.getName()));
            }
            file = new File(string);
            if (file.exists() && !file.delete()) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_DELETE_FILE", file.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() throws AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            this.close();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.deleteIfFileExists();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        FileHandler.this.deleteIfFileExists();
                        return null;
                    }
                });
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", file=" + this.getWorkingName() + ", files=" + this.getMaxFiles() + ", fileSize=" + this.getMaxFileSize();
    }

    public final class FileNameParts {
        private String directory = null;
        private String baseName = null;
        private String extension = null;
        private String workingName = null;

        public String getDirectory() {
            return this.directory;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getWorkingName() {
            return this.workingName;
        }

        public void setDirectory(String string) {
            this.directory = string;
        }

        public void setBaseName(String string) {
            this.baseName = string;
        }

        public void setExtension(String string) {
            this.extension = string;
        }

        public void setWorkingName(String string) {
            this.workingName = string;
        }
    }

    class LogFilenameFilter
    implements FilenameFilter {
        LogFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            String string2 = FileHandler.this.fileParts.getBaseName();
            String string3 = FileHandler.this.fileParts.getExtension();
            boolean bl = false;
            int n = FileHandler.this.getMaxFiles();
            try {
                int n2;
                int n3 = string2.length();
                if (string3 == null) {
                    int n4;
                    if (string.startsWith(string2) && (n4 = Integer.parseInt(string.substring(n3))) >= 1 && (n == 0 || n4 < n)) {
                        bl = true;
                    }
                } else if (string.startsWith(string2) && string.endsWith(string3) && (n2 = Integer.parseInt(string.substring(n3, string.lastIndexOf(string3)))) >= 1 && (n == 0 || n2 < n)) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return bl;
        }
    }
}

