/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.FileHandler;
import com.ibm.log.LogEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

public class SerialFileHandler
extends FileHandler {
    static final long serialVersionUID = -5708565483533134148L;
    private transient File outputFile = null;
    private transient FileDescriptor outputFileDesc = null;
    private transient ObjectOutputStream objectOutput = null;

    public SerialFileHandler() {
        this.setMaxFiles(1);
    }

    public SerialFileHandler(String string) {
        super(string);
        this.setMaxFiles(1);
    }

    public SerialFileHandler(String string, String string2) {
        super(string, string2);
        this.setMaxFiles(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile() throws Exception {
        long l = -1L;
        long l2 = this.getMaxFileSize() * 1024L;
        int n = this.getMaxFiles();
        Object object = this.deviceLock;
        synchronized (object) {
            boolean bl;
            if (n > 1 && this.outputFile != null) {
                this.outputFileDesc.sync();
                l = this.outputFile.length();
            }
            boolean bl2 = bl = n != 1 && l >= l2;
            if (!this.open || bl) {
                Object object2;
                this.close();
                this.makePath();
                if (bl) {
                    object2 = this.getDirList();
                    object2 = this.deleteExtraFiles((Vector)object2);
                    this.renameFiles((Vector)object2);
                }
                object2 = this.getWorkingName();
                FileOutputStream fileOutputStream = new FileOutputStream((String)object2, this.isAppending());
                this.objectOutput = new ObjectOutputStream(fileOutputStream);
                this.setOutputStream(this.objectOutput);
                this.outputFile = new File((String)object2);
                this.outputFileDesc = fileOutputStream.getFD();
                this.open = true;
            }
        }
    }

    public void open() throws Exception, AccessControlException {
        SecurityManager securityManager;
        String string = this.getWorkingName();
        if (string == null) {
            this.setFileNameAndDir("log.txt", "");
        }
        if ((securityManager = System.getSecurityManager()) == null) {
            this.openFile();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SerialFileHandler.this.openFile();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {}
            this.outputFile = null;
            this.objectOutput = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open();
            this.objectOutput.writeObject(logEvent);
            this.objectOutput.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector readEvents() throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException {
        ObjectInputStream objectInputStream = null;
        String string = null;
        Vector<LogEvent> vector = new Vector<LogEvent>();
        Object object = this.deviceLock;
        synchronized (object) {
            boolean bl;
            this.close();
            Vector vector2 = this.getDirList();
            int n = 0;
            while (n < vector2.size()) {
                string = String.valueOf(this.getWorkingDir()) + vector2.elementAt(n);
                objectInputStream = new ObjectInputStream(new FileInputStream(string));
                bl = false;
                while (!bl) {
                    try {
                        vector.addElement((LogEvent)objectInputStream.readObject());
                    }
                    catch (EOFException eOFException) {
                        bl = true;
                    }
                }
                objectInputStream.close();
                ++n;
            }
            objectInputStream = new ObjectInputStream(new FileInputStream(this.getWorkingName()));
            bl = false;
            while (!bl) {
                try {
                    vector.addElement((LogEvent)objectInputStream.readObject());
                }
                catch (EOFException eOFException) {
                    bl = true;
                }
            }
            objectInputStream.close();
        }
        return vector;
    }

    public Vector readSerializedEvents() throws Exception, AccessControlException {
        Vector vector;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            vector = this.readEvents();
        } else {
            try {
                vector = (Vector)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return SerialFileHandler.this.readEvents();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return vector;
    }
}

