/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.AnyTypeFilter;
import com.ibm.log.LogEvent;
import com.ibm.log.Logger;
import com.ibm.log.TypeFilter;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class TypeLogger
extends Logger {
    static final long serialVersionUID = 7894404770313464896L;
    private String filterName = null;
    private TypeFilter typeFilter = new AnyTypeFilter();

    public TypeLogger() {
    }

    public TypeLogger(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.filterName != null) {
            properties.put("filterName", this.filterName);
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("filterName");
        if (string != null) {
            this.filterName = string;
        }
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        if (typeFilter != null) {
            this.typeFilter = typeFilter;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setTypeFilter");
            LogUtil.errorMsg(string);
        }
    }

    protected boolean isLoggable(long l) {
        boolean bl = false;
        if (this.isLogging()) {
            bl = this.getTypeFilter().isLoggable(l);
        }
        return bl;
    }

    public void message(long l, String string) {
        if (this.isLoggable(l)) {
            this.logMessage(l, string, this.getMessageFile(), null);
        }
    }

    public void message(long l, String string, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logMessage(l, string, this.getMessageFile(), objectArray);
        }
    }

    public void message(long l, String string, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logMessage(l, string, this.getMessageFile(), objectArray);
        }
    }

    public void message(long l, String string, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logMessage(l, string, this.getMessageFile(), objectArray);
        }
    }

    public void msg(long l, String string, String string2) {
        if (this.isLoggable(l)) {
            this.logMessage(l, string, string2, null);
        }
    }

    public void msg(long l, String string, String string2, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logMessage(l, string, string2, objectArray);
        }
    }

    public void msg(long l, String string, String string2, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logMessage(l, string, string2, objectArray);
        }
    }

    public void msg(long l, String string, String string2, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logMessage(l, string, string2, objectArray);
        }
    }

    public void text(long l, String string) {
        if (this.isLoggable(l)) {
            this.logText(l, string, null);
        }
    }

    public void text(long l, String string, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object};
            this.logText(l, string, objectArray);
        }
    }

    public void text(long l, String string, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{object, object2};
            this.logText(l, string, objectArray);
        }
    }

    public void text(long l, String string, Object[] objectArray) {
        if (this.isLoggable(l)) {
            this.logText(l, string, objectArray);
        }
    }

    public void entry(long l) {
        if (this.isLoggable(l)) {
            this.logText(l, "Entry", null);
        }
    }

    public void entry(long l, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{TypeLogger.objToStr(object)};
            this.logText(l, "Entry, parm 1 = {0}", objectArray);
        }
    }

    public void entry(long l, Object object, Object object2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{TypeLogger.objToStr(object), TypeLogger.objToStr(object2)};
            this.logText(l, "Entry, parm 1 = {0}, parm 2 = {1}", objectArray);
        }
    }

    public void entry(long l, Object[] objectArray) {
        if (this.isLoggable(l)) {
            StringBuffer stringBuffer = new StringBuffer("Entry");
            Object[] objectArray2 = null;
            if (objectArray != null) {
                objectArray2 = new String[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(", parm " + (n + 1) + " = {" + n + "}");
                    objectArray2[n] = TypeLogger.objToStr(objectArray[n]);
                    ++n;
                }
            }
            this.logText(l, stringBuffer.toString(), objectArray2);
        }
    }

    public void exit(long l) {
        if (this.isLoggable(l)) {
            this.logText(l, "Exit", null);
        }
    }

    public void exit(long l, byte by) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Byte(by)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, short s) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Short(s)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, int n) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Integer(n)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, long l2) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Long(l2)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, float f) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Float(f)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, double d) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Double(d)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, char c) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Character(c)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, boolean bl) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exit(long l, Object object) {
        if (this.isLoggable(l)) {
            Object[] objectArray = new Object[]{TypeLogger.objToStr(object)};
            this.logText(l, "Exit, return value = {0}", objectArray);
        }
    }

    public void exception(long l, Throwable throwable) {
        if (this.isLoggable(l)) {
            LogEvent logEvent = new LogEvent(l, throwable);
            this.logAndWarn(logEvent);
        }
    }

    public void exception(long l, Throwable throwable, String string) {
        if (this.isLoggable(l)) {
            LogEvent logEvent = new LogEvent(l, throwable, string);
            this.logAndWarn(logEvent);
        }
    }

    protected void logMessage(long l, String string, String string2, Object[] objectArray) {
        LogEvent logEvent = new LogEvent(l, string, string2, objectArray);
        this.logAndWarn(logEvent);
    }

    protected void logText(long l, String string, Object[] objectArray) {
        LogEvent logEvent = new LogEvent(l, string, objectArray);
        this.logAndWarn(logEvent);
    }
}

