/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.CommandServer;
import com.ibm.log.cmd.LogCmdProcessor;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class LogCmdServer
implements CommandServer,
Runnable {
    public static final int DEFAULT_PORT = 9992;
    public static final int RC_OK = 0;
    public static final int RC_ERROR = 1;
    public static final String CTRL_MSG_CMD = "Cmd:";
    public static final String CTRL_MSG_RC = "RC:";
    public static final String CTRL_MSG_STDERR = "Stderr:";
    public static final String CTRL_MSG_STDOUT = "Stdout:";
    public static final String LOG_CMD_CONFIG = "config";
    public static final String LOG_CMD_DUMP = "dump";
    public static final String LOG_CMD_HELP = "help";
    public static final String LOG_CMD_LIST = "list";
    public static final String LOG_CMD_REMOVE = "remove";
    public static final String LOG_CMD_SAVE = "save";
    public static final String LOG_CMD_SAVE_OPT_ALL = "all";
    public static final String LOG_CMD_SET = "set";
    public static final String OPTION_HELP = "-h";
    private boolean started = false;
    private boolean stopRequested = false;
    private int serverPort = 9992;
    private ServerSocket serverSocket = null;

    public LogCmdServer() {
        this(9992);
    }

    public LogCmdServer(int n) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        final int n2 = n;
        if (securityManager == null) {
            this.obtainServerSocket(n2);
        } else {
            securityManager.checkListen(n2);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        LogCmdServer.this.obtainServerSocket(n2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.getException().printStackTrace(System.err);
            }
        }
    }

    private void obtainServerSocket(int n) {
        int n2;
        ServerSocket serverSocket = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            String string = LogUtil.getLogMsg("ERR_LOCALHOST_CMD_SOCKET");
            LogUtil.errorMsg(string);
            return;
        }
        if (n != 0) {
            try {
                this.serverSocket = serverSocket = new ServerSocket(n, 64, inetAddress);
                this.serverPort = n;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{new Integer(n)};
                String string = LogUtil.getLogMsg("ERR_PORT_IN_USE", objectArray);
                LogUtil.errorMsg(string);
            }
            return;
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = n2 = (int)(System.currentTimeMillis() % 16384L);
        while (serverSocket == null && !bl) {
            try {
                n3 = 49152 + n4;
                serverSocket = new ServerSocket(n3, 64, inetAddress);
            }
            catch (IOException iOException) {
                serverSocket = null;
                n4 = (n4 + 1) % 16384;
                if (n4 != n2) continue;
                bl = true;
            }
        }
        if (serverSocket != null) {
            this.serverSocket = serverSocket;
            this.serverPort = n3;
        } else {
            Object[] objectArray = new Object[]{"49152-65535"};
            String string = LogUtil.getLogMsg("ERR_PORT_IN_USE", objectArray);
            LogUtil.errorMsg(string);
        }
    }

    public synchronized void start() {
        Thread thread = new Thread((Runnable)this, this.getClass().getName());
        thread.setDaemon(true);
        thread.start();
        this.started = true;
    }

    public void run() {
        if (this.serverSocket == null) {
            this.started = false;
            return;
        }
        try {
            this.serverSocket.setSoTimeout(1000);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace(System.err);
        }
        SecurityManager securityManager = System.getSecurityManager();
        while (!this.stopRequested) {
            try {
                Socket socket;
                final ServerSocket serverSocket = this.serverSocket;
                if (securityManager == null) {
                    socket = serverSocket.accept();
                } else {
                    try {
                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return serverSocket.accept();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                }
                Thread thread = new Thread(new LogCmdProcessor(socket));
                thread.start();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        this.started = false;
    }

    public synchronized void stop() {
        this.stopRequested = true;
        while (this.started) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getPort() {
        return this.serverPort;
    }
}

