/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.net.InetAddress;

public class CBEGlobalInstanceID {
    private static final String ALPHA_PREFIX = "JL";
    private static final String HOST_IP = CBEGlobalInstanceID.getHostIP();
    private static final String START_TIME = CBEGlobalInstanceID.getStartTime();
    private static final int START_TIME_FIELD_LEN = 14;
    private static final long START_TIME_MASK = 0xFFFFFFFFFFFFL;
    private static int seqCounter = 0;
    private static final int SEQUENCE_FIELD_LEN = 8;
    private static final int BYTE_FF = 255;
    private static final int HEX_DIGIT_F = 15;

    private CBEGlobalInstanceID() {
    }

    public static void appendCBE101GUID(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            String string = Integer.toHexString(CBEGlobalInstanceID.getNextSequence());
            stringBuffer.append(ALPHA_PREFIX);
            stringBuffer.append(HOST_IP);
            stringBuffer.append(START_TIME);
            int n = string.length();
            while (n < 8) {
                stringBuffer.append('0');
                ++n;
            }
            stringBuffer.append(string);
        }
    }

    private static String getHostIP() {
        String string;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                if (n2 <= 15) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
                ++n;
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            string = "7f000001";
        }
        return string;
    }

    private static String getStartTime() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = System.currentTimeMillis() & 0xFFFFFFFFFFFFL;
        String string = Long.toHexString(l);
        int n = string.length();
        while (n < 14) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static synchronized int getNextSequence() {
        int n = seqCounter++;
        return n;
    }
}

