/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.internal.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.TupleComparator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class ResultSetWrapper {
    final List rawResultSet;
    final List workingResultSet;
    final String[] saExpressionKeys;
    final int[] iaDataTypes;
    private int[] iaGroupBreaks = null;
    private final Hashtable htLookup;
    private boolean bBaseGroupingApplied = false;
    private final GroupKey[] oaGroupKeys;
    private static final int[] NO_GROUP_BREAKS = new int[0];
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/datafeed");

    public ResultSetWrapper(Collection stExpressionKeys, List liResultSet, GroupKey[] groupKeys) {
        this.rawResultSet = liResultSet;
        this.workingResultSet = new ArrayList();
        this.workingResultSet.addAll(this.rawResultSet);
        this.saExpressionKeys = stExpressionKeys.toArray(new String[stExpressionKeys.size()]);
        this.iaDataTypes = new int[this.saExpressionKeys.length];
        this.htLookup = new Hashtable();
        for (int i = 0; i < this.saExpressionKeys.length; ++i) {
            this.htLookup.put(this.saExpressionKeys[i], new Integer(i));
        }
        this.oaGroupKeys = groupKeys;
        this.iaGroupBreaks = this.findGroupBreaks(this.workingResultSet, this.oaGroupKeys != null && this.oaGroupKeys.length > 0 ? this.oaGroupKeys[0] : null);
        this.initializeMeta();
    }

    private void initializeMeta() {
        Iterator it = this.workingResultSet.iterator();
        int iColumnCount = this.iaDataTypes.length;
        boolean[] boaFound = new boolean[iColumnCount];
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            for (int i = 0; i < iColumnCount; ++i) {
                boolean bAllDone = true;
                if (oaTuple[i] == null) continue;
                boaFound[i] = true;
                if (oaTuple[i] instanceof Number) {
                    this.iaDataTypes[i] = 1;
                } else if (oaTuple[i] instanceof String) {
                    this.iaDataTypes[i] = 16;
                } else if (oaTuple[i] instanceof Date || oaTuple[i] instanceof Calendar) {
                    this.iaDataTypes[i] = 8;
                }
                for (int j = 0; j < iColumnCount; ++j) {
                    if (boaFound[j]) continue;
                    bAllDone = false;
                    break;
                }
                if (!bAllDone) continue;
                return;
            }
        }
        logger.log(2, Messages.getString("exception.resultset.data.type.retrieval.failed"));
    }

    public void applyBaseSeriesSortingAndGrouping(SeriesDefinition sd, String[] saExpressionKeys) throws ChartException {
        if (this.bBaseGroupingApplied) {
            return;
        }
        this.bBaseGroupingApplied = true;
        boolean needBaseGrouping = true;
        SeriesGrouping sg = sd.getGrouping();
        if (sg == null || !sg.isEnabled()) {
            needBaseGrouping = false;
        }
        Series seBaseDesignTime = sd.getDesignTimeSeries();
        Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
        int iSortColumnIndex = (Integer)this.htLookup.get(q.getDefinition());
        SortOption so = null;
        if (!sd.isSetSorting()) {
            if (needBaseGrouping) {
                so = SortOption.ASCENDING_LITERAL;
            }
        } else {
            so = sd.getSorting();
        }
        new GroupingSorter().sort(this.workingResultSet, iSortColumnIndex, so, this.iaGroupBreaks);
        if (!needBaseGrouping) {
            return;
        }
        String sFunctionName = sg.getAggregateExpression();
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        IAggregateFunction[] iafa = new IAggregateFunction[iOrthogonalSeriesCount];
        try {
            for (int i = 0; i < iOrthogonalSeriesCount; ++i) {
                iafa[i] = PluginSettings.instance().getAggregateFunction(sFunctionName);
                iafa[i].initialize();
            }
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((Object)pex));
        }
        DataType dtGrouping = sg.getGroupType();
        if (dtGrouping == DataType.NUMERIC_LITERAL) {
            this.groupNumerically(this.workingResultSet, iSortColumnIndex, saExpressionKeys, this.iaGroupBreaks, null, sg.getGroupingInterval(), iafa);
        } else if (dtGrouping == DataType.DATE_TIME_LITERAL) {
            this.groupDateTime(this.workingResultSet, iSortColumnIndex, saExpressionKeys, this.iaGroupBreaks, null, sg.getGroupingInterval(), sg.getGroupingUnit(), iafa);
        } else if (dtGrouping == DataType.TEXT_LITERAL) {
            this.groupTextually(this.workingResultSet, iSortColumnIndex, saExpressionKeys, this.iaGroupBreaks, null, sg.getGroupingInterval(), iafa);
        }
        this.initializeMeta();
    }

    private void groupNumerically(List resultSet, int iBaseColumnIndex, String[] saExpressionKeys, int[] iaBreaks, NumberDataElement ndeBaseReference, long iGroupingInterval, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (int i = 0; i < iOrthogonalSeriesCount; ++i) {
            iaColumnIndexes[i] = (Integer)this.htLookup.get(saExpressionKeys[i]);
        }
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        for (int k = 0; k < totalGroupCount; ++k) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            NumberDataElement baseReference = ndeBaseReference;
            if (baseReference == null) {
                Number obj = (Number)((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex];
                baseReference = NumberDataElementImpl.create(obj == null ? 0.0 : obj.doubleValue());
            }
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            double dBaseReference = baseReference.getValue();
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            for (int j = iStartIndex; j < iEndIndex; ++j) {
                int i2;
                Object[] oaTuple = (Object[])resultSet.get(j);
                iGroupIndex = oaTuple[iBaseColumnIndex] != null ? (iGroupingInterval == 0L ? ++iGroupIndex : (int)Math.floor(Math.abs((((Number)oaTuple[iBaseColumnIndex]).doubleValue() - dBaseReference) / (double)iGroupingInterval))) : (iGroupingInterval == 0L ? ++iGroupIndex : (int)Math.floor(Math.abs(dBaseReference / (double)iGroupingInterval)));
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        for (i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                        }
                        Number obj = (Number)oaTuple[iBaseColumnIndex];
                        baseReference = NumberDataElementImpl.create(obj == null ? 0.0 : obj.doubleValue());
                        dBaseReference = baseReference.getValue();
                        iGroupIndex = 0;
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(new Integer(j));
                }
                for (i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
                    try {
                        iafa[i2].accumulate(oaTuple[iaColumnIndexes[i2]]);
                        continue;
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                }
                iLastGroupIndex = iGroupIndex;
            }
            if (oaSummarizedTuple != null) {
                for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                }
            }
            for (i = 0; i < trashList.size(); ++i) {
                resultSet.remove((Integer)trashList.get(i) - i);
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks.length > 0 && groupChange > 0) {
                int j = k;
                while (j < iaBreaks.length) {
                    int n = j++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
        }
    }

    private int groupingUnit2CDateUnit(GroupingUnitType unit) {
        if (unit != null) {
            switch (unit.getValue()) {
                case 0: {
                    return 13;
                }
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 1;
                }
            }
        }
        return 14;
    }

    private void groupDateTime(List resultSet, int iBaseColumnIndex, String[] saExpressionKeys, int[] iaBreaks, CDateTime ndeBaseReference, long iGroupingInterval, GroupingUnitType groupingUnit, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (int i = 0; i < iOrthogonalSeriesCount; ++i) {
            iaColumnIndexes[i] = (Integer)this.htLookup.get(saExpressionKeys[i]);
        }
        int cunit = this.groupingUnit2CDateUnit(groupingUnit);
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        for (int k = 0; k < totalGroupCount; ++k) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            CDateTime baseReference = ndeBaseReference;
            if (baseReference == null) {
                Object obj = ((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex];
                baseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : (obj instanceof Calendar ? new CDateTime((Calendar)obj) : (obj instanceof Date ? new CDateTime((Date)obj) : new CDateTime(0L)));
            }
            baseReference.clearBelow(cunit);
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            for (int j = iStartIndex; j < iEndIndex; ++j) {
                Object[] oaTuple = (Object[])resultSet.get(j);
                if (oaTuple[iBaseColumnIndex] != null) {
                    if (iGroupingInterval == 0L) {
                        ++iGroupIndex;
                    } else {
                        CDateTime dBaseValue = null;
                        Object obj = oaTuple[iBaseColumnIndex];
                        dBaseValue = obj instanceof CDateTime ? (CDateTime)((Object)obj) : (obj instanceof Calendar ? new CDateTime((Calendar)obj) : (obj instanceof Date ? new CDateTime((Date)obj) : new CDateTime()));
                        double diff = CDateTime.computeDifference(dBaseValue, baseReference, cunit, true);
                        iGroupIndex = (int)Math.floor(Math.abs(diff / (double)iGroupingInterval));
                    }
                } else if (iGroupingInterval == 0L) {
                    ++iGroupIndex;
                } else {
                    CDateTime dBaseValue = new CDateTime(0L);
                    double diff = CDateTime.computeDifference(dBaseValue, baseReference, cunit, true);
                    iGroupIndex = (int)Math.floor(Math.abs(diff / (double)iGroupingInterval));
                }
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        for (int i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                        }
                        Object obj = oaTuple[iBaseColumnIndex];
                        baseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : (obj instanceof Calendar ? new CDateTime((Calendar)obj) : (obj instanceof Date ? new CDateTime((Date)obj) : new CDateTime(0L)));
                        baseReference.clearBelow(cunit);
                        iGroupIndex = 0;
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(new Integer(j));
                }
                for (int i3 = 0; i3 < iOrthogonalSeriesCount; ++i3) {
                    try {
                        iafa[i3].accumulate(oaTuple[iaColumnIndexes[i3]]);
                        continue;
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                }
                iLastGroupIndex = iGroupIndex;
            }
            if (oaSummarizedTuple != null) {
                for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                }
            }
            for (i = 0; i < trashList.size(); ++i) {
                resultSet.remove((Integer)trashList.get(i) - i);
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks.length > 0 && groupChange > 0) {
                int j = k;
                while (j < iaBreaks.length) {
                    int n = j++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
        }
    }

    private void groupTextually(List resultSet, int iBaseColumnIndex, String[] saExpressionKeys, int[] iaBreaks, String ndeBaseReference, long iGroupingInterval, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        for (int i = 0; i < iOrthogonalSeriesCount; ++i) {
            iaColumnIndexes[i] = (Integer)this.htLookup.get(saExpressionKeys[i]);
        }
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        for (int k = 0; k < totalGroupCount; ++k) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            String baseReference = ndeBaseReference;
            if (baseReference == null) {
                baseReference = ChartUtil.stringValue(((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex]);
            }
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            int iGroupCounter = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            for (int j = iStartIndex; j < iEndIndex; ++j) {
                Object[] oaTuple = (Object[])resultSet.get(j);
                if (oaTuple[iBaseColumnIndex] != null) {
                    String dBaseValue = String.valueOf(oaTuple[iBaseColumnIndex]);
                    if (!dBaseValue.equals(baseReference)) {
                        ++iGroupCounter;
                        baseReference = dBaseValue;
                    }
                    if ((long)iGroupCounter > iGroupingInterval) {
                        ++iGroupIndex;
                    }
                } else {
                    if (baseReference != null) {
                        ++iGroupCounter;
                        baseReference = null;
                    }
                    if ((long)iGroupCounter > iGroupingInterval) {
                        ++iGroupIndex;
                    }
                }
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak) {
                    iGroupCounter = 0;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        for (int i2 = 0; i2 < iOrthogonalSeriesCount; ++i2) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                        }
                        baseReference = ChartUtil.stringValue(oaTuple[iBaseColumnIndex]);
                        iGroupIndex = 0;
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(new Integer(j));
                }
                for (int i3 = 0; i3 < iOrthogonalSeriesCount; ++i3) {
                    try {
                        iafa[i3].accumulate(oaTuple[iaColumnIndexes[i3]]);
                        continue;
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
                    }
                }
                iLastGroupIndex = iGroupIndex;
            }
            if (oaSummarizedTuple != null) {
                for (i = 0; i < iOrthogonalSeriesCount; ++i) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                }
            }
            for (i = 0; i < trashList.size(); ++i) {
                resultSet.remove((Integer)trashList.get(i) - i);
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks.length > 0 && groupChange > 0) {
                int j = k;
                while (j < iaBreaks.length) {
                    int n = j++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
        }
    }

    public int getGroupCount() {
        return this.iaGroupBreaks.length + 1;
    }

    public int getGroupRowCount(int iGroupIndex) {
        int startRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        int endRow = iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex];
        return endRow - startRow;
    }

    public int getColumnCount() {
        return this.saExpressionKeys.length;
    }

    public int getRowCount() {
        return this.workingResultSet.size();
    }

    public Object getGroupKey(int iGroupIndex, String sExpressionKey) {
        int iRow;
        if (!this.htLookup.containsKey(sExpressionKey)) {
            return "";
        }
        int iColumnIndex = (Integer)this.htLookup.get(sExpressionKey);
        int n = iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        if (iRow >= 0 && iRow < this.workingResultSet.size()) {
            return ((Object[])this.workingResultSet.get(iRow))[iColumnIndex];
        }
        return null;
    }

    public Object getGroupKey(int iGroupIndex, int iColumnIndex) {
        int iRow;
        int n = iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        if (iRow >= 0 && iRow < this.workingResultSet.size()) {
            return ((Object[])this.workingResultSet.get(iRow))[iColumnIndex];
        }
        return null;
    }

    public ResultSetDataSet getSubset(int iGroupIndex, String sExpressionKey) {
        return new ResultSetDataSet(this, new int[]{(Integer)this.htLookup.get(sExpressionKey)}, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, EList elExpressionKeys) {
        int n = elExpressionKeys.size();
        int[] iaColumnIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            String sExpressionKey = ((Query)elExpressionKeys.get(i)).getDefinition();
            iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpressionKey);
        }
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, String[] sExpressionKeys) {
        if (sExpressionKeys == null) {
            return null;
        }
        int n = sExpressionKeys.length;
        int[] iaColumnIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            String sExpressionKey = sExpressionKeys[i];
            iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpressionKey);
        }
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, iGroupIndex <= 0 ? 0L : (long)this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length ? (long)this.getRowCount() : (long)this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(EList elExpressions) throws ChartException {
        int n = elExpressions.size();
        int[] iaColumnIndexes = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String sExpression = ((Query)elExpressions.get(i)).getDefinition();
                iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpression);
            }
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle());
        }
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(String sExpressionKey) {
        return new ResultSetDataSet(this, new int[]{(Integer)this.htLookup.get(sExpressionKey)}, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(String[] sExpressionKeys) throws ChartException {
        if (sExpressionKeys == null) {
            return null;
        }
        int n = sExpressionKeys.length;
        int[] iaColumnIndexes = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String sExpression = sExpressionKeys[i];
                iaColumnIndexes[i] = (Integer)this.htLookup.get(sExpression);
            }
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle());
        }
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, 0L, this.getRowCount());
    }

    public Object[] getMergedGroupingBaseValues(int iColumnIndex, SortOption sorting) {
        int groupCount = this.getGroupCount();
        ArrayList idxList = new ArrayList(groupCount);
        ArrayList<Object> baseValue = new ArrayList<Object>();
        for (int k = 0; k < groupCount; ++k) {
            Object oValue;
            ResultSetDataSet rsd = this.getSubset(k, iColumnIndex);
            ArrayList<Integer> idx = new ArrayList<Integer>();
            if (k == 0) {
                int i = 0;
                while (rsd.hasNext()) {
                    oValue = rsd.next()[0];
                    baseValue.add(oValue);
                    idx.add(new Integer(i++));
                }
            } else {
                while (rsd.hasNext()) {
                    oValue = rsd.next()[0];
                    boolean matched = false;
                    int insertPoint = -1;
                    for (int j = 0; j < baseValue.size(); ++j) {
                        Object ov = baseValue.get(j);
                        int cprt = ResultSetWrapper.compareObjects(oValue, ov);
                        if (cprt == 0) {
                            if (!idx.contains(new Integer(j))) {
                                idx.add(new Integer(j));
                                matched = true;
                                break;
                            }
                            if (sorting == null) continue;
                            insertPoint = j + 1;
                            continue;
                        }
                        if (cprt < 0) {
                            if (sorting != SortOption.DESCENDING_LITERAL) continue;
                            insertPoint = j + 1;
                            continue;
                        }
                        if (cprt <= 0 || sorting != SortOption.ASCENDING_LITERAL) continue;
                        insertPoint = j + 1;
                    }
                    if (matched) continue;
                    if (sorting != null && insertPoint == -1) {
                        insertPoint = 0;
                    }
                    if (insertPoint == -1 || insertPoint >= baseValue.size()) {
                        baseValue.add(oValue);
                        idx.add(new Integer(baseValue.size() - 1));
                        continue;
                    }
                    baseValue.add(insertPoint, oValue);
                    for (int i = 0; i < idx.size(); ++i) {
                        int x = (Integer)idx.get(i);
                        if (x < insertPoint) continue;
                        idx.set(i, new Integer(x + 1));
                    }
                    idx.add(new Integer(insertPoint));
                    Iterator itr = idxList.iterator();
                    while (itr.hasNext()) {
                        List gidx = (List)itr.next();
                        for (int i = 0; i < gidx.size(); ++i) {
                            int x = (Integer)gidx.get(i);
                            if (x < insertPoint) continue;
                            gidx.set(i, new Integer(x + 1));
                        }
                    }
                }
            }
            idxList.add(idx);
        }
        int maxLen = baseValue.size();
        Iterator itr = idxList.iterator();
        while (itr.hasNext()) {
            List lst = (List)itr.next();
            if (lst.size() >= maxLen) continue;
            int inc = maxLen - lst.size();
            for (int i = 0; i < inc; ++i) {
                lst.add(new Integer(-1));
            }
        }
        return new Object[]{baseValue, idxList};
    }

    public int getColumnDataType(int iColumnIndex) {
        return this.iaDataTypes[iColumnIndex];
    }

    public Iterator iterator() {
        if (this.workingResultSet != null) {
            return this.workingResultSet.iterator();
        }
        return null;
    }

    private int[] findGroupBreaks(List resultSet, GroupKey groupKey) {
        if (groupKey == null || groupKey.getKey() == null) {
            return NO_GROUP_BREAKS;
        }
        Collections.sort(resultSet, new TupleComparator(new GroupKey[]{groupKey}));
        int iColumnIndex = groupKey.getKeyIndex();
        Iterator it = resultSet.iterator();
        ArrayList<Integer> al = new ArrayList<Integer>(8);
        boolean bFirst = true;
        Object oPreviousValue = null;
        int iRowIndex = 0;
        while (it.hasNext()) {
            Object oValue = ((Object[])it.next())[iColumnIndex];
            ++iRowIndex;
            if (bFirst) {
                bFirst = false;
                oPreviousValue = oValue;
                continue;
            }
            if (ResultSetWrapper.compareObjects(oPreviousValue, oValue) != 0) {
                al.add(new Integer(iRowIndex - 1));
            }
            oPreviousValue = oValue;
        }
        int[] ia = new int[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ia[i] = (Integer)al.get(i);
        }
        return ia;
    }

    public static int compareObjects(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a instanceof String) {
            int iC = a.toString().compareTo(b.toString());
            if (iC != 0) {
                iC = iC < 0 ? -1 : 1;
            }
            return iC;
        }
        if (a instanceof Number) {
            double d2;
            double d1 = ((Number)a).doubleValue();
            return d1 == (d2 = ((Number)b).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Date) {
            long d2;
            long d1 = ((Date)a).getTime();
            return d1 == (d2 = ((Date)b).getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Calendar) {
            long d2;
            long d1 = ((Calendar)a).getTime().getTime();
            return d1 == (d2 = ((Calendar)b).getTime().getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        return ResultSetWrapper.compareObjects(a.toString(), b.toString());
    }

    static final class GroupingSorter
    implements Comparator {
        private int iSortIndex;
        private boolean ascending;
        private Collator collator;

        GroupingSorter() {
        }

        void sort(List resultSet, int iSortIndex, SortOption so, int[] groupBreaks) {
            if (so == null) {
                return;
            }
            this.iSortIndex = iSortIndex;
            this.ascending = so == SortOption.ASCENDING_LITERAL;
            this.collator = Collator.getInstance();
            if (groupBreaks == null || groupBreaks.length == 0) {
                Collections.sort(resultSet, this);
            } else {
                int totalCount = resultSet.size();
                int startGroupIndex = 0;
                ArrayList tmpList = new ArrayList();
                for (int i = 0; i <= groupBreaks.length; ++i) {
                    int endGroupIndex = i == groupBreaks.length ? totalCount : groupBreaks[i];
                    tmpList.clear();
                    for (int j = startGroupIndex; j < endGroupIndex; ++j) {
                        tmpList.add(resultSet.get(j));
                    }
                    Collections.sort(tmpList, this);
                    for (int k = 0; k < tmpList.size(); ++k) {
                        resultSet.set(startGroupIndex + k, tmpList.get(k));
                    }
                    startGroupIndex = endGroupIndex;
                }
            }
        }

        public final int compare(Object o1, Object o2) {
            Object[] oaTuple1 = (Object[])o1;
            Object[] oaTuple2 = (Object[])o2;
            Object oC1 = oaTuple1[this.iSortIndex];
            Object oC2 = oaTuple2[this.iSortIndex];
            if (oC1 == null && oC2 == null) {
                return 0;
            }
            if (oC1 == null && oC2 != null) {
                return this.ascending ? -1 : 1;
            }
            if (oC1 != null && oC2 == null) {
                return this.ascending ? 1 : -1;
            }
            int ct = oC1 instanceof String ? this.collator.compare(oC1.toString(), oC2.toString()) : ((Comparable)oC1).compareTo(oC2);
            return this.ascending ? ct : -ct;
        }
    }
}

