/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.util.IOUtil;

class AllocationTable {
    static final int BLOCK_COUNT_INCREASE = 32;
    static final int FIRST_FAT_BLOCK = 1;
    static final int FIRST_FREE_BLOCK = 0;
    static final int LAST_BLOCK = -1;
    static final int CONTINUE_BLOCK = 0;
    private ArchiveFile af;
    private int[] fatBlocks;
    private int totalFATBlocks;
    private HashMap entries;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AllocationTable(ArchiveFile af) {
        this.af = af;
        this.fatBlocks = new int[32];
        this.fatBlocks[0] = 1;
        this.totalFATBlocks = 1;
        this.entries = new HashMap();
    }

    static AllocationTable createTable(ArchiveFile af) throws IOException {
        AllocationTable table = new AllocationTable(af);
        table.initFATBlock(1);
        return table;
    }

    static AllocationTable loadTable(ArchiveFile af) throws IOException {
        AllocationTable table = new AllocationTable(af);
        table.refresh();
        return table;
    }

    void flush() throws IOException {
    }

    void refresh() throws IOException {
        int lastBlockId = this.fatBlocks[this.totalFATBlocks - 1];
        int blockId = this.readFATInt(lastBlockId * 4);
        while (blockId != -1) {
            this.ensureFATBlocks(this.totalFATBlocks + 1);
            this.fatBlocks[this.totalFATBlocks] = blockId;
            ++this.totalFATBlocks;
            blockId = this.readFATInt(blockId * 4);
        }
    }

    private int getFreeBlock() throws IOException {
        int freeBlockId = this.readFATInt(0L);
        if (freeBlockId != -1) {
            int nextFreeBlockId = this.readFATInt(freeBlockId * 4);
            this.writeFATInt(0L, nextFreeBlockId);
            return freeBlockId;
        }
        return this.af.allocateBlock();
    }

    Entry createEntry() throws IOException {
        int blockId = this.getFreeBlock();
        this.writeFATInt(blockId * 4, -1);
        Entry entry = new Entry(blockId);
        this.entries.put(new Integer(blockId), entry);
        return entry;
    }

    Entry loadEntry(int blockId) throws IOException {
        Entry entry = (Entry)this.entries.get(new Integer(blockId));
        if (entry == null) {
            entry = new Entry(blockId);
            entry.refresh();
            this.entries.put(new Integer(blockId), entry);
        }
        return entry;
    }

    void removeEntry(Entry entry) throws IOException {
        int lastBlockId = entry.getLastBlock();
        int firstBlockId = entry.getFirstBlock();
        int freeBlockId = this.readFATInt(0L);
        this.writeFATInt(lastBlockId * 4, freeBlockId);
        this.writeFATInt(0L, firstBlockId);
        this.entries.remove(new Integer(firstBlockId));
    }

    private int readFATInt(long offset) throws IOException {
        if (offset > (long)(this.totalFATBlocks * 4096)) {
            throw new EOFException();
        }
        int blockId = (int)(offset / 4096L);
        int off = (int)(offset % 4096L);
        int phyBlockId = this.getFATBlock(blockId);
        byte[] b = new byte[4];
        this.af.read(phyBlockId, off, b, 0, 4);
        return IOUtil.bytesToInteger(b);
    }

    private void writeFATInt(long offset, int block) throws IOException {
        int blockId = (int)(offset / 4096L);
        int off = (int)(offset % 4096L);
        if (blockId >= this.totalFATBlocks) {
            int newTotalBlocks = blockId + 1;
            this.ensureFATBlocks(newTotalBlocks);
            int lastFATBlock = this.fatBlocks[this.totalFATBlocks - 1];
            for (int i = this.totalFATBlocks; i < newTotalBlocks; ++i) {
                int freeBlock = this.getFreeBlock();
                this.writeFATInt(lastFATBlock * 4, freeBlock);
                this.fatBlocks[this.totalFATBlocks] = freeBlock;
                lastFATBlock = freeBlock;
                ++this.totalFATBlocks;
            }
            this.writeFATInt(lastFATBlock * 4, -1);
        }
        int phyBlockId = this.getFATBlock(blockId);
        byte[] b = new byte[4];
        IOUtil.integerToBytes(block, b);
        this.af.write(phyBlockId, off, b, 0, 4);
    }

    private void ensureFATBlocks(int size) {
        if (this.fatBlocks.length < size) {
            int length = (size / 32 + 1) * 32;
            int[] blocks = new int[length];
            System.arraycopy(this.fatBlocks, 0, blocks, 0, this.totalFATBlocks);
            this.fatBlocks = blocks;
        }
    }

    private int getFATBlock(int blockId) throws IOException {
        if (!$assertionsDisabled && blockId >= this.totalFATBlocks) {
            throw new AssertionError();
        }
        return this.fatBlocks[blockId];
    }

    private void initFATBlock(int blockId) throws IOException {
        byte[] b = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            b[i] = -1;
        }
        this.af.write(blockId, 0, b, 0, 4096);
    }

    static {
        $assertionsDisabled = !AllocationTable.class.desiredAssertionStatus();
    }

    class Entry {
        private int totalBlocks;
        private int[] blockIds = new int[32];

        private Entry(int blockId) throws IOException {
            this.blockIds[0] = blockId;
            this.totalBlocks = 1;
        }

        void refresh() throws IOException {
            int lastBlockId = this.getLastBlock();
            int blockId = AllocationTable.this.readFATInt(lastBlockId * 4);
            while (blockId != -1) {
                this.ensureBlocks(this.totalBlocks + 1);
                this.blockIds[this.totalBlocks] = blockId;
                ++this.totalBlocks;
                blockId = AllocationTable.this.readFATInt(blockId * 4);
            }
        }

        private void ensureBlocks(int size) {
            if (this.blockIds == null || this.blockIds.length < size) {
                size = size / 32 * 32 + 32;
                int[] blocks = new int[size];
                if (this.blockIds != null) {
                    System.arraycopy(this.blockIds, 0, blocks, 0, this.totalBlocks);
                }
                this.blockIds = blocks;
            }
        }

        int getTotalBlocks() throws IOException {
            return this.totalBlocks;
        }

        int getFirstBlock() {
            return this.blockIds[0];
        }

        int getLastBlock() {
            return this.blockIds[this.totalBlocks - 1];
        }

        int getBlock(int index) {
            if (index < this.totalBlocks) {
                return this.blockIds[index];
            }
            return -1;
        }

        void allocBlocks(int blockCount) throws IOException {
            this.ensureBlocks(this.totalBlocks + blockCount);
            int lastBlockId = this.getLastBlock();
            for (int i = 0; i < blockCount; ++i) {
                int blockId;
                this.blockIds[this.totalBlocks + i] = blockId = AllocationTable.this.getFreeBlock();
                AllocationTable.this.writeFATInt(lastBlockId * 4, blockId);
                lastBlockId = blockId;
            }
            AllocationTable.this.writeFATInt(lastBlockId * 4, -1);
            this.totalBlocks += blockCount;
        }
    }
}

