/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.Page;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateContent;
import org.eclipse.birt.report.soapengine.api.UpdateData;

public abstract class AbstractGetPageActionHandler
extends AbstractBaseActionHandler {
    protected BaseAttributeBean __bean;
    protected String __docName;
    protected long __pageNumber;
    protected long __totalPageNumber;
    protected boolean __isCompleted = true;
    protected boolean __useBookmark = false;
    protected String __bookmark;
    protected boolean __svgFlag;
    protected ByteArrayOutputStream __page = null;
    protected ArrayList __activeIds = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract String __getReportDocument();

    protected abstract void __checkDocumentExists() throws Exception;

    public AbstractGetPageActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        super(iContext, operation, getUpdatedObjectsResponse);
    }

    protected void __execute() throws Exception {
        this.prepareParameters();
        this.doExecution();
        this.prepareResponse();
    }

    protected void prepareParameters() throws Exception, RemoteException {
        this.__bean = this.context.getBean();
        this.__docName = this.__getReportDocument();
        this.__checkDocumentExists();
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("locale", this.__bean.getLocale());
        inputOptions.setOption("rtl", new Boolean(this.__bean.isRtl()));
        inputOptions.setOption("request", this.context.getRequest());
        OutputOptions outputOptions = new OutputOptions();
        InputOptions inputOptions2 = new InputOptions();
        this.__totalPageNumber = this.getReportService().getPageCount(this.__docName, inputOptions, outputOptions);
        Boolean bl = (Boolean)outputOptions.getOption("completed");
        if (bl != null) {
            this.__isCompleted = bl;
        }
        this.__pageNumber = this.getPageNumber(this.context.getRequest(), this.operation.getOprand(), this.__docName);
        if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
            this.__bookmark = this.getBookmark(this.operation.getOprand(), this.__bean);
            inputOptions2.setOption("request", this.context.getRequest());
            inputOptions2.setOption("locale", this.__bean.getLocale());
            this.__pageNumber = this.getReportService().getPageNumberByBookmark(this.__docName, this.__bookmark, inputOptions2);
            if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
                this.__bookmark = this.getReportService().findTocByName(this.__docName, this.__bookmark, inputOptions2);
                this.__pageNumber = this.getReportService().getPageNumberByBookmark(this.__docName, this.__bookmark, inputOptions2);
                if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
                    AxisFault axisFault = new AxisFault();
                    axisFault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.INVALID_BOOKMARK", new String[]{this.getBookmark(this.operation.getOprand(), this.__bean)}));
                    throw axisFault;
                }
            }
            this.__useBookmark = true;
        }
        if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
            AxisFault axisFault = new AxisFault();
            axisFault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER"));
            throw axisFault;
        }
        this.__svgFlag = this.getSVGFlag(this.operation.getOprand());
    }

    protected void doExecution() throws ReportServiceException, RemoteException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("locale", this.__bean.getLocale());
        inputOptions.setOption("rtl", new Boolean(this.__bean.isRtl()));
        inputOptions.setOption("request", this.context.getRequest());
        inputOptions.setOption("svgFlag", new Boolean(this.__svgFlag));
        inputOptions.setOption("isMasterPageContent", new Boolean(this.__bean.isMasterPageContent()));
        this.__activeIds = new ArrayList();
        this.__page = this.getReportService().getPage(this.__docName, this.__pageNumber + "", inputOptions, this.__activeIds);
    }

    protected void prepareResponse() throws ReportServiceException, RemoteException {
        UpdateContent updateContent = new UpdateContent();
        updateContent.setContent(this.__page.toString());
        updateContent.setTarget("Document");
        updateContent.setInitializationId(this.parseReportId(this.__activeIds));
        if (this.__useBookmark) {
            updateContent.setBookmark(this.__bookmark);
        }
        Update update = new Update();
        update.setUpdateContent(updateContent);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("navigationBar");
        Page page = new Page();
        page.setPageNumber(String.valueOf(this.__pageNumber));
        page.setTotalPage(String.valueOf(this.__totalPageNumber));
        Data data = new Data();
        data.setPage(page);
        updateData.setData(data);
        Update update2 = new Update();
        update2.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update, update2});
    }

    protected boolean isValidPageNumber(HttpServletRequest httpServletRequest, long l, String string) throws RemoteException, ReportServiceException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        return l > 0L && l <= this.__totalPageNumber;
    }

    protected long getPageNumber(HttpServletRequest httpServletRequest, Oprand[] oprandArray, String string) throws RemoteException, ReportServiceException {
        long l = -1L;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"page".equalsIgnoreCase(oprandArray[i].getName())) continue;
                try {
                    l = Integer.parseInt(oprandArray[i].getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                if (l > 0L && l <= this.__totalPageNumber) break;
                AxisFault axisFault = new AxisFault();
                axisFault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                axisFault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER"));
                throw axisFault;
            }
        }
        return l;
    }

    protected String getBookmark(Oprand[] oprandArray, BaseAttributeBean baseAttributeBean) {
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        String string = null;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"bookmark".equalsIgnoreCase(oprandArray[i].getName())) continue;
                string = oprandArray[i].getValue();
                break;
            }
        }
        if (string == null || string.length() <= 0) {
            string = baseAttributeBean.getBookmark();
        }
        return string;
    }

    static {
        $assertionsDisabled = !AbstractGetPageActionHandler.class.desiredAssertionStatus();
    }
}

