/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.log;

import java.io.File;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.backend.JobLogFileReader;
import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class JobLogFileHandler
implements IAgentRequestHandler {
    private LogFileReader logReader = new JobLogFileReader();

    public void handle(Request request, Response response, Socket socket) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.log.JobLogFileHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (request.requestData instanceof ReadLogRequest) {
            ReadLogRequest readLogRequest = (ReadLogRequest)request.requestData;
            String string = readLogRequest.name;
            boolean bl = Agent.isWindows ? this.unqualifiedWindows(string) : this.unqualifiedUnix(string);
            if (bl) {
                readLogRequest.name = String.valueOf(Agent.logFileDirectory) + File.separatorChar + string;
            }
        }
        this.logReader.handle(request, response);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.log.JobLogFileHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle");
        }
    }

    private boolean unqualifiedWindows(String string) {
        if (string.length() < 3) {
            return true;
        }
        if (string.charAt(1) != ':' || string.charAt(2) != '\\') {
            return true;
        }
        char c = Character.toUpperCase(string.charAt(0));
        return c < 'A' || c > 'Z';
    }

    private boolean unqualifiedUnix(String string) {
        return string.length() <= 0 || string.charAt(0) != '/';
    }
}

