/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.agent.exec.CmdExecer;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CommonProbe {
    public Computer computer;
    public int rc;
    protected DevAccess removables;
    protected ProbeDefResp probeDef;
    protected static final String VRTS_BOOTFILE = "/etc/vx/volboot";
    protected String veritasHostName;
    protected static long blockSize = 512L;
    protected static long blockMultiplier = blockSize / 512L;
    protected int handleRc;
    protected static final int NONE_NULL = 1;
    protected static final int ALL_NULL = 0;
    protected static final int SOME_NULL = -1;

    protected abstract void platformSpecific();

    public static void setCtlrComputerID(Computer computer) {
        Controller controller = computer.cmpController;
        while (controller != null) {
            controller.ctlrComputerID = computer.cmpID;
            controller = controller.ctlrNext;
        }
    }

    public static void setVgComputerID(Computer computer) {
        VolGroup volGroup = computer.cmpVolGroup;
        while (volGroup != null) {
            volGroup.vgComputerID = computer.cmpID;
            if (computer.cmpOSType != 21) {
                computer.cmpVolGroupCapacity += volGroup.vgTotalSpace;
            }
            computer.cmpVolGroupFreespace += volGroup.vgFreeSpace;
            if (volGroup.vgDevices != null) {
                volGroup.vgDisks = volGroup.vgDevices.length;
            }
            volGroup = volGroup.vgNext;
        }
    }

    public static void setRankComputerID(Computer computer) {
        Rank rank = computer.cmpRank;
        while (rank != null) {
            rank.rankComputerID = computer.cmpID;
            rank = rank.rankNext;
        }
    }

    public static void sortExports(Computer computer) {
        TreeSet<Export> treeSet = new TreeSet<Export>(new PathCompare());
        Export export = computer.cmpExport;
        while (export != null) {
            treeSet.add(export);
            export = export.xpNext;
        }
        computer.cmpExport = null;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            export = (Export)iterator.next();
            export.xpNext = computer.cmpExport;
            export.xpComputerID = computer.cmpID;
            computer.cmpExport = export;
        }
    }

    private static long totalAllocdSpace(LogicalDisk logicalDisk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"totalAllocdSpace", (String)"ld");
        }
        long l = 0L;
        ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
        while (chunkCollection != null) {
            Chunk chunk = chunkCollection.ccChunkList;
            while (chunk != null) {
                if (chunk.chkDisk != null) {
                    Disk disk = chunk.chkDisk;
                    if (disk.devType != 5) {
                        l += chunk.chkSize;
                    }
                }
                chunk = chunk.chkNextInCollection;
            }
            chunkCollection = chunkCollection.ccNext;
        }
        long l2 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"totalAllocdSpace", (long)l2);
        }
        return l2;
    }

    public static void calculateLDOverhead(Computer computer) {
        LogicalDisk logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldType == 7 || logicalDisk.ldType == 4) {
                logicalDisk.ldOverhead = 0L;
            } else {
                LogicalDisk logicalDisk2;
                if (!Constants.isDiskArray((short)computer.cmpOSType) && logicalDisk.ldVgroup != null) {
                    VolGroup volGroup = logicalDisk.ldVgroup;
                    ++volGroup.vgVolumes;
                }
                if ((logicalDisk2 = logicalDisk.ldNextMirror) == null) {
                    logicalDisk.ldOverhead = CommonProbe.totalAllocdSpace(logicalDisk);
                } else {
                    logicalDisk.ldOverhead = 0L;
                    while (logicalDisk2 != null) {
                        logicalDisk.ldOverhead += CommonProbe.totalAllocdSpace(logicalDisk2);
                        logicalDisk2 = logicalDisk2.ldNextMirror;
                    }
                }
                logicalDisk.ldOverhead -= logicalDisk.ldCapacity;
                if (logicalDisk.ldOverhead < 0L) {
                    logicalDisk.ldOverhead = 0L;
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
    }

    protected void tallyGlobals(Computer computer) {
        if (computer.cmpOSType != 21) {
            computer.cmpDiskFreeSpace = 0L;
            computer.cmpDiskCapacity = 0L;
            computer.cmpOwnedDiskCap = 0L;
            computer.cmpOwnedDiskFreeSp = 0L;
            computer.cmpNDisks = 0;
            computer.cmpVolGroupCapacity = 0L;
            computer.cmpVolGroupFreespace = 0L;
            computer.cmpLogicalDiskAssignedCapacity = 0L;
            Device device = computer.cmpDevice;
            while (device != null) {
                if (device.devType != 5 && device instanceof Disk) {
                    boolean bl = false;
                    DevAccess devAccess = device.devControllers;
                    while (!bl && devAccess != null) {
                        if (devAccess.daInactive) {
                            devAccess = devAccess.daNextController;
                            continue;
                        }
                        bl = true;
                    }
                    Disk disk = (Disk)device;
                    if (disk.dskHistory.dkhFreeSpace < 0L) {
                        disk.dskHistory.dkhFreeSpace = -1L;
                    } else {
                        computer.cmpDiskFreeSpace += disk.dskHistory.dkhFreeSpace;
                        if (bl) {
                            computer.cmpOwnedDiskFreeSp += disk.dskHistory.dkhFreeSpace;
                        }
                    }
                    if (!disk.isSpare()) {
                        computer.cmpDiskCapacity += disk.dskCapacity;
                    }
                    if (bl) {
                        computer.cmpOwnedDiskCap += disk.dskCapacity;
                        ++computer.cmpNDisks;
                    }
                    disk.dskHistory.dkhCapacity = disk.dskCapacity;
                }
                device = device.devNext;
            }
            if (computer.cmpDiskFreeSpace < 0L) {
                computer.cmpDiskFreeSpace = -1L;
            }
            if (Constants.isDiskArray((short)computer.cmpOSType)) {
                computer.cmpZOSLogicalDiskCapacity = -1L;
                computer.cmpNLogicalDisks = 0;
                computer.cmpLogicalDiskCapacity = 0L;
                device = computer.cmpLogicalDisk;
                while (device != null) {
                    if (!device.notExposed()) {
                        computer.cmpLogicalDiskAssignedCapacity += device.ldCapacity;
                    }
                    if (computer.cmpOSType == 12) {
                        if (device.ldPath.startsWith("0")) {
                            computer.cmpZOSLogicalDiskCapacity += device.ldCapacity;
                        }
                    } else if ((computer.cmpOSType == 25 || computer.cmpOSType == 27) && device.ldStorageType == 3) {
                        computer.cmpZOSLogicalDiskCapacity += device.ldCapacity;
                    }
                    ++computer.cmpNLogicalDisks;
                    computer.cmpLogicalDiskCapacity += device.ldCapacity;
                    device = device.ldNext;
                }
            }
        }
        CommonProbe.calculateLDOverhead(computer);
        CommonProbe.setCtlrComputerID(computer);
        CommonProbe.setVgComputerID(computer);
        CommonProbe.setRankComputerID(computer);
        if (computer.cmpOSType == 15) {
            computer.cmpDiskFreeSpace = computer.cmpVolGroupFreespace + computer.cmpDiskGroupFreeCap;
        }
    }

    protected void tallyFS(Computer computer) {
        computer.cmpFilesystemFreeSpace = 0L;
        LogicalDisk logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            Filesystem filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null && filesystem.fsType != 10) {
                computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
            }
            logicalDisk = logicalDisk.ldNext;
        }
    }

    protected void tallyGlobals() {
        NasFiler nasFiler;
        this.tallyGlobals(this.computer);
        NasFiler nasFiler2 = nasFiler = this.computer.cmpNasFiler;
        while (nasFiler2 != null) {
            if (Constants.isVirtualServer((int)nasFiler2.nfComputer.cmpOSType)) {
                this.tallyGlobals(nasFiler2.nfComputer);
                this.tallyFS(nasFiler2.nfComputer);
            }
            nasFiler2 = nasFiler2.nfNext;
        }
    }

    public int probe(ProbeDefResp probeDefResp) {
        this.rc = 8;
        return this.rc;
    }

    protected void multiPathDevice(Device device, Device device2) {
    }

    public static void arrangeDevices(Computer computer, CommonProbe commonProbe) {
        Iterator iterator;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"arrangeDevices", (String)"computer, self");
        }
        computer.cmpDevice = null;
        TreeSet<Controller> treeSet = new TreeSet<Controller>(new CtlrCompare());
        TreeSet<DevAccess> treeSet2 = new TreeSet<DevAccess>(new AccessCompare());
        HashMap<String, Device> hashMap = new HashMap<String, Device>();
        Controller controller = computer.cmpController;
        while (controller != null) {
            treeSet.add(controller);
            DevAccess devAccess = controller.ctlrDevices;
            while (devAccess != null) {
                treeSet2.add(devAccess);
                Device device = devAccess.daDevice;
                Object v = hashMap.get(device.devSerialNumber);
                if (v == null) {
                    hashMap.put(device.devSerialNumber, device);
                    device.devNext = computer.cmpDevice;
                    computer.cmpDevice = device;
                    devAccess.daNextController = null;
                    device.devControllers = devAccess;
                } else {
                    Device device2 = (Device)v;
                    DevAccess devAccess2 = device2.devControllers;
                    MessageLog.logMessage((String)"STA0167I", (Object)devAccess2.daPath, (Object)devAccess.daPath);
                    devAccess.daDevice = device2;
                    devAccess.daNextController = devAccess2;
                    device2.devControllers = devAccess;
                    if (commonProbe != null) {
                        commonProbe.multiPathDevice(device2, device);
                    }
                }
                devAccess = devAccess.daNextDevice;
            }
            controller.ctlrDevices = null;
            iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                devAccess = (DevAccess)iterator.next();
                devAccess.daNextDevice = controller.ctlrDevices;
                controller.ctlrDevices = devAccess;
            }
            treeSet2.clear();
            controller = controller.ctlrNext;
        }
        computer.cmpController = null;
        hashMap = null;
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            controller = (Controller)iterator.next();
            controller.ctlrNext = computer.cmpController;
            computer.cmpController = controller;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"arrangeDevices");
        }
    }

    protected void arrangeDevices() {
        CommonProbe.arrangeDevices(this.computer, this);
    }

    private static boolean notEmpty(Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"notEmpty", (String)"array");
        }
        boolean bl = objectArray == null ? false : objectArray.length;
        boolean bl2 = true;
        boolean bl3 = false;
        while (bl2 && bl3 < bl) {
            if (objectArray[bl3] != null) {
                bl2 = false;
            }
            bl3 += 1;
        }
        boolean bl4 = bl3 = !bl2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"notEmpty", (boolean)bl3);
        }
        return bl3;
    }

    private static boolean cleanSimpleLD(LogicalDisk logicalDisk) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanSimpleLD", (String)"ld");
        }
        ChunkCollection chunkCollection = null;
        ChunkCollection chunkCollection2 = logicalDisk.ldCollectionList;
        while (chunkCollection2 != null) {
            if (chunkCollection2.ccChunkList != null || CommonProbe.notEmpty(chunkCollection2.ccPackedChunkList)) {
                chunkCollection = chunkCollection2;
            } else if (chunkCollection != null) {
                chunkCollection.ccNext = chunkCollection2.ccNext;
            } else {
                logicalDisk.ldCollectionList = chunkCollection2.ccNext;
            }
            chunkCollection2 = chunkCollection2.ccNext;
        }
        boolean bl2 = bl = logicalDisk.ldCollectionList != null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanSimpleLD", (boolean)bl);
        }
        return bl;
    }

    private static boolean cleanComplexLD(LogicalDisk logicalDisk) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanComplexLD", (String)"logicalDisk");
        }
        LogicalDisk logicalDisk2 = null;
        LogicalDisk logicalDisk3 = logicalDisk.ldNextMirror;
        while (logicalDisk3 != null) {
            if (CommonProbe.cleanSimpleLD(logicalDisk3)) {
                logicalDisk2 = logicalDisk3;
            } else {
                logicalDisk.ldMirrorCount = (byte)(logicalDisk.ldMirrorCount - 1);
                if (logicalDisk2 != null) {
                    logicalDisk2.ldNextMirror = logicalDisk3.ldNextMirror;
                } else {
                    logicalDisk.ldNextMirror = logicalDisk3.ldNextMirror;
                }
            }
            logicalDisk3 = logicalDisk3.ldNextMirror;
        }
        boolean bl2 = bl = logicalDisk.ldNextMirror != null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanComplexLD", (boolean)bl);
        }
        return bl;
    }

    private void removeChunklessCollections() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeChunklessCollections", (String)"");
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            boolean bl = logicalDisk.isComplex() ? CommonProbe.cleanComplexLD(logicalDisk) : CommonProbe.cleanSimpleLD(logicalDisk);
            if (!bl) {
                logicalDisk.ldType = (byte)7;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeChunklessCollections");
        }
    }

    protected LogicalDisk promoteChunk(Chunk chunk) {
        LogicalDisk logicalDisk;
        ChunkCollection chunkCollection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"promoteChunk", (String)"chunk");
        }
        if ((chunkCollection = chunk.chkCollection) != null) {
            LogicalDisk logicalDisk2 = chunkCollection.ccLogicalDisk;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"promoteChunk", (Object)logicalDisk2);
            }
            return logicalDisk2;
        }
        chunkCollection = new ChunkCollection();
        chunkCollection.ccStripingSize = -1;
        chunkCollection.ccSeqno = 0;
        chunkCollection.ccType = 0;
        chunkCollection.ccChunkList = chunk;
        chunk.chkCollection = chunkCollection;
        chunk.chkSeqno = 0;
        chunkCollection.ccLogicalDisk = logicalDisk = new LogicalDisk();
        logicalDisk.ldCollectionList = chunkCollection;
        logicalDisk.ldType = 0;
        logicalDisk.ldCapacity = chunk.chkSize;
        if (chunk.chkDisk != null) {
            logicalDisk.ldIsSwap = chunk.chkDiskID == -2;
        }
        logicalDisk.ldNext = this.computer.cmpLogicalDisk;
        this.computer.cmpLogicalDisk = logicalDisk;
        LogicalDisk logicalDisk3 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"promoteChunk", (Object)logicalDisk3);
        }
        return logicalDisk3;
    }

    protected void cleanUpPartitionsAndDisks() {
        Controller controller;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanUpPartitionsAndDisks", (String)"");
        }
        Device device = null;
        this.removeChunklessCollections();
        Device device2 = this.computer.cmpDevice;
        while (device2 != null) {
            if (device2 instanceof Disk) {
                Disk disk = (Disk)device2;
                Chunk chunk = disk.dskChunk;
                while (chunk != null) {
                    if (chunk.chkCollection == null) {
                        this.promoteChunk(chunk);
                    }
                    chunk = chunk.chkNextOnDisk;
                }
                device = device2;
            } else {
                if (device != null) {
                    device.devNext = device2.devNext;
                } else {
                    this.computer.cmpDevice = device2.devNext;
                }
                DevAccess devAccess = device2.devControllers;
                while (devAccess != null) {
                    controller = devAccess.daController;
                    DevAccess devAccess2 = null;
                    DevAccess devAccess3 = controller.ctlrDevices;
                    while (devAccess3 != devAccess && devAccess3 != null) {
                        devAccess2 = devAccess3;
                        devAccess3 = devAccess3.daNextDevice;
                    }
                    if (devAccess3 == devAccess) {
                        if (devAccess2 != null) {
                            devAccess2.daNextDevice = devAccess3.daNextDevice;
                        } else {
                            controller.ctlrDevices = devAccess3.daNextDevice;
                        }
                    }
                    devAccess.daNextDevice = this.removables;
                    this.removables = devAccess;
                    devAccess = devAccess.daNextController;
                }
            }
            device2 = device2.devNext;
        }
        Controller controller2 = null;
        controller = this.computer.cmpController;
        while (controller != null) {
            if (controller.ctlrDevices != null || controller.ctlrHBAPortWWN > 0L) {
                controller2 = controller;
            } else if (controller2 == null) {
                this.computer.cmpController = controller.ctlrNext;
            } else {
                controller2.ctlrNext = controller.ctlrNext;
            }
            controller = controller.ctlrNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanUpPartitionsAndDisks");
        }
    }

    protected Controller cloneController(Controller controller) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cloneController", (String)"ctlr");
        }
        Controller controller2 = new Controller();
        controller2.ctlrDriverName = controller.ctlrDriverName;
        controller2.ctlrDriverDescription = controller.ctlrDriverDescription;
        controller2.ctlrTarget = controller.ctlrTarget;
        controller2.ctlrType = controller.ctlrType;
        Controller controller3 = controller2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cloneController", (Object)controller3);
        }
        return controller3;
    }

    protected static void makeNASComputer(NasFiler nasFiler) {
        Computer computer = new Computer();
        computer.cmpManufacturer = nasFiler.nfManufacturer;
        computer.cmpDomain = nasFiler.nfDomain;
        computer.cmpDomainID = nasFiler.nfDomain != null ? nasFiler.nfDomain.domID : -1;
        computer.cmpOSType = (short)9;
        computer.cmpRAM = -1;
        computer.cmpSwapSpace = -1;
        computer.cmpDiskCapacity = -1L;
        computer.cmpDiskFreeSpace = -1L;
        computer.cmpOwnedDiskCap = -1L;
        computer.cmpOwnedDiskFreeSp = -1L;
        computer.cmpFilesystemFreeSpace = -1L;
        computer.cmpOSVersion = " ";
        computer.cmpProcessorType = " ";
        computer.cmpModel = " ";
        computer.cmpSerialNumber = " ";
        computer.cmpID = nasFiler.nfComputerID;
        nasFiler.nfComputer = computer;
    }

    protected static void addFSToFiler(NasFiler nasFiler, Filesystem filesystem) {
        LogicalDisk logicalDisk = new LogicalDisk();
        logicalDisk.ldCapacity = filesystem.fsCapacity;
        logicalDisk.ldPath = filesystem.fsMountPoint;
        logicalDisk.ldFilesystem = filesystem;
        filesystem.fsLogicalDisk = logicalDisk;
        logicalDisk.ldType = (byte)7;
        Computer computer = nasFiler.nfComputer;
        logicalDisk.ldNext = computer.cmpLogicalDisk;
        computer.cmpLogicalDisk = logicalDisk;
    }

    private static void cleanUpChild(CmdExecer cmdExecer) {
        cmdExecer.close();
    }

    protected boolean isVeritasRunning() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isVeritasRunning", (String)"");
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)">> executing ... /usr/sbin/vxdctl mode | awk '{ print $2 }'");
        }
        ShellCommand shellCommand = new ShellCommand("/usr/sbin/vxdctl mode | awk '{ print $2 }'");
        if (!shellCommand.bCool || shellCommand.getErrString() != null) {
            MessageLog.logMessage((String)"STA0350E");
            shellCommand.cleanUp();
            boolean bl2 = bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isVeritasRunning", (boolean)bl2);
            }
            return bl2;
        }
        String string = null;
        while ((string = shellCommand.getString()) != null) {
            if (string.compareTo("enabled") == 0) {
                bl = true;
                continue;
            }
            MessageLog.logMessage((String)"STA0350E");
        }
        shellCommand.cleanUp();
        boolean bl3 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isVeritasRunning", (boolean)bl3);
        }
        return bl3;
    }

    protected void determineVeritasHostName() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"determineVeritasHostName", (String)"");
        }
        this.veritasHostName = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(VRTS_BOOTFILE);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"determineVeritasHostName", (Throwable)iOException);
            }
            MessageLog.logException((String)"GEN0029E", (Exception)iOException);
            this.rc = 4;
        }
        if (fileReader == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"determineVeritasHostName");
            }
            return;
        }
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string;
            MutableInteger mutableInteger = new MutableInteger();
            while (this.veritasHostName == null && (string = bufferedReader.readLine()) != null) {
                mutableInteger.value = 0;
                String string2 = Util.nextWord((String)string, (MutableInteger)mutableInteger);
                if (!Util.stringsEqual((String)string2, (String)"hostid")) continue;
                this.veritasHostName = Util.nextWord((String)string, (MutableInteger)mutableInteger);
            }
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"determineVeritasHostName", (Throwable)iOException);
            }
            MessageLog.logException((String)"GEN0133E", (Exception)iOException, (Object)VRTS_BOOTFILE);
            bl = true;
        }
        if (this.veritasHostName == null) {
            if (!bl) {
                MessageLog.logMessage((String)"STA0244W");
            }
            this.rc = 4;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"determineVeritasHostName");
        }
    }

    private Vector getVeritasConfiguration() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVeritasConfiguration", (String)"");
        }
        Vector<VeritasDiskGroup> vector = new Vector<VeritasDiskGroup>(10, 2);
        ShellCommand shellCommand = null;
        String string = null;
        VeritasDiskGroup veritasDiskGroup = null;
        StringTokenizer stringTokenizer = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)">> executing ... /usr/sbin/vxdg -q list");
        }
        shellCommand = new ShellCommand("/usr/sbin/vxdg -q list");
        if (!shellCommand.bCool || shellCommand.getErrString() != null) {
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"31 /usr/sbin/vxdg -q list");
            shellCommand.cleanUp();
            Vector vector2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"getVeritasConfiguration", (String)">> No VxVM disk group found...");
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", vector2);
            }
            return vector2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getVeritasConfiguration", (String)(">> Processing VxVM disk group " + string));
        }
        String string2 = null;
        while ((string = shellCommand.getString()) != null) {
            stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
            veritasDiskGroup = new VeritasDiskGroup(string2);
            vector.add(veritasDiskGroup);
        }
        shellCommand.cleanUp();
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getVeritasConfiguration", (String)">> Processing each VxVM disk group attributes...");
        }
        int n = 0;
        while (n < vector.size()) {
            veritasDiskGroup = (VeritasDiskGroup)vector.elementAt(n);
            if (veritasDiskGroup.setAttributes()) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getVeritasConfiguration", (String)(">> Successfully processed VxVM disk group attributes for " + veritasDiskGroup.name));
                }
                bl = false;
            } else {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getVeritasConfiguration", (String)(">> ERROR: dg_getconfig_all() failed -- Veritas error 0, 31" + veritasDiskGroup.name));
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("31" + veritasDiskGroup.name));
            }
            ++n;
        }
        if (bl) {
            vector = null;
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"31 /usr/sbin/vxdg -q list");
        }
        Vector<VeritasDiskGroup> vector3 = vector;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            if (vector == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz3.getName(), (String)"getVeritasConfiguration", (String)">> Exiting with NO VxVM disk group found (NULL)...");
            } else {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz4.getName(), (String)"getVeritasConfiguration", (String)(">> Exiting with " + vector3.size() + " VxVM disk groups found..."));
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVeritasConfiguration", vector3);
        }
        return vector3;
    }

    public int handleVeritas() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleVeritas", (String)"");
        }
        Vector vector = null;
        HashedDisk hashedDisk = null;
        HashedVolume hashedVolume = null;
        HashedPlex hashedPlex = null;
        HashedSubDisk hashedSubDisk = null;
        Hashtable<VeritasRid, HashedDisk> hashtable = null;
        Hashtable<VeritasRid, HashedVolume> hashtable2 = null;
        Hashtable<VeritasRid, HashedPlex> hashtable3 = null;
        int n = 0;
        long l = 0L;
        VeritasDiskGroup veritasDiskGroup = null;
        VeritasDisk veritasDisk = null;
        VeritasVolume veritasVolume = null;
        VeritasPlex veritasPlex = null;
        VeritasSubDisk veritasSubDisk = null;
        HashedVolume hashedVolume2 = null;
        HashedVolume hashedVolume3 = null;
        HashedVolume hashedVolume4 = null;
        HashedVolume hashedVolume5 = null;
        HashedSubDisk hashedSubDisk2 = null;
        HashedSubDisk hashedSubDisk3 = null;
        vector = this.getVeritasConfiguration();
        if (vector == null) {
            int n2 = 4;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleVeritas", (int)n2);
            }
            return n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            veritasDiskGroup = (VeritasDiskGroup)vector.elementAt(n3);
            if (!veritasDiskGroup.probed) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"handleVeritas", (String)(">> Skipping non-probed VxVM disk group " + veritasDiskGroup.name));
                }
            } else {
                Chunk chunk;
                Disk disk;
                LinkedList<Disk> linkedList = new LinkedList<Disk>();
                hashtable = new Hashtable<VeritasRid, HashedDisk>();
                int n4 = 0;
                while (n4 < veritasDiskGroup.diskVector.size()) {
                    disk = null;
                    chunk = null;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"handleVeritas", (String)(">> Processing each disk of VxVM disk group " + veritasDiskGroup.name));
                    }
                    veritasDisk = (VeritasDisk)veritasDiskGroup.diskVector.elementAt(n4);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"handleVeritas", (String)(">> Calling lookUpDisk() for deviceTag " + veritasDisk.deviceTag + " with publicCPath = " + veritasDisk.publicCPath + " and privateCPath = " + veritasDisk.privateCPath));
                    }
                    if ((disk = this.lookUpDisk(veritasDisk.deviceTag)) == null) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"handleVeritas", (String)">> Returned from lookUpDisk() with NULL...continue to next disk...");
                        }
                        n = 4;
                    } else {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"handleVeritas", (String)(">> adding disk with deviceTag = " + veritasDisk.deviceTag + " and devCanonicalName = " + disk.devCanonicalName + " to vgDevlist..."));
                        }
                        linkedList.add(disk);
                        if (!this.AdjustDMOffset(disk, veritasDisk.publicCPath, veritasDisk.publicOffset)) {
                            n = 4;
                        }
                        l = disk.dskCapacity - 1L;
                        if (!veritasDisk.tFlag) {
                            chunk = null;
                        } else {
                            if (!this.AdjustDMOffset(disk, veritasDisk.privateCPath, veritasDisk.privateOffset)) {
                                n = 4;
                            }
                            chunk = new Chunk();
                            chunk.chkDiskID = -1;
                            chunk.chkPartition = (short)-1;
                            chunk.chkUnitSize = 512;
                            chunk.chkSize = veritasDisk.privateLength;
                            chunk.chkOffset = veritasDisk.privateOffset;
                            chunk.chkDisk = disk;
                            l -= chunk.chkSize;
                        }
                        disk.dskChunk = chunk;
                        disk.dskHistory.dkhFreeSpace = l;
                        hashedDisk = new HashedDisk(veritasDisk, disk);
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> putting hashDisk with vrtsDisk.rid = " + veritasDisk.rid.toString() + " to diskTable..."));
                        }
                        hashtable.put(veritasDisk.rid, hashedDisk);
                    }
                    ++n4;
                }
                hashedVolume3 = null;
                hashtable2 = new Hashtable<VeritasRid, HashedVolume>();
                n4 = 0;
                while (n4 < veritasDiskGroup.volumeVector.size()) {
                    veritasVolume = (VeritasVolume)veritasDiskGroup.volumeVector.elementAt(n4);
                    hashedVolume = new HashedVolume(veritasVolume);
                    if (veritasVolume.sdNum == 0) {
                        if (hashedVolume3 == null) {
                            hashedVolume3 = hashedVolume;
                        } else {
                            hashedVolume5.next = hashedVolume;
                        }
                        hashedVolume5 = hashedVolume;
                    }
                    hashtable2.put(veritasVolume.rid, hashedVolume);
                    ++n4;
                }
                hashtable3 = new Hashtable<VeritasRid, HashedPlex>();
                n4 = 0;
                while (n4 < veritasDiskGroup.plexVector.size()) {
                    veritasPlex = (VeritasPlex)veritasDiskGroup.plexVector.elementAt(n4);
                    hashedPlex = new HashedPlex(veritasPlex);
                    hashtable3.put(veritasPlex.rid, hashedPlex);
                    hashedVolume = (HashedVolume)hashtable2.get(veritasPlex.volumeRid);
                    if (hashedVolume != null) {
                        hashedPlex.hashVolume = hashedVolume;
                        this.AddPlexToVolume(hashedVolume, hashedPlex);
                    } else {
                        MessageLog.logMessage((String)"STA0229W", (Object)veritasPlex.name, (Object)veritasPlex.volumeName, (Object)veritasPlex.volumeRid.toString());
                        n = 4;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < veritasDiskGroup.subDiskVector.size()) {
                    veritasSubDisk = (VeritasSubDisk)veritasDiskGroup.subDiskVector.elementAt(n4);
                    if (veritasSubDisk.pFlag) {
                        hashedVolume = (HashedVolume)hashtable2.get(veritasSubDisk.diskRid);
                        if (hashedVolume == null) {
                            MessageLog.logMessage((String)"STA0230W", (Object)veritasSubDisk.name, (Object)veritasSubDisk.diskRid.toString());
                            n = 4;
                        } else {
                            hashedPlex = this.LookUpPlex(hashtable3, veritasSubDisk);
                            if (hashedPlex == null) {
                                n = 4;
                            } else if (hashedVolume.vrtsVolume.sdNum == 0) {
                                MessageLog.logMessage((String)"STA0233W", (Object)hashedVolume.vrtsVolume.name, (Object)hashedVolume.vrtsVolume.rid.toString());
                                n = 4;
                            } else {
                                hashedVolume2 = hashedPlex.hashVolume;
                                if (hashedVolume.assocVolume != null) {
                                    MessageLog.logMessage((String)"STA0232W", (Object)hashedVolume.vrtsVolume.name, (Object)hashedVolume.assocVolume.vrtsVolume.name, (Object)hashedVolume2.vrtsVolume.name);
                                    n = 4;
                                } else if (hashedVolume2.vrtsVolume.sdNum != 0) {
                                    MessageLog.logMessage((String)"STA0234W", (Object)hashedVolume2.vrtsVolume.name);
                                } else {
                                    hashedVolume.assocVolume = hashedVolume2;
                                    hashedVolume.column = veritasSubDisk.column;
                                    if (hashedVolume2.assocVolume == null) {
                                        hashedVolume.next = null;
                                        hashedVolume2.assocVolume = hashedVolume;
                                    } else if (hashedVolume.column <= hashedVolume2.assocVolume.column) {
                                        hashedVolume.next = hashedVolume2.assocVolume;
                                        hashedVolume2.assocVolume = hashedVolume;
                                    } else {
                                        hashedVolume5 = hashedVolume2.assocVolume;
                                        hashedVolume4 = hashedVolume5.next;
                                        while (hashedVolume4 != null && hashedVolume.column > hashedVolume4.column) {
                                            hashedVolume5 = hashedVolume4;
                                            hashedVolume4 = hashedVolume4.next;
                                        }
                                        hashedVolume.next = hashedVolume4;
                                        hashedVolume5.next = hashedVolume;
                                    }
                                }
                            }
                        }
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < veritasDiskGroup.subDiskVector.size()) {
                    veritasSubDisk = (VeritasSubDisk)veritasDiskGroup.subDiskVector.elementAt(n4);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> current vrtsSubDisk: diskName = " + veritasSubDisk.diskName + ", diskRid = " + veritasSubDisk.diskRid.toString() + ", pFlag = " + veritasSubDisk.pFlag + " for diskGroup = " + veritasSubDisk.diskGroup));
                    }
                    if (!veritasSubDisk.pFlag) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> getting hashDisk from diskTable with diskRid = " + veritasSubDisk.diskRid.toString()));
                        }
                        if ((hashedDisk = (HashedDisk)hashtable.get(veritasSubDisk.diskRid)) == null) {
                            MessageLog.logMessage((String)"STA0235W", (Object)veritasSubDisk.name, (Object)veritasSubDisk.diskName, (Object)veritasSubDisk.diskRid);
                            n = 4;
                        } else {
                            hashedDisk.disk.dskHistory.dkhFreeSpace -= veritasSubDisk.length;
                            hashedPlex = this.LookUpPlex(hashtable3, veritasSubDisk);
                            if (hashedPlex == null) {
                                n = 4;
                            } else {
                                hashedVolume = hashedPlex.hashVolume;
                                if (hashedVolume.vrtsVolume.sdNum != 0 && hashedVolume.assocVolume == null) {
                                    if (!hashedVolume.bMsgIssued) {
                                        MessageLog.logMessage((String)"STA0236W", (Object)hashedVolume.vrtsVolume.name, (Object)hashedVolume.vrtsVolume.rid.toString());
                                        hashedVolume.bMsgIssued = true;
                                    }
                                    n = 4;
                                } else {
                                    hashedSubDisk = new HashedSubDisk(veritasSubDisk, hashedDisk);
                                    if (hashedPlex.hashSubDisk == null) {
                                        hashedSubDisk.next = null;
                                        hashedPlex.hashSubDisk = hashedSubDisk;
                                    } else if (!this.SubDiskGreaterThan(hashedSubDisk, hashedPlex.hashSubDisk)) {
                                        hashedSubDisk.next = hashedPlex.hashSubDisk;
                                        hashedPlex.hashSubDisk = hashedSubDisk;
                                    } else {
                                        hashedSubDisk3 = hashedPlex.hashSubDisk;
                                        hashedSubDisk2 = hashedSubDisk3.next;
                                        while (hashedSubDisk2 != null && this.SubDiskGreaterThan(hashedSubDisk, hashedSubDisk2)) {
                                            hashedSubDisk3 = hashedSubDisk2;
                                            hashedSubDisk2 = hashedSubDisk2.next;
                                        }
                                        hashedSubDisk.next = hashedSubDisk2;
                                        hashedSubDisk3.next = hashedSubDisk;
                                    }
                                }
                            }
                        }
                    }
                    ++n4;
                }
                VolGroup volGroup = null;
                disk = new VolGroup();
                disk.vgName = veritasDiskGroup.name;
                disk.vgType = 0;
                disk.vgFreeSpace = veritasDiskGroup.freeSpace;
                disk.vgTotalSpace = veritasDiskGroup.totalSpace;
                disk.vgDevices = new Device[linkedList.size()];
                linkedList.toArray(disk.vgDevices);
                disk.vgNext = volGroup = this.computer.cmpVolGroup;
                this.computer.cmpVolGroup = disk;
                hashedVolume = hashedVolume3;
                while (hashedVolume != null) {
                    chunk = null;
                    LogicalDisk logicalDisk = null;
                    this.handleRc = n;
                    chunk = hashedVolume.assocVolume != null ? this.HandleLayeredVolume(hashedVolume) : this.HandleSimpleVolume(hashedVolume, false);
                    n = this.handleRc;
                    if (chunk != null) {
                        String string = "/dev/vx/dsk/" + veritasDiskGroup.name + "/" + hashedVolume.vrtsVolume.name;
                        chunk.ldVgroup = disk;
                        chunk.ldPath = string;
                        chunk.ldTruePath = string;
                        chunk.ldCapacity = hashedVolume.vrtsVolume.length;
                        chunk.ldNext = logicalDisk = this.computer.cmpLogicalDisk;
                        this.computer.cmpLogicalDisk = chunk;
                    }
                    hashedVolume = hashedVolume.next;
                }
            }
            ++n3;
        }
        n3 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleVeritas", (int)n3);
        }
        return n3;
    }

    private boolean AdjustDMOffset(Disk disk, String string, long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"AdjustDMOffset", (String)"disk, publicCPath, offset");
        }
        int n = 0;
        Chunk chunk = null;
        boolean bl = false;
        short s = 0;
        boolean bl2 = true;
        int n2 = -1;
        n2 = string.indexOf(115);
        if (n2 < 0) {
            boolean bl3 = bl2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AdjustDMOffset", (boolean)bl3);
            }
            return bl3;
        }
        try {
            n = Integer.parseInt(string.substring(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"AdjustDMOffset", (Throwable)numberFormatException);
            }
            boolean bl4 = bl2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AdjustDMOffset", (boolean)bl4);
            }
            return bl4;
        }
        if (n == 2) {
            boolean bl5 = bl2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AdjustDMOffset", (boolean)bl5);
            }
            return bl5;
        }
        bl = true;
        chunk = disk.dskChunk;
        while (chunk != null && bl) {
            s = chunk.chkPartition;
            if (s == n) {
                bl = false;
                continue;
            }
            chunk = chunk.chkNextOnDisk;
        }
        if (!bl) {
            l += chunk.chkOffset;
        } else {
            MessageLog.logMessage((String)"STA0228W", (Object)string);
            bl2 = false;
        }
        boolean bl6 = bl2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"AdjustDMOffset", (boolean)bl6);
        }
        return bl6;
    }

    private void AddPlexToVolume(HashedVolume hashedVolume, HashedPlex hashedPlex) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"AddPlexToVolume", (String)"hashVolume, hashPlex");
        }
        HashedPlex hashedPlex2 = null;
        HashedPlex hashedPlex3 = null;
        hashedPlex2 = hashedVolume.hashPlex;
        if (hashedPlex2 == null) {
            hashedVolume.hashPlex = hashedPlex;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AddPlexToVolume");
            }
            return;
        }
        if (hashedPlex.vrtsPlex.rid.compareTo(hashedPlex2.vrtsPlex.rid) > 0) {
            hashedPlex.next = hashedPlex2;
            hashedVolume.hashPlex = hashedPlex;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AddPlexToVolume");
            }
            return;
        }
        hashedPlex3 = hashedPlex2;
        hashedPlex2 = hashedPlex2.next;
        while (hashedPlex2 != null && hashedPlex.vrtsPlex.rid.compareTo(hashedPlex2.vrtsPlex.rid) > 0) {
            hashedPlex3 = hashedPlex2;
            hashedPlex2 = hashedPlex2.next;
        }
        hashedPlex.next = hashedPlex2;
        hashedPlex3.next = hashedPlex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"AddPlexToVolume");
        }
    }

    private HashedPlex LookUpPlex(Hashtable hashtable, VeritasSubDisk veritasSubDisk) {
        HashedPlex hashedPlex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"LookUpPlex", (String)"plexTable, veritasSubDisk");
        }
        if ((hashedPlex = (HashedPlex)hashtable.get(veritasSubDisk.plexRid)) == null) {
            MessageLog.logMessage((String)"STA0231W", (Object)veritasSubDisk.name, (Object)veritasSubDisk.plexName, (Object)veritasSubDisk.plexRid.toString());
        } else if (hashedPlex.hashVolume == null) {
            hashedPlex = null;
        }
        HashedPlex hashedPlex2 = hashedPlex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"LookUpPlex", (Object)hashedPlex2);
        }
        return hashedPlex2;
    }

    private boolean SubDiskGreaterThan(HashedSubDisk hashedSubDisk, HashedSubDisk hashedSubDisk2) {
        boolean bl;
        long l;
        long l2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"SubDiskGreaterThan", (String)"left, right");
        }
        if ((l2 = hashedSubDisk.vrtsSubDisk.plexOffset) != (l = hashedSubDisk2.vrtsSubDisk.plexOffset)) {
            boolean bl2;
            boolean bl3 = bl2 = l2 > l;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"SubDiskGreaterThan", (boolean)bl2);
            }
            return bl2;
        }
        boolean bl4 = bl = hashedSubDisk.vrtsSubDisk.column > hashedSubDisk2.vrtsSubDisk.column;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"SubDiskGreaterThan", (boolean)bl);
        }
        return bl;
    }

    private Chunk makeChunk(HashedDisk hashedDisk, ChunkCollection chunkCollection, int n, Chunk chunk, long l, long l2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeChunk", (String)"hashDisk, collection, seqNo, lastChunk, size, offset");
        }
        Chunk chunk2 = new Chunk();
        Disk disk = hashedDisk.disk;
        chunk2.chkPartition = (short)-1;
        chunk2.chkUnitSize = 512;
        chunk2.chkSize = l;
        chunk2.chkOffset = l2 + hashedDisk.vrtsDisk.publicOffset;
        chunk2.chkDiskID = -1;
        chunk2.chkDisk = disk;
        chunk2.chkNextOnDisk = disk.dskChunk;
        disk.dskChunk = chunk2;
        chunk2.chkCollection = chunkCollection;
        chunk2.chkSeqno = (short)n;
        if (chunk != null) {
            chunk.chkNextInCollection = chunk2;
        } else {
            chunkCollection.ccChunkList = chunk2;
        }
        Chunk chunk3 = chunk2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeChunk", (Object)chunk3);
        }
        return chunk3;
    }

    private Chunk makeChunkWrapped(HashedSubDisk hashedSubDisk, ChunkCollection chunkCollection, int n, Chunk chunk) {
        return this.makeChunk(hashedSubDisk.hashDisk, chunkCollection, n, chunk, hashedSubDisk.vrtsSubDisk.length, hashedSubDisk.vrtsSubDisk.diskOffset);
    }

    private ChunkCollection ConcatCollection(HashedPlex hashedPlex, LogicalDisk logicalDisk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ConcatCollection", (String)"hashPlex, logicalDisk");
        }
        ChunkCollection chunkCollection = new ChunkCollection();
        int n = 0;
        Chunk chunk = null;
        HashedSubDisk hashedSubDisk = hashedPlex.hashSubDisk;
        HashedSubDisk hashedSubDisk2 = null;
        if (hashedSubDisk == null) {
            ChunkCollection chunkCollection2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"ConcatCollection", chunkCollection2);
            }
            return chunkCollection2;
        }
        chunkCollection.ccType = 0;
        chunkCollection.ccLogicalDisk = logicalDisk;
        while (hashedSubDisk != null) {
            hashedSubDisk2 = hashedSubDisk.next;
            chunk = this.makeChunkWrapped(hashedSubDisk, chunkCollection, n, chunk);
            n = (short)(n + 1);
            hashedSubDisk = hashedSubDisk2;
        }
        ChunkCollection chunkCollection3 = chunkCollection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ConcatCollection", (Object)chunkCollection3);
        }
        return chunkCollection3;
    }

    /*
     * Unable to fully structure code
     */
    private static void binByColumn(HashedSubDisk[] var0, HashedSubDisk var1_1, int var2_2) {
        block1: {
            var3_3 = var0[var2_2];
            if (var3_3 != null) ** GOTO lbl6
            var0[var2_2] = var1_1;
            break block1;
lbl-1000:
            // 1 sources

            {
                var3_3 = var3_3.next;
lbl6:
                // 2 sources

                ** while (var3_3.next != null)
            }
lbl7:
            // 1 sources

            var3_3.next = var1_1;
        }
    }

    private static int checkArray(Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkArray", (String)"array");
        }
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                bl2 = false;
            } else {
                bl = false;
            }
            ++n;
        }
        n = bl ? 0 : (bl2 ? 1 : -1);
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkArray", (int)n2);
        }
        return n2;
    }

    private LogicalDisk MakePrimitiveLogicalDisk(HashedPlex hashedPlex) {
        Object[] objectArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"MakePrimitiveLogicalDisk", (String)"hashPlex");
        }
        HashedSubDisk[] hashedSubDiskArray = null;
        ChunkCollection chunkCollection = null;
        ChunkCollection chunkCollection2 = null;
        Chunk chunk = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        short s = 0;
        Object object = null;
        HashedSubDisk hashedSubDisk = null;
        hashedSubDiskArray = new LogicalDisk();
        hashedSubDiskArray.ldType = 1;
        if (hashedPlex.vrtsPlex.layout.equals("CONCAT")) {
            hashedSubDiskArray.ldCollectionList = chunkCollection = this.ConcatCollection(hashedPlex, (LogicalDisk)hashedSubDiskArray);
        } else {
            int n4;
            n = hashedPlex.vrtsPlex.layout.equals("RAID") ? 2 : 1;
            object = hashedPlex.hashSubDisk;
            while (object != null) {
                objectArray = ((HashedSubDisk)object).vrtsSubDisk;
                if (objectArray.column >= n3) {
                    n3 = objectArray.column + 1;
                }
                object = ((HashedSubDisk)object).next;
            }
            objectArray = new HashedSubDisk[n3];
            object = hashedPlex.hashSubDisk;
            while (object != null) {
                hashedSubDisk = ((HashedSubDisk)object).next;
                ((HashedSubDisk)object).next = null;
                CommonProbe.binByColumn((HashedSubDisk[])objectArray, (HashedSubDisk)object, ((HashedSubDisk)object).vrtsSubDisk.column);
                object = hashedSubDisk;
            }
            s = 0;
            chunkCollection = null;
            while ((n4 = CommonProbe.checkArray(objectArray)) == 1) {
                long l = Long.MAX_VALUE;
                int n5 = 0;
                while (n5 < n3) {
                    VeritasSubDisk veritasSubDisk = ((HashedSubDisk)objectArray[n5]).vrtsSubDisk;
                    if (veritasSubDisk.length < l) {
                        l = veritasSubDisk.length;
                    }
                    ++n5;
                }
                chunkCollection = new ChunkCollection();
                chunkCollection.ccType = (byte)n;
                chunkCollection.ccSeqno = s;
                s = (short)(s + 1);
                chunkCollection.ccLogicalDisk = hashedSubDiskArray;
                chunkCollection.ccStripingSize = (int)hashedPlex.vrtsPlex.stripeWidth * 512;
                if (chunkCollection2 == null) {
                    hashedSubDiskArray.ldCollectionList = chunkCollection;
                } else {
                    chunkCollection2.ccNext = chunkCollection;
                }
                chunkCollection2 = chunkCollection;
                chunk = null;
                n2 = 0;
                while (n2 < n3) {
                    object = objectArray[n2];
                    VeritasSubDisk veritasSubDisk = ((HashedSubDisk)object).vrtsSubDisk;
                    chunk = this.makeChunk(((HashedSubDisk)object).hashDisk, chunkCollection, n2, chunk, l, veritasSubDisk.diskOffset);
                    if (veritasSubDisk.length == l) {
                        objectArray[n2] = ((HashedSubDisk)object).next;
                    } else {
                        veritasSubDisk.diskOffset += l;
                        veritasSubDisk.length -= l;
                    }
                    ++n2;
                }
            }
            if (n4 != 0) {
                MessageLog.logMessage((String)"STA0605W", (Object)hashedPlex.vrtsPlex.rid.toString());
                this.handleRc = 4;
            }
        }
        if (chunkCollection == null) {
            hashedSubDiskArray = null;
        }
        objectArray = hashedSubDiskArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"MakePrimitiveLogicalDisk", (Object)objectArray);
        }
        return objectArray;
    }

    private LogicalDisk MakeCollectionMirror(HashedPlex hashedPlex) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"MakeCollectionMirror", (String)"plexHead");
        }
        int n = 0;
        LogicalDisk logicalDisk = null;
        ChunkCollection chunkCollection = null;
        ChunkCollection chunkCollection2 = null;
        HashedPlex hashedPlex2 = hashedPlex;
        logicalDisk = new LogicalDisk();
        logicalDisk.ldType = (byte)2;
        while (hashedPlex2 != null) {
            if (!hashedPlex2.vrtsPlex.isLogPlex() && (chunkCollection2 = this.ConcatCollection(hashedPlex2, logicalDisk)) != null) {
                int n2 = n;
                n = (short)(n2 + 1);
                chunkCollection2.ccSeqno = (short)n2;
                if (chunkCollection != null) {
                    chunkCollection.ccNext = chunkCollection2;
                } else {
                    logicalDisk.ldCollectionList = chunkCollection2;
                }
                chunkCollection = chunkCollection2;
            }
            hashedPlex2 = hashedPlex2.next;
        }
        if (chunkCollection == null) {
            logicalDisk = null;
        }
        LogicalDisk logicalDisk2 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"MakeCollectionMirror", (Object)logicalDisk2);
        }
        return logicalDisk2;
    }

    private LogicalDisk MakeLogicalDiskMirror(HashedVolume hashedVolume, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"MakeLogicalDiskMirror", (String)"hashVolume, copyNumber");
        }
        LogicalDisk logicalDisk = new LogicalDisk();
        LogicalDisk logicalDisk2 = null;
        LogicalDisk logicalDisk3 = null;
        HashedPlex hashedPlex = hashedVolume.hashPlex;
        String string = null;
        String string2 = String.valueOf(hashedVolume.vrtsVolume.name) + "_";
        int n2 = 0;
        logicalDisk.ldType = (byte)3;
        logicalDisk.ldMirrorCount = (byte)n;
        logicalDisk3 = logicalDisk;
        while (hashedPlex != null) {
            if (!hashedPlex.vrtsPlex.isLogPlex() && (logicalDisk2 = this.MakePrimitiveLogicalDisk(hashedPlex)) != null) {
                string = n2 < 10 ? "0" + n2 : "" + n2;
                logicalDisk2.ldPath = String.valueOf(string2) + string;
                logicalDisk3.ldNextMirror = logicalDisk2;
                logicalDisk3 = logicalDisk2;
                ++n2;
            }
            hashedPlex = hashedPlex.next;
        }
        if (logicalDisk3 == logicalDisk) {
            logicalDisk = null;
        }
        LogicalDisk logicalDisk4 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"MakeLogicalDiskMirror", (Object)logicalDisk4);
        }
        return logicalDisk4;
    }

    private LogicalDisk HandleSimpleVolume(HashedVolume hashedVolume, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"HandleSimpleVolume", (String)"hashVolume, isSubVolume");
        }
        int n = 0;
        HashedPlex hashedPlex = null;
        HashedPlex hashedPlex2 = null;
        boolean bl2 = true;
        LogicalDisk logicalDisk = null;
        hashedPlex = hashedVolume.hashPlex;
        while (hashedPlex != null) {
            if (!hashedPlex.vrtsPlex.isLogPlex()) {
                hashedPlex2 = hashedPlex;
                ++n;
                if (!hashedPlex.vrtsPlex.layout.equals("CONCAT")) {
                    bl2 = false;
                }
            }
            hashedPlex = hashedPlex.next;
        }
        if (n == 0) {
            MessageLog.logMessage((String)"STA0237W", (Object)hashedVolume.vrtsVolume.name);
            this.handleRc = 4;
            LogicalDisk logicalDisk2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"HandleSimpleVolume", logicalDisk2);
            }
            return logicalDisk2;
        }
        if (bl && n > 1 && !bl2) {
            MessageLog.logMessage((String)"STA0238W", (Object)hashedVolume.vrtsVolume.name);
            bl2 = true;
            this.handleRc = 4;
        }
        logicalDisk = n == 1 ? this.MakePrimitiveLogicalDisk(hashedPlex2) : (bl2 ? this.MakeCollectionMirror(hashedVolume.hashPlex) : this.MakeLogicalDiskMirror(hashedVolume, n));
        LogicalDisk logicalDisk3 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"HandleSimpleVolume", (Object)logicalDisk3);
        }
        return logicalDisk3;
    }

    private LogicalDisk HandleLayeredVolume(HashedVolume hashedVolume) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"HandleLayeredVolume", (String)"hashVolume");
        }
        int n = 0;
        HashedPlex hashedPlex = null;
        HashedPlex hashedPlex2 = null;
        LogicalDisk logicalDisk = null;
        int n2 = 0;
        LogicalDisk logicalDisk2 = null;
        LogicalDisk logicalDisk3 = null;
        String string = null;
        String string2 = null;
        int n3 = 0;
        hashedPlex = hashedVolume.hashPlex;
        while (hashedPlex != null) {
            if (!hashedPlex.vrtsPlex.isLogPlex()) {
                ++n;
                hashedPlex2 = hashedPlex;
            }
            hashedPlex = hashedPlex.next;
        }
        if (n != 1) {
            string2 = n == 0 ? "STA0237W" : "STA0239W";
            MessageLog.logMessage((String)string2, (Object)hashedVolume.vrtsVolume.name);
            this.handleRc = 4;
            LogicalDisk logicalDisk4 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"HandleLayeredVolume", logicalDisk4);
            }
            return logicalDisk4;
        }
        if (hashedVolume.assocVolume.next == null) {
            LogicalDisk logicalDisk5 = this.HandleSimpleVolume(hashedVolume.assocVolume, false);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"HandleLayeredVolume", (Object)logicalDisk5);
            }
            return logicalDisk5;
        }
        if (hashedPlex2.vrtsPlex.layout.equals("CONCAT")) {
            n3 = 6;
        } else if (hashedPlex2.vrtsPlex.layout.equals("STRIPE")) {
            n3 = 5;
        } else {
            MessageLog.logMessage((String)"STA0240W", (Object)hashedVolume.vrtsVolume.name);
            n3 = 5;
        }
        logicalDisk = new LogicalDisk();
        logicalDisk.ldType = (byte)n3;
        string = String.valueOf(hashedVolume.vrtsVolume.name) + "_";
        n2 = 0;
        logicalDisk2 = logicalDisk;
        hashedVolume = hashedVolume.assocVolume;
        while (hashedVolume != null) {
            logicalDisk3 = this.HandleSimpleVolume(hashedVolume, true);
            if (logicalDisk3 != null) {
                logicalDisk3.ldPath = String.valueOf(string) + n2;
                logicalDisk2.ldNextMirror = logicalDisk3;
                logicalDisk2 = logicalDisk3;
            }
            ++n2;
            hashedVolume = hashedVolume.next;
        }
        if (logicalDisk2 != logicalDisk) {
            logicalDisk.ldMirrorCount = (byte)n2;
        } else {
            logicalDisk = null;
        }
        LogicalDisk logicalDisk6 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"HandleLayeredVolume", (Object)logicalDisk6);
        }
        return logicalDisk6;
    }

    protected Disk lookUpDisk(String string) {
        return null;
    }

    private static class PathCompare
    implements Comparator {
        private PathCompare() {
        }

        public int compare(Object object, Object object2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$PathCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            Export export = (Export)object;
            Export export2 = (Export)object2;
            int n = export2.xpExportName.compareTo(export.xpExportName);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$PathCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compare", (int)n);
            }
            return n;
        }
    }

    private static class AccessCompare
    implements Comparator {
        private AccessCompare() {
        }

        public int compare(Object object, Object object2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$AccessCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            DevAccess devAccess = (DevAccess)object;
            DevAccess devAccess2 = (DevAccess)object2;
            int n = devAccess2.daTarget - devAccess.daTarget;
            if (n != 0) {
                int n2 = n;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$AccessCompare");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compare", (int)n2);
                }
                return n2;
            }
            int n3 = devAccess2.daLUN - devAccess.daLUN;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$AccessCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compare", (int)n3);
            }
            return n3;
        }
    }

    private static class CtlrCompare
    implements Comparator {
        private CtlrCompare() {
        }

        public int compare(Object object, Object object2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$CtlrCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            Controller controller = (Controller)object;
            Controller controller2 = (Controller)object2;
            int n = controller2.ctlrDriverName.compareTo(controller.ctlrDriverName);
            if (n == 0 && (n = controller2.ctlrInstance - controller.ctlrInstance) == 0) {
                n = controller2.ctlrBusNumber - controller.ctlrBusNumber;
            }
            int n2 = n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$CtlrCompare");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compare", (int)n2);
            }
            return n2;
        }
    }

    public static class ShellCommand {
        public BufferedReader bufferReader;
        public BufferedReader stderrReader;
        public boolean bCool;
        public CmdExecer execer;

        public ShellCommand(String string) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"ShellCommand", (String)"commandLine");
            }
            String[] stringArray = new String[]{"/bin/sh", "-c", string};
            this.execer = new CmdExecer(stringArray);
            this.bCool = this.execer.exec();
            if (!this.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("1.1 " + string));
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"ShellCommand");
                }
                return;
            }
            this.bufferReader = this.execer.stdout;
            this.stderrReader = this.execer.stderr;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"ShellCommand");
            }
        }

        public String getString() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getString", (String)"");
            }
            try {
                String string = this.bufferReader.readLine();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getString", (Object)string);
                }
                return string;
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getString", (Throwable)iOException);
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"1.2 ");
                String string = "";
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getString", (Object)string);
                }
                return string;
            }
        }

        public String getErrString() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getErrString", (String)"");
            }
            try {
                BufferedReader bufferedReader = this.stderrReader;
                if (bufferedReader.ready()) {
                    String string = this.stderrReader.readLine();
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getErrString", (Object)string);
                    }
                    return string;
                }
                return null;
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getErrString", (Throwable)iOException);
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"1.2 ");
                String string = "";
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$ShellCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getErrString", (Object)string);
                }
                return string;
            }
        }

        public void cleanUp() {
            CommonProbe.cleanUpChild(this.execer);
        }
    }

    private static class VeritasRid
    implements Comparable {
        public long ridHi;
        public long ridLo;

        VeritasRid(long l, long l2) {
            this.ridHi = l;
            this.ridLo = l2;
        }

        VeritasRid() {
            this.ridLo = 0L;
            this.ridHi = 0L;
        }

        boolean set(String string) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"set", (String)"token");
            }
            Integer n = null;
            Integer n2 = null;
            int n3 = string.indexOf(46);
            if (n3 <= 0 || n3 >= string.length() - 1) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("1 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"set", (boolean)bl);
                }
                return bl;
            }
            try {
                n = Integer.valueOf(string.substring(0, n3));
                n2 = Integer.valueOf(string.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"set", (Throwable)numberFormatException);
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("2 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"set", (boolean)bl);
                }
                return bl;
            }
            this.ridHi = n.longValue();
            this.ridLo = n2.longValue();
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"set", (boolean)bl);
            }
            return bl;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"pRid");
            }
            VeritasRid veritasRid = (VeritasRid)object;
            boolean bl2 = bl = this.ridLo == veritasRid.ridLo && this.ridHi == veritasRid.ridHi;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int hashCode() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"hashCode", (String)"");
            }
            int n = (int)this.ridLo;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"hashCode", (int)n);
            }
            return n;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasRid veritasRid = (VeritasRid)object;
            if (this.ridHi > veritasRid.ridHi) {
                int n = 1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
                }
                return n;
            }
            if (this.ridHi < veritasRid.ridHi) {
                int n = -1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
                }
                return n;
            }
            if (this.ridLo > veritasRid.ridLo) {
                int n = 1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
                }
                return n;
            }
            if (this.ridLo < veritasRid.ridLo) {
                int n = -1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
                }
                return n;
            }
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }

        public String toString() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string = this.ridHi + "." + this.ridLo;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string);
            }
            return string;
        }

        public boolean isNull() {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"isNull", (String)"");
            }
            boolean bl2 = bl = this.ridLo == 0L && this.ridHi == 0L;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasRid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isNull", (boolean)bl);
            }
            return bl;
        }
    }

    private static class VeritasDiskGroup
    implements Comparable {
        public String name;
        public int diskCount;
        public int volumeCount;
        public int plexCount;
        public int subDiskCount;
        public long freeSpace;
        public long totalSpace;
        public boolean probed;
        public Vector diskVector = new Vector(10, 2);
        public Vector volumeVector = new Vector(10, 2);
        public Vector plexVector = new Vector(10, 2);
        public Vector subDiskVector = new Vector(10, 2);

        VeritasDiskGroup(String string) {
            this.name = string;
            this.diskCount = 0;
            this.volumeCount = 0;
            this.plexCount = 0;
            this.subDiskCount = 0;
            this.freeSpace = 0L;
            this.totalSpace = 0L;
            this.probed = false;
        }

        /*
         * Unable to fully structure code
         */
        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"setAttributes", (String)"");
            }
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = null;
            var8_8 = null;
            var9_9 = null;
            var10_10 = null;
            var11_11 = null;
            var12_12 = null;
            var13_13 = null;
            var14_14 = false;
            if (TraceLogger.enableTrace) {
                try {
                    v2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v2.getName(), (String)"setAttributes", (String)">> executing ... /usr/sbin/vxdisk path");
            }
            var1_1 = new ShellCommand("/usr/sbin/vxdisk path");
            if (!var1_1.bCool || var1_1.getErrString() != null) {
                var14_14 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v4 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v4.getName(), (String)"setAttributes", (String)">> vxdisk path is not available...");
                }
            } else {
                var14_14 = true;
                if (TraceLogger.enableTrace) {
                    try {
                        v6 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v6.getName(), (String)"setAttributes", (String)">> vxdisk path is available...");
                }
            }
            var1_1.cleanUp();
            if (TraceLogger.enableTrace) {
                try {
                    v8 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v9) {
                    throw new NoClassDefFoundError(v9.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v8.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -S -g " + this.name + " list"));
            }
            var1_1 = new ShellCommand("/usr/sbin/vxprint -S -g " + this.name + " list");
            if (!var1_1.bCool || var1_1.getErrString() != null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3 /usr/sbin/vxprint -S -g " + this.name + " list"));
                var1_1.cleanUp();
                var15_15 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v10 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v11) {
                        throw new NoClassDefFoundError(v11.getMessage());
                    }
                    TraceLogger.exit((String)v10.getName(), (String)"setAttributes", (boolean)var15_15);
                }
                return var15_15;
            }
            var3_3 = var1_1.getString();
            if (var3_3 == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3.1 /usr/sbin/vxprint -S -g " + this.name + " list"));
                var1_1.cleanUp();
                var15_16 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v12 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v13) {
                        throw new NoClassDefFoundError(v13.getMessage());
                    }
                    TraceLogger.exit((String)v12.getName(), (String)"setAttributes", (boolean)var15_16);
                }
                return var15_16;
            }
            var4_4 = var1_1.getString();
            if (var4_4 == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3.2 /usr/sbin/vxprint -S -g " + this.name + " list"));
                var1_1.cleanUp();
                var15_17 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v14 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v15) {
                        throw new NoClassDefFoundError(v15.getMessage());
                    }
                    TraceLogger.exit((String)v14.getName(), (String)"setAttributes", (boolean)var15_17);
                }
                return var15_17;
            }
            var1_1.cleanUp();
            var6_6 = new StringTokenizer(var3_3);
            if (var6_6.countTokens() < 6) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("4 " + var3_3));
                var15_18 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v16 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v17) {
                        throw new NoClassDefFoundError(v17.getMessage());
                    }
                    TraceLogger.exit((String)v16.getName(), (String)"setAttributes", (boolean)var15_18);
                }
                return var15_18;
            }
            var7_7 = new StringTokenizer(var4_4);
            var15_19 = 1;
            while (var15_19 <= var6_6.countTokens()) {
                block168: {
                    var8_8 = var6_6.nextToken();
                    var9_9 = var7_7.nextToken();
                    try {
                        if (var8_8.equals("VOLUMES")) {
                            this.volumeCount = Integer.parseInt(var9_9);
                        } else if (var8_8.equals("PLEXES")) {
                            this.plexCount = Integer.parseInt(var9_9);
                        } else if (var8_8.equals("SUBDISKS")) {
                            this.subDiskCount = Integer.parseInt(var9_9);
                        } else if (var8_8.equals("DISKS")) {
                            this.diskCount = Integer.parseInt(var9_9);
                        }
                    }
                    catch (NumberFormatException var16_28) {
                        if (!TraceLogger.enableTrace) break block168;
                        try {
                            v18 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v19) {
                            throw new NoClassDefFoundError(v19.getMessage());
                        }
                        TraceLogger.exception((String)v18.getName(), (String)"setAttributes", (Throwable)var16_28);
                    }
                }
                var15_19 += 1;
            }
            if (TraceLogger.enableTrace) {
                try {
                    v20 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v21) {
                    throw new NoClassDefFoundError(v21.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v20.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxdisk -g " + this.name + " -q list"));
            }
            var1_1 = new ShellCommand("/usr/sbin/vxdisk -g " + this.name + " -q list");
            if (var1_1.bCool && var1_1.getErrString() == null) ** GOTO lbl245
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("6 /usr/sbin/vxdisk -g " + this.name + " -q list"));
            var1_1.cleanUp();
            var15_19 = 0;
            if (TraceLogger.enableTrace) {
                try {
                    v22 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException v23) {
                    throw new NoClassDefFoundError(v23.getMessage());
                }
                TraceLogger.exit((String)v22.getName(), (String)"setAttributes", (boolean)var15_19);
            }
            return (boolean)var15_19;
lbl-1000:
            // 1 sources

            {
                block169: {
                    var5_5 = new StringTokenizer(var2_2);
                    if (var5_5.countTokens() < 5) continue;
                    var15_20 = var5_5.nextToken();
                    var5_5.nextToken();
                    var16_29 = var5_5.nextToken();
                    if (TraceLogger.enableTrace) {
                        try {
                            v24 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException v25) {
                            throw new NoClassDefFoundError(v25.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v24.getName(), (String)"setAttributes", (String)(">> current deviceTag (daName) = " + var15_20 + " and dmName = " + (String)var16_29));
                    }
                    if (!var14_14) break block169;
                    if (TraceLogger.enableTrace) {
                        try {
                            v26 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException v27) {
                            throw new NoClassDefFoundError(v27.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v26.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxdisk -g " + this.name + " -q path"));
                    }
                    var17_31 = new ShellCommand("/usr/sbin/vxdisk -g " + this.name + " -q path");
                    if (var17_31.bCool && var17_31.getErrString() == null) ** GOTO lbl219
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("6 /usr/sbin/vxdisk -g " + this.name + " -q path"));
                    var17_31.cleanUp();
                    var18_36 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v28 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v29) {
                            throw new NoClassDefFoundError(v29.getMessage());
                        }
                        TraceLogger.exit((String)v28.getName(), (String)"setAttributes", (boolean)var18_36);
                    }
                    return var18_36;
lbl-1000:
                    // 1 sources

                    {
                        if (TraceLogger.enableTrace) {
                            try {
                                v30 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException v31) {
                                throw new NoClassDefFoundError(v31.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)v30.getName(), (String)"setAttributes", (String)(">> current buffer2 = " + var18_35));
                        }
                        if ((var19_39 = new StringTokenizer(var18_35)).countTokens() < 5) continue;
                        var20_42 = var19_39.nextToken();
                        var21_51 = var19_39.nextToken();
                        if (TraceLogger.enableTrace) {
                            try {
                                v32 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException v33) {
                                throw new NoClassDefFoundError(v33.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)v32.getName(), (String)"setAttributes", (String)(">> current subpath = " + var20_42 + " and daName = " + var21_51));
                        }
                        if (!var21_51.equals(var15_20)) continue;
                        if (TraceLogger.enableTrace) {
                            try {
                                v34 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                            }
                            catch (ClassNotFoundException v35) {
                                throw new NoClassDefFoundError(v35.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)v34.getName(), (String)"setAttributes", (String)(">> found subpath " + var20_42 + " for VxVM disk " + var15_20));
                        }
                        var15_20 = var20_42;
                        break;
lbl219:
                        // 3 sources

                        ** while ((var18_35 = var17_31.getString()) != null)
                    }
lbl220:
                    // 2 sources

                    var17_31.cleanUp();
                }
                if (TraceLogger.enableTrace) {
                    try {
                        v36 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v37) {
                        throw new NoClassDefFoundError(v37.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v36.getName(), (String)"setAttributes", (String)(">> adding VxVM disk with name " + (String)var16_29 + " to VeritasDisk..."));
                }
                var10_10 = new VeritasDisk(this, (String)var16_29);
                if (var15_20.length() > 2) {
                    var17_31 = var15_20.substring(var15_20.length() - 2);
                    var18_35 = var15_20.substring(0, var15_20.length() - 2);
                    var10_10.deviceTag = var17_31.equals("s2") ? var18_35 : var15_20;
                } else {
                    var10_10.deviceTag = var15_20;
                }
                if (TraceLogger.enableTrace) {
                    try {
                        v38 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v39) {
                        throw new NoClassDefFoundError(v39.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v38.getName(), (String)"setAttributes", (String)(">> adding VxVM disk with name " + var10_10.name + " and deviceTag " + var10_10.deviceTag + " to diskVector..."));
                }
                this.diskVector.add(var10_10);
lbl245:
                // 3 sources

                ** while ((var2_2 = var1_1.getString()) != null)
            }
lbl246:
            // 1 sources

            var1_1.cleanUp();
            if (this.diskVector.size() > this.diskCount) {
                this.diskCount = this.diskVector.size();
            }
            if (TraceLogger.enableTrace) {
                try {
                    v40 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v41) {
                    throw new NoClassDefFoundError(v41.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v40.getName(), (String)"setAttributes", (String)(">> found total of " + this.diskCount + " disks in disk group " + this.name));
            }
            var2_2 = null;
            if (this.diskCount > 0) {
                if (TraceLogger.enableTrace) {
                    try {
                        v42 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v43) {
                        throw new NoClassDefFoundError(v43.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v42.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.name + " -a -d "));
                }
                var1_1 = new ShellCommand("/usr/sbin/vxprint -g " + this.name + " -a -d ");
                if (!var1_1.bCool || (var2_2 = var1_1.getString()) == null) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("14 " + var2_2));
                    var1_1.cleanUp();
                    var15_21 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v44 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                        }
                        catch (ClassNotFoundException v45) {
                            throw new NoClassDefFoundError(v45.getMessage());
                        }
                        TraceLogger.exit((String)v44.getName(), (String)"setAttributes", (boolean)var15_21);
                    }
                    return var15_21;
                }
                var1_1.cleanUp();
            }
            if ((var5_5 = new StringTokenizer(var2_2)).countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("15 " + var2_2));
                var15_22 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v46 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                    }
                    catch (ClassNotFoundException v47) {
                        throw new NoClassDefFoundError(v47.getMessage());
                    }
                    TraceLogger.exit((String)v46.getName(), (String)"setAttributes", (boolean)var15_22);
                }
                return var15_22;
            }
            var5_5.nextToken();
            var5_5.nextToken();
            while (var5_5.hasMoreTokens()) {
                var15_23 = var5_5.nextToken();
                if (!var15_23.startsWith("atomic_iosize=")) continue;
                var16_29 = Long.valueOf(var15_23.substring(14));
                CommonProbe.blockSize = var16_29.longValue();
                CommonProbe.blockMultiplier = CommonProbe.blockSize / 512L;
            }
            var15_24 = 0;
            while (var15_24 < this.diskVector.size()) {
                var10_10 = (VeritasDisk)this.diskVector.elementAt(var15_24);
                if (!var10_10.setAttributes()) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("8 " + this.name));
                    var16_30 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v48 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v49) {
                            throw new NoClassDefFoundError(v49.getMessage());
                        }
                        TraceLogger.exit((String)v48.getName(), (String)"setAttributes", (boolean)var16_30);
                    }
                    return var16_30;
                }
                var15_24 += 1;
            }
            if (TraceLogger.enableTrace) {
                try {
                    v50 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v51) {
                    throw new NoClassDefFoundError(v51.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v50.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.name));
            }
            var1_1 = new ShellCommand("/usr/sbin/vxprint -g " + this.name);
            if (var1_1.bCool && var1_1.getErrString() == null) ** GOTO lbl391
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("9 /usr/sbin/vxprint -g " + this.name));
            var1_1.cleanUp();
            var15_24 = 0;
            if (TraceLogger.enableTrace) {
                try {
                    v52 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException v53) {
                    throw new NoClassDefFoundError(v53.getMessage());
                }
                TraceLogger.exit((String)v52.getName(), (String)"setAttributes", (boolean)var15_24);
            }
            return (boolean)var15_24;
lbl-1000:
            // 1 sources

            {
                var5_5 = new StringTokenizer(var2_2);
                if (var5_5.countTokens() < 7) continue;
                var15_25 = var5_5.nextToken();
                if (var15_25.equals("v")) {
                    var16_29 = var5_5.nextToken();
                    var5_5.nextToken();
                    var5_5.nextToken();
                    var17_31 = Long.valueOf(var5_5.nextToken());
                    var18_37 = var17_31.longValue() * CommonProbe.blockMultiplier;
                    var11_11 = new VeritasVolume(this, (String)var16_29, var18_37);
                    if (TraceLogger.enableTrace) {
                        try {
                            v54 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException v55) {
                            throw new NoClassDefFoundError(v55.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v54.getName(), (String)"setAttributes", (String)(">> adding VxVM volume with volumeName " + (String)var16_29 + ", volumeLength = " + var18_37 + " to volumeVector..."));
                    }
                    this.volumeVector.add(var11_11);
                    continue;
                }
                if (var15_25.equals("pl")) {
                    var16_29 = var5_5.nextToken();
                    var17_31 = var5_5.nextToken();
                    var12_12 = new VeritasPlex(this, (String)var16_29, (String)var17_31);
                    if (TraceLogger.enableTrace) {
                        try {
                            v56 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException v57) {
                            throw new NoClassDefFoundError(v57.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v56.getName(), (String)"setAttributes", (String)(">> adding VxVM plex with plexName " + (String)var16_29 + ", volumeName = " + (String)var17_31 + " to plexVector..."));
                    }
                    this.plexVector.add(var12_12);
                    continue;
                }
                if (!var15_25.equals("sd") && !var15_25.equals("sv")) continue;
                var16_29 = var5_5.nextToken();
                var17_31 = var5_5.nextToken();
                var5_5.nextToken();
                var18_38 = var5_5.nextToken();
                var19_39 = Long.valueOf(var18_38);
                var20_43 = var19_39.longValue() * CommonProbe.blockMultiplier;
                var13_13 = new VeritasSubDisk(this, (String)var16_29, (String)var17_31, var20_43);
                if (TraceLogger.enableTrace) {
                    try {
                        v58 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException v59) {
                        throw new NoClassDefFoundError(v59.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)v58.getName(), (String)"setAttributes", (String)(">> adding VxVM subdisk with subDiskName " + (String)var16_29 + ", plexName = " + (String)var17_31 + ", subdiskLength = " + var20_43 + " to subDiskVector..."));
                }
                this.subDiskVector.add(var13_13);
lbl391:
                // 6 sources

                ** while ((var2_2 = var1_1.getString()) != null)
            }
lbl392:
            // 1 sources

            var1_1.cleanUp();
            if (TraceLogger.enableTrace) {
                try {
                    v60 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v61) {
                    throw new NoClassDefFoundError(v61.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v60.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -qdg " + this.name));
            }
            var1_1 = new ShellCommand("/usr/sbin/vxprint -qdg " + this.name);
            if (!var1_1.bCool || var1_1.getErrString() != null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("10 /usr/sbin/vxprint -qdg " + this.name));
                var1_1.cleanUp();
                var15_26 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v62 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v63) {
                        throw new NoClassDefFoundError(v63.getMessage());
                    }
                    TraceLogger.exit((String)v62.getName(), (String)"setAttributes", (boolean)var15_26);
                }
                return var15_26;
            }
            var15_27 = 0L;
            while ((var2_2 = var1_1.getString()) != null) {
                var5_5 = new StringTokenizer(var2_2);
                if (var5_5.countTokens() < 5) continue;
                var19_39 = null;
                var20_44 = 0;
                while (var20_44 < 5) {
                    var19_39 = var5_5.nextToken();
                    ++var20_44;
                }
                var17_33 = 0L;
                try {
                    var17_33 = Long.parseLong((String)var19_39) * CommonProbe.blockMultiplier;
                }
                catch (NumberFormatException var20_45) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v64 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v65) {
                            throw new NoClassDefFoundError(v65.getMessage());
                        }
                        TraceLogger.exception((String)v64.getName(), (String)"setAttributes", (Throwable)var20_45);
                    }
                    var17_33 = 0L;
                }
                var15_27 += var17_33;
            }
            var1_1.cleanUp();
            this.totalSpace = var15_27;
            if (TraceLogger.enableTrace) {
                try {
                    v66 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException v67) {
                    throw new NoClassDefFoundError(v67.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)v66.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxdg -qg " + this.name + " free "));
            }
            var1_1 = new ShellCommand("/usr/sbin/vxdg -qg " + this.name + " free ");
            if (!var1_1.bCool || var1_1.getErrString() != null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("11 /usr/sbin/vxdg -qg " + this.name + " free "));
                var1_1.cleanUp();
                var19_40 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v68 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                    }
                    catch (ClassNotFoundException v69) {
                        throw new NoClassDefFoundError(v69.getMessage());
                    }
                    TraceLogger.exit((String)v68.getName(), (String)"setAttributes", (boolean)var19_40);
                }
                return var19_40;
            }
            var15_27 = 0L;
            var17_34 = 0L;
            while ((var2_2 = var1_1.getString()) != null) {
                var5_5 = new StringTokenizer(var2_2);
                if (var5_5.countTokens() < 5) continue;
                var19_39 = null;
                var20_46 = 0;
                while (var20_46 < 5) {
                    var19_39 = var5_5.nextToken();
                    ++var20_46;
                }
                var17_34 = 0L;
                try {
                    var17_34 = Long.parseLong((String)var19_39) * CommonProbe.blockMultiplier;
                }
                catch (NumberFormatException var20_47) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v70 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v71) {
                            throw new NoClassDefFoundError(v71.getMessage());
                        }
                        TraceLogger.exception((String)v70.getName(), (String)"setAttributes", (Throwable)var20_47);
                    }
                    var17_34 = 0L;
                }
                var15_27 += var17_34;
            }
            var1_1.cleanUp();
            this.freeSpace = var15_27;
            if (this.volumeVector.size() > this.volumeCount) {
                this.volumeCount = this.volumeVector.size();
            }
            if (this.plexVector.size() > this.plexCount) {
                this.plexCount = this.plexVector.size();
            }
            if (this.subDiskVector.size() > this.subDiskCount) {
                this.subDiskCount = this.subDiskVector.size();
            }
            var19_41 = 0;
            while (var19_41 < this.volumeVector.size()) {
                var11_11 = (VeritasVolume)this.volumeVector.elementAt(var19_41);
                if (!var11_11.setAttributes()) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("11 " + var11_11.name));
                    var20_48 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v72 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v73) {
                            throw new NoClassDefFoundError(v73.getMessage());
                        }
                        TraceLogger.exit((String)v72.getName(), (String)"setAttributes", (boolean)var20_48);
                    }
                    return var20_48;
                }
                var19_41 += 1;
            }
            var19_41 = 0;
            while (var19_41 < this.plexVector.size()) {
                var12_12 = (VeritasPlex)this.plexVector.elementAt(var19_41);
                if (!var12_12.setAttributes()) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("12 " + var12_12.name));
                    var20_49 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v74 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v75) {
                            throw new NoClassDefFoundError(v75.getMessage());
                        }
                        TraceLogger.exit((String)v74.getName(), (String)"setAttributes", (boolean)var20_49);
                    }
                    return var20_49;
                }
                var19_41 += 1;
            }
            var19_41 = 0;
            while (var19_41 < this.subDiskVector.size()) {
                var13_13 = (VeritasSubDisk)this.subDiskVector.elementAt(var19_41);
                if (!var13_13.setAttributes()) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("13 " + var13_13.name));
                    var20_50 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v76 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                        }
                        catch (ClassNotFoundException v77) {
                            throw new NoClassDefFoundError(v77.getMessage());
                        }
                        TraceLogger.exit((String)v76.getName(), (String)"setAttributes", (boolean)var20_50);
                    }
                    return var20_50;
                }
                var19_41 += 1;
            }
            this.probed = true;
            var19_41 = 1;
            if (TraceLogger.enableTrace) {
                try {
                    v78 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException v79) {
                    throw new NoClassDefFoundError(v79.getMessage());
                }
                TraceLogger.exit((String)v78.getName(), (String)"setAttributes", (boolean)var19_41);
            }
            return (boolean)var19_41;
        }

        public boolean equals(VeritasDiskGroup veritasDiskGroup) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherDiskGroup");
            }
            boolean bl = this.name.equals(veritasDiskGroup.name);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasDiskGroup veritasDiskGroup = (VeritasDiskGroup)object;
            int n = this.name.compareTo(veritasDiskGroup.name);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string2 = string = "diskGroup name = " + this.name + " diskCount = " + this.diskCount + " volumeCount = " + this.volumeCount + " plexCount = " + this.plexCount + " subDiskCount = " + this.subDiskCount;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDiskGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string2);
            }
            return string2;
        }
    }

    private static class VeritasDisk
    implements Comparable {
        public String deviceTag = "";
        public String publicCPath = "";
        public long publicOffset = 0L;
        public long publicLength;
        public String privateCPath = "";
        public long privateOffset = 0L;
        public long privateLength;
        public boolean tFlag = false;
        public VeritasRid rid = new VeritasRid();
        public String name;
        public long freeSpace;
        public VeritasDiskGroup diskGroup;

        VeritasDisk(VeritasDiskGroup veritasDiskGroup, String string) {
            this.name = string;
            this.diskGroup = veritasDiskGroup;
            this.freeSpace = 0L;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shellCommand = null;
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            String string3 = null;
            Long l = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name));
            }
            shellCommand = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shellCommand.bCool || (string = shellCommand.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("14 " + string));
                shellCommand.cleanUp();
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            shellCommand.cleanUp();
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("15 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                Class<?> clazz;
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("priv_cpath=")) {
                    this.privateCPath = string2.substring(12);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"setAttributes", (String)(">> found privateCPath (priv_cpath) = " + this.privateCPath));
                    }
                } else if (string2.startsWith("pub_cpath=")) {
                    this.publicCPath = string2.substring(11);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz3.getName(), (String)"setAttributes", (String)(">> found publicCPath (pub_cpath) = " + this.publicCPath));
                    }
                }
                if (string2.startsWith("priv_offset=")) {
                    l = Long.valueOf(string2.substring(12));
                    this.privateOffset = l * blockMultiplier;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz4;
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz4.getName(), (String)"setAttributes", (String)(">> found privateOffset (priv_offset) = " + this.privateOffset));
                    }
                } else if (string2.startsWith("pub_offset=")) {
                    l = Long.valueOf(string2.substring(11));
                    this.publicOffset = l * blockMultiplier;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz5.getName(), (String)"setAttributes", (String)(">> found publicOffset (pub_offset) = " + this.publicOffset));
                    }
                }
                if (string2.startsWith("priv_len=")) {
                    Class<?> clazz6;
                    l = Long.valueOf(string2.substring(9));
                    this.privateLength = l * blockMultiplier;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz6.getName(), (String)"setAttributes", (String)(">> found privateLength (priv_len) = " + this.privateLength));
                    continue;
                }
                if (string2.startsWith("pub_len=")) {
                    Class<?> clazz7;
                    l = Long.valueOf(string2.substring(8));
                    this.publicLength = l * blockMultiplier;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz7 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz7.getName(), (String)"setAttributes", (String)(">> found publicLength (pub_len) = " + this.publicLength));
                    continue;
                }
                if (string2.startsWith("private=")) {
                    Class<?> clazz8;
                    string3 = string2.substring(8);
                    if (string3.equals("on")) {
                        this.tFlag = true;
                    } else if (string3.equals("off")) {
                        this.tFlag = false;
                    } else {
                        MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("16 " + string2));
                        boolean bl = false;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz9;
                            try {
                                clazz9 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz9.getName(), (String)"setAttributes", (boolean)bl);
                        }
                        return bl;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz8 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz8.getName(), (String)"setAttributes", (String)(">> found tFlag (private) = " + string3));
                    continue;
                }
                if (!string2.startsWith("rid=")) continue;
                this.rid = new VeritasRid();
                if (!this.rid.set(string2.substring(4))) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("17 " + string2));
                    boolean bl = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz10;
                        try {
                            clazz10 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz10.getName(), (String)"setAttributes", (boolean)bl);
                    }
                    return bl;
                }
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> found rid = " + this.rid.toString()));
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
            }
            return bl;
        }

        public boolean equals(VeritasDisk veritasDisk) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherDisk");
            }
            boolean bl = this.rid.equals(veritasDisk.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasDisk veritasDisk = (VeritasDisk)object;
            int n = this.rid.compareTo(veritasDisk.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string2 = string = "disk name = " + this.name + " disk group name = " + this.diskGroup.name + " publicCPath = " + this.publicCPath + " publicOffset = " + this.publicOffset + " publicLength = " + this.publicLength + " privateCPath = " + this.privateCPath + " privateOffset = " + this.privateOffset + " privateLength = " + this.privateLength + " tFlag = " + this.tFlag + " rid = " + this.rid;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string2);
            }
            return string2;
        }
    }

    private static class VeritasVolume
    implements Comparable {
        public String name;
        public long length;
        public VeritasRid rid;
        public int sdNum;
        public VeritasDiskGroup diskGroup;

        VeritasVolume(VeritasDiskGroup veritasDiskGroup, String string, long l) {
            this.diskGroup = veritasDiskGroup;
            this.name = string;
            this.length = l;
            this.rid = new VeritasRid();
            this.sdNum = 0;
        }

        VeritasVolume() {
            this.diskGroup = null;
            this.name = "";
            this.length = 0L;
            this.rid = new VeritasRid();
            this.sdNum = 0;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shellCommand = null;
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name));
            }
            shellCommand = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shellCommand.bCool || (string = shellCommand.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("18 " + string));
                shellCommand.cleanUp();
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            shellCommand.cleanUp();
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("19 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                Class<?> clazz;
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("sd_num=")) {
                    Class<?> clazz2;
                    this.sdNum = Integer.parseInt(string2.substring(7));
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"setAttributes", (String)(">> found sd_Num = " + this.sdNum));
                    continue;
                }
                if (!string2.startsWith("rid=")) continue;
                this.rid = new VeritasRid();
                if (!this.rid.set(string2.substring(4))) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("20 " + string2));
                    boolean bl = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz3.getName(), (String)"setAttributes", (boolean)bl);
                    }
                    return bl;
                }
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> found rid = " + this.rid.toString()));
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasVolume veritasVolume = (VeritasVolume)object;
            int n = this.rid.compareTo(veritasVolume.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }

        public boolean equals(VeritasVolume veritasVolume) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherVolume");
            }
            boolean bl = this.rid.equals(veritasVolume.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string2 = string = "volume name = " + this.name + " length = " + this.length + " rid = " + this.rid + " sdNum = " + this.sdNum + " iosize = " + blockSize;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string2);
            }
            return string2;
        }
    }

    private static class VeritasPlex
    implements Comparable {
        public String name;
        public String volumeName;
        public String state;
        public VeritasRid rid;
        public VeritasRid volumeRid;
        public VeritasRid logSubDiskRid;
        public VeritasDiskGroup diskGroup;
        public String layout;
        public int nColumn;
        public long stripeWidth;

        VeritasPlex(VeritasDiskGroup veritasDiskGroup, String string, String string2) {
            this.diskGroup = veritasDiskGroup;
            this.name = string;
            this.rid = new VeritasRid();
            this.state = "";
            this.volumeName = string2;
            this.volumeRid = new VeritasRid();
            this.logSubDiskRid = new VeritasRid();
        }

        VeritasPlex() {
            this.diskGroup = null;
            this.name = "";
            this.volumeName = "";
            this.state = "";
            this.rid = new VeritasRid();
            this.volumeRid = new VeritasRid();
            this.logSubDiskRid = new VeritasRid();
        }

        public boolean isLogPlex() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"isLogPlex", (String)"");
            }
            if (!this.logSubDiskRid.isNull() || this.state.equals("LOG")) {
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"isLogPlex", (boolean)bl);
                }
                return bl;
            }
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isLogPlex", (boolean)bl);
            }
            return bl;
        }

        public boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shellCommand = null;
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            Integer n = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name));
            }
            shellCommand = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shellCommand.bCool || (string = shellCommand.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("21 " + string));
                shellCommand.cleanUp();
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            shellCommand.cleanUp();
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("22 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                Class<?> clazz;
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("rid=")) {
                    Class<?> clazz2;
                    this.rid = new VeritasRid();
                    if (!this.rid.set(string2.substring(4))) {
                        MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("23 " + string2));
                        boolean bl = false;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz3.getName(), (String)"setAttributes", (boolean)bl);
                        }
                        return bl;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"setAttributes", (String)(">> found rid = " + this.rid.toString()));
                    continue;
                }
                if (string2.startsWith("ncolumn=")) {
                    Class<?> clazz4;
                    this.nColumn = Integer.parseInt(string2.substring(8));
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz4.getName(), (String)"setAttributes", (String)(">> found nColumn = " + this.nColumn));
                    continue;
                }
                if (string2.startsWith("state=")) {
                    Class<?> clazz5;
                    this.state = string2.substring(7);
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz5.getName(), (String)"setAttributes", (String)(">> found state = " + this.state));
                    continue;
                }
                if (string2.startsWith("vol_rid=")) {
                    Class<?> clazz6;
                    this.volumeRid = new VeritasRid();
                    if (!this.volumeRid.set(string2.substring(8))) {
                        MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("24 " + string2));
                        boolean bl = false;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz7;
                            try {
                                clazz7 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz7.getName(), (String)"setAttributes", (boolean)bl);
                        }
                        return bl;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz6.getName(), (String)"setAttributes", (String)(">> found volumeRid (vol_rid) = " + this.volumeRid.toString()));
                    continue;
                }
                if (string2.startsWith("st_width=")) {
                    Class<?> clazz8;
                    n = Integer.valueOf(string2.substring(9));
                    this.stripeWidth = n.longValue();
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz8 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz8.getName(), (String)"setAttributes", (String)(">> found stripeWidth = " + this.stripeWidth));
                    continue;
                }
                if (string2.startsWith("layout=")) {
                    Class<?> clazz9;
                    this.layout = string2.substring(7);
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz9 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz9.getName(), (String)"setAttributes", (String)(">> found layout = " + this.layout));
                    continue;
                }
                if (!string2.startsWith("log_sd_rid=")) continue;
                this.logSubDiskRid = new VeritasRid();
                if (!this.logSubDiskRid.set(string2.substring(11))) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("25 " + string2));
                    boolean bl = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz10;
                        try {
                            clazz10 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz10.getName(), (String)"setAttributes", (boolean)bl);
                    }
                    return bl;
                }
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> found logSubDiskRid (log_sd_rid) = " + this.logSubDiskRid.toString()));
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
            }
            return bl;
        }

        public boolean equals(VeritasPlex veritasPlex) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherPlex");
            }
            boolean bl = this.rid.equals(veritasPlex.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasPlex veritasPlex = (VeritasPlex)object;
            int n = this.rid.compareTo(veritasPlex.rid);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string2 = string = "plex name = " + this.name + " volumeName = " + this.volumeName + " state = " + this.state + " rid = " + this.rid + " volumeRid = " + this.volumeRid + " logSubDiskRid = " + this.logSubDiskRid + " layout = " + this.layout + " nColumn = " + this.nColumn + " stripeWidth = " + this.stripeWidth;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string2);
            }
            return string2;
        }
    }

    private static class VeritasSubDisk
    implements Comparable {
        public VeritasDiskGroup diskGroup;
        public String name;
        public String diskName;
        public String plexName;
        public boolean pFlag;
        public VeritasRid plexRid;
        public VeritasRid diskRid;
        public int column;
        public long length;
        public long diskOffset;
        public long plexOffset;

        VeritasSubDisk(VeritasDiskGroup veritasDiskGroup, String string, String string2, long l) {
            this.diskGroup = veritasDiskGroup;
            this.name = string;
            this.plexName = string2;
            this.pFlag = false;
            this.plexRid = new VeritasRid();
            this.diskRid = new VeritasRid();
            this.column = 0;
            this.length = l;
            this.diskOffset = 0L;
            this.plexOffset = 0L;
        }

        VeritasSubDisk() {
            this.diskGroup = null;
            this.name = "";
            this.plexName = "";
            this.pFlag = false;
            this.plexRid = null;
            this.diskRid = null;
            this.column = 0;
            this.length = 0L;
            this.diskOffset = 0L;
            this.plexOffset = 0L;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shellCommand = null;
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            String string3 = null;
            Long l = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> executing ... /usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name));
            }
            shellCommand = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shellCommand.bCool || (string = shellCommand.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("26 " + string));
                shellCommand.cleanUp();
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            shellCommand.cleanUp();
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("27 " + string));
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
                }
                return bl;
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                Class<?> clazz;
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("dm_rid=")) {
                    Class<?> clazz2;
                    this.diskRid = new VeritasRid();
                    if (!this.diskRid.set(string2.substring(7))) {
                        MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("28 " + string2));
                        boolean bl = false;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz3.getName(), (String)"setAttributes", (boolean)bl);
                        }
                        return bl;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"setAttributes", (String)(">> found diskRid (dm_rid) = " + this.diskRid.toString()));
                    continue;
                }
                if (string2.startsWith("plex_rid=")) {
                    Class<?> clazz4;
                    this.plexRid = new VeritasRid();
                    if (!this.plexRid.set(string2.substring(9))) {
                        MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("29 " + string2));
                        boolean bl = false;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz5;
                            try {
                                clazz5 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz5.getName(), (String)"setAttributes", (boolean)bl);
                        }
                        return bl;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz4.getName(), (String)"setAttributes", (String)(">> found plexRid (plex_rid) = " + this.plexRid.toString()));
                    continue;
                }
                if (string2.startsWith("dm_name=")) {
                    Class<?> clazz6;
                    this.diskName = string2.substring(8);
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz6.getName(), (String)"setAttributes", (String)(">> found diskName (dm_name) = " + this.diskName));
                    continue;
                }
                if (string2.startsWith("pl_offset=")) {
                    Class<?> clazz7;
                    l = Long.valueOf(string2.substring(10));
                    this.plexOffset = l * blockMultiplier;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz7 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz7.getName(), (String)"setAttributes", (String)(">> found plexOffset = " + this.plexOffset));
                    continue;
                }
                if (string2.startsWith("dm_offset=")) {
                    Class<?> clazz8;
                    l = Long.valueOf(string2.substring(10));
                    this.diskOffset = l * blockMultiplier;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz8 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz8.getName(), (String)"setAttributes", (String)(">> found diskOffset (dm_offset) = " + this.diskOffset));
                    continue;
                }
                if (string2.startsWith("column=")) {
                    Class<?> clazz9;
                    this.column = Integer.parseInt(string2.substring(7));
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz9 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz9.getName(), (String)"setAttributes", (String)(">> found column = " + this.column));
                    continue;
                }
                if (!string2.startsWith("subvolume=")) continue;
                string3 = string2.substring(10);
                if (string3.equals("on")) {
                    this.pFlag = true;
                } else if (string3.equals("off")) {
                    this.pFlag = false;
                } else {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("30 " + string2));
                    boolean bl = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz10;
                        try {
                            clazz10 = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz10.getName(), (String)"setAttributes", (boolean)bl);
                    }
                    return bl;
                }
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"setAttributes", (String)(">> found subvolume = " + string3 + " and set pFlag to " + this.pFlag));
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setAttributes", (boolean)bl);
            }
            return bl;
        }

        public boolean equals(VeritasSubDisk veritasSubDisk) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherSubDisk");
            }
            if (!this.diskRid.equals(veritasSubDisk.diskRid)) {
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
                }
                return bl;
            }
            if (this.diskOffset != veritasSubDisk.diskOffset) {
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
                }
                return bl;
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            VeritasSubDisk veritasSubDisk = (VeritasSubDisk)object;
            int n = this.diskRid.compareTo(veritasSubDisk.diskRid);
            if (n != 0) {
                int n2 = n;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n2);
                }
                return n2;
            }
            if (this.diskOffset > veritasSubDisk.diskOffset) {
                int n3 = 1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n3);
                }
                return n3;
            }
            if (this.diskOffset == veritasSubDisk.diskOffset) {
                int n4 = 0;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n4);
                }
                return n4;
            }
            int n5 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n5);
            }
            return n5;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"toString", (String)"");
            }
            String string2 = string = "subDiskName = " + this.name + " diskName = " + this.diskName + " plexName = " + this.plexName + " pFlag = " + this.pFlag + " plexRid = " + this.plexRid + " diskRid = " + this.diskRid + " column = " + this.column + " length = " + this.length + " diskOffset = " + this.diskOffset + " plexOffset = " + this.plexOffset;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$VeritasSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"toString", (Object)string2);
            }
            return string2;
        }
    }

    private static class HashedDisk
    implements Comparable {
        public VeritasDisk vrtsDisk;
        public Disk disk;

        HashedDisk(VeritasDisk veritasDisk, Disk disk) {
            this.vrtsDisk = veritasDisk;
            this.disk = disk;
        }

        HashedDisk() {
            this.vrtsDisk = null;
            this.disk = null;
        }

        public boolean equals(HashedDisk hashedDisk) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherDisk");
            }
            boolean bl = this.vrtsDisk.equals(hashedDisk.vrtsDisk);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            HashedDisk hashedDisk = (HashedDisk)object;
            int n = this.vrtsDisk.compareTo(hashedDisk.vrtsDisk);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }
    }

    private static class HashedSubDisk
    implements Comparable {
        public VeritasSubDisk vrtsSubDisk;
        public HashedDisk hashDisk;
        public HashedSubDisk next;

        HashedSubDisk(VeritasSubDisk veritasSubDisk, HashedDisk hashedDisk) {
            this.vrtsSubDisk = veritasSubDisk;
            this.hashDisk = hashedDisk;
            this.next = null;
        }

        HashedSubDisk() {
            this.vrtsSubDisk = null;
            this.hashDisk = null;
            this.next = null;
        }

        public boolean equals(HashedSubDisk hashedSubDisk) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherSubDisk");
            }
            boolean bl = this.vrtsSubDisk.equals(hashedSubDisk.vrtsSubDisk);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            HashedSubDisk hashedSubDisk = (HashedSubDisk)object;
            int n = this.vrtsSubDisk.compareTo(hashedSubDisk.vrtsSubDisk);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedSubDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }
    }

    private static class HashedPlex
    implements Comparable {
        public VeritasPlex vrtsPlex;
        public HashedSubDisk hashSubDisk;
        public HashedVolume hashVolume;
        public HashedPlex next;

        HashedPlex(VeritasPlex veritasPlex) {
            this.vrtsPlex = veritasPlex;
            this.hashSubDisk = null;
            this.hashVolume = null;
            this.next = null;
        }

        HashedPlex() {
            this.vrtsPlex = null;
            this.hashSubDisk = null;
            this.hashVolume = null;
            this.next = null;
        }

        public boolean equals(HashedPlex hashedPlex) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherPlex");
            }
            boolean bl = this.vrtsPlex.equals(hashedPlex.vrtsPlex);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            HashedPlex hashedPlex = (HashedPlex)object;
            int n = this.vrtsPlex.compareTo(hashedPlex.vrtsPlex);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedPlex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }
    }

    private static class HashedVolume
    implements Comparable {
        public VeritasVolume vrtsVolume;
        public HashedPlex hashPlex;
        int column;
        boolean bMsgIssued;
        HashedVolume assocVolume;
        HashedVolume next;

        HashedVolume(VeritasVolume veritasVolume) {
            this.vrtsVolume = veritasVolume;
            this.hashPlex = null;
            this.column = 0;
            this.bMsgIssued = false;
            this.assocVolume = null;
            this.next = null;
        }

        HashedVolume() {
            this.vrtsVolume = null;
            this.hashPlex = null;
            this.column = 0;
            this.bMsgIssued = false;
            this.assocVolume = null;
            this.next = null;
        }

        public boolean equals(HashedVolume hashedVolume) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"otherVolume");
            }
            boolean bl = this.vrtsVolume.equals(hashedVolume.vrtsVolume);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"compareTo", (String)"object");
            }
            HashedVolume hashedVolume = (HashedVolume)object;
            int n = this.vrtsVolume.compareTo(hashedVolume.vrtsVolume);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.CommonProbe$HashedVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"compareTo", (int)n);
            }
            return n;
        }
    }
}

