/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.nas.netware.NetWareUtil;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.probe.UpTime;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.backend.ProbeLock;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbe
implements IExecutable {
    private static Class probeClass = ExecProbe.init();
    private int scheduleID;
    private boolean isInitial;
    private ProbeDefResp def;
    private NasFiler diskArrays;

    private native void defineProbe(ProbeDefResp var1);

    private native void cleanUp();

    public ExecProbe(boolean bl) {
        this.initialize(bl, null);
    }

    public ExecProbe(ProbeDefResp probeDefResp) {
        this.initialize(false, probeDefResp);
    }

    public ExecProbe() {
        this.initialize(false, null);
    }

    public int exec(StartedJob startedJob, String[] stringArray) {
        this.scheduleID = startedJob.getJobRun().getSchedID();
        return this.exec();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int exec() {
        String[] stringArray;
        Object object;
        LinkedInteger linkedInteger;
        Response response;
        ScanDefReq scanDefReq;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"main", (String)"");
        }
        int n = 8;
        Probe probe = null;
        try {
            probe = (Probe)probeClass.newInstance();
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"main", (Throwable)exception);
            }
            MessageLog.logException((String)"STA0114E", (Exception)exception);
        }
        if (probe == null) {
            int n2 = n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"main", (int)n2);
            }
            return n2;
        }
        boolean bl = false;
        CheckedRequest checkedRequest = Agent.makeCheckedRequest();
        checkedRequest.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        checkedRequest.subType = "org.eclipse.aperi.server.handler.agent.ProbeDefHndlr";
        checkedRequest.serviceName = RequestTypeManager.getInternalName((String)checkedRequest.typeCode);
        checkedRequest.machineName = Agent.localName;
        checkedRequest.userName = null;
        checkedRequest.flags = 0;
        if (this.def == null) {
            scanDefReq = new ScanDefReq();
            scanDefReq.computerID = ComputerID.cachedCID;
            scanDefReq.scheduleID = this.scheduleID;
            checkedRequest.requestData = scanDefReq;
            MessageLog.logMessage((String)"AGT0145I");
            response = Agent.reporter.sendRequest((Request)checkedRequest, (byte)1);
            if (response == null || response.status > 4 || !(response.responseData instanceof ProbeDefResp)) {
                MessageLog.logMessage((String)"STA0111E");
                int n3 = n;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"main", (int)n3);
                }
                return n3;
            }
            this.def = (ProbeDefResp)response.responseData;
            MessageLog.logMessage((String)"AGT0152I");
        }
        this.def.unpack();
        scanDefReq = null;
        if (this.def.pdProbeLocal) {
            scanDefReq = new NasFiler();
            scanDefReq.nfComputerID = ComputerID.cachedCID.computerID;
            scanDefReq.nfName = Agent.realLocalName;
            scanDefReq.nfNext = this.def.pdNasFiler;
        }
        if ((linkedInteger = ProbeLock.lock((ProbeDefResp)this.def, (NasFiler)scanDefReq)) == null) {
            int n4 = n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"main", (int)n4);
            }
            return n4;
        }
        Computer computer = null;
        try {
            block66: {
                try {
                    int n5;
                    int n6;
                    MessageLog.logMessage((String)"STA0113I");
                    this.separateOutDiskArrays(this.def);
                    if (!this.def.pdProbeLocal) {
                        object = null;
                        computer = new Computer();
                        computer.cmpOSType = Agent.hardwareID.osType;
                        n = 0;
                        MessageLog.logMessage((String)"STA0256I");
                    } else {
                        object = (UpTime)Agent.upTimePoller;
                        this.defineProbe(this.def);
                        n = probe.probe(this.def);
                        if (n > 4) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz.getName(), (String)"main");
                            }
                            throw new GeneralException();
                        }
                        computer = probe.computer;
                        if (NetWareLoader.loadNetWare(false)) {
                            try {
                                LdapTree ldapTree;
                                computer.cmpLdapTree = ldapTree = NetWareUtil.enumTrees();
                                while (ldapTree != null) {
                                    ldapTree.ltComputerID = ComputerID.cachedCID.computerID;
                                    ldapTree = ldapTree.ltNext;
                                }
                            }
                            catch (LocalizableException localizableException) {
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.exception((String)clazz.getName(), (String)"main", (Throwable)localizableException);
                                }
                                localizableException.print();
                                n = 4;
                            }
                        }
                    }
                    if (this.def.pdNasFiler != null && (n6 = probe.probeNAS(this.def, computer)) > n) {
                        n = n6;
                    }
                    if (n <= 4 && this.diskArrays != null && (n5 = this.probeDiskArrays(computer)) > n) {
                        n = n5;
                    }
                    if (!this.def.pdProbeLocal && computer.cmpNasFiler == null) {
                        MessageLog.logMessage((String)"STA0274E");
                        n = 8;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"main");
                        }
                        throw new GeneralException();
                    }
                    if (object != null) {
                        CompHist compHist;
                        computer.cmpHistory = compHist = new CompHist();
                        compHist.chMonitorStart = ((UpTime)object).beganMonitoring;
                        compHist.chMonitorEnd = System.currentTimeMillis();
                        compHist.chDownTime = (int)(((UpTime)object).downTime / 1000L);
                        compHist.chPowerCycles = (int)((UpTime)object).powerCycles;
                    }
                    computer.pack();
                    checkedRequest.subType = "org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr";
                    checkedRequest.flags = (byte)2;
                    checkedRequest.requestData = computer;
                    MessageLog.logMessage((String)"STA0249I");
                    response = Agent.reporter.sendRequest((Request)checkedRequest, (byte)2);
                    if (response == null || response.status > 4) {
                        MessageLog.logMessage((String)"STA0112E");
                        n = 8;
                    } else {
                        if (object != null) {
                            ((UpTime)object).reset(computer.cmpHistory.chMonitorEnd);
                        }
                        if (response.status > n) {
                            n = response.status;
                        }
                        if (n <= 4) {
                            if (this.isInitial) {
                                bl = true;
                                if (!Agent.isWindows || response.responseData != null) {
                                    // empty if block
                                }
                            }
                            MessageLog.logMessage((String)"STA0250I");
                        }
                    }
                    computer.unpack();
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block66;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"main", (Throwable)generalException);
                }
            }
            Object var11_24 = null;
            if (this.def != null) {
                this.cleanUp();
            }
        }
        catch (Throwable throwable) {
            Object var11_23 = null;
            if (this.def != null) {
                this.cleanUp();
            }
            ProbeLock.unlock((LinkedInteger)linkedInteger);
            throw throwable;
        }
        ProbeLock.unlock((LinkedInteger)linkedInteger);
        if (n == 0) {
            MessageLog.logMessage((String)"STA0109I");
        } else if (n > 4) {
            MessageLog.logMessage((String)"STA0108I");
        } else {
            MessageLog.logMessage((String)"STA0110I");
        }
        if (bl && (object = new ExecDiscovery()).exec(null, stringArray = new String[]{"NETWORK_DISCOVERY"}) != 0) {
            n = 4;
        }
        int n7 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"main", (int)n7);
        }
        return n7;
    }

    private void initialize(boolean bl, ProbeDefResp probeDefResp) {
        this.scheduleID = 103;
        this.isInitial = bl;
        this.def = probeDefResp;
    }

    private void separateOutDiskArrays(ProbeDefResp probeDefResp) {
        this.diskArrays = null;
        NasFiler nasFiler = null;
        NasFiler nasFiler2 = probeDefResp.pdNasFiler;
        while (nasFiler2 != null) {
            NasFiler nasFiler3 = nasFiler2.nfNext;
            if (Constants.isDiskArray((short)nasFiler2.nfOSType)) {
                if (nasFiler != null) {
                    nasFiler.nfNext = nasFiler3;
                } else {
                    probeDefResp.pdNasFiler = nasFiler3;
                }
                nasFiler2.nfNext = this.diskArrays;
                this.diskArrays = nasFiler2;
                MessageLog.logMessage((String)"SAA0028W", (Object)nasFiler2.nfName, (Object)nasFiler2.nfAlias);
            } else {
                nasFiler = nasFiler2;
                if (Constants.supportsFullProbe((short)nasFiler2.nfOSType)) {
                    MessageLog.logMessage((String)"NAA0072I", (Object)nasFiler2.nfName);
                } else if (Constants.isSANFSClient((int)nasFiler2.nfOSType)) {
                    MessageLog.logMessage((String)"NAA0120I", (Object)nasFiler2.nfName);
                } else {
                    MessageLog.logMessage((String)"NAA0073I", (Object)nasFiler2.nfName);
                    Filesystem filesystem = nasFiler2.nfFilesystems;
                    while (filesystem != null) {
                        MessageLog.logMessage((String)"NAA0074I", (Object)filesystem.fsMountPoint);
                        filesystem = filesystem.fsNext;
                    }
                }
            }
            nasFiler2 = nasFiler3;
        }
        this.diskArrays = null;
    }

    private int probeDiskArrays(Computer computer) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"probeDiskArrays", (String)"computer");
        }
        int n2 = 0;
        while (n2 < 8 && this.diskArrays != null) {
            boolean bl;
            NasFiler nasFiler = this.diskArrays.nfNext;
            this.diskArrays.nfNext = null;
            short cfr_ignored_0 = this.diskArrays.nfOSType;
            n = 8;
            MessageLog.logMessage((String)"SAA0023W", (Object)new Integer(this.diskArrays.nfOSType));
            boolean bl2 = bl = n < 8;
            if (!bl) {
                n -= 4;
            } else {
                this.diskArrays.nfNext = computer.cmpNasFiler;
                computer.cmpNasFiler = this.diskArrays;
            }
            if (n > n2) {
                n2 = n;
            }
            this.diskArrays = nasFiler;
        }
        n = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ExecProbe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"probeDiskArrays", (int)n);
        }
        return n;
    }

    private static native Class init();
}

