/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.util.LinkedList;
import java.util.Properties;

public class ThreadHandler
extends Handler
implements Runnable {
    static final long serialVersionUID = 8709102387974828892L;
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private transient boolean daemon = false;
    private transient boolean finished = false;
    private transient boolean stopRequested = false;
    private int capacity = 10000;
    private transient int discardedEventCount = 0;
    protected transient Object queueEmptyLock = new Object();
    protected transient Object queueFullLock = new Object();
    private transient LinkedList queue = new LinkedList();
    protected transient Thread myThread = null;

    public ThreadHandler() {
    }

    public ThreadHandler(String string) {
        super(string);
    }

    public ThreadHandler(String string, boolean bl) {
        super(string);
        this.daemon = bl;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("queueCapacity", new Integer(this.getQueueCapacity()).toString());
        properties.put("daemon", new Boolean(this.daemon).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("queueCapacity");
        if (string != null) {
            this.setQueueCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("daemon")) != null) {
            this.setDaemon(new Boolean(string));
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    public int getQueueCount() {
        return this.queue.size();
    }

    public int getQueueCapacity() {
        return this.capacity;
    }

    public void setQueueCapacity(int n) {
        if (n >= 0) {
            this.capacity = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setQueueCapacity");
            LogUtil.errorMsg(string);
        }
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                String string = String.valueOf(this.getClass().getName()) + ":" + this.getName();
                this.myThread = new Thread((Runnable)this, string);
                if (this.isDaemon()) {
                    this.myThread.setDaemon(true);
                } else {
                    this.myThread.setDaemon(false);
                }
                this.myThread.start();
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (!this.finished) {
            LogEvent logEvent;
            object = this.queueEmptyLock;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    logEvent = null;
                    if (this.stopRequested) {
                        this.finished = true;
                    } else {
                        try {
                            this.queueEmptyLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    logEvent = (LogEvent)this.queue.removeFirst();
                }
            }
            if (logEvent == null) continue;
            object = this.queueFullLock;
            synchronized (object) {
                this.queueFullLock.notifyAll();
            }
            this.log(logEvent);
            if (this.discardedEventCount == 0) continue;
            if (this.discardedEventCount == 1) {
                LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_1", this.getName()));
            } else {
                LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_2", this.getName(), new Integer(this.discardedEventCount)));
            }
            this.discardedEventCount = 0;
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            this.queueEmptyLock.notify();
        }
        object = this.deviceLock;
        synchronized (object) {
            this.myThread = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.stopRequested = true;
            this.queueEmptyLock.notify();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            while (true) {
                if (!this.open) {
                    return;
                }
                try {
                    this.queueEmptyLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(LogEvent logEvent) {
        if (logEvent != null && !this.stopRequested) {
            if (!this.open) {
                try {
                    this.open();
                }
                catch (Exception exception) {}
            }
            boolean bl = false;
            while (!bl) {
                Object object;
                if (this.queue.size() < this.getQueueCapacity()) {
                    object = this.queueEmptyLock;
                    synchronized (object) {
                        this.queue.addLast(logEvent);
                        this.queueEmptyLock.notify();
                    }
                    bl = true;
                    continue;
                }
                if (!Thread.currentThread().equals(this.myThread)) {
                    object = this.queueFullLock;
                    synchronized (object) {
                        try {
                            this.queueFullLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_QUEUE_FULL", this.getName()));
                }
                ++this.discardedEventCount;
                bl = true;
            }
        }
    }

    public void write(LogEvent logEvent) throws Exception {
    }
}

