/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.util.LogUtil;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageCatalog {
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final char SINGLE_QUOTE = '\'';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_LITERAL_BRACE = 2;
    private static final int STATE_MSG_ELEMENT = 3;
    private static boolean debugMode = false;
    private int hitCount = 0;
    private Locale locale;
    private MessageFormat msgFormatter = new MessageFormat("");
    private Object formatLock = new Object();
    private ResourceBundle msgBundle;
    private String baseName;

    public static ClassLoader getClassLoader() {
        return LogUtil.getDefaultResourceClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        LogUtil.setDefaultResourceClassLoader(classLoader);
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean bl) {
        debugMode = bl;
    }

    public MessageCatalog(String string) {
        this(string, null);
    }

    public MessageCatalog(String string, Locale locale) {
        this.baseName = string;
        this.msgBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    public MessageCatalog(ResourceBundle resourceBundle) {
        this(resourceBundle, null);
    }

    public MessageCatalog(ResourceBundle resourceBundle, Locale locale) {
        this.msgBundle = resourceBundle;
        this.baseName = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
            this.msgFormatter.setLocale(locale);
            if (this.baseName != null) {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = LogUtil.getClassLoaderForResource(this.baseName);
                    try {
                        clazz = Class.forName("com.ibm.log.util.MessageCatalog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    Class<?> clazz2 = clazz;
                    synchronized (clazz) {
                        this.msgBundle = classLoader == null ? ResourceBundle.getBundle(this.baseName, this.getLocale()) : ResourceBundle.getBundle(this.baseName, this.getLocale(), classLoader);
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    this.msgBundle = null;
                }
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLocale");
            LogUtil.errorMsg(string);
        }
        {
            return;
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Enumeration getKeys() {
        return this.msgBundle.getKeys();
    }

    public String getUnformattedMessage(String string) {
        String string2 = null;
        if (this.msgBundle != null) {
            try {
                string2 = this.msgBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public String getMessage(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (this.msgBundle != null) {
            try {
                string2 = this.formatMessage(this.msgBundle.getString(string), objectArray);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer(256);
            if (this.msgBundle == null) {
                if (this.baseName == null) {
                    stringBuffer.append(LogUtil.getLogMsg("ERR_MISSING_BUNDLE_NO_FILE", string));
                } else {
                    stringBuffer.append(LogUtil.getLogMsg("ERR_MISSING_BUNDLE", this.baseName, string));
                }
            } else if (this.baseName == null) {
                stringBuffer.append(LogUtil.getLogMsg("ERR_MISSING_KEY_NO_FILE", string));
            } else {
                stringBuffer.append(LogUtil.getLogMsg("ERR_MISSING_KEY", string, this.baseName));
            }
            if (MessageCatalog.isDebugMode()) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            if (objectArray == null) {
                stringBuffer.append(".");
            } else {
                objectArray = LogUtil.checkNullObjects(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(", p" + (n + 1) + "=" + objectArray[n].toString());
                    ++n;
                }
            }
            if (MessageCatalog.isDebugMode()) {
                stringBuffer.append("]");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String formatMessage(String var1_1, Object[] var2_2) {
        var3_3 = null;
        if (var2_2 != null) {
            block14: {
                var4_4 = new StringBuffer();
                var2_2 = LogUtil.checkNullObjects(var2_2);
                try {
                    var5_5 = this.formatLock;
                    synchronized (var5_5) {
                        this.msgFormatter.applyPattern(this.fixPattern(var1_1));
                        var6_8 = this.formatLock;
                        synchronized (var6_8) {
                            var4_4 = this.msgFormatter.format(var2_2, var4_4, (FieldPosition)null);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException v2) {
                    var4_4.setLength(0);
                    var4_4.append(var1_1);
                    var5_6 = 0;
                    ** while (var5_6 < var2_2.length)
                }
lbl-1000:
                // 1 sources

                {
                    var4_4.append(", p" + (var5_6 + 1) + "=" + var2_2[var5_6].toString());
                    ++var5_6;
                    continue;
lbl30:
                    // 1 sources

                    break block14;
                }
                catch (IllegalArgumentException v3) {
                    var4_4.setLength(0);
                    var4_4.append(var1_1);
                    var5_7 = 0;
                    ** while (var5_7 < var2_2.length)
                }
lbl-1000:
                // 1 sources

                {
                    var4_4.append(", p" + (var5_7 + 1) + "=" + var2_2[var5_7].toString());
                    ++var5_7;
                    continue;
                }
            }
            var3_3 = var4_4.toString();
        } else {
            var3_3 = var1_1;
        }
        if (MessageCatalog.isDebugMode()) {
            var3_3 = "[" + var3_3 + "]";
        }
        ++this.hitCount;
        return var3_3;
    }

    protected String fixPattern(String string) {
        if (string.indexOf(39) != -1) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                block0 : switch (n2) {
                    case 0: {
                        switch (c) {
                            case '\'': {
                                n2 = 1;
                                break;
                            }
                            case '{': {
                                n2 = 3;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '\'': {
                                n2 = 0;
                                break block0;
                            }
                            case '{': 
                            case '}': {
                                n2 = 2;
                                break block0;
                            }
                        }
                        stringBuffer.append('\'');
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case '\'': {
                                n2 = 0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (c) {
                            case '}': {
                                n2 = 0;
                            }
                        }
                    }
                }
                stringBuffer.append(c);
                ++n3;
            }
            if (n2 == 1) {
                stringBuffer.append('\'');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public char getChar(String string) {
        String string2 = this.getMessage(string);
        char c = MessageCatalog.isDebugMode() ? string2.charAt(1) : string2.charAt(0);
        return c;
    }

    public String toString() {
        String string = this.baseName != null ? this.baseName : this.msgBundle.toString();
        return "bundle=" + string + ", locale=" + this.getLocale().toString() + ", debugMode=" + MessageCatalog.isDebugMode();
    }
}

