/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.dbaccess.CIMOMDbAccess;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.DiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.ProcessPluginFactory;
import org.eclipse.aperi.disk.util.DiscoveryMessageHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMTransportException;

public class TopLevelDiscoveryProcess
extends DiscoverProcess
implements DiscoveryConstants,
CIMNames {
    private static String discoverEventPrefix = "D";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopLevelDiscoveryProcess(String string, boolean bl) {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super(string, bl, new String[]{"CIMOM", "Type"}, stringArray);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"TopLevelDiscoveryProcess", (Object[])new Object[]{string, new Boolean(bl)});
        try {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.disk.discovery.TopLevelDiscoveryProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz3.getName());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit(null);
    }

    protected Result handleCIMOM(TopLevelParameter topLevelParameter) {
        Result result;
        Properties properties;
        Result result2;
        LogTraceHelper logTraceHelper;
        block5: {
            logTraceHelper = LogTraceHelper.entry((Request)topLevelParameter.getDiscoverRequest(), (Object)((Object)this), (String)"handleCIMOM", (Object[])new Object[0]);
            result2 = null;
            topLevelParameter.setCIMOMProperties(null);
            properties = this.collectCIMOMData(topLevelParameter);
            topLevelParameter.setCIMOMProperties(properties);
            if (properties != null) break block5;
            logTraceHelper.traceError("Error finding devices", null);
            logTraceHelper.logMsg("HWN021601E", new Object[]{"collect CIM_ObjectManager"});
            Result result3 = result2 = new Result(10002, new SRMMessage("HWN021601E", new String[]{"discoverStorageSubsystems"}));
            Object var6_9 = null;
            logTraceHelper.exit((Object)result2);
            return result3;
        }
        try {
            DiscoveryProcessPlugin discoveryProcessPlugin = ProcessPluginFactory.getProcessPlugin(properties, topLevelParameter.getParameters());
            discoveryProcessPlugin.initRequest(topLevelParameter.getDiscoverRequest(), topLevelParameter.getParameters(), topLevelParameter.getDiskCIMProcessor());
            topLevelParameter.setDiscoveryProcessPlugin(discoveryProcessPlugin);
            result = new Result(0, new SRMMessage("HWN020001I", new String[]{"discoverStorageSubsystems"}));
            Object var6_10 = null;
        }
        catch (DiscoveryException discoveryException) {
            Result result4;
            try {
                result2 = new Result(10003, new SRMMessage(discoveryException.getMsgKey(), discoveryException.getMsgInserts()));
                logTraceHelper.logMsg(discoveryException.getMsgKey(), (Object[])discoveryException.getMsgInserts());
                logTraceHelper.traceInfo("StorageDiscoveryProcess : unable to collect CIMOM ");
                result4 = result2;
                Object var6_11 = null;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                logTraceHelper.exit(result2);
                throw throwable;
            }
            logTraceHelper.exit((Object)result2);
            return result4;
        }
        logTraceHelper.exit((Object)result2);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties collectCIMOMData(TopLevelParameter topLevelParameter) throws DiscoveryException {
        Properties properties;
        LogTraceHelper logTraceHelper;
        block23: {
            block24: {
                Properties properties2;
                block22: {
                    String string = "collectCIMOMData";
                    logTraceHelper = LogTraceHelper.entry((Request)topLevelParameter.getDiscoverRequest(), (Object)((Object)this), (String)string, (Object[])new Object[0]);
                    properties = null;
                    try {
                        String[] stringArray = Router.getRouter().perform("RegisteredProfile", topLevelParameter.getParameters(), new Integer(topLevelParameter.getDiscoverRequest().getId()).toString());
                        Router.getRouter().waitTilComplete(stringArray);
                        JobInfo jobInfo = (JobInfo)JobEngine.getInstance().getJobs(stringArray[1]).get(0);
                        if (!jobInfo.isSuccessful()) {
                            String string2 = "";
                            if (jobInfo.getResponse() != null) {
                                Throwable throwable = null;
                                Object object = jobInfo.getResponse().getData();
                                if (object instanceof CIMException) {
                                    throwable = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
                                } else if (object instanceof DiskManagerRTException) {
                                    Throwable throwable2 = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
                                    while (throwable2.getCause() != null) {
                                        if ((throwable2 = throwable2.getCause()) instanceof CIMException) {
                                            throwable = throwable2;
                                            break;
                                        }
                                        throwable = null;
                                    }
                                } else {
                                    logTraceHelper.traceInfo("No instance of CIMException");
                                    throwable = null;
                                }
                                if (throwable != null && throwable instanceof CIMTransportException || throwable instanceof CIMException && throwable.getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
                                    logTraceHelper.traceError("CIMOM connection Failure", throwable);
                                    throw new DiscoveryException("CIMOM connection Failure", "HWN021537E", new String[]{((String[])topLevelParameter.getParameters().get("CIMOM"))[0], throwable.getMessage()}, (Exception)throwable);
                                }
                                if (throwable != null && throwable instanceof CIMAuthenticationException || throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("challenge") > 0) {
                                    logTraceHelper.traceError("CIMOM authentication Failure", throwable);
                                    throw new DiscoveryException("CIMOM authentication Failure", "HWN021537E", new String[]{((String[])topLevelParameter.getParameters().get("CIMOM"))[0], throwable.getMessage()}, (Exception)throwable);
                                }
                                if (throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                                    logTraceHelper.traceError("CIMOM timout Failure", throwable);
                                    throw new DiscoveryException("CIMOM timout Failure", "HWN021650E", new String[]{((String[])topLevelParameter.getParameters().get("CIMOM"))[0], throwable.getMessage()}, (Exception)throwable);
                                }
                                if (throwable != null && throwable instanceof DiskManagerTimeoutException) {
                                    logTraceHelper.traceError("CIMOM timout Failure", throwable);
                                    throw new DiscoveryException("CIMOM timout Failure", "HWN021650E", new String[]{((String[])topLevelParameter.getParameters().get("CIMOM"))[0], throwable.getMessage()}, (Exception)throwable);
                                }
                                string2 = ((Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData()).toString();
                                logTraceHelper.traceWarning("No Profile found (" + string2 + ")");
                            }
                            properties = new Properties();
                            properties.put("NoServerProfile", new Boolean(true));
                            properties2 = properties;
                            Object var15_16 = null;
                            break block22;
                        }
                        Response response = jobInfo.getResponse();
                        if (!(response instanceof Response)) break block23;
                        Map map = topLevelParameter.getParameters();
                        Enumeration enumeration = (Enumeration)response.getData();
                        HashSet<String> hashSet = new HashSet<String>();
                        while (true) {
                            if (!enumeration.hasMoreElements()) {
                                if (properties != null) {
                                    properties.setProperty("RegisteredProfile", ((Object)hashSet).toString());
                                }
                                break block23;
                            }
                            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                            String string3 = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"RegisteredName");
                            if ("Server".equals(string3)) {
                                map.put("IN_SYSTEM_OBJECTMANAGER", cIMInstance);
                                String[] stringArray2 = Router.getRouter().perform("OBJECTMANAGER", map, new Integer(topLevelParameter.getDiscoverRequest().getId()).toString());
                                Router.getRouter().waitTilComplete(stringArray2);
                                JobInfo jobInfo2 = (JobInfo)JobEngine.getInstance().getJobs(stringArray2[1]).get(0);
                                if (!jobInfo2.isSuccessful()) {
                                    logTraceHelper.traceInfo("Error executing associator call CIM_RegiseredProfile, CIM_ElementConformsToProfile, CIM_ObjectManager");
                                    break block24;
                                } else {
                                    properties = this.saveProperties(properties, stringArray2, jobInfo2);
                                    continue;
                                }
                            }
                            hashSet.add(string3);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_18 = null;
                        logTraceHelper.exit(properties);
                        throw throwable;
                    }
                }
                logTraceHelper.exit((Object)properties);
                return properties2;
            }
            Object var15_17 = null;
            logTraceHelper.exit((Object)properties);
            return null;
        }
        Object var15_19 = null;
        logTraceHelper.exit((Object)properties);
        return properties;
    }

    protected Properties saveProperties(Properties properties, String[] stringArray, JobInfo jobInfo) {
        Response response = jobInfo.getResponse();
        Enumeration enumeration = (Enumeration)response.getData();
        while (enumeration.hasMoreElements()) {
            properties = new Properties();
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.toString());
            cIMObjectPath.getNameSpace();
            properties.put("Name", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Name"));
            properties.put("SystemName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SystemName"));
            properties.put("ElementName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"ElementName"));
            properties.put("Description", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Description"));
            properties.put("CreationClassName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"CreationClassName"));
            properties.put("SystemCreationClassName", CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"SystemCreationClassName"));
            String string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Version");
            if (string != null) {
                properties.put("Version", string);
            } else {
                properties.put("Version", "");
            }
            properties.put("ObjectManager", stringArray[1]);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Result collectStorageDevices(TopLevelParameter topLevelParameter) {
        Result result;
        Result result2;
        LogTraceHelper logTraceHelper;
        String string;
        block20: {
            Result result3;
            block19: {
                Result result4;
                block18: {
                    Result result5;
                    block17: {
                        Result result6;
                        block16: {
                            string = ((String[])topLevelParameter.getParameters().get("CIMOM"))[0];
                            logTraceHelper = LogTraceHelper.entry((Request)topLevelParameter.getDiscoverRequest(), (Object)((Object)this), (String)"collectStorageDevices", (Object[])new Object[]{string});
                            result2 = null;
                            try {
                                try {
                                    Class<?> clazz;
                                    Map map = topLevelParameter.getParameters();
                                    map = DiscoverUtils.setProbeTimeout((Map)map, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Discovery.Timeout", (long)0L), (LogTraceHelper)logTraceHelper);
                                    topLevelParameter.setParameters(map);
                                    logTraceHelper.logMsg("HWN021727I", new Object[]{string});
                                    CIMOM[] cIMOMArray = CIMOMDbAccess.getCIMOMs((String[])new String[]{string});
                                    if (cIMOMArray == null || cIMOMArray.length == 0) {
                                        SRMMessage sRMMessage = new SRMMessage("HWN021801E", new String[]{string});
                                        result2 = new Result(10030, sRMMessage);
                                        logTraceHelper.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM " + string);
                                        logTraceHelper.logMsg(sRMMessage.getMsgId(), (Object[])sRMMessage.getMsgInserts());
                                        result6 = result2;
                                        Object var9_18 = null;
                                        break block16;
                                    }
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.common.api.ICIMOMMgmtService");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    ICIMOMMgmtService iCIMOMMgmtService = (ICIMOMMgmtService)DiscoveryActivator._serviceHelper.bindLocalOSGiService(clazz.getName());
                                    CIMOMConnectionStatus[] cIMOMConnectionStatusArray = iCIMOMMgmtService.testCIMOMConnection(cIMOMArray);
                                    if (!cIMOMConnectionStatusArray[0].isSuccess()) {
                                        result5 = this.getResultFromConnectionStaus(cIMOMConnectionStatusArray[0], cIMOMArray[0], logTraceHelper);
                                        break block17;
                                    }
                                    result2 = this.handleCIMOM(topLevelParameter);
                                    if (result2.getRc() != 0) {
                                        result4 = result2;
                                        break block18;
                                    }
                                    if (topLevelParameter.getDiscoveryProcessPlugin() != null) {
                                        topLevelParameter.getDiscoveryProcessPlugin().collectDeviceData((String)topLevelParameter.getCIMOMProperties().get("ObjectManager"), (String)topLevelParameter.getCIMOMProperties().get("Version"), topLevelParameter.getParameters());
                                        result3 = result2;
                                        break block19;
                                    }
                                    result = result2 = new Result(10001, new SRMMessage("HWN021503E", new String[0]));
                                    break block20;
                                }
                                catch (DiscoveryException discoveryException) {
                                    String string2 = discoveryException.getMsgKey();
                                    if (string2 != null && string2.equalsIgnoreCase("HWN021537E") || string2 != null && string2.equalsIgnoreCase("HWN021538E")) {
                                        result2 = new Result(10003, new SRMMessage(discoveryException.getMsgKey(), discoveryException.getMsgInserts()));
                                        logTraceHelper.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM ");
                                        logTraceHelper.logMsg(string2, (Object[])discoveryException.getMsgInserts());
                                        Result result7 = result2;
                                        Object var9_23 = null;
                                        logTraceHelper.logMsg("HWN021728I", new Object[]{string});
                                        logTraceHelper.exit((Object)result2);
                                        return result7;
                                    }
                                    if (string2 != null && string2.equalsIgnoreCase("HWN021650E")) {
                                        result2 = new Result(10006, new SRMMessage(discoveryException.getMsgKey(), discoveryException.getMsgInserts()));
                                        logTraceHelper.traceInfo("TopLevelDiscoveryProcess : unable to collect CIMOM with timeout ");
                                    } else if (discoveryException.getCause() instanceof CIMException) {
                                        logTraceHelper.traceInfo("TopLevelDiscoveryProcess : CIMException  ");
                                    }
                                    result2 = new Result(10001, new SRMMessage(discoveryException.getMsgKey(), discoveryException.getMsgInserts()));
                                    throw DiskMessageHelper.getServerException((String)discoveryException.getMsgKey(), (Object)discoveryException.getMsgInserts(), (Throwable)discoveryException, (LogTraceHelper)logTraceHelper);
                                }
                                catch (Exception exception) {
                                    result2 = new Result(10001, new SRMMessage("HWN021503E", new String[0]));
                                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_24 = null;
                                logTraceHelper.logMsg("HWN021728I", new Object[]{string});
                                logTraceHelper.exit((Object)result2);
                                throw throwable;
                            }
                        }
                        logTraceHelper.logMsg("HWN021728I", new Object[]{string});
                        logTraceHelper.exit((Object)result2);
                        return result6;
                    }
                    Object var9_19 = null;
                    logTraceHelper.logMsg("HWN021728I", new Object[]{string});
                    logTraceHelper.exit((Object)result2);
                    return result5;
                }
                Object var9_20 = null;
                logTraceHelper.logMsg("HWN021728I", new Object[]{string});
                logTraceHelper.exit((Object)result2);
                return result4;
            }
            Object var9_21 = null;
            logTraceHelper.logMsg("HWN021728I", new Object[]{string});
            logTraceHelper.exit((Object)result2);
            return result3;
        }
        Object var9_22 = null;
        logTraceHelper.logMsg("HWN021728I", new Object[]{string});
        logTraceHelper.exit((Object)result2);
        return result;
    }

    protected Result getResultFromConnectionStaus(CIMOMConnectionStatus cIMOMConnectionStatus, CIMOM cIMOM, LogTraceHelper logTraceHelper) {
        Result result = null;
        if (cIMOMConnectionStatus.equals(CIMOMConnectionStatus.LOGIN_FAILED)) {
            String string = cIMOM.getUserId() == null ? "null" : cIMOM.getUserId();
            result = new Result(10022, new SRMMessage("HWN021538E", new String[]{string, cIMOM.getServiceUrl()}));
            logTraceHelper.logMsg("HWN021538E", (Object[])new String[]{string, cIMOM.getServiceUrl()});
            logTraceHelper.traceInfo("getResultFromConnectionStaus : Login failed ");
        } else if (cIMOMConnectionStatus.equals(CIMOMConnectionStatus.TIMEOUT)) {
            result = new Result(10006, new SRMMessage("HWN021650E", new String[]{cIMOM.getServiceUrl()}));
            logTraceHelper.logMsg("HWN021650E", (Object[])new String[]{cIMOM.getServiceUrl()});
            logTraceHelper.traceInfo("getResultFromConnectionStaus : timeout ");
        } else if (cIMOMConnectionStatus.equals(CIMOMConnectionStatus.REFUSED)) {
            result = new Result(10003, new SRMMessage("HWN021537E", new String[]{cIMOM.getServiceUrl(), cIMOMConnectionStatus.toString()}));
            logTraceHelper.logMsg("HWN021537E", (Object[])new String[]{cIMOM.getServiceUrl(), cIMOMConnectionStatus.toString()});
            logTraceHelper.traceInfo("getResultFromConnectionStaus : connection failed ");
        } else {
            result = new Result(10001, new SRMMessage("HWN021537E", new String[]{cIMOM.getServiceUrl(), cIMOMConnectionStatus.toString()}));
            logTraceHelper.logMsg("HWN021650E", (Object[])new String[]{cIMOM.getServiceUrl(), cIMOMConnectionStatus.toString()});
            logTraceHelper.traceInfo("getResultFromConnectionStaus : other ");
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Result process(Request var1_1, Map var2_2) throws ParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 114->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getScannerId(Map map) throws ParameterException {
        String string = "DS2";
        String[] stringArray = (String[])map.get("CIMOM");
        if (stringArray == null || stringArray.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String string2 = stringArray[0];
        String string3 = String.valueOf(string) + ":" + string2;
        return string3;
    }

    public int getAuthoritativeReferenceType(Map map) throws ParameterException {
        return 100;
    }

    public int getAuthoritativeReferenceId(Map map) throws ParameterException {
        try {
            String[] stringArray = (String[])map.get("CIMOM");
            if (stringArray == null || stringArray.length < 1) {
                throw new ParameterException("Missing parameter: CIMOM");
            }
            String string = stringArray[0];
            return CIMOMDbAccess.getCIMOMIDforURL((String)string);
        }
        catch (SQLException sQLException) {
            throw new ParameterException("Missing parameter for saved CIMOM : CIMOM");
        }
    }

    public String getProcessInfoForJobLog(Map map) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            String[] stringArray = (String[])TopLevelDiscoveryProcess.getParameter((Map)map, (String)"CIMOM", (String)clazz.getName());
            return "discoverSubsystems+" + stringArray[0];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void checkJobSuccessful(String string, LogTraceHelper logTraceHelper, JobInfo jobInfo, String string2, Map map) throws DiscoveryException {
        DiscoveryException discoveryException = null;
        Throwable throwable = null;
        Object object = jobInfo.getResponse().getData();
        if (object instanceof CIMException) {
            throwable = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
        } else if (object instanceof DiskManagerRTException) {
            Throwable throwable2 = (Throwable)((CIMExceptionResponse)jobInfo.getResponse()).getData();
            while (throwable2.getCause() != null) {
                if ((throwable2 = throwable2.getCause()) instanceof CIMException) {
                    throwable = throwable2;
                    break;
                }
                throwable = null;
            }
        } else {
            logTraceHelper.traceInfo("No instance of CIMException");
            throwable = null;
        }
        if (throwable != null && throwable instanceof CIMTransportException || throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("UNABLE_TO_CONNECT") > 0) {
            logTraceHelper.traceError("CIMOM connection Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021537E", (String[])new String[]{((String[])map.get("CIMOM"))[0], throwable.getMessage()}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMAuthenticationException) {
            logTraceHelper.traceError("CIMOM authentication Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021538E", (String[])new String[]{(String)map.get("USERID"), ((String[])map.get("CIMOM"))[0], throwable.getMessage()}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMException && throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021650E", (String[])new String[]{((String[])map.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (object != null && object instanceof DiskManagerTimeoutException) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021650E", (String[])new String[]{((String[])map.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else if (throwable != null && throwable instanceof CIMException) {
            logTraceHelper.traceError("CIMOM timout Failure", throwable);
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021529E", (String[])new String[]{((String[])map.get("CIMOM"))[0]}, (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        } else {
            discoveryException = DiscoveryMessageHelper.getDiscoveryException((String)(String.valueOf(string) + string2), (String)"HWN021503E", (String[])new String[0], (JobInfo)jobInfo, (LogTraceHelper)logTraceHelper);
        }
        throw discoveryException;
    }

    protected class TopLevelParameter {
        private DiscoveryProcessPlugin cDiscoveryProcessPlugin = null;
        private Request cDiscoverRequest = null;
        private Map cParameters = null;
        private Properties cCIMOMProperties = null;
        private DiskCIMProcessor cDiskCIMProcessor = null;

        public Properties getCIMOMProperties() {
            return this.cCIMOMProperties;
        }

        public Request getDiscoverRequest() {
            return this.cDiscoverRequest;
        }

        public DiscoveryProcessPlugin getDiscoveryProcessPlugin() {
            return this.cDiscoveryProcessPlugin;
        }

        public DiskCIMProcessor getDiskCIMProcessor() {
            return this.cDiskCIMProcessor;
        }

        public Map getParameters() {
            return this.cParameters;
        }

        public void setCIMOMProperties(Properties properties) {
            this.cCIMOMProperties = properties;
        }

        public void setDiscoverRequest(Request request) {
            this.cDiscoverRequest = request;
        }

        public void setDiscoveryProcessPlugin(DiscoveryProcessPlugin discoveryProcessPlugin) {
            this.cDiscoveryProcessPlugin = discoveryProcessPlugin;
        }

        public void setDiskCIMProcessor(DiskCIMProcessor diskCIMProcessor) {
            this.cDiskCIMProcessor = diskCIMProcessor;
        }

        public void setParameters(Map map) {
            this.cParameters = map;
        }
    }
}

