/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.io.InvalidClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskIndicationHandlerFactory {
    private static DiskIndicationHandlerFactory stSingletonInstance = new DiskIndicationHandlerFactory();
    private Map cHandlerMap = new HashMap(50);
    private Map cSuperclassMap = Collections.synchronizedMap(new HashMap(100));

    public static DiskIndicationHandlerFactory getInstance() {
        return stSingletonInstance;
    }

    private DiskIndicationHandlerFactory() {
        this.cHandlerMap = new HashMap();
    }

    public ICIMIndicationHandler getHandler(String string, String string2, CIMIndicationEvent cIMIndicationEvent) {
        Class<?> clazz = this.findHandler(string, string2);
        if (clazz == null && (clazz = this.findHandler(string, this.getSuperclass(string2, cIMIndicationEvent))) == null && (clazz = this.findHandler(this.getSuperclass(string, cIMIndicationEvent), this.getSuperclass(string2, cIMIndicationEvent))) == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.disk.monitor.NOPHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = clazz2;
        }
        try {
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class[] classArray = new Class[3];
            try {
                clazz5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz5;
            try {
                clazz4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[1] = clazz4;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[2] = clazz3;
            Class[] classArray2 = classArray;
            Constructor<?> constructor = clazz.getConstructor(classArray2);
            Object[] objectArray = new Object[]{string, string2, cIMIndicationEvent};
            return (ICIMIndicationHandler)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String getSuperclass(String string, CIMIndicationEvent cIMIndicationEvent) {
        String string2 = (String)this.cSuperclassMap.get(string);
        if (string2 == null) {
            string2 = this.getSuperclassFromCimom(string, cIMIndicationEvent);
            this.cSuperclassMap.put(string, string2);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSuperclassFromCimom(String string, CIMIndicationEvent cIMIndicationEvent) {
        String string2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getSuperclassFromCimom", (Object[])new Object[]{string, cIMIndicationEvent});
        String string3 = null;
        try {
            try {
                CIMClientWrapper cIMClientWrapper = cIMIndicationEvent.getCIMClient();
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string, cIMIndicationEvent.getCIMNameSpace());
                CIMClass cIMClass = cIMClientWrapper.getClass(cIMObjectPath, false, false, false, logTraceHelper);
                string2 = string3 = cIMClass.getSuperClass();
                Object var8_11 = null;
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("getSuperclassFromCimom failed", (Throwable)cIMException);
                throw new RuntimeException(cIMException);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("getSuperclassFromCimom failed", (Throwable)diskManagerTimeoutException);
                throw new RuntimeException(diskManagerTimeoutException);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            logTraceHelper.exit(string3);
            throw throwable;
        }
        logTraceHelper.exit((Object)string3);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findHandler(String string, String string2) {
        Map map = this.cHandlerMap;
        synchronized (map) {
            Map map2 = (Map)this.cHandlerMap.get(string);
            return map2 != null ? (Class)map2.get(string2) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(Class clazz) throws InvalidClassException {
        CIMIndicationHandler.RegistrationData[] registrationDataArray;
        Object object;
        Class<?> clazz2;
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        Class<?>[] classArray = clazz.getInterfaces();
        Arrays.sort(classArray, comparator);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.disk.monitor.ICIMIndicationHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (Arrays.binarySearch(classArray, clazz2.toString(), comparator) < 0) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.disk.monitor.ICIMIndicationHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new InvalidClassException(clazz.getName(), "Class doesn't implement " + clazz3.getName());
        }
        try {
            object = clazz.getMethod("getRegistrationData", new Class[0]);
            registrationDataArray = (CIMIndicationHandler.RegistrationData[])((Method)object).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new InvalidClassException(clazz.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        object = this.cHandlerMap;
        synchronized (object) {
            int n = 0;
            while (n < registrationDataArray.length) {
                CIMIndicationHandler.RegistrationData registrationData = registrationDataArray[n];
                Map map = this.getOrCreateInnerMap(this.cHandlerMap, registrationData.getIndicationType());
                if (map.containsKey(registrationData.getCIMClassName())) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                map.put(registrationData.getCIMClassName(), clazz);
                ++n;
            }
        }
    }

    private Map getOrCreateInnerMap(Map map, String string) {
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(string, hashMap);
        }
        return hashMap;
    }
}

