/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.DiskMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.FabricMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.StormTreeLabel;
import org.eclipse.aperi.TStorm.gui.TapeMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.About;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiApplet;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.dashboard.DashInitialize;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.rcp.gui.ApplicationActionBarAdvisor;
import org.eclipse.aperi.rcp.gui.ApplicationWorkbenchWindowAdvisor;
import org.eclipse.aperi.rcp.gui.actions.CloseAllAction;
import org.eclipse.aperi.rcp.gui.actions.ShowDashAction;
import org.eclipse.aperi.rcp.gui.connection.Connection;
import org.eclipse.aperi.rcp.gui.connection.ConnectionManager;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.swt.widgets.Display;

public class GuiMainPanel
extends JPanel
implements IGuiMain,
MouseListener {
    public static final String LAF = GuiMainPanel.setSystemLAF();
    public static Frame frame;
    static boolean DEMO_MODE;
    public static final String VERSION = "5.0.0";
    static final String BUILD = "5.0.0_20060709-200000";
    private static final short ERROR = 12;
    public static String server;
    private static Hashtable computerTable;
    public static GuiMainPanel pGuiMain;
    public static BaseTree pBaseTree;
    protected static String userName;
    public static UserPreferences prefs;
    public static DataDisplayInfo nullDDI;
    private static DashMain dashMain;
    public static DashTotalsRow dashTotalsRow;
    private static final String TITLE;
    private static final String NOT_CONNECTED;
    private static final String TREE;
    private static final String DISCONNECT_TITLE;
    private static final String DISCONNECT_WARNING;
    public static JSplitPane splitPane;
    public static JScrollPane treePane;
    public static JScrollPane dataPane;
    private static JPanel holderPane;
    private static Component glassPane;
    public static Container contentPane;
    public static int curProperAdmin;
    public static BaseTreeNode selectedNode;
    private JLabel treeTitle;
    public static JPanel leftPanel;
    public static String adminGroup;
    private static boolean[] showNoSaveMsg;
    protected static GuiApplet applet;
    public static final Color blueGreen;
    public static final Color dustyRose;
    public static final Color purple;
    public static final Color brightRed;
    public static final Color coral;
    public static final Color dkCoral;
    public static final Color ltPink;
    public static final Color leafGreen;
    public static final Color blueSky;
    public static final Color greySky;
    public static final Color swimPool;
    public static final Color ltYellow;
    public static final Color hotPink;
    public static final Color teal;
    public static final Color sage;
    public static final Color bronze;
    public static final Color ocre;
    public static final Color peaGreen;
    public static final Color moss;
    public static final Color seaweed;
    public static final Color violet;
    public static final Color darkBlue;
    private static Component savedComponentWithFocus;
    public static Capabilities capabilities;
    private EventListenerList saveListenerList = new EventListenerList();
    private EventListenerList saveAsListenerList = new EventListenerList();
    private EventListenerList printListenerList = new EventListenerList();
    private EventListenerList exportListenerList = new EventListenerList();
    private EventListenerList cancelListenerList = new EventListenerList();
    private EventListenerList stopListenerList = new EventListenerList();
    ApplicationActionBarAdvisor actionBarAdvisor = ApplicationWorkbenchWindowAdvisor.getActionBarAdvisor();
    int indentLevel = 0;
    boolean expanded;
    static final String[] indentDots;
    static final String[] indentBlanks;
    private String INDENT_CHARS = "     ";
    String[] indenters;
    public static DataDisplayInfo ddiCurr;
    public static boolean disconnectInProcess;

    static {
        DEMO_MODE = false;
        computerTable = null;
        prefs = new UserPreferences();
        nullDDI = new DataDisplayInfo();
        TITLE = String.valueOf(MessageLog.getMessageNoID((String)"GUI0000T")) + ":  ";
        NOT_CONNECTED = MessageLog.getMessageNoID((String)"GUI0010T");
        TREE = MessageLog.getMessageNoID((String)"GUI0152L");
        DISCONNECT_TITLE = MessageLog.getMessageNoID((String)"GUI0132T");
        DISCONNECT_WARNING = MessageLog.getMessageNoID((String)"GUI0133T");
        curProperAdmin = 5;
        showNoSaveMsg = new boolean[7];
        applet = null;
        blueGreen = new Color(64, 204, 204);
        dustyRose = new Color(204, 102, 102);
        purple = new Color(150, 0, 150);
        brightRed = new Color(255, 0, 0);
        coral = new Color(255, 120, 60);
        dkCoral = new Color(220, 35, 35);
        ltPink = new Color(255, 210, 210);
        leafGreen = new Color(188, 255, 50);
        blueSky = new Color(150, 150, 255);
        greySky = new Color(200, 200, 255);
        swimPool = new Color(200, 255, 255);
        ltYellow = new Color(255, 255, 150);
        hotPink = new Color(255, 140, 255);
        teal = new Color(0, 100, 200);
        sage = new Color(180, 220, 180);
        bronze = new Color(200, 100, 0);
        ocre = new Color(200, 150, 0);
        peaGreen = new Color(200, 220, 0);
        moss = new Color(150, 150, 50);
        seaweed = new Color(100, 100, 0);
        violet = new Color(150, 110, 150);
        darkBlue = new Color(0, 0, 200);
        savedComponentWithFocus = null;
        indentDots = new String[]{"", ".....", "..........", "...............", "....................", ".........................", "..............................", "...................................", "........................................", ".............................................", "..................................................", "......................................................."};
        indentBlanks = new String[]{"", "     ", "          ", "               ", "                    ", "                         ", "                              ", "                                   ", "                                        ", "                                             ", "                                                  ", "                                                       "};
        disconnectInProcess = false;
    }

    public boolean isProperAdmin() {
        boolean bl = false;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null) {
            BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
            bl = GuiMainPanel.isProperAdmin(baseTreeNode);
        }
        return bl;
    }

    private static boolean isProperAdmin(BaseTreeNode baseTreeNode) {
        boolean bl = false;
        if (baseTreeNode != null) {
            TreeNode[] treeNodeArray = baseTreeNode.getPath();
            int n = treeNodeArray.length;
            if (n < 2) {
                return false;
            }
            TreeNode treeNode = treeNodeArray[1];
            if (treeNode instanceof AdminTreeLabel) {
                bl = capabilities.isAperiAdmin();
                curProperAdmin = 5;
            } else if (treeNode instanceof TreeLabel) {
                bl = capabilities.isAnyAdmin();
                curProperAdmin = 4;
            } else if (treeNode instanceof StormTreeLabel) {
                bl = capabilities.isDataAdmin();
                curProperAdmin = 1;
            } else if (treeNode instanceof DiskMgrTreeLabel) {
                bl = capabilities.isDiskAdmin();
                curProperAdmin = 2;
            } else if (treeNode instanceof FabricMgrTreeLabel) {
                bl = capabilities.isFabricAdmin();
                curProperAdmin = 3;
            } else if (treeNode instanceof TapeMgrTreeLabel) {
                bl = capabilities.isTapeAdmin();
                curProperAdmin = 6;
            }
        }
        return bl;
    }

    public GuiMainPanel(Frame frame) {
        GuiManager.getGuiManager().setGuiMain((IGuiMain)this);
        GuiMainPanel.frame = frame;
        pGuiMain = this;
        this.setLayout(new BorderLayout());
        int n = 0;
        while (n < 7) {
            GuiMainPanel.showNoSaveMsg[n] = true;
            ++n;
        }
        GuiUtil.setAccessible((Component)pGuiMain, (String)TITLE, (String)TITLE);
        this.init();
        contentPane = this.buildPanel();
        this.add((Component)contentPane, "Center");
        GuiMainPanel.nullDDI.displayInScrollPane = false;
        nullDDI.setDescription(MessageLog.getMessageNoID((String)"STG5238L"));
        dashMain = new DashMain();
        BaseTree.pBaseTree.newTree();
        this.showNull(false);
        BaseTree.pBaseTree.setSelectionRow(0);
        BaseTree.pBaseTree.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
    }

    private void setSelectedNode() {
        selectedNode = null;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo == null) {
            return;
        }
        BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
        if (baseTreeNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = BaseTree.MyTree.getPathToRoot((TreeNode)baseTreeNode);
        if (treeNodeArray == null || treeNodeArray.length == 0) {
            return;
        }
        if (treeNodeArray[0] == (TreeNode)BaseTree.MyTree.getRoot()) {
            selectedNode = baseTreeNode;
        }
    }

    public void printTree(BaseTreeNode baseTreeNode) {
        PrintOutputChooser printOutputChooser = new PrintOutputChooser();
        printOutputChooser.allowCSV(false);
        printOutputChooser.allowFormatted(false);
        PrintOptions printOptions = printOutputChooser.getOptions(true, true);
        if (printOptions != null) {
            printOptions.creator = GuiUtil.getUserName();
            printOptions.title = MessageLog.getMessageNoID((String)"GEN0194L");
            printOptions.fileMask = TREE;
            if (printOptions.outputType == 2 || printOptions.outputType == 3 || printOptions.outputType == 4 || printOptions.outputType == 5) {
                printOptions.fileName = PrintTableData.getFileName((PrintOptions)printOptions);
                if (printOptions.fileName == null) {
                    return;
                }
            }
            if (printOptions.outputType == 1) {
                BaseTree.setPrintableSubTree((BaseTreeNode)baseTreeNode);
                new PrintPreviewPanel((PrintPreviewable)pBaseTree, false);
                return;
            }
            PrintManager.getPrinter((PrintOptions)printOptions);
            if (printOptions.outFile != null) {
                printOptions.printTitle(printOptions.outFile);
                if (printOptions.outputType == 3) {
                    this.INDENT_CHARS = ".....";
                    OutputStreamWriter outputStreamWriter = null;
                    PrintWriter printWriter = null;
                    try {
                        if (printOptions.outFile != null) {
                            outputStreamWriter = new OutputStreamWriter((OutputStream)printOptions.outFile, "UTF-8");
                        }
                    }
                    catch (Exception exception) {
                        GuiMainPanel.displayErrorMessage(exception.getMessage());
                    }
                    if (printOptions.outFile != null) {
                        printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                    }
                    if (printWriter != null) {
                        printWriter.println("<html>");
                        printWriter.println("<head>");
                        printWriter.print("<title>");
                        if (printOptions.title != null) {
                            printWriter.print(printOptions.title);
                        }
                        printWriter.println("</title>");
                        printWriter.println(" ");
                        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
                        printWriter.println("<style type=\"text/css\">");
                        printWriter.println("   .title   { color: #000066  }");
                        printWriter.println("</style>");
                        printWriter.println(" ");
                        printWriter.println("</head>");
                        printWriter.println("<body>");
                        printWriter.println(" ");
                        printWriter.print("<h2 class=\"title\">");
                        if (printOptions.title != null) {
                            printWriter.print(printOptions.title);
                        }
                        printWriter.println("</h2>");
                        printWriter.println(" ");
                        printWriter.print("<h4 class=\"title\">");
                        printWriter.print(MessageLog.getMessageNoID((String)"GEN0192L"));
                        printWriter.print(" ");
                        printWriter.print(GuiUtil.getUserName());
                        printWriter.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        printWriter.print(MessageLog.getMessageNoID((String)"GEN0193L"));
                        printWriter.print(" ");
                        printWriter.print(Util.formatDateTime((Date)Calendar.getInstance().getTime()));
                        printWriter.println("</h4>");
                        printWriter.println(" ");
                        printWriter.println("<p>");
                        this.printHTMLSubtree(baseTreeNode, printWriter);
                        printWriter.println("</p>");
                        printWriter.println(" ");
                        printWriter.println("</body>");
                        printWriter.println("</html>");
                        printWriter.close();
                    }
                    return;
                }
                this.indenters = indentBlanks;
                this.printSubtree(baseTreeNode);
                PrintManager.printDocument((PrintOptions)printOptions);
            }
        }
    }

    private void printSubtree(BaseTreeNode baseTreeNode) {
        if (baseTreeNode.getAllowsChildren()) {
            this.expanded = pBaseTree.isExpanded(new TreePath(baseTreeNode.getPath()));
        }
        if (baseTreeNode.getAllowsChildren() && this.expanded) {
            ++this.indentLevel;
            baseTreeNode.getChildCount();
            Enumeration enumeration = baseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.printSubtree((BaseTreeNode)enumeration.nextElement());
            }
            --this.indentLevel;
        }
    }

    private String createTreeIndent(BaseTreeNode baseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        int n = baseTreeNode.getLevel();
        while (n > 0) {
            stringBuffer.append(this.INDENT_CHARS);
            --n;
        }
        return stringBuffer.toString();
    }

    private void printHTMLSubtree(BaseTreeNode baseTreeNode, PrintWriter printWriter) {
        boolean bl = false;
        if (baseTreeNode.nodeColor != Color.black) {
            bl = true;
            printWriter.print("<font color=\"#");
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getRed()));
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getGreen()));
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getBlue()));
            printWriter.print("\"/>");
        }
        printWriter.print(this.createTreeIndent(baseTreeNode));
        if (baseTreeNode.getAllowsChildren()) {
            if (pBaseTree.isExpanded(new TreePath(baseTreeNode.getPath()))) {
                printWriter.print("- ");
                this.expanded = true;
            } else {
                printWriter.print("+ ");
                this.expanded = false;
            }
        } else {
            printWriter.print("  ");
        }
        printWriter.print(baseTreeNode.toString());
        if (bl) {
            printWriter.print("</font>");
        }
        printWriter.println("<br>");
        if (baseTreeNode.getAllowsChildren() && this.expanded) {
            baseTreeNode.getChildCount();
            Enumeration enumeration = baseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.printHTMLSubtree((BaseTreeNode)enumeration.nextElement(), printWriter);
            }
        }
    }

    public void endRequestWait() {
        GuiClient.cancelAll();
        pGuiMain.guiEnabled(true);
    }

    private void enableRollover() {
    }

    public void guiEnabled(boolean bl) {
        if (savedComponentWithFocus != null) {
            savedComponentWithFocus.requestFocus();
        } else {
            pBaseTree.requestFocus();
        }
        this.setStopActionEnabled(!bl, false);
        if (bl) {
            pGuiMain.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void setServer(String string) {
        server = string;
    }

    public void showNull() {
        this.showNull(false);
    }

    public void showNull(boolean bl) {
        if (DataDisplayInfo.getCurrent() != null) {
            DataDisplayInfo.getCurrent().loseFocus();
        }
        GuiMainPanel.nullDDI.panel = server == NOT_CONNECTED || dashTotalsRow == null ? About.getAboutPanel() : dashMain.getDashboard(dashTotalsRow, bl);
        this.setView(nullDDI);
        this.setShowDashActionEnabled(false);
    }

    public static void setTheTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(TITLE);
        stringBuffer.append(server);
        stringBuffer.append(" -- ");
        stringBuffer.append(string);
        frame.setTitle(stringBuffer.toString());
    }

    public void setView(DataDisplayInfo dataDisplayInfo) {
        if (dataDisplayInfo != nullDDI) {
            GuiMainPanel.nullDDI.panel = null;
            this.setShowDashActionEnabled(true);
        }
        ddiCurr = dataDisplayInfo;
        int n = splitPane.getDividerLocation();
        if (dataDisplayInfo.displayInScrollPane) {
            splitPane.add((Component)dataPane, "right");
            dataPane.setViewportView(dataDisplayInfo.panel);
        } else {
            holderPane = new JPanel();
            holderPane.setLayout(new BorderLayout());
            holderPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            holderPane.setBounds(193, 1, 406, 798);
            holderPane.add((Component)dataDisplayInfo.panel, "Center");
            splitPane.add((Component)holderPane, "right");
            contentPane.setBackground(Color.white);
        }
        splitPane.setDividerLocation(n);
        pBaseTree.reselect(dataDisplayInfo.treeNode);
        splitPane.requestFocusInWindow();
        this.setPrevNext();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(TITLE);
        stringBuffer.append(server);
        if (dataDisplayInfo != nullDDI) {
            stringBuffer.append(" -- ");
            stringBuffer.append(dataDisplayInfo.getDescription());
        }
        frame.setTitle(stringBuffer.toString());
        this.setCloseAllActionEnabled(DataDisplayInfo.getCurrent() != null);
    }

    public void setPrevNext() {
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        DataDisplayInfo dataDisplayInfo2 = null;
        DataDisplayInfo dataDisplayInfo3 = null;
        if (dataDisplayInfo == null) {
            pGuiMain.setPrintActionEnabled(false, false);
        } else {
            if (dataDisplayInfo.panel == null) {
                pGuiMain.setPrintActionEnabled(false, false);
            }
            dataDisplayInfo3 = dataDisplayInfo.getNext();
            dataDisplayInfo2 = ddiCurr == nullDDI ? dataDisplayInfo : dataDisplayInfo.getPrev();
        }
        pGuiMain.setBackEnabled(dataDisplayInfo2 != null);
        pGuiMain.setNextEnabled(dataDisplayInfo3 != null);
    }

    public boolean disconnectFromServer() {
        disconnectInProcess = true;
        DataDisplayInfo.removeAllWithoutChanges();
        this.removeAllDDIChanged();
        if (DataDisplayInfo.getCurrent() == null) {
            if (server != NOT_CONNECTED) {
                GuiClient.saveUserPrefs();
            }
            computerTable = null;
            GuiMainPanel.setServer(NOT_CONNECTED);
            BaseTree.pBaseTree.setVisible(false);
            GuiClient.serverStatusResp = null;
            this.showNull(false);
            disconnectInProcess = false;
            int n = 0;
            while (n < 7) {
                GuiMainPanel.showNoSaveMsg[n] = true;
                ++n;
            }
            return true;
        }
        DataDisplayInfo.getCurrent().reDisplay();
        return false;
    }

    public void removeAllDDIChanged() {
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null) {
            Object[] objectArray = new String[]{MessageLog.getMessageNoID((String)"GUI0113L"), MessageLog.getMessageNoID((String)"GUI0114L")};
            int n = 0;
            BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
            if (GuiMainPanel.isProperAdmin(baseTreeNode)) {
                n = JOptionPane.showOptionDialog(pGuiMain, DISCONNECT_WARNING, DISCONNECT_TITLE, 0, 2, null, objectArray, objectArray[1]);
            }
            if (n == 0) {
                GuiMainPanel.removeAllDDI();
            }
        }
    }

    private static void removeAllDDI() {
        DataDisplayInfo dataDisplayInfo;
        while ((dataDisplayInfo = DataDisplayInfo.getCurrent()) != null) {
            dataDisplayInfo.remove();
        }
    }

    public static void resetConnection() {
        pGuiMain.init();
        splitPane.repaint();
        pBaseTree.newTree();
        GuiMainPanel.setServer(GuiClient.serverStatusResp.serverName);
        if (dashTotalsRow == null) {
            new DashInitialize();
        }
        pGuiMain.showNull();
    }

    public static void displayErrorMessage(String string) {
        Object object;
        String string2 = string.substring(0, 8);
        String string3 = string.substring(10);
        if (string3.length() > 100) {
            object = new TextArea(string3, 1, 100);
            ((TextArea)object).setEditable(false);
        } else {
            object = string3;
        }
        JOptionPane.showMessageDialog(null, object, string2, 0);
    }

    public static void displayException(GeneralException generalException) {
        GuiMainPanel.displayErrorMessage(generalException.getMessage());
    }

    public void setExportActionEnabled(final boolean bl, final boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.exportDataAction", bl2 ? bl : bl && GuiMainPanel.this.isProperAdmin());
            }
        });
    }

    public void setShowDashActionEnabled(final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled(ShowDashAction.ID, bl);
            }
        });
    }

    public void setCloseAllActionEnabled(final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled(CloseAllAction.ID, bl);
            }
        });
    }

    public void setPrintActionEnabled(boolean bl, boolean bl2) {
    }

    public void setPrintTreeActionEnabled(final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.printTreeAction", bl);
            }
        });
    }

    public void setNextEnabled(final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.forwardaction", bl);
            }
        });
    }

    public void setBackEnabled(final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.backaction", bl);
            }
        });
    }

    public void setSaveAsActionEnabled(final boolean bl, final boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.saveasaction", bl2 ? bl : bl && GuiMainPanel.this.isProperAdmin());
            }
        });
    }

    public void setSaveActionEnabled(final boolean bl, final boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.saveaction", bl2 ? bl : bl && GuiMainPanel.this.isProperAdmin());
            }
        });
    }

    public Frame getFrame() {
        return frame;
    }

    public ActionListener[] getSaveActionListeners() {
        return (ActionListener[])this.saveListenerList.getListeners(ActionListener.class);
    }

    public ActionListener[] getSaveAsActionListeners() {
        return (ActionListener[])this.saveAsListenerList.getListeners(ActionListener.class);
    }

    public void addSaveActionListener(ActionListener actionListener) {
        this.saveListenerList.add(ActionListener.class, actionListener);
    }

    public void addSaveAsActionListener(ActionListener actionListener) {
        this.saveAsListenerList.add(ActionListener.class, actionListener);
    }

    public BaseTree getBaseTree() {
        return pBaseTree;
    }

    public void removeSaveActionListener(ActionListener actionListener) {
        this.saveListenerList.remove(ActionListener.class, actionListener);
    }

    public void removeSaveAsActionListener(ActionListener actionListener) {
        this.saveAsListenerList.remove(ActionListener.class, actionListener);
    }

    public void setSaveActionToolTip(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionToolTipText("org.eclipse.aperi.rcp.gui.actions.saveaction", string);
            }
        });
    }

    public void setSaveAsActionToolTip(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionToolTipText("org.eclipse.aperi.rcp.gui.actions.saveasaction", string);
            }
        });
    }

    public void removeExportActionListener(ActionListener actionListener) {
        this.exportListenerList.remove(ActionListener.class, actionListener);
    }

    public void removePrintActionListener(ActionListener actionListener) {
    }

    public void addExportActionListener(ActionListener actionListener) {
        this.exportListenerList.add(ActionListener.class, actionListener);
    }

    public void setExportActionToolTip(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionToolTipText("org.eclipse.aperi.rcp.gui.actions.exportDataAction", string);
            }
        });
    }

    public void addPrintActionListener(ActionListener actionListener) {
    }

    public void setPrintActionToolTip(String string) {
    }

    public ActionListener[] getExportActionListeners() {
        return (ActionListener[])this.exportListenerList.getListeners(ActionListener.class);
    }

    public void setDashTotalsRow(DashTotalsRow dashTotalsRow) {
        GuiMainPanel.dashTotalsRow = dashTotalsRow;
    }

    public Capabilities getCapabilities() {
        return capabilities;
    }

    private Container buildPanel() {
        contentPane = new JPanel(new BorderLayout(0, 0));
        splitPane = new JSplitPane();
        treePane = new JScrollPane();
        dataPane = new JScrollPane();
        Dimension dimension = this.getToolkit().getScreenSize();
        splitPane.setDividerLocation((int)((double)dimension.width * 0.27));
        contentPane.add("Center", splitPane);
        splitPane.setBounds(0, 0, 0, 0);
        treePane.setOpaque(true);
        leftPanel = new JPanel(new BorderLayout(2, 2));
        this.treeTitle = new JLabel(Util.getString((String)"LABEL_TREE_TITLE"));
        this.treeTitle.setOpaque(false);
        this.treeTitle.setDisplayedMnemonic(GuiUtil.getMnemonic((String)"MNEMONIC_TREE_TITLE"));
        this.treeTitle.setLabelFor((Component)pBaseTree);
        leftPanel.add((Component)this.treeTitle, "North");
        leftPanel.add((Component)treePane, "Center");
        splitPane.add((Component)leftPanel, "left");
        treePane.setBounds(1, 1, 182, 798);
        pBaseTree = new BaseTree();
        pBaseTree.setBackground(Color.white);
        pBaseTree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        treePane.getViewport().add((Component)pBaseTree);
        pBaseTree.setBounds(0, 0, 179, 795);
        splitPane.add((Component)dataPane, "right");
        dataPane.setBounds(193, 1, 406, 798);
        return contentPane;
    }

    private void init() {
        Connection connection = ConnectionManager.getConnectionManager().getCurrentConnection();
        GuiMainPanel.setServer(connection.getServer().getHost());
        SignonResp signonResp = connection.getSignonResp();
        capabilities = new Capabilities(signonResp.userRoles, signonResp.productAvailabilities, signonResp.deviceServerInstalled);
        AlertManager.refresh((NameList)NameList.unpackList((NameList[])signonResp.activeAlerts));
        prefs = signonResp.prefs;
        adminGroup = signonResp.adminGroup;
        GuiUtil.sortOrderNotASCII = signonResp.sortOrderNotASCII;
        dashTotalsRow = signonResp.dashTotalsRow;
        Variables.spaceUnits = GuiMainPanel.prefs.spaceUnits;
        ReportPrefsManager.cacheAll((ReportPrefs)GuiMainPanel.prefs.sm.reportPrefs);
        AlertLogDDI.showLoginAlerts();
        GuiMainPanel.prefs.administrator = capabilities.isAperiAdmin();
        GuiClient.getChartCustomizations((String)GuiUtil.getUserName());
        new Help();
    }

    private static String setSystemLAF() {
        String string = null;
        try {
            string = GuiMainPanel.getSystemLAF();
            UIManager.setLookAndFeel(string);
            return string;
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            JOptionPane.showMessageDialog(null, MessageLog.getMessageNoID((String)"GUI0109M", (Object[])objectArray), MessageLog.getMessageNoID((String)"GUI0110T", null), 2);
            return null;
        }
    }

    public static String getSystemLAF() {
        String string = System.getProperty("os.name", " ");
        String string2 = UIManager.getSystemLookAndFeelClassName();
        if (string.regionMatches(true, 0, "linux", 0, 4)) {
            return "javax.swing.plaf.metal.MetalLookAndFeel";
        }
        return string2;
    }

    public static void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            if (pGuiMain == null) {
                return;
            }
            int n = splitPane.getDividerLocation() + splitPane.getDividerSize() / 2;
            UIManager.setLookAndFeel(string);
            GuiMainPanel.prefs.lookAndFeel = string;
            SwingUtilities.updateComponentTreeUI(pGuiMain);
            splitPane.setDividerLocation(n - splitPane.getDividerSize() / 2);
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
            while (dataDisplayInfo != null) {
                if (dataDisplayInfo.panel != null) {
                    SwingUtilities.updateComponentTreeUI(dataDisplayInfo.panel);
                }
                dataDisplayInfo = dataDisplayInfo.getNext();
            }
            pGuiMain.enableRollover();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            JOptionPane.showMessageDialog(pGuiMain, MessageLog.getMessageNoID((String)"GUI0109M", (Object[])objectArray), MessageLog.getMessageNoID((String)"GUI0110T", null), 2);
        }
    }

    public UserPreferences getUserPrefs() {
        return prefs;
    }

    public DataDisplayInfo getCurrentDDI() {
        return ddiCurr;
    }

    public DataDisplayInfo getNullDDI() {
        return nullDDI;
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.cancelListenerList.add(ActionListener.class, actionListener);
    }

    public void addStopActionListener(ActionListener actionListener) {
        this.stopListenerList.add(ActionListener.class, actionListener);
    }

    public ActionListener[] getCancelActionListeners() {
        return (ActionListener[])this.cancelListenerList.getListeners(ActionListener.class);
    }

    public ActionListener[] getStopActionListeners() {
        return (ActionListener[])this.stopListenerList.getListeners(ActionListener.class);
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        this.cancelListenerList.remove(ActionListener.class, actionListener);
    }

    public void removeStopActionListener(ActionListener actionListener) {
        this.stopListenerList.remove(ActionListener.class, actionListener);
    }

    public void setCancelActionToolTip(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionToolTipText("org.eclipse.aperi.rcp.gui.actions.closeaction", string);
            }
        });
    }

    public void setCancelActionEnabled(final boolean bl, boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.closeaction", bl);
            }
        });
    }

    public void setStopActionToolTip(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionToolTipText("org.eclipse.aperi.rcp.gui.actions.stopaction", string);
            }
        });
    }

    public void setStopActionEnabled(final boolean bl, boolean bl2) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GuiMainPanel.this.actionBarAdvisor.setActionEnabled("org.eclipse.aperi.rcp.gui.actions.stopaction", bl);
            }
        });
    }
}

