/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui.actions;

import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.rcp.gui.GuiMainPanel;
import org.eclipse.aperi.rcp.gui.LoginDialog;
import org.eclipse.aperi.rcp.gui.connection.Connection;
import org.eclipse.aperi.rcp.gui.connection.ConnectionManager;
import org.eclipse.aperi.rcp.gui.connection.ConnectionStatus;
import org.eclipse.aperi.rcp.gui.connection.IConnectionListener;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class LoginAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "org.eclipse.aperi.rcp.gui.actions.login";
    private static final String LABEL_NEW_CONNECTION = MessageLog.getMessageNoID((String)"GUI0012L");
    IWorkbenchWindow window;

    public LoginAction(IWorkbenchWindow iWorkbenchWindow) {
        this.setId(ID);
        this.setText("&" + LABEL_NEW_CONNECTION);
        this.setToolTipText("Login to a server");
        this.window = iWorkbenchWindow;
    }

    public void run() {
        final IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        LoginDialog loginDialog = new LoginDialog(null);
        boolean bl = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                iGuiMain.disconnectFromServer();
            }
        });
        while (!bl) {
            if (loginDialog.open() != 0) {
                return;
            }
            Connection connection = loginDialog.getConnection();
            ConnectionManager.getConnectionManager().signon(connection);
            ConnectionManager.getConnectionManager().addConnectionListener(new IConnectionListener(){

                public void connectionChanged(Connection connection) {
                    ConnectionManager.getConnectionManager().getServerServices();
                }
            });
            bl = connection.getStatus().equals(ConnectionStatus.CONNECTED);
            if (bl) {
                ConnectionManager.getConnectionManager().setCurrentConnection(connection);
                GuiMainPanel.resetConnection();
                continue;
            }
            MessageDialog.openError(null, (String)"Connection Error", (String)connection.getErrorMessage());
        }
    }

    public void dispose() {
    }
}

