/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResHbaTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNode2hbaTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;

public class AffectedHostAnalyzer {
    public static List getAffectedHostsForSVCNode(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForSVCNode", (Object[])new Object[]{string});
        List list = AffectedHostAnalyzer.getAffectedHostsForStorageSystem(EventDBAccessor.getSubsystemIDForSVCNodeID(string));
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForStorageSystem(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForStorageSystem", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "SUBSYSTEM_ID" + " = " + string + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForBackendController(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForBackendController", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "SUBSYSTEM_ID" + " IN " + "(select " + "OWNING_SUBSYSTEM_ID" + " from " + TResBackendControllerTable.getTablename() + " where " + "BACKEND_CONTROLLER_ID" + " = " + string + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForNode(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForNode", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " = " + string + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForPort(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForPort", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " = " + string + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForPool(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForPool", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "SVID" + " from " + TResStorageVolumeTable.getTablename() + " where " + "POOL_ID" + " = " + string + ")" + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForExtent(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForExtent", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " = " + string + ")" + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForVolume(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForVolume", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " = " + string + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForDiskDrive(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDiskDrive", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " IN " + "(select " + "STORAGE_EXTENT_ID" + " from " + TResPhysicalvolume2extentTable.getTablename() + " where " + "PHYSICAL_VOLUME_ID" + " = " + string + ")" + ")" + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForDiskGroup(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDiskGroup", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "VOLUME_ID" + " IN " + "(select " + "VOLUME_ID" + " from " + TResVolume2extentTable.getTablename() + " where " + "STORAGE_EXTENT_ID" + " IN " + "(select " + "STORAGE_EXTENT_ID" + " from " + TResPhysicalvolume2extentTable.getTablename() + " where " + "PHYSICAL_VOLUME_ID" + " IN " + "(select " + "PHYSICAL_VOLUME_ID" + " from " + TResPhysicalVolumeTable.getTablename() + " where " + "DISK_GROUP_ID" + " = " + string + ")" + ")" + ")" + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getAffectedHostsForDataPath(String string) {
        List list;
        LogTraceHelper logTraceHelper;
        block5: {
            Vector vector;
            block4: {
                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDataPath", (Object[])new Object[]{string});
                list = null;
                try {
                    if (string == null) {
                        vector = new Vector();
                        Object var4_4 = null;
                        break block4;
                    }
                    String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + " IN " + "(select " + "INITIATOR_PORT_ID" + " from " + TResDataPathTable.getTablename() + " where " + "DATA_PATH_ID" + " = " + string + ")" + ")" + ")";
                    list = AffectedHostAnalyzer.getNegativeHostIDsWithComplexQuery(string2);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    logTraceHelper.exit(list);
                    throw throwable;
                }
            }
            logTraceHelper.exit(list);
            return vector;
        }
        Object var4_6 = null;
        logTraceHelper.exit((Object)list);
        return list;
    }

    public static List getAffectedHostsForDataPathWithPortId(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getAffectedHostsForDataPath", (Object[])new Object[]{string});
        if (string == null) {
            return new Vector();
        }
        String string2 = "select HOST_ID from " + TResHbaTable.getTablename() + " where " + "HBA_ID" + " IN " + "(select " + "HBA_ID" + " from " + TResNode2hbaTable.getTablename() + " where " + "NODE_ID" + " IN " + "(select " + "NODE_ID" + " from " + TResPortTable.getTablename() + " where " + "PORT_ID" + "=" + string + ")" + ")";
        List list = AffectedHostAnalyzer.getNegativeHostIDsWithComplexQuery(string2);
        logTraceHelper.exit((Object)list);
        return list;
    }

    private static List getHostIDsWithComplexQuery(String string) {
        return AffectedHostAnalyzer.getHostIDsWithComplexQuery(string, false);
    }

    private static List getNegativeHostIDsWithComplexQuery(String string) {
        return AffectedHostAnalyzer.getHostIDsWithComplexQuery(string, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getHostIDsWithComplexQuery(String var0, boolean var1_1) {
        block16: {
            var2_2 = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getHostIDsWithComplexQuery", (Object[])new Object[]{var0});
            new Vector<E>();
            var3_3 = null;
            var4_4 = null;
            var5_5 = new Vector<Integer>();
            try {
                try {
                    var3_3 = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                    var2_2.traceHigh(var0);
                    var4_4 = ComplexQuery.sqlQuery((DBConnection)var3_3, (String)var0, new Hashtable<K, V>());
                    if (var4_4 == null) {
                        var2_2.traceError("The result set was empty when retrieving host IDs from database", null);
                    } else {
                        while (var4_4.next()) {
                            if (var1_1) {
                                var6_6 = var4_4.getInt(1);
                                var5_5.add(new Integer(-var6_6));
                                continue;
                            }
                            var5_5.add(new Integer(var4_4.getInt(1)));
                        }
                    }
                }
                catch (SQLException var6_7) {
                    var2_2.traceError("Failed to retrieve host IDs from database", (Throwable)var6_7);
                }
            }
            catch (Throwable var8_8) {
                var7_9 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.commit();
                        if (var4_4 != null) {
                            var4_4.closeAll();
                        }
                        var3_3.close();
                    }
                    catch (SQLException var9_11) {
                        var2_2.traceError("Failed to commit or close a database connection or result set", (Throwable)var9_11);
                    }
                }
                var2_2.exit(var5_5);
                throw var8_8;
            }
            {
                var7_10 = null;
                if (var3_3 == null) break block16;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 173->194)] { 
lbl46:
            // 1 sources

            var3_3.commit();
            if (var4_4 != null) {
                var4_4.closeAll();
            }
            var3_3.close();
            break block16;
lbl51:
            // 1 sources

            catch (SQLException var9_12) {
                var2_2.traceError("Failed to commit or close a database connection or result set", (Throwable)var9_12);
            }
        }
        var2_2.exit(var5_5);
        return var5_5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForStorageSystem(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block9: {
            HashMap<String, List> hashMap2;
            block8: {
                HashMap<String, List> hashMap3;
                block7: {
                    HashMap<String, List> hashMap4;
                    block6: {
                        logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForStorageSystem", (Object[])new Object[]{string});
                        hashMap = new HashMap<String, List>();
                        Vector<String> vector = new Vector<String>();
                        try {
                            vector.add(string);
                            hashMap.put("SUBSYSTEM_ID", vector);
                            if (string == null) {
                                hashMap.put("HOST_ID", new Vector());
                                hashMap4 = hashMap;
                                Object var7_7 = null;
                                break block6;
                            }
                            List list = AffectedHostAnalyzer.getNodeIDsFromTResPortForSubsystemIDs(vector);
                            hashMap.put("NODE_ID", list);
                            if (list.size() == 0) {
                                hashMap3 = hashMap;
                                break block7;
                            }
                            List list2 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list);
                            hashMap.put("HBA_ID", list2);
                            if (list2.size() == 0) {
                                hashMap2 = hashMap;
                                break block8;
                            }
                            List list3 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list2);
                            hashMap.put("HOST_ID", list3);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            logTraceHelper.exit(hashMap);
                            throw throwable;
                        }
                    }
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var7_8 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var7_9 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var7_11 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForNode(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block7: {
            HashMap<String, List> hashMap2;
            block6: {
                HashMap<String, List> hashMap3;
                block5: {
                    logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForNode", (Object[])new Object[]{string});
                    hashMap = new HashMap<String, List>();
                    Vector<String> vector = new Vector<String>();
                    try {
                        vector.add(string);
                        hashMap.put("NODE_ID", vector);
                        if (string == null) {
                            hashMap.put("HOST_ID", new Vector());
                            hashMap3 = hashMap;
                            Object var6_6 = null;
                            break block5;
                        }
                        List list = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(vector);
                        hashMap.put("HBA_ID", list);
                        if (list.size() == 0) {
                            hashMap2 = hashMap;
                            break block6;
                        }
                        List list2 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list);
                        hashMap.put("HOST_ID", list2);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        logTraceHelper.exit(hashMap);
                        throw throwable;
                    }
                }
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var6_7 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var6_9 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForPort(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block9: {
            HashMap<String, List> hashMap2;
            block8: {
                HashMap<String, List> hashMap3;
                block7: {
                    HashMap<String, List> hashMap4;
                    block6: {
                        logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForPort", (Object[])new Object[]{string});
                        hashMap = new HashMap<String, List>();
                        Vector<String> vector = new Vector<String>();
                        try {
                            vector.add(string);
                            hashMap.put("PORT_ID", vector);
                            if (string == null) {
                                hashMap.put("HOST_ID", new Vector());
                                hashMap4 = hashMap;
                                Object var7_7 = null;
                                break block6;
                            }
                            List list = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(vector);
                            hashMap.put("NODE_ID", list);
                            if (list.size() == 0) {
                                hashMap3 = hashMap;
                                break block7;
                            }
                            List list2 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list);
                            hashMap.put("HBA_ID", list2);
                            if (list2.size() == 0) {
                                hashMap2 = hashMap;
                                break block8;
                            }
                            List list3 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list2);
                            hashMap.put("HOST_ID", list3);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            logTraceHelper.exit(hashMap);
                            throw throwable;
                        }
                    }
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var7_8 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var7_9 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var7_11 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForPool(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block13: {
            HashMap<String, List> hashMap2;
            block12: {
                HashMap<String, List> hashMap3;
                block11: {
                    HashMap<String, List> hashMap4;
                    block10: {
                        HashMap<String, List> hashMap5;
                        block9: {
                            HashMap<String, List> hashMap6;
                            block8: {
                                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForPool", (Object[])new Object[]{string});
                                hashMap = new HashMap<String, List>();
                                Vector<String> vector = new Vector<String>();
                                try {
                                    vector.add(string);
                                    hashMap.put("POOL_ID", vector);
                                    if (string == null) {
                                        hashMap.put("HOST_ID", new Vector());
                                        hashMap6 = hashMap;
                                        Object var9_9 = null;
                                        break block8;
                                    }
                                    List list = AffectedHostAnalyzer.getSVIDsFromTResStoragevolumeForPoolIDs(vector);
                                    hashMap.put("SVID", list);
                                    if (list.size() == 0) {
                                        hashMap5 = hashMap;
                                        break block9;
                                    }
                                    List list2 = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(list);
                                    hashMap.put("INITIATOR_PORT_ID", list2);
                                    if (list2.size() == 0) {
                                        hashMap4 = hashMap;
                                        break block10;
                                    }
                                    List list3 = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(list2);
                                    hashMap.put("NODE_ID", list3);
                                    if (list3.size() == 0) {
                                        hashMap3 = hashMap;
                                        break block11;
                                    }
                                    List list4 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list3);
                                    hashMap.put("HBA_ID", list4);
                                    if (list4.size() == 0) {
                                        hashMap2 = hashMap;
                                        break block12;
                                    }
                                    List list5 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list4);
                                    hashMap.put("HOST_ID", list5);
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    logTraceHelper.exit(hashMap);
                                    throw throwable;
                                }
                            }
                            logTraceHelper.exit(hashMap);
                            return hashMap6;
                        }
                        Object var9_10 = null;
                        logTraceHelper.exit(hashMap);
                        return hashMap5;
                    }
                    Object var9_11 = null;
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var9_12 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var9_13 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var9_15 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForExtent(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block13: {
            HashMap<String, List> hashMap2;
            block12: {
                HashMap<String, List> hashMap3;
                block11: {
                    HashMap<String, List> hashMap4;
                    block10: {
                        HashMap<String, List> hashMap5;
                        block9: {
                            HashMap<String, List> hashMap6;
                            block8: {
                                logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForExtent", (Object[])new Object[]{string});
                                hashMap = new HashMap<String, List>();
                                Vector<String> vector = new Vector<String>();
                                try {
                                    vector.add(string);
                                    hashMap.put("STORAGE_EXTENT_ID", vector);
                                    if (string == null) {
                                        hashMap.put("HOST_ID", new Vector());
                                        hashMap6 = hashMap;
                                        Object var9_9 = null;
                                        break block8;
                                    }
                                    List list = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(vector);
                                    hashMap.put("VOLUME_ID", list);
                                    if (list.size() == 0) {
                                        hashMap5 = hashMap;
                                        break block9;
                                    }
                                    List list2 = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(list);
                                    hashMap.put("INITIATOR_PORT_ID", list2);
                                    if (list2.size() == 0) {
                                        hashMap4 = hashMap;
                                        break block10;
                                    }
                                    List list3 = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(list2);
                                    hashMap.put("NODE_ID", list3);
                                    if (list3.size() == 0) {
                                        hashMap3 = hashMap;
                                        break block11;
                                    }
                                    List list4 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list3);
                                    hashMap.put("HBA_ID", list4);
                                    if (list4.size() == 0) {
                                        hashMap2 = hashMap;
                                        break block12;
                                    }
                                    List list5 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list4);
                                    hashMap.put("HOST_ID", list5);
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    logTraceHelper.exit(hashMap);
                                    throw throwable;
                                }
                            }
                            logTraceHelper.exit(hashMap);
                            return hashMap6;
                        }
                        Object var9_10 = null;
                        logTraceHelper.exit(hashMap);
                        return hashMap5;
                    }
                    Object var9_11 = null;
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var9_12 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var9_13 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var9_15 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForVolume(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block11: {
            HashMap<String, List> hashMap2;
            block10: {
                HashMap<String, List> hashMap3;
                block9: {
                    HashMap<String, List> hashMap4;
                    block8: {
                        HashMap<String, List> hashMap5;
                        block7: {
                            logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForVolume", (Object[])new Object[]{string});
                            hashMap = new HashMap<String, List>();
                            Vector<String> vector = new Vector<String>();
                            try {
                                vector.add(string);
                                hashMap.put("VOLUME_ID", vector);
                                if (string == null) {
                                    hashMap.put("HOST_ID", vector);
                                    hashMap5 = hashMap;
                                    Object var8_8 = null;
                                    break block7;
                                }
                                List list = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(vector);
                                hashMap.put("INITIATOR_PORT_ID", list);
                                if (list.size() == 0) {
                                    hashMap4 = hashMap;
                                    break block8;
                                }
                                List list2 = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(list);
                                hashMap.put("NODE_ID", list2);
                                if (list2.size() == 0) {
                                    hashMap3 = hashMap;
                                    break block9;
                                }
                                List list3 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list2);
                                hashMap.put("HBA_ID", list3);
                                if (list3.size() == 0) {
                                    hashMap2 = hashMap;
                                    break block10;
                                }
                                List list4 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list3);
                                hashMap.put("HOST_ID", list4);
                                break block11;
                            }
                            catch (Throwable throwable) {
                                Object var8_12 = null;
                                logTraceHelper.exit(hashMap);
                                throw throwable;
                            }
                        }
                        logTraceHelper.exit(hashMap);
                        return hashMap5;
                    }
                    Object var8_9 = null;
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var8_10 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var8_11 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var8_13 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForDiskDrive(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block15: {
            HashMap<String, List> hashMap2;
            block14: {
                HashMap<String, List> hashMap3;
                block13: {
                    HashMap<String, List> hashMap4;
                    block12: {
                        HashMap<String, List> hashMap5;
                        block11: {
                            HashMap<String, List> hashMap6;
                            block10: {
                                HashMap<String, List> hashMap7;
                                block9: {
                                    logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForDiskDrive", (Object[])new Object[]{string});
                                    hashMap = new HashMap<String, List>();
                                    Vector<String> vector = new Vector<String>();
                                    try {
                                        vector.add(string);
                                        hashMap.put("PHYSICAL_VOLUME_ID", vector);
                                        if (string == null) {
                                            hashMap.put("HOST_ID", new Vector());
                                            hashMap7 = hashMap;
                                            Object var10_10 = null;
                                            break block9;
                                        }
                                        List list = AffectedHostAnalyzer.getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(vector);
                                        hashMap.put("STORAGE_EXTENT_ID", list);
                                        if (list.size() == 0) {
                                            hashMap6 = hashMap;
                                            break block10;
                                        }
                                        List list2 = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(list);
                                        hashMap.put("VOLUME_ID", list2);
                                        if (list2.size() == 0) {
                                            hashMap5 = hashMap;
                                            break block11;
                                        }
                                        List list3 = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(list2);
                                        hashMap.put("INITIATOR_PORT_ID", list3);
                                        if (list3.size() == 0) {
                                            hashMap4 = hashMap;
                                            break block12;
                                        }
                                        List list4 = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(list3);
                                        hashMap.put("NODE_ID", list4);
                                        if (list4.size() == 0) {
                                            hashMap3 = hashMap;
                                            break block13;
                                        }
                                        List list5 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list4);
                                        hashMap.put("HBA_ID", list5);
                                        if (list5.size() == 0) {
                                            hashMap2 = hashMap;
                                            break block14;
                                        }
                                        List list6 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list5);
                                        hashMap.put("HOST_ID", list6);
                                        break block15;
                                    }
                                    catch (Throwable throwable) {
                                        Object var10_16 = null;
                                        logTraceHelper.exit(hashMap);
                                        throw throwable;
                                    }
                                }
                                logTraceHelper.exit(hashMap);
                                return hashMap7;
                            }
                            Object var10_11 = null;
                            logTraceHelper.exit(hashMap);
                            return hashMap6;
                        }
                        Object var10_12 = null;
                        logTraceHelper.exit(hashMap);
                        return hashMap5;
                    }
                    Object var10_13 = null;
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var10_14 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var10_15 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var10_17 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap analyzeAffectedHostsForDiskGroup(String string) {
        HashMap<String, List> hashMap;
        LogTraceHelper logTraceHelper;
        block17: {
            HashMap<String, List> hashMap2;
            block16: {
                HashMap<String, List> hashMap3;
                block15: {
                    HashMap<String, List> hashMap4;
                    block14: {
                        HashMap<String, List> hashMap5;
                        block13: {
                            HashMap<String, List> hashMap6;
                            block12: {
                                HashMap<String, List> hashMap7;
                                block11: {
                                    HashMap<String, List> hashMap8;
                                    block10: {
                                        logTraceHelper = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"analyzeAffectedHostsForDiskGroup", (Object[])new Object[]{string});
                                        hashMap = new HashMap<String, List>();
                                        Vector<String> vector = new Vector<String>();
                                        try {
                                            vector.add(string);
                                            hashMap.put("DISK_GROUP_ID", vector);
                                            if (string == null) {
                                                hashMap.put("HOST_ID", new Vector());
                                                hashMap8 = hashMap;
                                                Object var11_11 = null;
                                                break block10;
                                            }
                                            List list = AffectedHostAnalyzer.getPhysicalVolumeIDsFromTResPhysicalvolumeForDiskGroupIDs(vector);
                                            hashMap.put("PHYSICAL_VOLUME_ID", list);
                                            if (list.size() == 0) {
                                                hashMap7 = hashMap;
                                                break block11;
                                            }
                                            List list2 = AffectedHostAnalyzer.getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(list);
                                            hashMap.put("STORAGE_EXTENT_ID", list2);
                                            if (list2.size() == 0) {
                                                hashMap6 = hashMap;
                                                break block12;
                                            }
                                            List list3 = AffectedHostAnalyzer.getVolumeIDsFromTResVolume2extentForStorageExtentIDs(list2);
                                            hashMap.put("VOLUME_ID", list3);
                                            if (list3.size() == 0) {
                                                hashMap5 = hashMap;
                                                break block13;
                                            }
                                            List list4 = AffectedHostAnalyzer.getInitiatorPortIDsFromTResDatapathForVolumeIDs(list3);
                                            hashMap.put("INITIATOR_PORT_ID", list4);
                                            if (list4.size() == 0) {
                                                hashMap4 = hashMap;
                                                break block14;
                                            }
                                            List list5 = AffectedHostAnalyzer.getNodeIDsFromTResPortForPortIDs(list4);
                                            hashMap.put("NODE_ID", list5);
                                            if (list5.size() == 0) {
                                                hashMap3 = hashMap;
                                                break block15;
                                            }
                                            List list6 = AffectedHostAnalyzer.getHbaIDsFromTResNode2hbaForNodeIDs(list5);
                                            hashMap.put("HBA_ID", list6);
                                            if (list6.size() == 0) {
                                                hashMap2 = hashMap;
                                                break block16;
                                            }
                                            List list7 = AffectedHostAnalyzer.getHostIDsFromTResHbaForHbaWWNs(list6);
                                            hashMap.put("HOST_ID", list7);
                                            break block17;
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_18 = null;
                                            logTraceHelper.exit(hashMap);
                                            throw throwable;
                                        }
                                    }
                                    logTraceHelper.exit(hashMap);
                                    return hashMap8;
                                }
                                Object var11_12 = null;
                                logTraceHelper.exit(hashMap);
                                return hashMap7;
                            }
                            Object var11_13 = null;
                            logTraceHelper.exit(hashMap);
                            return hashMap6;
                        }
                        Object var11_14 = null;
                        logTraceHelper.exit(hashMap);
                        return hashMap5;
                    }
                    Object var11_15 = null;
                    logTraceHelper.exit(hashMap);
                    return hashMap4;
                }
                Object var11_16 = null;
                logTraceHelper.exit(hashMap);
                return hashMap3;
            }
            Object var11_17 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        Object var11_19 = null;
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getIDsFromTableForOtherIDs(String var0, String var1_1, String var2_2, boolean var3_3, List var4_4) {
        block17: {
            var5_5 = LogTraceHelper.entry((Object)"AffectedHostAnalyzer", (String)"getIDsFromTableForOtherIDs", (Object[])new Object[]{var0, var1_1, var2_2, new Boolean(var3_3), var4_4});
            var6_6 = null;
            var7_7 = null;
            var8_8 = new Vector<String>();
            try {
                try {
                    var9_9 = "select " + var1_1 + " from " + var0 + " where " + var2_2 + " in (";
                    var10_11 = 0;
                    while (true) {
                        block18: {
                            if (var10_11 < var4_4.size()) break block18;
                            var9_9 = String.valueOf(var9_9) + ")";
                            var6_6 = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                            var5_5.traceHigh(var9_9);
                            var7_7 = ComplexQuery.sqlQuery((DBConnection)var6_6, (String)var9_9, new Hashtable<K, V>());
                            if (var7_7 != null) break;
                            var5_5.traceError("result set was null", null);
                            ** GOTO lbl-1000
                        }
                        var11_12 = (String)var4_4.get(var10_11);
                        if (var3_3) {
                            var9_9 = String.valueOf(var9_9) + "'";
                        }
                        var9_9 = String.valueOf(var9_9) + var11_12;
                        if (var3_3) {
                            var9_9 = String.valueOf(var9_9) + "'";
                        }
                        if (var10_11 < var4_4.size() - 1) {
                            var9_9 = String.valueOf(var9_9) + ",";
                        }
                        ++var10_11;
                    }
                    while (var7_7.next()) {
                        var8_8.add(var7_7.getString(1));
                    }
                }
                catch (SQLException var9_10) {
                    var5_5.traceError("Failed to get a database connection", (Throwable)var9_10);
                }
            }
            catch (Throwable var13_13) {
                var12_14 = null;
                if (var6_6 != null) {
                    try {
                        var6_6.commit();
                        if (var7_7 != null) {
                            var7_7.closeAll();
                        }
                        var6_6.close();
                    }
                    catch (SQLException var14_16) {
                        var5_5.traceError("Failed to get a database connection", (Throwable)var14_16);
                    }
                }
                var5_5.exit(var8_8);
                throw var13_13;
            }
lbl-1000:
            // 3 sources

            {
                var12_15 = null;
                if (var6_6 == null) break block17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 377->400)] { 
lbl55:
            // 1 sources

            var6_6.commit();
            if (var7_7 != null) {
                var7_7.closeAll();
            }
            var6_6.close();
            break block17;
lbl60:
            // 1 sources

            catch (SQLException var14_17) {
                var5_5.traceError("Failed to get a database connection", (Throwable)var14_17);
            }
        }
        var5_5.exit(var8_8);
        return var8_8;
    }

    private static List getHbaIDsFromTResNode2hbaForNodeIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResNode2hbaTable.getTablename(), "HBA_ID", "NODE_ID", false, list);
    }

    private static List getNodeIDsFromTResPortForSubsystemIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPortTable.getTablename(), "SUBSYSTEM_ID", "NODE_ID", false, list);
    }

    private static List getHostIDsFromTResHbaForHbaWWNs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResHbaTable.getTablename(), "HOST_ID", "HBA_WWN", true, list);
    }

    private static List getNodeIDsFromTResPortForPortIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPortTable.getTablename(), "NODE_ID", "PORT_ID", false, list);
    }

    private static List getSVIDsFromTResStoragevolumeForPoolIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResStorageVolumeTable.getTablename(), "SVID", "POOL_ID", false, list);
    }

    private static List getInitiatorPortIDsFromTResDatapathForVolumeIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResDataPathTable.getTablename(), "INITIATOR_PORT_ID", "VOLUME_ID", false, list);
    }

    private static List getVolumeIDsFromTResVolume2extentForStorageExtentIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResVolume2extentTable.getTablename(), "VOLUME_ID", "STORAGE_EXTENT_ID", false, list);
    }

    private static List getStorageExtentIDsFromTResPhysicalvolume2extentTableForPhysicalVolumeIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPhysicalvolume2extentTable.getTablename(), "STORAGE_EXTENT_ID", "PHYSICAL_VOLUME_ID", false, list);
    }

    private static List getPhysicalVolumeIDsFromTResPhysicalvolumeForDiskGroupIDs(List list) {
        return AffectedHostAnalyzer.getIDsFromTableForOtherIDs(TResPhysicalVolumeTable.getTablename(), "PHYSICAL_VOLUME_ID", "DISK_GROUP_ID", false, list);
    }

    public static List getAffectedHostsForBackgroundController(String string) {
        return null;
    }
}

