/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.impl.TESTopicImpl;
import org.eclipse.aperi.snmp.SnmpTrap;

public class SANEvent
extends TESTopicImpl
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    public static final String className;
    public String tecEventClass;
    public Hashtable tecAttributes;
    public String tecHostName;
    public String tecMessage;
    public String tecMessageId;
    public String tecSeverity;
    public String tecComponent;
    public String tecFunction;
    public String tecIPAddress;
    private long creationTime;
    public SnmpTrap sanTrap;
    public static final String EVENT_CLASS = "eventClass";
    public static final String HOSTNAME = "hostname";
    public static final String ORIGIN = "origin";
    public static final String SOURCE = "source";
    public static final String SUB_SOURCE = "sub_source";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageId";
    public static final String SEVERITY = "severity";
    public static final String UNIQUE_ID = "uniqueId";
    public static final String ENTITY_TYPE = "entityType";
    public static final String LABEL = "label";
    public static final String TYPE = "type";
    public static final String HLD = "highLevelDevice";
    public static final String STATE = "state";
    public static final String EVENT_TYPE = "eventType";
    public static final String FROM_OBJ_UID = "fromObjectUniqueId";
    public static final String FROM_OBJ_HLD_UID = "fromObjectHLDUniqueId";
    public static final String FROM_OBJ_TYPE = "fromObjectType";
    public static final String FROM_OBJ_LABEL = "fromObjectLabel";
    public static final String FROM_OBJ_HLD_TYPE = "fromObjectHLDType";
    public static final String FROM_OBJ_HLD_LABEL = "fromObjectHLDLabel";
    public static final String FROM_HLD = "fromHighLevelDevice";
    public static final String TO_OBJ_UID = "toObjectUniqueId";
    public static final String TO_OBJ_HLD_UID = "toObjectHLDUniqueId";
    public static final String TO_OBJ_TYPE = "toObjectType";
    public static final String TO_OBJ_LABEL = "toObjectLabel";
    public static final String TO_OBJ_HLD_TYPE = "toObjectHLDType";
    public static final String TO_OBJ_HLD_LABEL = "toObjectHLDLabel";
    public static final String TO_HLD = "toHighLevelDevice";
    public static final String ACTION_PERFORMED = "actionPerformed";
    public static final String SAN_NAME = "SANName";
    public static final String ZONE_NAME = "zoneName";
    public static final String ACTIVE = "Active";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_STATE = "serviceState";
    public static final String PHYSICAL_ENTITY_EVENT = "PhysicalEntityEvent";
    public static final String PHYSICAL_RELATIONSHIP_EVENT = "PhysicalRelationshipEvent";
    public static final String LOGICAL_ENTITY_EVENT = "LogicalEntityEvent";
    public static final String LOGICAL_RELATIONSHIP_EVENT = "LogicalRelationshipEvent";
    public static final String SAN_MANAGER_STATUS_EVENT = "SANManagerStatusEvent";
    public static final String SAN_REGION_EVENT = "SANRegionEvent";
    public static final String SERVICE_EVENT = "ServiceEvent";
    public static final String HLD_LABEL = "highLevelDeviceLabel";
    public static final String HLD_TYPE = "highLevelDeviceType";
    public static final String FROM_HLD_LABEL = "fromHighLevelDeviceLabel";
    public static final String FROM_HLD_TYPE = "fromHighLevelDeviceType";
    public static final String TO_HLD_LABEL = "toHighLevelDeviceLabel";
    public static final String TO_HLD_TYPE = "toHighLevelDeviceType";
    public static final String PORT_PHY_NUM = "portPhysicalNumber";
    public static final String FROM_PORT_PHY_NUM = "fromPortPhysicalNumber";
    public static final String TO_PORT_PHY_NUM = "toPortPhysicalNumber";
    public static final String ZONE_SET_NAME = "zoneSetName";
    public static final String ZONE_ALIAS_NAME = "zoneAliasName";
    public static final String ZONE_MEMBER_ID = "zoneMemberID";
    public static final String ZONE_MEMBER_TYPE = "zoneMemberType";
    public static final String ZONE_MEMBER_VENDORTYPE = "zoneMemberVendorType";
    public static final String FROM_STATE = "fromState";
    public static final String TO_STATE = "toState";
    public static final String FATAL = "FATAL";
    public static final String CRITICAL = "CRITICAL";
    public static final String WARNING = "WARNING";
    public static final String HARMLESS = "HARMLESS";
    public static final String MINOR = "MINOR";
    public static final String UNKNOWN = "UNKNOWN";
    public String serializedTEC;
    public String tecSpecial;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.data.SANEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SANEvent() {
        block6: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.tecEventClass = SERVICE_EVENT;
            this.tecAttributes = null;
            this.tecHostName = null;
            this.tecMessage = null;
            this.tecMessageId = null;
            this.tecSeverity = HARMLESS;
            this.tecComponent = null;
            this.tecFunction = null;
            this.tecIPAddress = null;
            this.creationTime = 0L;
            this.sanTrap = null;
            this.serializedTEC = null;
            this.tecSpecial = "'";
            this.creationTime = System.currentTimeMillis();
            this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEvent");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                String string2 = InetAddress.getByName(string).getHostName();
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "SANEvent", "The TEC host name is " + string2 + " and the IP address is " + string + ".");
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEvent", (Throwable)unknownHostException);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEvent", (Throwable)unknownHostException);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEvent");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getHostName() {
        return this.tecHostName;
    }

    public SnmpTrap getsanTrap() {
        return this.sanTrap;
    }

    public void setHostName(String string) {
        this.tecHostName = string;
    }

    public void setsanTrap(SnmpTrap snmpTrap) {
        this.sanTrap = snmpTrap;
    }

    public void setTECAttributes(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Hashtable hashtable) throws IllegalArgumentException {
        block4: {
            try {
                this.tecEventClass = string;
                this.tecHostName = string2;
                this.tecIPAddress = string3;
                this.tecComponent = string4;
                this.tecFunction = string5;
                this.tecMessageId = string6;
                this.tecMessage = string7;
                this.tecSeverity = string8;
                this.tecAttributes = new Hashtable();
                if (hashtable != null) {
                    this.tecAttributes.putAll(hashtable);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)nullPointerException);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)nullPointerException);
            }
        }
        this.serializedTEC = this.createTECEvent();
    }

    public String toString() {
        return "SANEvent (" + new Date(this.creationTime) + "): " + className;
    }

    private void logEvent(SANEvent sANEvent) throws IOException, JMSException {
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)sANEvent);
    }

    private String createTECEvent() throws IllegalArgumentException {
        Object object;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            object = "tecMessage = " + this.tecMessage + ";\n" + "tecMessageId = " + this.tecMessageId + ";\n" + "tecComponent = " + this.tecComponent + ";\n" + "tecFunction = " + this.tecFunction + ";\n" + "tecHostName = " + this.tecHostName + ";\n" + "tecIPAddress = " + this.tecIPAddress + ";\n" + "tecSeverity = " + this.tecSeverity + ".\n";
            String string = "Creating a TEC Event with the following data:\n" + (String)object;
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "createTECEvent");
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createTECEvent", string);
        }
        if (this.tecEventClass.equals(PHYSICAL_ENTITY_EVENT)) {
            block30: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    object.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    object.setSlot(LABEL, this.verifyValue(LABEL, (String)this.tecAttributes.get(HLD_LABEL)));
                    object.setSlot(TYPE, this.verifyValue(TYPE, (String)this.tecAttributes.get(TYPE)));
                    object.setSlot(HLD, this.verifyValue(HLD, (String)this.tecAttributes.get(HLD)));
                    object.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    object.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block30;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(PHYSICAL_RELATIONSHIP_EVENT)) {
            block31: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    object.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    object.setSlot(TO_OBJ_UID, this.verifyValue(TO_OBJ_HLD_UID, (String)this.tecAttributes.get(TO_OBJ_HLD_UID)));
                    object.setSlot(TO_OBJ_LABEL, this.verifyValue(TO_OBJ_HLD_LABEL, (String)this.tecAttributes.get(TO_OBJ_HLD_LABEL)));
                    object.setSlot(TO_OBJ_TYPE, this.verifyValue(TO_OBJ_HLD_TYPE, (String)this.tecAttributes.get(TO_OBJ_HLD_TYPE)));
                    object.setSlot(TO_HLD, this.verifyValue(TO_HLD, (String)this.tecAttributes.get(TO_HLD)));
                    object.setSlot(FROM_OBJ_UID, this.verifyValue(FROM_OBJ_HLD_UID, (String)this.tecAttributes.get(FROM_OBJ_HLD_UID)));
                    object.setSlot(FROM_OBJ_LABEL, this.verifyValue(FROM_OBJ_HLD_LABEL, (String)this.tecAttributes.get(FROM_OBJ_HLD_LABEL)));
                    object.setSlot(FROM_OBJ_TYPE, this.verifyValue(FROM_OBJ_HLD_TYPE, (String)this.tecAttributes.get(FROM_OBJ_HLD_TYPE)));
                    object.setSlot(FROM_HLD, this.verifyValue(FROM_HLD, (String)this.tecAttributes.get(FROM_HLD)));
                    object.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    object.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block31;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(LOGICAL_ENTITY_EVENT)) {
            block32: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    object.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    object.setSlot(LABEL, this.verifyValue(LABEL, (String)this.tecAttributes.get(LABEL)));
                    object.setSlot(TYPE, this.verifyValue(TYPE, (String)this.tecAttributes.get(TYPE)));
                    object.setSlot(HLD, this.verifyValue(HLD, (String)this.tecAttributes.get(HLD)));
                    object.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    object.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block32;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(LOGICAL_RELATIONSHIP_EVENT)) {
            block33: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(UNIQUE_ID, this.verifyValue(UNIQUE_ID, (String)this.tecAttributes.get(UNIQUE_ID)));
                    object.setSlot(ENTITY_TYPE, this.verifyValue(ENTITY_TYPE, (String)this.tecAttributes.get(ENTITY_TYPE)));
                    object.setSlot(TO_OBJ_UID, this.verifyValue(TO_OBJ_UID, (String)this.tecAttributes.get(TO_OBJ_UID)));
                    object.setSlot(TO_OBJ_LABEL, this.verifyValue(TO_OBJ_LABEL, (String)this.tecAttributes.get(TO_OBJ_LABEL)));
                    object.setSlot(TO_OBJ_TYPE, this.verifyValue(TO_OBJ_TYPE, (String)this.tecAttributes.get(TO_OBJ_TYPE)));
                    object.setSlot(TO_HLD, this.verifyValue(TO_HLD, (String)this.tecAttributes.get(TO_HLD)));
                    object.setSlot(FROM_OBJ_UID, this.verifyValue(FROM_OBJ_UID, (String)this.tecAttributes.get(FROM_OBJ_UID)));
                    object.setSlot(FROM_OBJ_LABEL, this.verifyValue(FROM_OBJ_LABEL, (String)this.tecAttributes.get(FROM_OBJ_LABEL)));
                    object.setSlot(FROM_OBJ_TYPE, this.verifyValue(FROM_OBJ_TYPE, (String)this.tecAttributes.get(FROM_OBJ_TYPE)));
                    object.setSlot(FROM_HLD, this.verifyValue(FROM_HLD, (String)this.tecAttributes.get(FROM_HLD)));
                    object.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    object.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block33;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(SAN_MANAGER_STATUS_EVENT)) {
            block34: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(ACTION_PERFORMED, this.verifyValue(ACTION_PERFORMED, (String)this.tecAttributes.get(ACTION_PERFORMED)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block34;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(SAN_REGION_EVENT)) {
            block35: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(SAN_NAME, this.verifyValue(SAN_NAME, (String)this.tecAttributes.get(SAN_NAME)));
                    object.setSlot(ZONE_NAME, this.verifyValue(ZONE_NAME, (String)this.tecAttributes.get(ZONE_NAME)));
                    object.setSlot(STATE, this.verifyValue(STATE, (String)this.tecAttributes.get(STATE)));
                    object.setSlot(EVENT_TYPE, this.verifyValue(EVENT_TYPE, (String)this.tecAttributes.get(EVENT_TYPE)));
                    object.setSlot(ZONE_SET_NAME, this.verifyValue(ZONE_SET_NAME, (String)this.tecAttributes.get(ZONE_SET_NAME)));
                    object.setSlot(ACTIVE, this.verifyValue(ACTIVE, (String)this.tecAttributes.get(ACTIVE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block35;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.tecEventClass.equals(SERVICE_EVENT)) {
            block36: {
                object = new TECEvent();
                this.setGeneralTECValues((TECEvent)object);
                try {
                    object.setSlot(SERVICE_NAME, this.verifyValue(SERVICE_NAME, (String)this.tecAttributes.get(SERVICE_NAME)));
                    object.setSlot(SERVICE_STATE, this.verifyValue(SERVICE_STATE, (String)this.tecAttributes.get(SERVICE_STATE)));
                }
                catch (NullPointerException nullPointerException) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "createTECEvent", (Throwable)nullPointerException);
                    if (object != null) break block36;
                    throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "createTECEvent");
            }
            return object.toString();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "createTECEvent", (Object)("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass));
        }
        throw new IllegalArgumentException("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass);
    }

    private void setGeneralTECValues(TECEvent tECEvent) {
        tECEvent.setClassName(this.tecEventClass);
        tECEvent.setSlot(HOSTNAME, String.valueOf(this.tecSpecial) + this.tecHostName + this.tecSpecial);
        tECEvent.setSlot(ORIGIN, String.valueOf(this.tecSpecial) + this.tecIPAddress + this.tecSpecial);
        tECEvent.setSlot(SOURCE, String.valueOf(this.tecSpecial) + this.tecComponent + this.tecSpecial);
        tECEvent.setSlot(SUB_SOURCE, String.valueOf(this.tecSpecial) + this.tecFunction + this.tecSpecial);
        tECEvent.setSlot(MSG, String.valueOf(this.tecSpecial) + this.tecMessage + this.tecSpecial);
        tECEvent.setSlot(MSG_ID, String.valueOf(this.tecSpecial) + this.tecMessageId + this.tecSpecial);
        tECEvent.setSlot(SEVERITY, String.valueOf(this.tecSpecial) + this.tecSeverity + this.tecSpecial);
    }

    public Hashtable getTECAttributes() throws NullPointerException {
        return this.tecAttributes;
    }

    public String getTECComponent() {
        return this.tecComponent;
    }

    public String getTECFunction() {
        return this.tecFunction;
    }

    public String getTECIPAddress() {
        return this.tecIPAddress;
    }

    public String getTECMessage() {
        return this.tecMessage;
    }

    public String getTECMessageId() {
        return this.tecMessageId;
    }

    public String getTECSeverity() {
        return this.tecSeverity;
    }

    public String getTECEventClass() {
        return this.tecEventClass;
    }

    public void setTECComponent(String string) {
        this.tecComponent = string;
    }

    public void setTECFunction(String string) {
        this.tecFunction = string;
    }

    public void setTECIPAddress(String string) {
        this.tecIPAddress = string;
    }

    public void setTECMessage(String string) {
        this.tecMessage = string;
    }

    public void setTECMessageId(String string) {
        this.tecMessageId = string;
    }

    public void setTECSeverity(String string) {
        this.tecSeverity = string;
    }

    public void setTECEventClass(String string) {
        this.tecEventClass = string;
    }

    private String verifyValue(String string, String string2) {
        String string3 = "verifyValue";
        String string4 = string2;
        if (string4 != null) {
            return String.valueOf(this.tecSpecial) + string4 + this.tecSpecial;
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string3, "Null value found for TEC attribute " + string);
        }
        String string5 = "";
        return string5;
    }
}

