/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.report.model.api.BundleFactory;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;

public class DefaultResourceLocator
implements IResourceLocator {
    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        if (fileName == null) {
            return null;
        }
        try {
            File f = new File(fileName);
            if (f.isAbsolute()) {
                return f.exists() && f.isFile() ? f.getCanonicalFile().toURL() : null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            URL objURI = new URL(fileName);
            if (this.isGlobalResource(objURI)) {
                return objURI;
            }
            return this.tryLocalResourceSearch(objURI);
        }
        catch (MalformedURLException e) {
            URL url;
            if (moduleHandle == null) {
                return this.tryFragmentSearch(fileName);
            }
            String resourcePath = moduleHandle.getModule().getSession().getResourceFolder();
            if (StringUtil.isBlank(resourcePath)) {
                resourcePath = moduleHandle.getResourceFolder();
            }
            if (resourcePath != null) {
                File f = new File(resourcePath, fileName);
                try {
                    if (f.exists() && f.isFile()) {
                        return f.getCanonicalFile().toURL();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            if ((url = this.tryFragmentSearch(fileName)) != null) {
                return url;
            }
            URL systemId = moduleHandle.getModule().getSystemId();
            if (systemId == null) {
                return null;
            }
            try {
                url = new URL(systemId, URIUtil.convertFileNameToURLString(fileName));
                if (this.isGlobalResource(url)) {
                    return url;
                }
                return this.tryLocalResourceSearch(url);
            }
            catch (MalformedURLException e3) {
                return null;
            }
        }
    }

    private boolean isGlobalResource(URL url) {
        if ("ftp".equalsIgnoreCase(url.getProtocol()) || "http".equalsIgnoreCase(url.getProtocol())) {
            return true;
        }
        return url.getFile().toLowerCase().startsWith("ftp") || url.getFile().toLowerCase().startsWith("http");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL tryLocalResourceSearch(URL url) {
        InputStream in = null;
        in = url.openStream();
        Object var6_3 = null;
        if (in == null) return url;
        try {
            in.close();
            return url;
        }
        catch (IOException e) {}
        return url;
        {
            catch (IOException e1) {
                URL uRL = null;
                Object var6_4 = null;
                if (in == null) return uRL;
                try {
                    in.close();
                    return uRL;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return uRL;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private URL tryFragmentSearch(String fileName) {
        return BundleFactory.getBundleFactory().getBundleResource("org.eclipse.birt.resources", fileName);
    }
}

