/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.command.ElementRefRecord;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.MoveListItemRecord;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyListRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.PropertyReplaceRecord;
import org.eclipse.birt.report.model.command.SimplePropertyListRecord;
import org.eclipse.birt.report.model.command.StructBackRefRecord;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class PropertyCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        ElementPropertyDefn prop = this.element.getPropertyDefn(propName = StringUtil.trimString(propName));
        if (prop == null) {
            throw new PropertyNameException(this.element, propName);
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        String propName;
        if ("extensionName".equals(prop.getName())) {
            throw new PropertyValueException(this.element, "extensionName", value, "Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN");
        }
        String mask = this.element.getPropertyMask(this.module, prop.getName());
        if ("lock".equalsIgnoreCase(mask)) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.VALUE_LOCKED");
        }
        if (this.element.isVirtualElement() && this.element instanceof Cell && ("colSpan".equalsIgnoreCase(propName = prop.getName()) || "rowSpan".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName))) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN");
        }
        if (this.element instanceof MasterPage) {
            propName = prop.getName();
            if (!((MasterPage)this.element).isCustomType(this.module) && ("width".equals(propName) || "height".equals(propName))) {
                throw new SemanticError(this.element, "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
            }
        }
        value = this.validateValue(prop, value);
        if (this.element instanceof GroupElement && "groupName".equals(prop.getName()) && !this.isGroupNameValidInContext((String)value)) {
            throw new NameException(this.element, (String)value, "Error.NameException.DUPLICATE");
        }
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop, value);
        } else {
            this.doSetProperty(prop, value);
        }
    }

    private void doSetProperty(ElementPropertyDefn prop, Object value) throws ExtendedElementException, PropertyValueException {
        ExtendedItem extendedItem;
        Object oldValue = this.element.getLocalProperty(this.module, prop);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        if (this.element instanceof ExtendedItem && ((extendedItem = (ExtendedItem)this.element).isExtensionModelProperty(prop.getName()) || extendedItem.isExtensionXMLProperty(prop.getName()))) {
            IReportItem extElement = extendedItem.getExtendedElement();
            if (!$assertionsDisabled && extElement == null) {
                throw new AssertionError();
            }
            extElement.checkProperty(prop.getName(), value);
            extElement.setProperty(prop.getName(), value);
            return;
        }
        PropertyRecord record = new PropertyRecord(this.element, prop, value);
        this.getActivityStack().execute(record);
    }

    private void assertExtendedElement(Module module, DesignElement element, PropertyDefn prop) {
        if (element instanceof ExtendedItem && prop.isExtended() && !$assertionsDisabled && ((ExtendedItem)element).getExtendedElement() == null) {
            throw new AssertionError();
        }
    }

    private Object validateValue(ElementPropertyDefn prop, Object value) throws SemanticException {
        if (value == null) {
            return null;
        }
        Object input = value;
        if (value instanceof DesignElementHandle) {
            DesignElementHandle elementHandle = (DesignElementHandle)value;
            Module root = elementHandle.getModule();
            input = ReferenceValueUtil.needTheNamespacePrefix(elementHandle.getElement(), root, this.module);
        }
        Object retValue = null;
        try {
            retValue = prop.validateValue(this.module, input);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(prop.getName());
            throw ex;
        }
        if (!(retValue instanceof ElementRefValue)) {
            return retValue;
        }
        ElementRefValue refValue = (ElementRefValue)retValue;
        if (refValue.isResolved() && value instanceof DesignElementHandle && refValue.getElement() != ((DesignElementHandle)value).getElement()) {
            throw new SemanticError(this.element, new String[]{prop.getName(), refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        return retValue;
    }

    private void setIntrinsicProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        String propName = prop.getName();
        if ("name".equals(propName)) {
            String name = (String)value;
            NameCommand cmd = new NameCommand(this.module, this.element);
            cmd.setName(name);
        } else if ("extends".equals(propName)) {
            ExtendsCommand cmd = new ExtendsCommand(this.module, this.element);
            cmd.setExtendsRefValue((ElementRefValue)value);
        } else if ("style".equals(propName)) {
            StyleCommand cmd = new StyleCommand(this.module, this.element);
            cmd.setStyleRefValue((ElementRefValue)value);
        } else if ("units".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("extensionName".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("theme".equals(propName)) {
            if (!$assertionsDisabled && this.module != this.element) {
                throw new AssertionError();
            }
            ThemeCommand cmd = new ThemeCommand((Module)this.element);
            cmd.setThemeRefValue((ElementRefValue)value);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private boolean isGroupNameValidInContext(String groupName) {
        if (!$assertionsDisabled && !(this.element instanceof GroupElement)) {
            throw new AssertionError();
        }
        if (groupName == null) {
            return true;
        }
        if (this.element.getContainer() != null) {
            DesignElement tmpContainer = this.element.getContainer();
            List errors = GroupNameValidator.getInstance().validateForRenamingGroup((ListingHandle)tmpContainer.getHandle(this.module), (GroupHandle)this.element.getHandle(this.module), groupName);
            if (!errors.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void setMember(MemberRef ref, Object value) throws SemanticException {
        Object oldValue;
        PropertyDefn memberDefn = ref.getMemberDefn();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        value = memberDefn.validateValue(this.module, value);
        if (memberDefn.getTypeCode() == 13 || memberDefn.getTypeCode() == 22) {
            this.checkItemName(ref, (String)value);
        }
        if ((oldValue = ref.getLocalValue(this.module, this.element)) == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        String label = ModelMessages.getMessage("Message.ChangeItem");
        stack.startTrans(label);
        this.makeLocalCompositeValue(ref);
        MemberRecord record = new MemberRecord(this.module, this.element, ref, value);
        stack.execute(record);
        Structure structure = ref.getStructure(this.module, this.element);
        List semanticList = structure.validate(this.module, this.element);
        if (semanticList.size() > 0) {
            stack.rollback();
            throw (SemanticException)((Object)semanticList.get(0));
        }
        stack.commit();
    }

    public void addItem(MemberRef ref, IStructure item) throws SemanticException {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        if (item == null) {
            return;
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (item.isReferencable() && !$assertionsDisabled && ((ReferencableStructure)item).hasReferences()) {
            throw new AssertionError();
        }
        this.checkListMemberRef(ref);
        this.checkItem(ref, item);
        ArrayList list = ref.getList(this.module, this.element);
        this.element.checkStructureList(this.module, ref.getPropDefn(), list, item);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(ModelMessages.getMessage("Message.AddItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (null == list) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, ref, list);
            stack.execute(memberRecord);
        }
        CachedMemberRef insertRef = new CachedMemberRef(ref, list.size());
        PropertyListRecord record = new PropertyListRecord(this.element, insertRef, ((MemberRef)insertRef).getList(this.module, this.element), item);
        stack.execute(record);
        stack.commit();
    }

    public void insertItem(MemberRef ref, IStructure item, int posn) throws SemanticException {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        if (item == null) {
            return;
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        this.checkItem(ref, item);
        ArrayList list = ref.getList(this.module, this.element);
        this.element.checkStructureList(this.module, ref.getPropDefn(), list, item);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(ModelMessages.getMessage("Message.InsertItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (null == list) {
            list = new ArrayList();
            MemberRecord memberRecord = new MemberRecord(this.module, this.element, ref, list);
            stack.execute(memberRecord);
        }
        if (posn < 0 || posn > list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        CachedMemberRef insertRef = new CachedMemberRef(ref, posn);
        PropertyListRecord record = new PropertyListRecord(this.element, insertRef, list, item);
        stack.execute(record);
        stack.commit();
    }

    public void removeItem(MemberRef ref, int posn) throws PropertyValueException {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (posn < 0 || posn >= list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        this.doRemoveItem(new CachedMemberRef(ref, posn));
    }

    public void removeItem(MemberRef ref, IStructure structure) throws PropertyValueException {
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        int posn = list.indexOf(structure);
        if (posn == -1) {
            throw new PropertyValueException(this.element, ref.getPropDefn().getName(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        this.doRemoveItem(new CachedMemberRef(ref, posn));
    }

    private void doRemoveItem(MemberRef structRef) {
        String label = ModelMessages.getMessage("Message.RemoveItem");
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(label);
        this.makeLocalCompositeValue(structRef);
        List list = structRef.getList(this.module, this.element);
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        Structure struct = structRef.getStructure(this.module, this.element);
        if (struct.isReferencable()) {
            this.adjustReferenceClients((ReferencableStructure)struct);
        }
        PropertyListRecord record = new PropertyListRecord(this.element, structRef, list);
        stack.execute(record);
        stack.commit();
    }

    private void adjustReferenceClients(ReferencableStructure struct) {
        if (!$assertionsDisabled && struct == null) {
            throw new AssertionError();
        }
        if (!struct.hasReferences()) {
            return;
        }
        ArrayList clients = new ArrayList(struct.getClientList());
        Iterator iter = clients.iterator();
        while (iter.hasNext()) {
            BackRef ref = (BackRef)iter.next();
            DesignElement client = ref.element;
            StructBackRefRecord record = new StructBackRefRecord(this.module, struct, client, ref.propName);
            this.getActivityStack().execute(record);
        }
    }

    public void replaceItem(MemberRef ref, IStructure oldItem, IStructure newItem) throws SemanticException {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (newItem != null) {
            this.checkItem(ref, newItem);
            this.element.checkStructureList(this.module, ref.getPropDefn(), list, newItem);
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(ModelMessages.getMessage("Message.ReplaceItem"));
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        int index = list.indexOf(oldItem);
        if (index == -1) {
            throw new PropertyValueException(this.element, ref.getPropDefn().getName(), (Object)oldItem, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        PropertyReplaceRecord record = new PropertyReplaceRecord(this.element, ref, list, index, newItem);
        stack.execute(record);
        if (oldItem.isReferencable()) {
            this.adjustReferenceClients((ReferencableStructure)oldItem);
        }
        stack.commit();
    }

    public void removeAllItems(MemberRef ref) throws SemanticException {
        this.checkListMemberRef(ref);
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (ref.refType == 0) {
            this.setProperty(ref.getPropDefn(), null);
        } else {
            this.setMember(ref, null);
        }
    }

    public void moveItem(MemberRef ref, int oldPosn, int newPosn) throws PropertyValueException {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.checkListMemberRef(ref);
        List list = ref.getList(this.module, this.element);
        if (list == null) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        String label = ModelMessages.getMessage("Message.MoveItem");
        int adjustedNewPosn = PropertyCommand.checkAndAdjustPosition(oldPosn, newPosn, list.size());
        if (oldPosn == adjustedNewPosn) {
            return;
        }
        stack.startTrans(label);
        this.makeLocalCompositeValue(ref);
        list = ref.getList(this.module, this.element);
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        MoveListItemRecord record = new MoveListItemRecord(this.element, ref, list, oldPosn, adjustedNewPosn);
        stack.execute(record);
        stack.commit();
    }

    void makeLocalCompositeValue(MemberRef ref) {
        if (!$assertionsDisabled && ref == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (ref.getPropDefn().isList()) {
            ArrayList<IStructure> list = (ArrayList<IStructure>)this.element.getLocalProperty(this.module, propDefn);
            if (list != null) {
                return;
            }
            ArrayList inherited = (ArrayList)this.element.getProperty(this.module, propDefn);
            list = new ArrayList<IStructure>();
            if (inherited != null) {
                for (int i = 0; i < inherited.size(); ++i) {
                    list.add(((IStructure)inherited.get(i)).copy());
                }
            }
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, list);
            this.getActivityStack().execute(propRecord);
            return;
        }
        Structure struct = (Structure)this.element.getLocalProperty(this.module, propDefn);
        if (struct != null) {
            return;
        }
        Structure inherited = (Structure)this.element.getProperty(this.module, propDefn);
        if (inherited != null) {
            IStructure copy = inherited.copy();
            PropertyRecord propRecord = new PropertyRecord(this.element, propDefn, (Object)copy);
            this.getActivityStack().execute(propRecord);
        }
    }

    private void checkListMemberRef(MemberRef ref) throws PropertyValueException {
        if (!ref.isListRef()) {
            throw new PropertyValueException(this.element, ref.getPropDefn(), null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    private void checkItem(MemberRef ref, IStructure item) throws SemanticException {
        List errorList;
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        PropertyDefn propDefn = null;
        if (ref.refType == 0) {
            propDefn = ref.getPropDefn();
            if (item.getDefn() != propDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, propDefn, (Object)item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
        } else {
            propDefn = ref.getMemberDefn();
            if (item.getDefn() != propDefn.getStructDefn()) {
                throw new PropertyValueException(this.element, ref.getPropDefn(), propDefn, item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
        }
        Iterator iter = item.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            if ("libReference".equals(memberDefn.getName())) continue;
            item.setProperty(memberDefn, memberDefn.validateValue(this.module, item.getLocalProperty(this.module, memberDefn)));
        }
        if (item instanceof Structure && (errorList = ((Structure)item).validate(this.module, this.element)).size() > 0) {
            throw (SemanticException)((Object)errorList.get(0));
        }
    }

    public void addItem(ElementPropertyDefn prop, Object item) throws SemanticException {
        ElementRefValue refValue;
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (item == null) {
            return;
        }
        if (!$assertionsDisabled && item instanceof IStructure) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, prop);
        this.checkListProperty(prop);
        Object value = this.checkItem(prop, item);
        ArrayList list = this.element.getListProperty(this.module, prop.getName());
        this.element.checkSimpleList(this.module, prop, list, value);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(ModelMessages.getMessage("Message.AddItem"));
        this.makeLocalCompositeValue(prop);
        list = this.element.getListProperty(this.module, prop.getName());
        if (null == list) {
            list = new ArrayList();
            PropertyRecord propRecord = new PropertyRecord(this.element, prop, list);
            stack.execute(propRecord);
        }
        SimplePropertyListRecord record = new SimplePropertyListRecord(this.element, prop, list, value, list.size());
        stack.execute(record);
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), prop.getName(), true);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    private void checkListProperty(ElementPropertyDefn prop) throws PropertyValueException {
        if (prop.getTypeCode() != 20) {
            throw new PropertyValueException(this.element, prop, null, "Error.PropertyValueException.NOT_LIST_TYPE");
        }
    }

    private Object checkItem(ElementPropertyDefn prop, Object item) throws PropertyValueException, SemanticError {
        if (!$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prop.getTypeCode() != 20) {
            throw new AssertionError();
        }
        Object value = item;
        if (item instanceof DesignElementHandle) {
            value = ((DesignElementHandle)item).getElement();
        }
        PropertyType type = prop.getSubType();
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        Object result = type.validateValue(this.module, prop, value);
        if (result instanceof ElementRefValue && !((ElementRefValue)result).isResolved()) {
            throw new SemanticError(this.element, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        return result;
    }

    void makeLocalCompositeValue(ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        ArrayList list = (ArrayList)this.element.getLocalProperty(this.module, prop);
        if (list != null) {
            return;
        }
        ArrayList inherited = (ArrayList)this.element.getProperty(this.module, prop);
        Object value = ModelUtil.copyValue(prop, inherited);
        PropertyRecord propRecord = new PropertyRecord(this.element, prop, value);
        this.getActivityStack().execute(propRecord);
    }

    public void removeItem(ElementPropertyDefn prop, int posn) throws SemanticException {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, prop);
        this.checkListProperty(prop);
        List list = this.element.getListProperty(this.module, prop.getName());
        if (list == null) {
            throw new PropertyValueException(this.element, prop.getName(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (posn < 0 || posn >= list.size()) {
            throw new IndexOutOfBoundsException("Posn: " + posn + ", List Size: " + list.size());
        }
        Object obj = list.get(posn);
        this.doRemoveItem(prop, posn, obj);
    }

    public void removeItem(ElementPropertyDefn prop, Object item) throws SemanticException {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (item == null) {
            return;
        }
        this.assertExtendedElement(this.module, this.element, prop);
        this.checkListProperty(prop);
        Object value = null;
        value = prop.getSubTypeCode() == 15 ? this.checkItem(prop, item) : item;
        List list = this.element.getListProperty(this.module, prop.getName());
        if (list == null) {
            throw new PropertyValueException(this.element, prop, null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        int posn = list.indexOf(value);
        if (posn == -1) {
            throw new PropertyValueException(this.element, prop.getName(), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        this.doRemoveItem(prop, posn, value);
    }

    private void doRemoveItem(ElementPropertyDefn prop, int posn, Object item) {
        ElementRefValue refValue;
        String label = ModelMessages.getMessage("Message.RemoveItem");
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(label);
        this.makeLocalCompositeValue(prop);
        List list = this.element.getListProperty(this.module, prop.getName());
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        SimplePropertyListRecord record = new SimplePropertyListRecord(this.element, prop, list, posn);
        stack.execute(record);
        if (item instanceof ElementRefValue && (refValue = (ElementRefValue)item).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), prop.getName(), false);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    private void checkItemName(MemberRef memberRef, String newName) throws SemanticException {
        ElementPropertyDefn propDefn = memberRef.getPropDefn();
        Structure structure = memberRef.getStructure(this.module, this.element);
        List errors = StructureListValidator.getInstance().validateForRenaming(this.element.getHandle(this.module), propDefn, memberRef.getList(this.module, this.element), structure, memberRef.getMemberDefn(), newName);
        if (errors.size() > 0) {
            throw (PropertyValueException)((Object)errors.get(0));
        }
    }

    static {
        $assertionsDisabled = !PropertyCommand.class.desiredAssertionStatus();
    }
}

