/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public final class TranslationTable
implements Cloneable {
    Map resourceMap = new LinkedHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void add(Translation newTranslation) {
        if (!$assertionsDisabled && newTranslation == null) {
            throw new AssertionError();
        }
        String resourceKey = newTranslation.getResourceKey();
        ArrayList<Translation> translationList = (ArrayList<Translation>)this.resourceMap.get(resourceKey);
        if (translationList == null) {
            translationList = new ArrayList<Translation>();
            this.resourceMap.put(resourceKey, translationList);
        }
        translationList.add(newTranslation);
    }

    public boolean remove(Translation trans) {
        if (trans == null) {
            return false;
        }
        ArrayList translationList = (ArrayList)this.resourceMap.get(trans.getResourceKey());
        if (translationList == null) {
            return false;
        }
        return translationList.remove(trans);
    }

    public String getMessage(String resourceKey) {
        return this.getMessage(resourceKey, ThreadResources.getLocale());
    }

    public String getMessage(String resourceKey, ULocale theLocale) {
        String language;
        Translation trans;
        String locale;
        if (StringUtil.isBlank(resourceKey)) {
            return null;
        }
        String string = locale = theLocale == null ? null : theLocale.toString();
        if (locale == null) {
            Translation trans2 = this.findTranslation(resourceKey, null);
            return trans2 != null ? trans2.getText() : null;
        }
        ArrayList translationList = (ArrayList)this.resourceMap.get(resourceKey);
        if (translationList == null) {
            return null;
        }
        if (locale.length() > 5) {
            locale = locale.substring(0, 5);
        }
        if ((trans = this.findTranslation(resourceKey, locale)) != null) {
            return trans.getText();
        }
        if (locale != null && locale.length() >= 2 && (trans = this.findTranslation(resourceKey, language = locale.substring(0, 2))) != null) {
            return trans.getText();
        }
        trans = this.findTranslation(resourceKey, null);
        if (trans != null) {
            return trans.getText();
        }
        return null;
    }

    public Translation findTranslation(String resourceKey, String locale) {
        ArrayList translationList = (ArrayList)this.resourceMap.get(resourceKey);
        if (translationList == null) {
            return null;
        }
        Iterator transIterator = translationList.iterator();
        while (transIterator.hasNext()) {
            Translation trans = (Translation)transIterator.next();
            if (locale == null && trans.getLocale() == null) {
                return trans;
            }
            if (locale == null || !locale.equalsIgnoreCase(trans.getLocale())) continue;
            return trans;
        }
        return null;
    }

    public boolean contains(Translation trans) {
        if (trans == null) {
            return false;
        }
        return this.findTranslation(trans.getResourceKey(), trans.getLocale()) != null;
    }

    public List getTranslations() {
        ArrayList translations = new ArrayList();
        Iterator iterator = this.resourceMap.values().iterator();
        while (iterator.hasNext()) {
            translations.addAll((ArrayList)iterator.next());
        }
        if (translations.isEmpty()) {
            return null;
        }
        return translations;
    }

    public List getTranslations(String resourceKey) {
        return (ArrayList)this.resourceMap.get(resourceKey);
    }

    public String[] getResourceKeys() {
        Set keySet = this.resourceMap.keySet();
        int size = keySet.size();
        if (size == 0) {
            return null;
        }
        String[] keys = new String[size];
        keySet.toArray(keys);
        return keys;
    }

    public Object clone() throws CloneNotSupportedException {
        TranslationTable table = (TranslationTable)super.clone();
        table.resourceMap = new LinkedHashMap();
        Iterator it = this.resourceMap.values().iterator();
        while (it.hasNext()) {
            ArrayList transList = (ArrayList)it.next();
            for (int i = 0; i < transList.size(); ++i) {
                Translation trans = (Translation)transList.get(i);
                table.add((Translation)trans.clone());
            }
        }
        return table;
    }

    static {
        $assertionsDisabled = !TranslationTable.class.desiredAssertionStatus();
    }
}

