/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class DimensionPropertyType
extends PropertyType {
    private static Logger logger;
    private static final String DISPLAY_NAME_KEY = "Property.dimension";
    static final /* synthetic */ boolean $assertionsDisabled;

    public DimensionPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            logger.log(Level.FINE, "The input value object is null.");
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        if (value instanceof DimensionValue) {
            if (!StringUtil.isBlank(((DimensionValue)value).getUnits())) {
                logger.log(Level.FINE, "Validate the dimension value with defined unit " + value);
                return value;
            }
            logger.log(Level.FINE, "return dimension value with default unit " + value);
            return new DimensionValue(((DimensionValue)value).getMeasure(), this.getDefaultUnit(module, defn));
        }
        if (value instanceof Integer) {
            return this.fromDouble(module, defn, ((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return this.fromDouble(module, defn, (Double)value);
        }
        if (value instanceof BigDecimal) {
            return this.fromDouble(module, defn, ((BigDecimal)value).doubleValue());
        }
        logger.log(Level.SEVERE, "invalid dimension value type:" + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 3);
    }

    private String getDefaultUnit(Module module, PropertyDefn defn) {
        String unit = defn.getDefaultUnit();
        if (!StringUtil.isBlank(unit)) {
            return unit;
        }
        if (module == null) {
            return "in";
        }
        unit = module.getUnits();
        if (!StringUtil.isBlank(unit)) {
            return unit;
        }
        if (module.getSession() != null) {
            return module.getSession().getUnits();
        }
        return "in";
    }

    private DimensionValue fromDouble(Module module, PropertyDefn defn, double value) {
        return new DimensionValue(value, this.getDefaultUnit(module, defn));
    }

    public Object validateXml(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        DimensionValue dim = DimensionValue.parse(value);
        if (dim == null) {
            logger.log(Level.FINE, "The input string may be a blank string or without measure." + value);
            return null;
        }
        this.validateUnits(module, defn, dim);
        if (!"".equalsIgnoreCase(dim.getUnits())) {
            logger.log(Level.FINE, "return dimension value with user defined unit " + dim.toString());
            return dim;
        }
        logger.log(Level.FINE, "return dimension value with default unit " + dim.getMeasure());
        return new DimensionValue(dim.getMeasure(), this.getDefaultUnit(module, defn));
    }

    public Object validateInputString(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        DimensionValue dim = DimensionValue.parseInput(value);
        if (dim == null) {
            logger.log(Level.FINE, "The input string may be a blank string or without measure." + value);
            return null;
        }
        this.validateUnits(module, defn, dim);
        if (!"".equalsIgnoreCase(dim.getUnits())) {
            logger.log(Level.FINE, "return dimension with user-defined unit " + dim.toString());
            return dim;
        }
        dim = new DimensionValue(dim.getMeasure(), this.getDefaultUnit(module, defn));
        logger.log(Level.FINE, "return dimension with default unit " + dim.toString());
        return dim;
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (!$assertionsDisabled && !(value instanceof DimensionValue)) {
            throw new AssertionError();
        }
        return ((DimensionValue)value).toDisplayString();
    }

    private void validateUnits(Module module, PropertyDefn defn, DimensionValue value) throws PropertyValueException {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        String unit = value.getUnits();
        if ("".equalsIgnoreCase(unit)) {
            unit = this.getDefaultUnit(module, defn);
        }
        IChoiceSet units = defn.getAllowedChoices();
        if (!$assertionsDisabled && units == null) {
            throw new AssertionError();
        }
        if (!StringUtil.isBlank(unit) && !units.contains(unit)) {
            logger.log(Level.SEVERE, "unit:" + unit + " not allowed ");
            throw new PropertyValueException(null, defn, (Object)value, "Error.PropertyValueException.UNIT_NOT_ALLOWED");
        }
    }

    public int getTypeCode() {
        return 3;
    }

    public String getName() {
        return "dimension";
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (!$assertionsDisabled && !(value instanceof DimensionValue)) {
            throw new AssertionError();
        }
        return value.toString();
    }

    public double toDouble(Module module, Object value) {
        DimensionValue dim = (DimensionValue)value;
        if (dim == null) {
            return 0.0;
        }
        if ("".equalsIgnoreCase(dim.getUnits())) {
            return dim.getMeasure();
        }
        return DimensionUtil.convertTo(dim.getMeasure(), dim.getUnits(), module.getSession().getUnits()).getMeasure();
    }

    static {
        $assertionsDisabled = !DimensionPropertyType.class.desiredAssertionStatus();
        logger = Logger.getLogger(DimensionPropertyType.class.getName());
    }
}

