/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.CompatibleLibraryStylesState;
import org.eclipse.birt.report.model.parser.CompatibleReportPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ModuleState;
import org.eclipse.birt.report.model.parser.ParametersState;
import org.eclipse.birt.report.model.parser.ThemeState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.xml.sax.SAXException;

public class LibraryState
extends ModuleState {
    public LibraryState(ModuleParserHandler theHandler) {
        super(theHandler);
    }

    public void end() throws SAXException {
        Library library = (Library)this.getElement();
        Object themeObj = this.getElement().getLocalProperty(this.module, "theme");
        if (themeObj != null) {
            return;
        }
        Theme theme = null;
        ContainerSlot themes = this.module.getSlot(0);
        for (int i = 0; i < themes.getCount(); ++i) {
            Theme tmpTheme = (Theme)themes.getContent(i);
            if (!ModelMessages.getMessage("Theme.defaultThemeName").equalsIgnoreCase(tmpTheme.getName())) continue;
            theme = tmpTheme;
            break;
        }
        if (theme == null) {
            theme = new Theme(ModelMessages.getMessage("Theme.defaultThemeName"));
            ModelUtil.insertCompatibleThemeToLibrary(library, theme);
        }
        library.setProperty("theme", (Object)new ElementRefValue(null, theme));
        super.end();
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("translations")) {
            return new ModuleState.TranslationsState(this);
        }
        if (tagName.equalsIgnoreCase("parameters")) {
            return new ParametersState(this.handler);
        }
        if (tagName.equalsIgnoreCase("data-sources")) {
            return new ModuleState.DataSourcesState(this);
        }
        if (tagName.equalsIgnoreCase("data-sets")) {
            return new ModuleState.DataSetsState(this);
        }
        if (tagName.equalsIgnoreCase("themes")) {
            return new ThemesState();
        }
        if (tagName.equalsIgnoreCase("styles")) {
            return new CompatibleLibraryStylesState(this.handler, this.getElement(), 0);
        }
        if (tagName.equalsIgnoreCase("page-setup")) {
            return new ModuleState.PageSetupState(this);
        }
        if (tagName.equalsIgnoreCase("components")) {
            return new ModuleState.SlotState(this, 5);
        }
        if (tagName.equalsIgnoreCase("property")) {
            return new CompatibleReportPropertyState(this.handler, this.getElement());
        }
        return super.startElement(tagName);
    }

    class ThemesState
    extends ModuleState.InnerParseState {
        ThemesState() {
            super(LibraryState.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase("theme")) {
                return new ThemeState(LibraryState.this.handler, LibraryState.this.module, 0);
            }
            return super.startElement(tagName);
        }
    }
}

