/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.script;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.script.Color;
import org.eclipse.birt.report.model.script.Dimension;
import org.eclipse.birt.report.model.script.PropertyDefinition;

public class ElementDefinition {
    DesignElementHandle element;

    ElementDefinition(DesignElementHandle element) {
        this.element = element;
    }

    String getName() {
        return this.element.getName();
    }

    String getExtendsElement() {
        if (this.element.getExtends() != null) {
            return this.element.getExtends().getName();
        }
        return null;
    }

    Map getPropertyDefns() {
        LinkedHashMap<String, PropertyDefinition> map = new LinkedHashMap<String, PropertyDefinition>();
        List propList = this.element.getElement().getPropertyDefns();
        Iterator iter = propList.iterator();
        while (iter.hasNext()) {
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            map.put(propDefn.getName(), new PropertyDefinition(propDefn));
        }
        return map;
    }

    Map getProperties() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator iter = this.element.getPropertyIterator();
        while (iter.hasNext()) {
            PropertyHandle propHandle = (PropertyHandle)iter.next();
            if (propHandle.getDefn().getTypeCode() == 4) {
                Color color = new Color(new ColorHandle(this.element, (ElementPropertyDefn)propHandle.getDefn()));
                map.put(propHandle.getPropertyDefn().getName(), color);
                continue;
            }
            if (propHandle.getDefn().getTypeCode() == 3) {
                Dimension dimension = new Dimension(new DimensionHandle(this.element, (ElementPropertyDefn)propHandle.getDefn()));
                map.put(propHandle.getPropertyDefn().getName(), dimension);
                continue;
            }
            map.put(propHandle.getPropertyDefn().getName(), propHandle.getValue());
        }
        return map;
    }

    boolean allowsUserProperties() {
        return this.element.getDefn().allowsUserProperties();
    }

    boolean hasStyle() {
        return this.element.getDefn().hasStyle();
    }

    ElementDefinition getContainer() {
        if (this.element.getContainer() != null) {
            return new ElementDefinition(this.element.getContainer());
        }
        return null;
    }

    String getContainerSlot() {
        if (this.element.getContainer() != null) {
            return this.element.getContainer().getDefn().getSlot(this.element.getContainerSlotHandle().getSlotID()).getName();
        }
        return "";
    }

    Object getProperty(String name) {
        return this.element.getProperty(name);
    }

    Map getSlots() {
        return null;
    }

    Map getSlotDefns() {
        return null;
    }
}

