/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class DiscoverViaSNMP
extends DiscoverProcess {
    private static String MSG_FILE = FabricManagerConstants.MSG_FILE;
    private final String className = "DiscoverViaSNMP";
    public static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    public static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    boolean trace;

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public DiscoverViaSNMP() {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super("Discover Via SNMP", false, new String[]{"IPADDRESS", "SCANNER"}, stringArray);
        this.className = "DiscoverViaSNMP";
        this.trace = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException {
        JobInfo jobInfo;
        Object object;
        String string;
        String[] stringArray;
        String string2;
        String string3;
        block17: {
            Class<?> clazz;
            Class<?> clazz2;
            string3 = null;
            string2 = null;
            try {
                clazz2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray = (String[])DiscoverViaSNMP.getParameter((Map)map, (String)"IPADDRESS", (String)clazz2.getName());
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            String string4 = (String)DiscoverViaSNMP.getParameter((Map)map, (String)"SCANNER", (String)clazz.getName());
            string = (String)Discover.snmpScannerToScannerClassMapping.get(string4);
            DBConnection dBConnection = ServiceUtils.getConnection();
            dBConnection.getSchema();
            new IpTarget();
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(IpTarget.getColumnInfo((String)"IP_ADDRESS"), stringArray[0]);
            try {
                try {
                    object = IpTarget.retrieve((DBConnection)dBConnection, hashtable);
                    if (object != null) {
                        string3 = object.getReadCommunityName();
                        string2 = object.getRwCommunityName();
                    }
                    if (string3 == null || string2 == null) {
                        if (this.trace) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)"DiscoverViaSNMP", "process", "Could not read SNMP Community and SNMP Write Community from the DB. Trying to read from the properties file ");
                        }
                        string3 = OutbandScannerProperty.getSnmpCommunityName();
                        string2 = OutbandScannerProperty.getSnmpWriteCommunityName();
                    }
                }
                catch (Exception exception) {
                    if (this.trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)"DiscoverViaSNMP", "process", (Throwable)exception);
                    }
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (dBConnection == null) throw throwable;
                try {
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                jobInfo = null;
                if (dBConnection == null) break block17;
            }
            try {}
            catch (SQLException sQLException) {}
            dBConnection.close();
        }
        object = new Hashtable();
        ((Hashtable)object).put("SCANNER", string);
        ((Hashtable)object).put("SNMP Community", string3);
        ((Hashtable)object).put("SNMP Write Community", string2);
        jobInfo = new JobInfo();
        jobInfo.setDiscoverRequest(new Integer(request.getId()).toString());
        jobInfo.setResourceQueue(OutbandScanner.queueName);
        jobInfo.setResourceId(stringArray[0]);
        String string5 = this.getScannerId(map);
        if (string5 != null) {
            jobInfo.setRequestId(string5);
            jobInfo.setRequest((Response)new ObjectResponse(object, jobInfo));
            jobInfo.setTarget(stringArray);
            JobInfo jobInfo2 = (JobInfo)jobInfo.clone();
            jobInfo2.setResourceQueue(TSANMLegacyParser.queueName);
            jobInfo.setNextJob(jobInfo2);
            JobEngine.getInstance().addJob(jobInfo);
            return new Result(0);
        }
        if (!this.trace) return new Result(-100);
        traceLogger.text(IRecordType.TYPE_ERROR, (Object)"DiscoverViaSNMP", "process", "Unsupported scanner type " + string);
        return new Result(-100);
    }

    public String getScannerId(Map map) throws ParameterException {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        String[] stringArray = (String[])DiscoverViaSNMP.getParameter((Map)map, (String)"IPADDRESS", (String)clazz2.getName());
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        String string = (String)DiscoverViaSNMP.getParameter((Map)map, (String)"SCANNER", (String)clazz.getName());
        String string2 = (String)Discover.snmpScannerToScannerClassMapping.get(string);
        String string3 = null;
        if (OutbandScanner.CiscoMDSScanner.equals(string2)) {
            string3 = "PO4:" + stringArray[0];
        } else if (OutbandScanner.TopologyScanner.equals(string2)) {
            string3 = "PO2:" + stringArray[0];
        }
        return string3;
    }
}

