/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Database;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class SANEventFilter {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String className;
    private static final String TEC_EVENT = "tec";
    private static final String SNMP_TRAP = "trap";
    private static final String SUPPRESS_EVENT = "suppress";
    private static final String PUBLISH_EVENT = "publish";
    private static final String UNSPECIFIED = "unspecified";
    private static String severity;
    private static String entityType;
    private static String eventCategory;
    private static String uniqueId;
    static final String EVENT_ACTION = "EVENT_ACTION";
    DBPreparedStatement stmt;
    DBConnection connection;
    private static SANEventFilter instance;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.SANEventFilter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        severity = null;
        entityType = null;
        eventCategory = null;
        uniqueId = null;
        instance = new SANEventFilter();
    }

    public static SANEventFilter getInstance() {
        return instance;
    }

    private SANEventFilter() {
        block5: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.stmt = null;
            this.connection = null;
            this.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEventFilter");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
            if (this.msgLogger != null) {
                this.msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
            }
            Database database = new Database("", "", "");
            database.setAutoCommit(true);
            try {
                this.connection = database.getConnection();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "SANEventFilter", (Throwable)exception);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block5;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEventFilter", (Throwable)exception);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEventFilter");
        }
    }

    private void getTECAttributes(SANEvent sANEvent) {
        Object object;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "getTECAttributes");
        }
        String string = sANEvent.serializedTEC;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getTECAttributes", "Event Filter received TEC event: " + string);
            object = "tecMessage = " + sANEvent.tecMessage + ";\n" + "tecMessageId = " + sANEvent.tecMessageId + ";\n" + "tecComponent = " + sANEvent.tecComponent + ";\n" + "tecFunction = " + sANEvent.tecFunction + ";\n" + "tecHostName = " + sANEvent.tecHostName + ";\n" + "tecIPAddress = " + sANEvent.tecIPAddress + ";\n" + "tecSeverity = " + sANEvent.tecSeverity + ".\n";
            String string2 = "Received an event with the following data:\n" + (String)object;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getTECAttributes", string2);
        }
        object = sANEvent.getTECAttributes();
        severity = null;
        eventCategory = null;
        entityType = null;
        uniqueId = null;
        severity = sANEvent.tecSeverity.toLowerCase();
        eventCategory = sANEvent.getTECEventClass();
        if (object != null) {
            entityType = (String)((Hashtable)object).get("entityType");
            uniqueId = (String)((Hashtable)object).get("uniqueId");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getTECAttributes", "severity = " + severity + " category = " + eventCategory + " type = " + entityType + " uniqueId = " + uniqueId);
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "getTECAttributes");
        }
    }

    boolean snmpTrapSuppressed(SANEvent sANEvent) {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "snmpTrapSuppressed");
        }
        this.getTECAttributes(sANEvent);
        boolean bl = this.eventSuppressed(SNMP_TRAP);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpTrapSuppressed", (Object)("suppressed = " + bl));
        }
        return bl;
    }

    boolean tecEventSuppressed(SANEvent sANEvent) {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "tecEventSuppressed");
        }
        this.getTECAttributes(sANEvent);
        boolean bl = this.eventSuppressed(TEC_EVENT);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "tecEventSuppressed", (Object)("suppressed = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean eventSuppressed(String var1_1) {
        block15: {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)SANEventFilter.className, "eventSuppressed");
            }
            var2_2 = null;
            var3_3 = false;
            var4_4 = null;
            try {
                try {
                    var5_5 = new String(" SELECT ITSANM.SANM_EVENT_FILTER.RULE_ID AS RULE_ID, ITSANM.SANM_EVENT_ACTION.NAME AS EVENT_ACTION FROM ITSANM.SANM_EVENT_FILTER, ITSANM.SANM_EVENT_ACTION  WHERE ((ITSANM.SANM_EVENT_ACTION.ID = ITSANM.SANM_EVENT_FILTER.EVENT_ACTION)  AND (ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY =  (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY =  (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY =   (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY =   (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.EVENT_TYPE =  (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_TYPE =  (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_TYPE IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.UNIQUE_ID = ?  OR (ITSANM.SANM_EVENT_FILTER.UNIQUE_ID IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE =  (SELECT ID FROM ITSANM.SANM_DEV_KEYS WHERE NAME = ?)  OR (ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE IS NULL)))  ORDER BY RULE_ID ASC");
                    if (this.stmt == null) {
                        this.stmt = this.connection.prepareStatement(var5_5);
                    }
                    if (this.stmt != null) {
                        this.stmt.setString(1, SANEventFilter.severity);
                        this.stmt.setString(2, SANEventFilter.eventCategory);
                        this.stmt.setString(3, var1_1);
                        this.stmt.setString(4, SANEventFilter.uniqueId);
                        this.stmt.setString(5, SANEventFilter.entityType);
                        var4_4 = this.stmt.executeQuery();
                        if (var4_4 != null && var4_4.next()) {
                            var2_2 = var4_4.getString("EVENT_ACTION");
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SANEventFilter.className, "eventSuppressed", "action = " + var2_2);
                            }
                            if (var2_2 != null && var2_2.equalsIgnoreCase("suppress")) {
                                var3_3 = true;
                            }
                        }
                    }
                }
                catch (Exception var5_6) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "eventSuppressed", (Throwable)var5_6);
                    if (this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventFilter.className, "eventSuppressed", (Throwable)var5_6);
                    }
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                if (var4_4 == null) throw var7_7;
                try {
                    var4_4.close();
                    throw var7_7;
                }
                catch (Exception var8_10) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "eventSuppressed", (Throwable)var8_10);
                    if (this.traceLogger == null) throw var7_7;
                    if (this.traceLogger.isLogging() == false) throw var7_7;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventFilter.className, "eventSuppressed", (Throwable)var8_10);
                }
                throw var7_7;
            }
            {
                var6_9 = null;
                if (var4_4 == null) break block15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 308->316)] { 
lbl48:
            // 1 sources

            var4_4.close();
            break block15;
lbl50:
            // 1 sources

            catch (Exception var8_11) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "eventSuppressed", (Throwable)var8_11);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block15;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventFilter.className, "eventSuppressed", (Throwable)var8_11);
            }
        }
        if (this.traceLogger == null) return var3_3;
        if (this.traceLogger.isLogging() == false) return var3_3;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SANEventFilter.className, "eventSuppressed");
        return var3_3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBResultSet executeQuery(DBPreparedStatement dBPreparedStatement) {
        String string = "executeQuery";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        int n = 3;
        boolean bl = false;
        DBResultSet dBResultSet = null;
        while (true) {
            Exception exception3;
            Object var7_9;
            if (bl || n <= 0) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                }
                if (!bl) return null;
                return dBResultSet;
            }
            dBResultSet = null;
            try {
                try {
                    dBResultSet = dBPreparedStatement.executeQuery();
                    bl = true;
                }
                catch (SQLException sQLException) {
                    if (--n == 0) {
                        sQLException.printStackTrace();
                    }
                }
                catch (Exception exception2) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception2);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception2);
                    }
                    n = 0;
                }
            }
            catch (Throwable throwable) {
                var7_9 = null;
                try {
                    this.connection.commit();
                    throw throwable;
                }
                catch (Exception exception3) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception3);
                    if (this.traceLogger == null) throw throwable;
                    if (!this.traceLogger.isLogging()) throw throwable;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception3);
                }
                throw throwable;
            }
            {
                var7_9 = null;
            }
            try {}
            catch (Exception exception3) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception3);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception3);
                continue;
            }
            this.connection.commit();
            continue;
            break;
        }
    }
}

