/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.log;

import com.ibm.log.Level;
import com.ibm.log.PDLogger;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyDataStore;
import com.ibm.log.util.MessageCatalog;
import java.io.File;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.log.ConnectorResources;

public class LogHelper {
    private static PDLogger logger = null;
    private static PDLogger tracer = null;
    private static LogManager lm = null;
    private static MessageCatalog msgCat = new MessageCatalog((ResourceBundle)new ConnectorResources());
    public static final Level INFO = Level.INFO;
    public static final Level WARN = Level.WARN;
    public static final Level ERROR = Level.ERROR;
    public static final Level MAX = Level.DEBUG_MAX;
    public static final Level MIN = Level.DEBUG_MIN;
    public static final Level MID = Level.DEBUG_MID;

    public static void log(String string, Class clazz, String string2) {
        String string3 = msgCat.getMessage(string);
        LogHelper.getLogger().text(INFO, (Object)clazz, string2, string3);
    }

    public static void log(String string, Class clazz, String string2, String string3) {
        String string4 = msgCat.getMessage(string, (Object)string3);
        LogHelper.getLogger().text(INFO, (Object)clazz, string2, string4);
    }

    public static void log(String string, Class clazz, String string2, String[] stringArray) {
        String string3 = msgCat.getMessage(string, (Object[])stringArray);
        LogHelper.getLogger().text(INFO, (Object)clazz, string2, string3);
    }

    public static void logException(Exception exception, Class clazz, String string) {
        LogHelper.getLogger().exception(ERROR, (Object)clazz, string, (Throwable)exception);
    }

    public static void logException(Exception exception, Class clazz, String string, String string2) {
        LogHelper.getLogger().exception(ERROR, (Object)clazz, string, (Throwable)exception, string2);
    }

    public static void trace(String string, Class clazz, String string2) {
        LogHelper.getTracer().text(MID, (Object)clazz, string2, string);
    }

    public static void traceException(Exception exception, Class clazz, String string) {
        LogHelper.getTracer().exception(ERROR, (Object)clazz, string, (Throwable)exception);
    }

    public static void traceEntry(Class clazz, String string) {
        LogHelper.getTracer().entry(MAX, (Object)clazz, string);
    }

    public static void traceExit(Class clazz, String string) {
        LogHelper.getTracer().exit(MAX, (Object)clazz, string);
    }

    private static PDLogger getLogger() {
        if (logger == null) {
            logger = (PDLogger)LogHelper.getLogManager().getLogger("common.log");
        }
        return logger;
    }

    private static PDLogger getTracer() {
        if (tracer == null) {
            tracer = (PDLogger)LogHelper.getLogManager().getLogger("common.trace");
        }
        return tracer;
    }

    private static LogManager getLogManager() {
        if (lm == null) {
            try {
                InputStream inputStream = LogHelper.class.getResourceAsStream("/org/eclipse/aperi/connector/log/logging.properties");
                PropertyDataStore propertyDataStore = new PropertyDataStore(inputStream);
                DataStoreConfig dataStoreConfig = propertyDataStore.getConfig("file");
                File file = new File(Constants.LOG_DIR);
                if (!file.exists()) {
                    file.mkdir();
                }
                dataStoreConfig.setProperty("fileDir", Constants.LOG_DIR);
                lm = LogManager.getManagerWithMergedDataStore((DataStore)propertyDataStore, (boolean)false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                lm = LogManager.getManager();
            }
        }
        return lm;
    }
}

