/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.PropertyDataStore;
import com.ibm.log.util.LogException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyFileDataStore
extends PropertyDataStore {
    public PropertyFileDataStore(String string) throws IOException, LogException {
        super(string);
    }

    private void getFileAndProperties(String string, Properties properties) throws IOException {
        String string2;
        this.propFileName = string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            string2 = System.getProperty("jlog.propertyFileDir");
        } else {
            try {
                string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return System.getProperty("jlog.propertyFileDir");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        if (string2 != null) {
            String string3 = string2.replace('/', File.separatorChar);
            if (!string3.endsWith(File.separator)) {
                string3 = String.valueOf(string3) + File.separator;
            }
            this.propFileName = String.valueOf(string3) + string;
        }
        this.is = new BufferedInputStream(new FileInputStream(this.propFileName));
        properties.load(this.is);
    }

    protected Properties loadProperties(String string) throws IOException, AccessControlException {
        Properties properties = new Properties();
        String string2 = string;
        this.getFileAndProperties(string2, properties);
        this.is.close();
        return properties;
    }

    public void saveConfig(boolean bl) throws Exception, AccessControlException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.propFileName, false);
        String string = "Written by " + this.getClass().getName();
        Enumeration enumeration = this.getConfig();
        while (enumeration.hasMoreElements()) {
            DataStoreConfig dataStoreConfig = (DataStoreConfig)enumeration.nextElement();
            String string2 = dataStoreConfig.getProperty("name");
            if (dataStoreConfig == this.getRoot() || !bl && !dataStoreConfig.isLoadedFromDataStore()) continue;
            Properties properties = new Properties();
            Enumeration<Object> enumeration2 = dataStoreConfig.keys();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                if (string3.equals("name")) continue;
                String string4 = String.valueOf(string2) + "." + string3;
                String string5 = (String)dataStoreConfig.get(string3);
                properties.setProperty(string4, string5);
            }
            properties.store(fileOutputStream, string);
        }
        fileOutputStream.close();
    }

    public boolean isWriteable() {
        return true;
    }
}

