/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.SerialFileHandler;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.io.File;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class BackupErrorProtocol
extends MessageErrorProtocol {
    static final long serialVersionUID = 1608895686546511054L;
    public static final int DEFAULT_CAPACITY = 100000;
    private static final String NAME_START = "backup_";
    private static final String NAME_END = ".log";
    private transient boolean cleanupRequired = false;
    public transient boolean open = false;
    private int capacity = 100000;
    private transient int discardedEventCount = 0;
    private transient int backedEventCount = 0;
    private transient SerialFileHandler backupFile = null;
    private String backupDir = null;
    private transient String backupName = null;

    public BackupErrorProtocol() {
    }

    public BackupErrorProtocol(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("backupCapacity", new Integer(this.getCapacity()).toString());
        if (this.getBackupDir() != null) {
            properties.put("backupDir", this.getBackupDir());
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("backupCapacity");
        if (string != null) {
            this.setCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("backupDir")) != null) {
            this.setBackupDir(string);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int n) {
        if (n >= 0) {
            this.capacity = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setCapacity");
            LogUtil.errorMsg(string);
        }
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(String string) {
        this.backupDir = string;
        if (this.backupDir != null) {
            this.backupDir = this.backupDir.replace('\\', File.separatorChar);
            this.backupDir = this.backupDir.replace('/', File.separatorChar);
            if (this.backupDir.charAt(this.backupDir.length() - 1) != File.separatorChar) {
                this.backupDir = String.valueOf(this.backupDir) + File.separator;
            }
        }
    }

    public void error(Handler handler, LogEvent logEvent, Throwable throwable) {
        if (this.backedEventCount == 0 && this.discardedEventCount == 0) {
            LogUtil.errorMsg(LogUtil.getLogMsg("BACKUP_ATTEMPT", handler.getName()));
        }
        if (!this.isFull()) {
            try {
                if (!this.open) {
                    this.open();
                }
                this.backupFile.write(logEvent);
                ++this.backedEventCount;
                this.cleanupRequired = true;
            }
            catch (Exception exception) {
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_WRITE_BACKUP", this.backupName, handler.getName()));
                }
                ++this.discardedEventCount;
            }
        } else {
            if (this.discardedEventCount == 0) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_BACKUP_FULL", this.backupName, handler.getName()));
            }
            ++this.discardedEventCount;
        }
    }

    public void cleanup(Handler handler) {
        Vector vector = null;
        try {
            vector = this.backupFile.readSerializedEvents();
        }
        catch (Exception exception) {
            LogUtil.errorMsg(LogUtil.getLogMsg("ERR_READ_BACKUP", this.backupName, handler.getName()));
            this.close();
        }
        if (vector != null) {
            int n = 0;
            try {
                while (n < vector.size()) {
                    handler.write((LogEvent)vector.elementAt(n));
                    --this.backedEventCount;
                    ++n;
                }
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_0", handler.getName()));
                } else if (this.discardedEventCount == 1) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_1", handler.getName()));
                } else {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_2", handler.getName(), new Integer(this.discardedEventCount)));
                }
                this.discardedEventCount = 0;
                this.close();
                this.backupFile.deleteLog();
            }
            catch (Exception exception) {
                this.close();
                this.backupFile.deleteLog();
                try {
                    this.open();
                    int n2 = n;
                    while (n2 < vector.size()) {
                        LogEvent logEvent = (LogEvent)vector.elementAt(n2);
                        this.backupFile.write(logEvent);
                        ++this.backedEventCount;
                        ++n2;
                    }
                    this.cleanupRequired = true;
                }
                catch (Exception exception2) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_WRITE_BACKUP", this.backupName, handler.getName()));
                    this.close();
                }
            }
        }
    }

    public boolean isCleanupRequired() {
        return this.cleanupRequired;
    }

    protected synchronized boolean isFull() {
        return this.backedEventCount >= this.capacity && this.capacity != 0;
    }

    protected void open() throws Exception {
        Random random = new Random();
        while (!this.open) {
            String string = this.getBackupDir();
            this.backupName = string != null ? string : "";
            int n = random.nextInt();
            if (n < 0) {
                n = -n;
            }
            this.backupName = String.valueOf(this.backupName) + NAME_START + new Integer(n).toString() + NAME_END;
            File file = new File(this.backupName);
            if (file.exists()) continue;
            if (this.backupFile == null) {
                this.backupFile = new SerialFileHandler();
                this.backupFile.setMaxFiles(1);
            }
            this.backupFile.setFileName(this.backupName);
            this.backupFile.open();
            this.open = true;
        }
    }

    protected void close() {
        if (this.backupFile != null) {
            this.backupFile.close();
        }
        this.open = false;
        this.cleanupRequired = false;
        this.backedEventCount = 0;
        this.discardedEventCount = 0;
    }
}

