/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control.storagesubsystem;

import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.Controller;
import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.data.storagesubsystem.Pool;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.interfaces.IController;

public class StorageSubsystemController
extends Controller
implements IStorageSubsystemControl {
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.storagesubsystem.StorageSubsystemController");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public StorageSubsystemController() {
        this.controllerThreadPool = new ThreadPool(5);
    }

    public StorageSubsystemController(ControlEngine controlEngine) {
        this();
        this.ce = controlEngine;
    }

    private StorageSubsystemController(ControlEngine controlEngine, Token token, Method method, Object[] objectArray) {
        this.ce = controlEngine;
        this.token = token;
        this.m = method;
        this.args = objectArray;
    }

    public Controller createController(ControlEngine controlEngine, Token token, Method method, Object[] objectArray) {
        return new StorageSubsystemController(controlEngine, token, method, objectArray);
    }

    public String[] getAsyncMethodNames() {
        return new String[]{"createStorageVolumes", "deleteStorageVolumes", "assignStorageVolumesToWWPNs", "unassignStorageVolumesFromWWPNs", "modifyStorageVolumeSize", "createSVCDisks", "modifyStoragePoolSize"};
    }

    public String[] getNonPersistedTopLevelJobAPIMethodNames() {
        return new String[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createStorageVolumes(CreateStorageVolumesParameter[] createStorageVolumesParameterArray) throws NotAvailableException {
        String string = "createStorageVolumes";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{createStorageVolumesParameterArray});
        AsyncResult asyncResult = new AsyncResult(-1, -1);
        ExecGroup execGroup = null;
        try {
            try {
                execGroup = DiskThreadManager.getExecutionGroup();
                Long[] longArray = new Long[createStorageVolumesParameterArray.length];
                int n = 0;
                while (true) {
                    if (n >= createStorageVolumesParameterArray.length) break;
                    IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)createStorageVolumesParameterArray[n]);
                    createStorageVolumesParameterArray[n].setToken(this.getToken());
                    Object[] objectArray = new Object[]{createStorageVolumesParameterArray[n]};
                    DiskManager.registerSubsystemDataInUse(createStorageVolumesParameterArray[n].getStorageSubsystemID());
                    longArray[n] = execGroup.executeAsSubJob((Object)iStorageConfigurationPlugin, string, objectArray, logTraceHelper, (IController)this, createStorageVolumesParameterArray[n].getStoragePoolCIMOPs().length);
                    ++n;
                }
                asyncResult.setStatus(2);
                execGroup.waitForCompletion(0L);
                Vector<AsyncResult> vector = new Vector<AsyncResult>();
                int n2 = 0;
                while (true) {
                    if (n2 >= longArray.length) {
                        AsyncResult[] asyncResultArray = vector.toArray(new AsyncResult[vector.size()]);
                        asyncResult = ResultHelper.computeAndSetFinalStatus((AsyncResult[])asyncResultArray, (String)string);
                    }
                    DiskManager.deregisterSubsystemDataInUse(createStorageVolumesParameterArray[n2].getStorageSubsystemID());
                    vector.add(execGroup.getExecutionResultInSubJob(longArray[n2], (IController)this, logTraceHelper));
                    ++n2;
                }
            }
            catch (Exception exception) {
                asyncResult.setStatus(0);
                logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            execGroup.clear();
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        execGroup.clear();
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult deleteStorageVolumes(DeleteStorageVolumesParameter[] deleteStorageVolumesParameterArray) throws NotAvailableException {
        String string = "deleteStorageVolumes";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{deleteStorageVolumesParameterArray});
        AsyncResult asyncResult = new AsyncResult(-1, -1);
        ExecGroup execGroup = null;
        try {
            try {
                execGroup = DiskThreadManager.getExecutionGroup();
                Long[] longArray = new Long[deleteStorageVolumesParameterArray.length];
                int n = 0;
                while (true) {
                    if (n >= deleteStorageVolumesParameterArray.length) break;
                    IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)deleteStorageVolumesParameterArray[n]);
                    deleteStorageVolumesParameterArray[n].setToken(this.getToken());
                    Object[] objectArray = new Object[]{deleteStorageVolumesParameterArray[n]};
                    DiskManager.registerSubsystemDataInUse(deleteStorageVolumesParameterArray[n].getStorageSubsystemID());
                    longArray[n] = execGroup.executeAsSubJob((Object)iStorageConfigurationPlugin, "deleteStorageVolumes", objectArray, logTraceHelper, (IController)this, deleteStorageVolumesParameterArray[n].getStorageVolumeCIMOPs().length);
                    ++n;
                }
                asyncResult.setStatus(2);
                execGroup.waitForCompletion(0L);
                Vector<AsyncResult> vector = new Vector<AsyncResult>();
                int n2 = 0;
                while (true) {
                    if (n2 >= longArray.length) {
                        AsyncResult[] asyncResultArray = vector.toArray(new AsyncResult[vector.size()]);
                        asyncResult = ResultHelper.computeAndSetFinalStatus((AsyncResult[])asyncResultArray, (String)string);
                    }
                    DiskManager.deregisterSubsystemDataInUse(deleteStorageVolumesParameterArray[n2].getStorageSubsystemID());
                    vector.add(execGroup.getExecutionResultInSubJob(longArray[n2], (IController)this, logTraceHelper));
                    ++n2;
                }
            }
            catch (Exception exception) {
                asyncResult.setStatus(0);
                logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            execGroup.clear();
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        execGroup.clear();
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    public AsyncResult createPool(String string, long l, Pool pool, Pool pool2, Pool pool3) throws NotAvailableException {
        return new AsyncResult(0, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStorageVolumeSize(ModifyStorageVolumeParameter modifyStorageVolumeParameter) throws NotAvailableException {
        String string = "modifyStorageVolumeSize";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{modifyStorageVolumeParameter});
        AsyncResult asyncResult = new AsyncResult(-1, -1);
        modifyStorageVolumeParameter.setToken(this.getToken());
        try {
            try {
                IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)modifyStorageVolumeParameter);
                Object[] objectArray = new Object[]{modifyStorageVolumeParameter};
                asyncResult = (AsyncResult)DiskThreadManager.executeWithTimeLimit((Object)iStorageConfigurationPlugin, (String)"modifyStorageVolumeSize", (Object[])objectArray, (long)0L, (LogTraceHelper)logTraceHelper);
            }
            catch (Exception exception) {
                asyncResult.setStatus(0);
                logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createSVCDisks(CreateSVCStorageVolumesParameter[] createSVCStorageVolumesParameterArray) throws NotAvailableException {
        AsyncResult asyncResult;
        LogTraceHelper logTraceHelper;
        block10: {
            String string = "createSVCDisks";
            logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{createSVCStorageVolumesParameterArray});
            asyncResult = new AsyncResult(-1, -1);
            ExecGroup execGroup = null;
            try {
                try {
                    IStorageConfigurationPlugin iStorageConfigurationPlugin;
                    execGroup = DiskThreadManager.getExecutionGroup();
                    Long[] longArray = new Long[createSVCStorageVolumesParameterArray.length];
                    int n = 0;
                    while (true) {
                        if (n >= createSVCStorageVolumesParameterArray.length) break;
                        iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)createSVCStorageVolumesParameterArray[n]);
                        createSVCStorageVolumesParameterArray[n].setToken(this.getToken());
                        Object[] objectArray = new Object[]{createSVCStorageVolumesParameterArray[n]};
                        DiskManager.registerSubsystemDataInUse(createSVCStorageVolumesParameterArray[n].getStorageSubsystemID());
                        longArray[n] = execGroup.executeAsSubJob((Object)iStorageConfigurationPlugin, "createSVCVDisks", objectArray, logTraceHelper, (IController)this, createSVCStorageVolumesParameterArray[n].getMDiskGroups().length);
                        ++n;
                    }
                    asyncResult.setStatus(2);
                    execGroup.waitForCompletion(0L);
                    n = 0;
                    while (true) {
                        block11: {
                            if (n < longArray.length) break block11;
                            asyncResult = ResultHelper.computeAndSetFinalStatus((AsyncResult)asyncResult, (String)string);
                            break;
                        }
                        DiskManager.deregisterSubsystemDataInUse(createSVCStorageVolumesParameterArray[n].getStorageSubsystemID());
                        iStorageConfigurationPlugin = execGroup.getExecutionResultInSubJob(longArray[n], (IController)this, logTraceHelper);
                        if (iStorageConfigurationPlugin.getSubJobResults() != null) {
                            ResultHelper.addAsyncSubResults((AsyncResult)asyncResult, (AsyncResult[])iStorageConfigurationPlugin.getSubJobResults());
                        }
                        ++n;
                    }
                }
                catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                    logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                    throw DiskMessageHelper.getServerException((String)"HWN021652E", null, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                }
                catch (DiskManagerExecException diskManagerExecException) {
                    logTraceHelper.traceError("Internal error: DiskManagerExecException", (Throwable)diskManagerExecException);
                    throw DiskMessageHelper.getServerException((String)"HWN021653E", null, (Throwable)diskManagerExecException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (execGroup != null) {
                    execGroup.clear();
                }
                logTraceHelper.exit((Object)asyncResult);
                throw throwable;
            }
            {
                Object var10_14 = null;
                if (execGroup == null) break block10;
            }
            execGroup.clear();
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStoragePoolSize(ModifyStoragePoolParameter modifyStoragePoolParameter) throws NotAvailableException {
        String string = "modifyStoragePoolSize";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{modifyStoragePoolParameter});
        AsyncResult asyncResult = new AsyncResult(10001, -1);
        modifyStoragePoolParameter.setToken(this.getToken());
        try {
            try {
                ExecGroup execGroup = DiskThreadManager.getExecutionGroup();
                IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)modifyStoragePoolParameter);
                Object[] objectArray = new Object[]{modifyStoragePoolParameter};
                DiskManager.registerSubsystemDataInUse(modifyStoragePoolParameter.getStorageSubsystemID());
                Long l = execGroup.executeAsSubJob((Object)iStorageConfigurationPlugin, "modifyStoragePoolSize", objectArray, logTraceHelper, (IController)this, 1);
                asyncResult.setStatus(2);
                execGroup.waitForCompletion(0L);
                DiskManager.deregisterSubsystemDataInUse(modifyStoragePoolParameter.getStorageSubsystemID());
                asyncResult = (AsyncResult)execGroup.getExecutionResult(l);
                this.endSubJob(0, asyncResult.getRc(), asyncResult.getStatus(), asyncResult.getSRMMessage(), null, asyncResult.getResults());
            }
            catch (Exception exception) {
                asyncResult.setStatus(0);
                this.endSubJob(0, asyncResult.getRc(), asyncResult.getStatus(), asyncResult.getSRMMessage(), exception, null);
                logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    public AsyncResult deletePool(Pool pool) throws NotAvailableException {
        System.out.println("Doing deletePool");
        return new AsyncResult(0, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult assignStorageVolumesToWWPNs(ConfigurationParameter[] configurationParameterArray) throws ServerException {
        String string = "assignStorageVolumesToWWPNs";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[]{configurationParameterArray});
        AsyncResult asyncResult = null;
        try {
            int[] nArray = this.getNumberOfSubJobsForMapping((AssignmentParameter[])configurationParameterArray);
            asyncResult = this.executeMethod(string, configurationParameterArray, nArray);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    private int[] getNumberOfSubJobsForMapping(AssignmentParameter[] assignmentParameterArray) {
        int[] nArray = new int[assignmentParameterArray.length];
        int n = 0;
        while (n < assignmentParameterArray.length) {
            assignmentParameterArray[n].setToken(this.getToken());
            nArray[n] = assignmentParameterArray[n].getVolumeIDs().length * assignmentParameterArray[n].getInitiatorWWPNs().size();
            ++n;
        }
        return nArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(ConfigurationParameter[] configurationParameterArray) throws ServerException {
        String string = "unassignStorageVolumesFromWWPNs";
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)string, (Object[])new Object[0]);
        AsyncResult asyncResult = null;
        try {
            int[] nArray = this.getNumberOfSubJobsForMapping((AssignmentParameter[])configurationParameterArray);
            asyncResult = this.executeMethod(string, configurationParameterArray, nArray);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit(asyncResult);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AsyncResult executeMethod(String string, ConfigurationParameter[] configurationParameterArray, int[] nArray) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)"executeMethod", (Object[])new Object[]{string, configurationParameterArray});
        AsyncResult asyncResult = new AsyncResult(-1, -1);
        asyncResult.setSubJobResults(new AsyncResult[0]);
        ExecGroup execGroup = null;
        try {
            AsyncResult asyncResult2;
            block8: {
                try {
                    IStorageConfigurationPlugin iStorageConfigurationPlugin;
                    execGroup = DiskThreadManager.getExecutionGroup();
                    Long[] longArray = new Long[configurationParameterArray.length];
                    int n = 0;
                    while (n < configurationParameterArray.length) {
                        asyncResult.setSubJobResults(new AsyncResult[0]);
                        configurationParameterArray[n].setToken(this.getToken());
                        iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin(configurationParameterArray[n]);
                        DiskManager.registerSubsystemDataInUse(configurationParameterArray[n].getStorageSubsystemID());
                        longArray[n] = execGroup.executeAsSubJob((Object)iStorageConfigurationPlugin, string, new Object[]{configurationParameterArray[n]}, logTraceHelper, (IController)this, nArray[n]);
                        ++n;
                    }
                    asyncResult.setStatus(2);
                    execGroup.waitForCompletion(0L);
                    n = 0;
                    while (n < longArray.length) {
                        DiskManager.deregisterSubsystemDataInUse(configurationParameterArray[n].getStorageSubsystemID());
                        iStorageConfigurationPlugin = execGroup.getExecutionResultInSubJob(longArray[n], (IController)this, logTraceHelper);
                        ResultHelper.addAsyncSubResults((AsyncResult)asyncResult, (AsyncResult[])iStorageConfigurationPlugin.getSubJobResults());
                        ++n;
                    }
                    asyncResult2 = asyncResult = ResultHelper.computeAndSetFinalStatus((AsyncResult)asyncResult, (String)string);
                    Object var10_13 = null;
                    if (execGroup == null) break block8;
                }
                catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                    logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                    throw DiskMessageHelper.getServerException((String)"HWN021652E", null, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                }
                catch (DiskManagerExecException diskManagerExecException) {
                    logTraceHelper.traceError("Internal error: DiskManagerExecException", (Throwable)diskManagerExecException);
                    throw DiskMessageHelper.getServerException((String)"HWN021653E", null, (Throwable)diskManagerExecException, (LogTraceHelper)logTraceHelper);
                }
                execGroup.clear();
            }
            this.closeCimClients(configurationParameterArray);
            logTraceHelper.exit((Object)asyncResult);
            return asyncResult2;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (execGroup != null) {
                execGroup.clear();
            }
            this.closeCimClients(configurationParameterArray);
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
    }

    private void closeCimClients(ConfigurationParameter[] configurationParameterArray) {
        int n = 0;
        while (n < configurationParameterArray.length) {
            if (configurationParameterArray[n].getCIMClientWrapper() != null) {
                CIMClientPool.returnClient((CIMClientWrapper)configurationParameterArray[n].getCIMClientWrapper());
            }
            ++n;
        }
    }

    public int startSubJob(String string, boolean bl) {
        return super.startSubJob(string, bl);
    }

    public boolean endSubJob(int n, int n2, int n3, SRMMessage sRMMessage, Exception exception, Object[] objectArray) {
        return super.endSubJob(n, n2, n3, sRMMessage, exception, objectArray);
    }

    protected Class getProxyInterfaceClass() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }
}

