/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.birt.core.archive.compound.AllocationTable;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.util.IOUtil;

class EntryTable {
    static final int FIRST_ENTRY_BLOCK = 2;
    protected int totalSlots;
    protected HashMap entries;
    protected AllocationTable.Entry index;
    protected ArchiveFile af;
    static final int ENTRY_SLOT_SIZE = 128;
    static final int ENTRY_USED_SLOT_OFFSET = 0;
    static final int ENTRY_LENGTH_OFFSET = 4;
    static final int ENTRY_BLOCK_OFFSET = 12;
    static final int ENTRY_NAME_OFFSET = 16;

    private EntryTable(ArchiveFile af) throws IOException {
        this.af = af;
        this.totalSlots = 0;
        this.entries = new HashMap();
        this.index = af.allocTbl.loadEntry(2);
    }

    static EntryTable loadTable(ArchiveFile af) throws IOException {
        EntryTable table = new EntryTable(af);
        table.loadEntries();
        return table;
    }

    static EntryTable createTable(ArchiveFile af) throws IOException {
        EntryTable table = new EntryTable(af);
        table.initEntries();
        return table;
    }

    private void loadEntries() throws IOException {
        this.totalSlots = 0;
        while (true) {
            Entry entry = new Entry(this.totalSlots);
            entry.read();
            int usedSlots = entry.getUsedSlots();
            if (usedSlots == 0) {
                ++this.totalSlots;
                continue;
            }
            if (usedSlots == -1) break;
            this.entries.put(entry.getName(), entry);
            this.totalSlots += usedSlots;
        }
    }

    private void initEntries() throws IOException {
        this.totalSlots = 0;
        this.setUsedSlots(0, -1);
    }

    void removeEntry(Entry entry) throws IOException {
        this.entries.remove(entry.getName());
        int slotId = entry.getSlotID();
        int usedSlots = entry.getUsedSlots();
        for (int i = 0; i < usedSlots; ++i) {
            this.setUsedSlots(slotId + i, 0);
        }
    }

    Entry createEntry(String name) throws IOException {
        Entry entry = (Entry)this.entries.get(name);
        if (entry != null) {
            entry.setLength(0L);
            return entry;
        }
        this.ensureSlots(this.totalSlots + 1);
        entry = new Entry(this.totalSlots, name);
        entry.write();
        this.totalSlots += entry.getUsedSlots();
        this.setUsedSlots(this.totalSlots, -1);
        this.entries.put(name, entry);
        return entry;
    }

    Entry findEntry(String name) throws IOException {
        return (Entry)this.entries.get(name);
    }

    Collection listEntries() {
        return this.entries.values();
    }

    private void ensureSlots(int slotSize) throws IOException {
        long offset = (long)(slotSize + 1) * 128L;
        int blockCount = (int)((offset + 4096L - 1L) / 4096L);
        int totalBlock = this.index.getTotalBlocks();
        if (blockCount > totalBlock) {
            int increaseCount = blockCount - totalBlock + 1;
            this.index.allocBlocks(increaseCount);
        }
    }

    private void setUsedSlots(int slotId, int usedSlots) throws IOException {
        this.ensureSlots(slotId + 1);
        long offset = slotId * 128 + 0;
        int blkId = (int)(offset / 4096L);
        int blkOff = (int)(offset % 4096L);
        int phyBlk = this.index.getBlock(blkId);
        byte[] b = new byte[4];
        IOUtil.integerToBytes(usedSlots, b);
        this.af.write(phyBlk, blkOff, b, 0, 4);
    }

    void readSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / 4096L);
        int blkOff = (int)(offset % 4096L);
        int phyBlk = this.index.getBlock(blkId);
        this.af.read(phyBlk, blkOff, b, off, 128);
    }

    void writeSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / 4096L);
        int blkOff = (int)(offset % 4096L);
        int phyBlk = this.index.getBlock(blkId);
        int size = b.length - off;
        if (size > 128) {
            size = 128;
        }
        this.af.write(phyBlk, blkOff, b, off, size);
    }

    class Entry {
        private int slotId;
        private int usedSlots;
        private long length;
        private int firstBlock;
        private String name;

        private Entry(int slotId) {
            this.slotId = slotId;
            this.name = null;
            this.usedSlots = 0;
            this.firstBlock = -1;
            this.length = 0L;
        }

        private Entry(int slotId, String name) {
            this.slotId = slotId;
            this.name = name;
            this.usedSlots = 0;
            this.firstBlock = -1;
            this.length = 0L;
        }

        void read() throws IOException {
            byte[] b = new byte[128];
            EntryTable.this.readSlot(this.slotId, b, 0);
            this.usedSlots = IOUtil.bytesToInteger(b);
            if (this.usedSlots <= 0) {
                return;
            }
            if (this.usedSlots > 1) {
                byte[] nb = new byte[128 * this.usedSlots];
                System.arraycopy(b, 0, nb, 0, 128);
                for (int i = 1; i < this.usedSlots; ++i) {
                    EntryTable.this.readSlot(this.slotId + i, nb, i * 128);
                }
                b = nb;
            }
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(b));
            is.skipBytes(4);
            this.length = is.readLong();
            this.firstBlock = is.readInt();
            this.name = is.readUTF();
        }

        void write() throws IOException {
            ByteArrayOutputStream buff = new ByteArrayOutputStream(128);
            DataOutputStream os = new DataOutputStream(buff);
            os.writeInt(1);
            os.writeLong(this.length);
            os.writeInt(this.firstBlock);
            os.writeUTF(this.name);
            byte[] b = buff.toByteArray();
            this.usedSlots = (b.length + 128 - 1) / 128;
            if (this.usedSlots != 1) {
                IOUtil.integerToBytes(this.usedSlots, b);
            }
            for (int i = 0; i < this.usedSlots; ++i) {
                EntryTable.this.writeSlot(this.slotId + i, b, i * 128);
            }
        }

        int getSlotID() {
            return this.slotId;
        }

        int getUsedSlots() {
            return this.usedSlots;
        }

        String getName() {
            return this.name;
        }

        long getLength() {
            return this.length;
        }

        void setLength(long length) throws IOException {
            long offset = this.slotId * 128 + 4;
            int blkId = (int)(offset / 4096L);
            int blkOff = (int)(offset % 4096L);
            int phyBlk = EntryTable.this.index.getBlock(blkId);
            byte[] b = new byte[8];
            IOUtil.longToBytes(length, b);
            EntryTable.this.af.write(phyBlk, blkOff, b, 0, 8);
            this.length = length;
        }

        int getBlock() {
            return this.firstBlock;
        }

        void setBlock(int blockId) throws IOException {
            long offset = this.slotId * 128 + 12;
            int blkId = (int)(offset / 4096L);
            int blkOff = (int)(offset % 4096L);
            int phyBlk = EntryTable.this.index.getBlock(blkId);
            byte[] b = new byte[4];
            IOUtil.integerToBytes(blockId, b);
            EntryTable.this.af.write(phyBlk, blkOff, b, 0, 4);
            this.firstBlock = blockId;
        }
    }
}

