/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class IOUtil {
    public static final int INT_LENGTH = 4;
    public static final int RA_STREAM_BUFFER_LENGTH = 8192;
    public static final int MAX_NUMBER_OF_STREAM_BUFFER = 128;
    private static Map type2IndexMap;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_FLOAT = 2;
    private static final int TYPE_DOUBLE = 3;
    private static final int TYPE_BIG_DECIMAL = 4;
    private static final int TYPE_DATE = 5;
    private static final int TYPE_TIME = 6;
    private static final int TYPE_TIME_STAMP = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_BYTES = 10;
    private static final int TYPE_LIST = 11;
    private static final int TYPE_MAP = 12;
    private static final int TYPE_SERIALIZABLE = 13;
    private static final int TYPE_JSObject = 14;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final short readShort(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        return (short)((ch1 << 8) + ch2);
    }

    public static final void writeShort(OutputStream outputStream, short value) throws IOException {
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        int ch3 = inputStream.read();
        int ch4 = inputStream.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final void writeInt(OutputStream outputStream, int value) throws IOException {
        outputStream.write(value >>> 24 & 0xFF);
        outputStream.write(value >>> 16 & 0xFF);
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int getInt(byte[] bytes) {
        if (!$assertionsDisabled && bytes.length != 4) {
            throw new AssertionError();
        }
        int ch1 = bytes[0] & 0xFF;
        int ch2 = bytes[1] & 0xFF;
        int ch3 = bytes[2] & 0xFF;
        int ch4 = bytes[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final int bytesToInteger(byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final boolean readBool(InputStream inputStream) throws IOException {
        return inputStream.read() != 0;
    }

    public static final void writeBool(OutputStream outputStream, boolean bool) throws IOException {
        outputStream.write(!bool ? 0 : 1);
    }

    public static final float readFloat(DataInputStream inputStream) throws IOException {
        return inputStream.readFloat();
    }

    public static final void writeFloat(DataOutputStream outputStream, float value) throws IOException {
        outputStream.writeFloat(value);
    }

    public static final double readDouble(DataInputStream inputStream) throws IOException {
        return inputStream.readDouble();
    }

    public static final void writeDouble(DataOutputStream outputStream, double value) throws IOException {
        outputStream.writeDouble(value);
    }

    public static final long readLong(DataInputStream inputStream) throws IOException {
        return inputStream.readLong();
    }

    public static final void writeLong(DataOutputStream outputStream, long value) throws IOException {
        outputStream.writeLong(value);
    }

    public static final void writeRawBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (!$assertionsDisabled && bytes == null) {
            throw new AssertionError();
        }
        dos.write(bytes);
    }

    private static int getTypeIndex(Object obValue) {
        if (obValue == null) {
            return 0;
        }
        Integer indexOb = (Integer)type2IndexMap.get(obValue.getClass());
        if (indexOb == null) {
            if (obValue instanceof Map) {
                return 12;
            }
            if (obValue instanceof List) {
                return 11;
            }
            if (obValue instanceof Scriptable) {
                return 14;
            }
            if (obValue instanceof Serializable) {
                return 13;
            }
            return -1;
        }
        return indexOb;
    }

    public static final Object readObject(DataInputStream dis) throws IOException {
        int typeIndex = IOUtil.readInt(dis);
        Object obValue = null;
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                obValue = new Integer(dis.readInt());
                break;
            }
            case 2: {
                obValue = new Float(dis.readFloat());
                break;
            }
            case 3: {
                obValue = new Double(dis.readDouble());
                break;
            }
            case 4: {
                obValue = new BigDecimal(dis.readUTF());
                break;
            }
            case 5: {
                obValue = new Date(dis.readLong());
                break;
            }
            case 6: {
                obValue = new Time(dis.readLong());
                break;
            }
            case 7: {
                obValue = new Timestamp(dis.readLong());
                break;
            }
            case 8: {
                obValue = new Boolean(dis.readBoolean());
                break;
            }
            case 9: {
                obValue = dis.readUTF();
                break;
            }
            case 10: {
                int len = IOUtil.readInt(dis);
                byte[] bytes = new byte[len];
                if (len > 0) {
                    dis.readFully(bytes);
                }
                obValue = bytes;
                break;
            }
            case 11: {
                obValue = IOUtil.readList(dis);
                break;
            }
            case 12: {
                obValue = IOUtil.readMap(dis);
                break;
            }
            case 13: {
                int len = IOUtil.readInt(dis);
                if (len == 0) break;
                byte[] bytes = new byte[len];
                dis.readFully(bytes);
                try {
                    ObjectInputStream oo = new ObjectInputStream(new ByteArrayInputStream(bytes));
                    obValue = oo.readObject();
                }
                catch (Exception ex) {}
                break;
            }
            case 14: {
                Object ob = IOUtil.readObject(dis);
                obValue = JavascriptEvalUtil.convertToJavascriptValue(ob);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return obValue;
    }

    public static final void writeObject(DataOutputStream dos, Object obValue) throws IOException {
        int typeIndex = IOUtil.getTypeIndex(obValue);
        if (typeIndex == -1) {
            IOUtil.writeInt(dos, 0);
            throw new IOException("Data type of " + obValue.getClass().toString() + " is not supported to be serialized");
        }
        IOUtil.writeInt(dos, typeIndex);
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                dos.writeInt((Integer)obValue);
                break;
            }
            case 2: {
                dos.writeFloat(((Float)obValue).floatValue());
                break;
            }
            case 3: {
                dos.writeDouble((Double)obValue);
                break;
            }
            case 4: {
                dos.writeUTF(((BigDecimal)obValue).toString());
                break;
            }
            case 5: {
                dos.writeLong(((Date)obValue).getTime());
                break;
            }
            case 6: {
                dos.writeLong(((Time)obValue).getTime());
                break;
            }
            case 7: {
                dos.writeLong(((Timestamp)obValue).getTime());
                break;
            }
            case 8: {
                dos.writeBoolean((Boolean)obValue);
                break;
            }
            case 9: {
                dos.writeUTF(obValue.toString());
                break;
            }
            case 10: {
                byte[] bytes = (byte[])obValue;
                int length = bytes.length;
                IOUtil.writeInt(dos, length);
                if (length <= 0) break;
                dos.write(bytes);
                break;
            }
            case 11: {
                IOUtil.writeList(dos, (List)obValue);
                break;
            }
            case 12: {
                IOUtil.writeMap(dos, (Map)obValue);
                break;
            }
            case 13: {
                byte[] bytes = null;
                try {
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    ObjectOutputStream oo = new ObjectOutputStream(buff);
                    oo.writeObject(obValue);
                    oo.close();
                    bytes = buff.toByteArray();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (bytes == null || bytes.length == 0) {
                    IOUtil.writeInt(dos, 0);
                    break;
                }
                IOUtil.writeInt(dos, bytes.length);
                dos.write(bytes);
                break;
            }
            case 14: {
                if (obValue instanceof IdScriptableObject) {
                    IdScriptableObject jsObject = (IdScriptableObject)obValue;
                    if (jsObject.getClassName().equals("Date")) {
                        Date date = (Date)JavascriptEvalUtil.convertJavascriptValue(obValue);
                        IOUtil.writeObject(dos, date);
                        break;
                    }
                    IOUtil.writeObject(dos, null);
                    break;
                }
                if (obValue instanceof NativeJavaObject) {
                    obValue = JavascriptEvalUtil.convertJavascriptValue(obValue);
                    IOUtil.writeObject(dos, obValue);
                    break;
                }
                IOUtil.writeObject(dos, null);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public static final String readString(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        return dis.readUTF();
    }

    public static final void writeString(DataOutputStream dos, String str) throws IOException {
        if (str == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 9);
        dos.writeUTF(str);
    }

    public static final byte[] readBytes(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        int size = IOUtil.readInt(dis);
        byte[] bytes = new byte[size];
        if (size != 0) {
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static final void writeBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (bytes == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 10);
        int size = bytes.length;
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        dos.write(bytes);
    }

    public static final List readList(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataList;
        }
        for (int i = 0; i < size; ++i) {
            dataList.add(IOUtil.readObject(dis));
        }
        return dataList;
    }

    public static final void writeList(DataOutputStream dos, List list) throws IOException {
        if (list == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 12);
        int size = list.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IOUtil.writeObject(dos, list.get(i));
        }
    }

    public static final Map readMap(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataMap;
        }
        for (int i = 0; i < size; ++i) {
            Object key = IOUtil.readObject(dis);
            Object value = IOUtil.readObject(dis);
            dataMap.put(key, value);
        }
        return dataMap;
    }

    public static final void writeMap(DataOutputStream dos, Map map) throws IOException {
        if (map == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 12);
        int size = map.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            IOUtil.writeObject(dos, key);
            IOUtil.writeObject(dos, value);
        }
    }

    static {
        $assertionsDisabled = !IOUtil.class.desiredAssertionStatus();
        type2IndexMap = new HashMap();
        type2IndexMap.put(Integer.class, new Integer(1));
        type2IndexMap.put(Float.class, new Integer(2));
        type2IndexMap.put(Double.class, new Integer(3));
        type2IndexMap.put(BigDecimal.class, new Integer(4));
        type2IndexMap.put(Date.class, new Integer(5));
        type2IndexMap.put(Time.class, new Integer(6));
        type2IndexMap.put(Timestamp.class, new Integer(7));
        type2IndexMap.put(Boolean.class, new Integer(8));
        type2IndexMap.put(String.class, new Integer(9));
        type2IndexMap.put([B.class, new Integer(10));
        type2IndexMap.put(List.class, new Integer(11));
        type2IndexMap.put(Map.class, new Integer(12));
        type2IndexMap.put(Serializable.class, new Integer(13));
        type2IndexMap.put(null, new Integer(0));
        type2IndexMap.put(IdScriptableObject.class, new Integer(14));
    }
}

