/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.xmsg.MessageLog;

public class HostPathAdjuster
extends ReportDataAdjuster {
    private static final int HOST = 0;
    private static final int OS_TYPE = 1;
    private static final int PATH = 2;
    private static final String[] columnNameMsgIDs = new String[]{"SAG0018L", "STG1108L", "STG1219L"};
    private String[] columnNames;
    private int[] rendererArray;
    private Share[] dataArray;

    public void adjust(Object[] objectArray, boolean bl) {
        this.columnNames = new String[columnNameMsgIDs.length];
        int n = 0;
        while (n < columnNameMsgIDs.length) {
            this.columnNames[n] = MessageLog.getMessageNoID(columnNameMsgIDs[n]);
            ++n;
        }
        this.rendererArray = new int[this.columnNames.length];
        this.dataArray = (Share[])objectArray;
    }

    public String[] getLabels() {
        return this.columnNames;
    }

    public int getNumberRows() {
        return this.dataArray.length;
    }

    public int getNumberColumns() {
        return columnNameMsgIDs.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getCellData(int n, int n2) {
        Share share = this.dataArray[n];
        String string = null;
        switch (n2) {
            case 0: {
                string = share.shComputerName;
                break;
            }
            case 1: {
                if (share.shResourceType == 0) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                if (share.shPath.startsWith("HP")) {
                    string = MessageLog.getMessageNoID(Constants.OSTYPES[18]);
                    break;
                }
                string = MessageLog.getMessageNoID(Constants.OSTYPES[share.shResourceType]);
                break;
            }
            case 2: {
                string = share.shPath;
            }
        }
        return string;
    }

    public boolean hasTotalsRow() {
        return false;
    }
}

