/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.common.LunWWNAdjuster;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class LunWWNTable
extends JPanel
implements GuiRequestor {
    private MegaTable lunWWNTable = new MegaTable();
    private GuiReportReq grr;
    private Lun[] lunArray;
    private LunWWNAdjuster adjuster;
    private ReportingDDI ddi;

    public LunWWNTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new LunWWNAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        this.setLayout(new BorderLayout());
        if (s <= 4) {
            this.lunArray = (Lun[])response.responseData;
        }
        int n = 0;
        if (this.lunArray != null) {
            n = this.lunArray.length;
        }
        if (n == 0) {
            if (this.ddi != null) {
                this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            } else {
                this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            }
            return;
        }
        this.adjuster.adjust(this.lunArray, false);
        this.lunArray = (Lun[])this.adjuster.getArray();
        this.lunWWNTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lunWWNTable.setMouseListener(new SelectionListener());
        try {
            clazz3 = Class.forName("org.eclipse.aperi.common.MutableInteger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.lunWWNTable.setCellRenderer(clazz3, TableCellRenderers.number);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.common.MutableLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.lunWWNTable.setCellRenderer(clazz2, TableCellRenderers.space);
        try {
            clazz = Class.forName("java.util.Date");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.lunWWNTable.setCellRenderer(clazz, TableCellRenderers.date);
        this.lunWWNTable.setRowIcon(10, true);
        if (this.adjuster.frozenRows > 0) {
            this.lunWWNTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lunWWNTable.setBaseTableModel(new LunWWNTableModel());
        this.lunWWNTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.add((Component)this.lunWWNTable, "Center");
        if (this.ddi != null) {
            this.ddi.addRowCount(this.adjuster);
        }
    }

    private class LunWWNTableModel
    extends BaseTableModel {
        LunWWNTableModel() {
            this.columnNames = ((LunWWNTable)LunWWNTable.this).adjuster.colNames;
            this.rowCount = LunWWNTable.this.lunArray.length;
            this.commonAdjuster = LunWWNTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return LunWWNTable.this.adjuster.getCellData(n, LunWWNTable.this.adjuster.translateColumn(n2));
        }
    }

    public class SelectionListener
    extends TJCTableMouseAdapter {
        public boolean select(int n, int n2) {
            return n >= ((LunWWNTable)LunWWNTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int n, int n2) {
            if (n >= ((LunWWNTable)LunWWNTable.this).adjuster.frozenRows) {
                Lun lun = LunWWNTable.this.lunArray[n];
                NameList nameList = new NameList();
                nameList.nlID = lun.lunDaID;
                nameList.nlName = lun.lunDaAlias;
                nameList.nlID2 = lun.lunOSType;
                new LogicalUnitDDI(null, lun.lunID, nameList, lun.lunName);
            }
        }
    }
}

