/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.LogicalVolumeAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String GRAPH_SIZE_SEL = "STG1251T";
    public static final String GRAPH_SIZE = "STG7528L";
    public static final String GRAPH_SIZE_ALL = "STG1276T";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String USED_HIST = "STG5107L";
    public static final String USED_PERCENT_HIST = "STG5108L";
    public static final String FREE_HIST_ALL = "STG7530L";
    public static final String FREE_PCT_HIST_ALL = "STG7531L";
    public static final String USED_HIST_ALL = "STG7537L";
    public static final String USED_PCT_HIST_ALL = "STG7538L";

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        this.title = guiReportReq.histSubtype == 1 ? FREE_HIST : (guiReportReq.histSubtype == 2 ? FREE_PERCENT_HIST : (guiReportReq.histSubtype == 3 ? USED_HIST : USED_PERCENT_HIST));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        AperiChart aperiChart = null;
        if (guiReportReq.chartSubtype > 0) {
            aperiChart = this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, this.title);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        Share[] shareArray = (Share[])objectArray;
        LogicalVolumeAdjuster logicalVolumeAdjuster = (LogicalVolumeAdjuster)reportDataAdjuster;
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (shareArray[nArray[n2]].shFilesystem.fsID > 0) {
                ++n;
            }
            ++n2;
        }
        Number[][] numberArray = new Number[2][n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[]{LogicalVolumeAdjuster.USED, LogicalVolumeAdjuster.FREE};
        n = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            Share share = shareArray[nArray[n3]];
            if (share.shFilesystem.fsID > 0) {
                numberArray[0][n3] = new Long(share.shFilesystem.fsUsedSpace);
                numberArray[1][n3] = new Long(share.shFilesystem.fsFreeSpace);
                stringArray[n3] = String.valueOf(share.shComputerName) + " - " + share.shFilesystem.fsMountPoint;
            }
            ++n3;
        }
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, numberArray, stringArray2, stringArray, new ChartOptions(), guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        return aperiCustomizableChart;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, String string) {
        Share[] shareArray = (Share[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (shareArray[nArray[n2]].shFilesystem.fsID > 0) {
                ++n;
            }
            ++n2;
        }
        guiReportReq2.selectedResources = new int[n];
        int n3 = 0;
        while (n3 < nArray.length) {
            Share share = shareArray[nArray[n3]];
            int n4 = share.shFilesystem.fsID;
            if (n4 > 0) {
                guiReportReq2.selectedResources[n3] = n4;
                SpaceHistChart.addLegend(guiReportReq2, share.shComputerName, share.shFilesystem.fsMountPoint, n4);
            }
            ++n3;
        }
        if (string == FREE_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = 1;
            guiReportReq2.historyTitle = "STG5111L";
        } else if (string == FREE_PERCENT_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)2;
            guiReportReq2.historyTitle = "STG5112L";
        } else if (string == USED_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = (byte)3;
            guiReportReq2.historyTitle = "STG1278T";
        } else {
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.histSubtype = (byte)4;
            guiReportReq2.historyTitle = "STG5110L";
        }
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        return guiReportReq2;
    }
}

