/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.eclipse.aperi.TStorm.common.BatchGraphInterface;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.BasicSocketClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class MakeBatchGraph
implements BatchGraphInterface {
    static final String CREATED_BY = MessageLog.getMessageNoID("GEN0192L");
    static final String PRINTED = MessageLog.getMessageNoID("GEN0193L");
    public static final Color BLUE_GREEN = new Color(64, 204, 204);
    public static final Color DUSTY_ROSE = new Color(204, 102, 102);

    public int makeGraph(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster, Object[] objectArray, FileOutputStream fileOutputStream, String string, byte by, String string2, BatchReport batchReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.MakeBatchGraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeGraph", "grr, adjuster, dataArray, stream, fileName, reportType, creator, batchReport");
        }
        int n = 8;
        GuiChartSettingsReq guiChartSettingsReq = new GuiChartSettingsReq();
        guiChartSettingsReq.reportId = guiReportReq.reportType;
        guiChartSettingsReq.reportSubtype = guiReportReq.reportSubtype;
        if (guiReportReq.histSubtype > 0) {
            guiChartSettingsReq.chartId = guiReportReq.histSubtype;
            guiChartSettingsReq.chartSubtype = guiReportReq.histSubtypeRange;
        } else {
            guiChartSettingsReq.chartId = guiReportReq.chartSubtype;
        }
        guiChartSettingsReq.creator = string2;
        guiChartSettingsReq.batchId = batchReport.reportID;
        guiChartSettingsReq.reqType = 4;
        guiChartSettingsReq.options = null;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        request.userName = string2;
        request.flags = (byte)4;
        request.requestData = guiChartSettingsReq;
        Response response = null;
        try {
            response = BasicSocketClient.sendRequest(request, Variables.server, Variables.port);
        }
        catch (Exception exception) {
            response = new Response(12, null);
            response.errorMessage = exception.getMessage();
        }
        if (response == null || response.status > 4) {
            MessageLog.logMessage("AGT0151E");
        } else {
            Object object;
            Serializable serializable;
            guiChartSettingsReq = (GuiChartSettingsReq)response.responseData;
            ChartOptions chartOptions = guiChartSettingsReq.options;
            String string3 = null;
            Grapher grapher = null;
            try {
                string3 = GuiReportReq.guiClasses[guiReportReq.reportType][6];
                serializable = Class.forName(string3);
                object = new Class[]{};
                Constructor<?> constructor = serializable.getConstructor((Class<?>[])object);
                Object[] objectArray2 = new Object[]{};
                grapher = (Grapher)constructor.newInstance(objectArray2);
            }
            catch (Exception exception) {
                object = new Object[]{string3};
                MessageLog.logMessage("STA2009E", object);
                System.err.println(exception);
                exception.printStackTrace();
            }
            if (grapher != null) {
                serializable = new PrintOptions();
                if (serializable != null) {
                    int n2;
                    int[] nArray;
                    int n3;
                    int n4;
                    object = grapher.getChartType(guiReportReq, reportDataAdjuster);
                    if (chartOptions != null) {
                        object = chartOptions.title;
                        if (grapher.suffix != null) {
                            object = String.valueOf(object) + " - " + grapher.suffix;
                        }
                    }
                    if (object == null) {
                        object = String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2])) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0]);
                    }
                    ((PrintOptions)serializable).outputType = (byte)3;
                    ((PrintOptions)serializable).fileName = string;
                    ((PrintOptions)serializable).title = object;
                    if (string2 != null) {
                        ((PrintOptions)serializable).creator = string2;
                    }
                    int n5 = objectArray.length;
                    if (guiReportReq.chartSubtype == 0) {
                        String cfr_ignored_0 = String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2])) + " " + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0]);
                        n4 = chartOptions != null && chartOptions.chartsPerView > 0 ? chartOptions.chartsPerView : 10;
                    } else {
                        n4 = grapher.graphsPerPage(guiReportReq);
                        if (n4 < 0) {
                            n4 = 2;
                        }
                        if ((n3 = grapher.isOtherTypeReport(0)) != 0) {
                            n4 = chartOptions != null && chartOptions.seriesPerChart > 0 ? chartOptions.seriesPerChart : 12;
                            grapher.isOtherTypeReport(n4);
                        } else if (chartOptions != null && chartOptions.chartsPerView > 0) {
                            n4 = chartOptions.chartsPerView;
                        }
                    }
                    n3 = n5 - n4;
                    boolean bl = false;
                    int n6 = 0;
                    boolean bl2 = grapher.isOtherTypeReport(n4);
                    if (bl2) {
                        nArray = new int[n5];
                        n2 = 0;
                        while (n2 < n5) {
                            nArray[n2] = n2;
                            ++n2;
                        }
                    } else {
                        nArray = new int[n4];
                    }
                    while (n6 < n5) {
                        AperiChart aperiChart;
                        if (!bl2) {
                            if (n6 > n3) {
                                n4 = n5 - n6;
                                nArray = new int[n4];
                            }
                            n2 = 0;
                            while (n2 < n4) {
                                nArray[n2] = n6++;
                                ++n2;
                            }
                        }
                        if ((aperiChart = grapher.processBatch(guiReportReq, objectArray, nArray, reportDataAdjuster, guiChartSettingsReq)) == null) {
                            if (!bl2) continue;
                            break;
                        }
                        bl = true;
                        ((PrintOptions)serializable).defaultWidth = 800;
                        ((PrintOptions)serializable).defaultHeight = 500;
                        ((PrintOptions)serializable).htmlChart = aperiChart;
                        if (by == 8) continue;
                        PrintComponent.print(serializable, null, ((PrintOptions)serializable).creator, (String)object, (String)object, true);
                    }
                    n = bl ? 0 : 4;
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.MakeBatchGraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeGraph", n);
        }
        return n;
    }
}

