/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.JobChangeListener;
import org.eclipse.aperi.gui.JobChangeManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class EditableJobHistoryNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor,
JobChangeListener {
    protected static final String RUN_NOW = "R";
    private static final String EDIT = "E";
    private static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private static final String UPDATE = "U";
    private JMenuItem runNow;
    private JMenuItem edit;
    private JMenuItem history;
    private JMenuItem refresh;
    private JMenuItem update;
    private String label;
    private String labelMsgID;
    private String submitMsgID;
    private int scheduleID;
    private short resourceType;
    private int adminType;
    public JPopupMenu menu;

    protected abstract NameListToTreeNode getNameListToTreeNode();

    public EditableJobHistoryNode(String string, String string2, short s, int n) {
        this(string, string2, s, n, 5);
    }

    public EditableJobHistoryNode(String string, String string2, short s, int n, int n2) {
        super(MessageLog.getMessageNoID(string), true);
        this.labelMsgID = string;
        this.submitMsgID = string2;
        this.scheduleID = n;
        this.resourceType = s;
        this.adminType = n2;
        this.label = MessageLog.getMessageNoID(string);
        String string3 = MessageLog.getMessageNoID("JSS1002L");
        this.runNow = new JMenuItem(string3);
        this.runNow.setName(string3);
        this.runNow.setActionCommand(RUN_NOW);
        this.runNow.addActionListener(this);
        this.runNow.setEnabled(this.capabilities.adminCapable(n2));
        string3 = MessageLog.getMessageNoID("GUI0052L");
        this.history = new JMenuItem(string3);
        this.history.setName(string3);
        this.history.setActionCommand(HISTORY);
        this.history.addActionListener(this);
        string3 = Util.getString("REFRESH_JOB_LIST");
        this.refresh = new JMenuItem(string3);
        this.refresh = new JMenuItem(string3);
        this.refresh.setActionCommand(REFRESH);
        this.refresh.addActionListener(this);
        string3 = Util.getString("UPDATE_JOB_STATUS");
        this.update = new JMenuItem(string3);
        this.update.setActionCommand(UPDATE);
        this.update.addActionListener(this);
        if (GuiUtil.isDiscoveryNode(s)) {
            JobChangeManager.addListener(this, s);
        }
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.menu = this.getPopupMenu();
        this.menu.add(this.refresh);
        this.menu.add(this.update);
        this.menu.add(this.history);
        this.menu.add(this.runNow);
        if (mouseEvent != null) {
            this.showPopupMenu(this.menu, mouseEvent);
        }
    }

    private void submitToRun() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
        request.flags = (byte)4;
        NameList nameList = new NameList();
        nameList.nlID = this.scheduleID;
        nameList.nlInfo = this.resourceType;
        request.requestData = nameList;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s > 4) {
                    return;
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = MessageLog.getMessageNoID(EditableJobHistoryNode.this.submitMsgID);
                Object[] objectArray2 = objectArray;
                JSgcScheduleCreateWhenData.displayJobSubmittedMessage(objectArray2);
                EditableJobHistoryNode.this.expand(null);
            }
        }, request);
    }

    protected abstract void createEditor();

    public void sendRefreshRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        schHistoryRequestNode.queryType = 1;
        schHistoryRequestNode.queryID = this.scheduleID;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void sendUpdateRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        Request request = new Request();
        schHistoryRequestNode.queryID = this.scheduleID;
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.UpdateJobStatusHndlr";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        EditableObjectLabel.refresh(this, response, this.getNameListToTreeNode());
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            DataDisplayInfo dataDisplayInfo2 = baseTreeNode.ddi;
            if (dataDisplayInfo2 == null) continue;
            dataDisplayInfo2.nullOutPanel();
            if (dataDisplayInfo2 != dataDisplayInfo) continue;
            dataDisplayInfo2.reDisplay();
        }
    }

    protected abstract void makeRunDDI();

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == RUN_NOW) {
            this.submitToRun();
        } else if (string == EDIT) {
            this.createEditor();
        } else if (string == HISTORY) {
            this.makeRunDDI();
        } else if (string == REFRESH) {
            this.sendRefreshRequest();
        } else if (string == UPDATE) {
            this.sendUpdateRequest();
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.createEditor();
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0 || GuiUtil.isDiscoveryNode(this.resourceType) && (treeExpansionEvent != null || BaseTree.pBaseTree.isExpanded(new TreePath(this.getPath())))) {
            this.sendRefreshRequest();
        }
    }

    public int getAdminType() {
        return this.adminType;
    }

    public void setAdminType(int n) {
        this.adminType = n;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelMsgID() {
        return this.labelMsgID;
    }

    public void setLabelMsgID(String string) {
        this.labelMsgID = string;
    }

    public short getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(short s) {
        this.resourceType = s;
    }

    public int getScheduleID() {
        return this.scheduleID;
    }

    public void setScheduleID(int n) {
        this.scheduleID = n;
    }

    public String getSubmitMsgID() {
        return this.submitMsgID;
    }

    public void setSubmitMsgID(String string) {
        this.submitMsgID = string;
    }

    public void jobChangeOccurred(int n, NameList nameList) {
        this.expand(null);
    }
}

