/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.FabricDiscoveryOptions;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.IPScanListEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;

public class FabricOptionsEditor
extends JPanel {
    private JLabel defaultCommunityLabel;
    private JTextField defaultCommunity;
    private JLabel scanTimeoutLabel;
    private JTextField scanTimeout;
    private JLabel scanUnitsLabel;
    private JLabel baseIPAddressLabel;
    private IPScanListEditor ipAddresses;
    private JLabel userNameLabel;
    private JTextField userName;
    private JLabel passwordLabel;
    private JPasswordField password;
    private boolean panelBuilt;
    private FabricDiscoveryOptions options;
    private ProbePing schedule;
    private String defaultTimeout = "500";

    public FabricOptionsEditor(ProbePing probePing) {
        this.options = new FabricDiscoveryOptions(probePing.arguments);
        this.schedule = probePing;
    }

    public Component getComponent() {
        if (this.panelBuilt) {
            return this;
        }
        String string = Util.getString("SNMP_DEFAULT_COMMUNITY");
        this.defaultCommunityLabel = new BlackLabel(string);
        this.defaultCommunity = TTextField.newTTextField(null, 12, 64, false);
        TextUtil.setText(this.defaultCommunity, this.options.getDefaultCommunity());
        GuiUtil.setAccessibleLabel(this.defaultCommunityLabel, this.defaultCommunity, "", this.defaultCommunityLabel.getText(), this.defaultCommunityLabel.getText());
        string = Util.getString("SNMP_SCAN_TIMEOUT");
        this.scanTimeoutLabel = new BlackLabel(string);
        this.scanTimeout = TTextField.newTTextField(null, 8, 64, true);
        String string2 = this.options.getScanTimeoutString();
        if (Util.isEmpty(string2)) {
            TextUtil.setText(this.scanTimeout, this.defaultTimeout);
        } else {
            TextUtil.setText(this.scanTimeout, string2);
        }
        GuiUtil.setAccessibleLabel(this.scanTimeoutLabel, this.scanTimeout, "", this.scanTimeoutLabel.getText(), this.scanTimeoutLabel.getText());
        string = Util.getString("MILLISECS");
        this.scanUnitsLabel = new BlackLabel(string);
        string = Util.getString("BASE_IP_ADDRESSES");
        this.ipAddresses = new IPScanListEditor(this.schedule.pbSnmpIPAddresses, string);
        string = Util.getString("LABEL_USERNAME");
        this.userNameLabel = new BlackLabel(string);
        string = this.schedule.pbBrocadeUserName;
        this.userName = TTextField.newTTextField(null, 12, 64, false);
        TextUtil.setText(this.userName, this.options.getUserName());
        GuiUtil.setAccessibleLabel(this.userNameLabel, this.userName, "", this.userNameLabel.getText(), this.userNameLabel.getText());
        string = Util.getString("LABEL_PASSWORD");
        this.passwordLabel = new BlackLabel(string);
        string = this.schedule.pbBrocadePassword;
        this.password = new JPasswordField(12);
        TextUtil.setText(this.password, this.options.getPasword());
        GuiUtil.setAccessibleLabel(this.passwordLabel, this.password, "", this.passwordLabel.getText(), this.passwordLabel.getText());
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(Util.getString("SNMP_PARAMETERS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.top = 4;
        gridBagConstraints2.insets.left = 4;
        gridBagConstraints2.insets.bottom = 4;
        gridBagConstraints2.insets.right = 4;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        jPanel.add((Component)this.defaultCommunityLabel, gridBagConstraints);
        jPanel.add((Component)this.defaultCommunity, gridBagConstraints2);
        GuiUtil.completePanel(jPanel);
        JPanel jPanel2 = GuiUtil.getTitledBorderedPanel(Util.getString("SNMP_ADDRESS_SCAN"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets.top = 4;
        gridBagConstraints3.insets.left = 4;
        gridBagConstraints3.insets.bottom = 4;
        gridBagConstraints3.insets.right = 4;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridwidth = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.scanTimeoutLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.scanTimeout);
        jPanel5.add(this.scanUnitsLabel);
        jPanel4.add((Component)jPanel5, gridBagConstraints2);
        jPanel3.add(jPanel4);
        jPanel3.add(this.ipAddresses.getComponent());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets.top = 4;
        gridBagConstraints4.insets.left = 4;
        gridBagConstraints4.insets.bottom = 4;
        gridBagConstraints4.insets.right = 4;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridwidth = -1;
        jPanel2.add((Component)jPanel3, gridBagConstraints4);
        GuiUtil.completePanel(jPanel2);
        JPanel jPanel6 = GuiUtil.getPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        GuiUtil.completePanel(jPanel6);
        this.setPanelSize(jPanel6);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel6, "North");
        this.panelBuilt = true;
        return this;
    }

    private void setPanelSize(JPanel jPanel) {
        int n = (int)jPanel.getMaximumSize().getWidth();
        int n2 = (int)jPanel.getMaximumSize().getHeight();
        jPanel.setMaximumSize(new Dimension(n, n2));
    }

    public String getArgumentsData() {
        this.options.setScanTimeout(this.scanTimeout.getText());
        this.options.setDefaultCommunity(this.defaultCommunity.getText());
        this.options.setUserName(this.userName.getText());
        String string = new String(this.password.getPassword());
        this.options.setPasswordStr(string);
        return this.options.getOptionsString();
    }

    public String getEncryptedArgumentsData() {
        this.options.setScanTimeout(this.scanTimeout.getText());
        this.options.setDefaultCommunity(this.defaultCommunity.getText());
        this.options.setUserName(this.userName.getText());
        String string = new String(this.password.getPassword());
        this.options.setPassword(string);
        return this.options.getOptionsString();
    }

    public NameList getAddressesData() {
        return this.ipAddresses.getData();
    }
}

