/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    protected NameList computer;
    protected int diskID;
    protected int volgroupID;

    public LogicalVolumeTreeLabel(NameList nameList, int n, int n2) {
        this.computer = nameList;
        this.diskID = n;
        this.volgroupID = n2;
        if (nameList.nlID2 == 23) {
            this.setUserObject(MessageLog.getMessageNoID("STG1045L"));
        } else {
            this.setUserObject(MessageLog.getMessageNoID("STG1005L"));
        }
    }

    public LogicalVolumeTreeLabel(NameList nameList, int n) {
        this(nameList, n, -1);
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.logicalVolumeList(request, this.computer.nlID, this.diskID);
            GuiListReq guiListReq = (GuiListReq)request.requestData;
            guiListReq.groupID = this.volgroupID;
            GuiClient.doRequest(this, request);
        }
    }

    protected BaseTreeNode makeChild(NameList nameList) {
        return new LogicalVolumeTreeNode(nameList.nlID, nameList.nlName, nameList.nlName2, nameList.nlID2, this.computer);
    }

    public void handleResponse(short s, Response response) {
        NameList nameList = null;
        NameList nameList2 = null;
        NameList nameList3 = null;
        if (s <= 4) {
            nameList = (NameList)response.responseData;
        }
        if (Constants.isDiskArray((short)this.computer.nlID2)) {
            while (nameList != null) {
                nameList3 = nameList.nlNext;
                nameList.nlNext = nameList2;
                nameList2 = nameList;
                nameList = nameList3;
            }
            nameList = nameList2;
        }
        while (nameList != null) {
            this.add(this.makeChild(nameList));
            nameList = nameList.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }
}

