/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.DataReportColumnSelector;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ReportColumnSelector
implements ListSelectionListener,
ActionListener,
ListCellRenderer,
Comparator {
    private static final char ADD = 'A';
    private static final char REMOVE = '-';
    private static final char UP = 'U';
    private static final char DOWN = 'D';
    private static final char RESET = 'R';
    private Container panel;
    private Container wrhPanel;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    protected JList availableList;
    protected DefaultListModel availableModel;
    private JList selectedList;
    protected DefaultListModel selectedModel;
    private ListCellRenderer renderer;
    private int frozenColumns;
    protected CustomReportDataAdjuster adjuster;
    protected GuiReportReq grr;
    private boolean selectionMightRecurse;

    public static ReportColumnSelector createInstance(GuiReportReq guiReportReq, CustomReportDataAdjuster customReportDataAdjuster) {
        DataReportColumnSelector dataReportColumnSelector = null;
        dataReportColumnSelector = new DataReportColumnSelector(guiReportReq, customReportDataAdjuster);
        return dataReportColumnSelector;
    }

    protected ReportColumnSelector(GuiReportReq guiReportReq, CustomReportDataAdjuster customReportDataAdjuster) {
        this.grr = guiReportReq;
        this.constructModels(customReportDataAdjuster);
        this.selectedList = new JList(this.selectedModel);
        this.renderer = this.selectedList.getCellRenderer();
        this.selectedList.setCellRenderer(this);
        this.selectedList.addListSelectionListener(this);
        this.availableList = new JList(this.availableModel);
        this.availableList.addListSelectionListener(this);
        this.wrhPanel = new JPanel();
        this.wrhPanel.setLayout(new BorderLayout());
        Container container = ReportColumnSelector.makeListPanel(this.availableList, "STG3248L");
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.left = 13;
        gridBagConstraints.insets.top = 10;
        this.panel.add((Component)container, gridBagConstraints);
        this.addButton = new JButton(">>");
        this.addButton.setActionCommand(ReportingSelectionDriver.charToString('A'));
        this.removeButton = new JButton("<<");
        this.removeButton.setActionCommand(ReportingSelectionDriver.charToString('-'));
        container = this.makeButtonPanel(this.addButton, this.removeButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 0;
        this.panel.add((Component)container, gridBagConstraints);
        container = ReportColumnSelector.makeListPanel(this.selectedList, "STG3262L");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)container, gridBagConstraints);
        ImageIcon imageIcon = IconFactory.getUpIcon();
        this.upButton = new JButton(imageIcon);
        this.upButton.setActionCommand(ReportingSelectionDriver.charToString('U'));
        imageIcon = IconFactory.getDownIcon();
        this.downButton = new JButton(imageIcon);
        this.downButton.setActionCommand(ReportingSelectionDriver.charToString('D'));
        container = this.makeButtonPanel(this.upButton, this.downButton);
        String string = MessageLog.getMessageNoID("STG1154L");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(string);
        Dimension dimension = jButton.getPreferredSize();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add(Box.createVerticalStrut(dimension.height), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)container, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        jButton.setActionCommand(ReportingSelectionDriver.charToString('R'));
        jButton.addActionListener(this);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.weightx = 0.0;
        this.panel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add(jButton);
        this.wrhPanel.add((Component)jPanel, "South");
        this.wrhPanel.add((Component)this.panel, "Center");
    }

    public void refresh(CustomReportDataAdjuster customReportDataAdjuster) {
        this.constructModels(customReportDataAdjuster);
        this.selectedList.setModel(this.selectedModel);
        this.availableList.setModel(this.availableModel);
    }

    private void constructModels(CustomReportDataAdjuster customReportDataAdjuster) {
        Object object;
        this.adjuster = customReportDataAdjuster;
        this.selectionMightRecurse = false;
        ColumnDescriptor columnDescriptor = this.adjuster.getColumnDescriptors();
        short s = -1;
        this.frozenColumns = 0;
        ColumnDescriptor columnDescriptor2 = columnDescriptor;
        while (columnDescriptor2 != null) {
            if (columnDescriptor2.cdIsFrozen && (columnDescriptor2.cdTwin == null || columnDescriptor2.cdTwin == columnDescriptor2.cdNext)) {
                ++this.frozenColumns;
            }
            if (columnDescriptor2.cdID > s) {
                s = columnDescriptor2.cdID;
            }
            columnDescriptor2 = columnDescriptor2.cdNext;
        }
        NameList[] nameListArray = new NameList[s + 1];
        int n = 0;
        columnDescriptor2 = columnDescriptor;
        while (columnDescriptor2 != null) {
            ++n;
            if (columnDescriptor2.cdTwin == null || columnDescriptor2.cdTwin == columnDescriptor2.cdNext) {
                object = new NameList();
                object.nlID = columnDescriptor2.cdID;
                object.nlID2 = n;
                object.nlID3 = columnDescriptor2.cdTwin == null ? -1 : (int)columnDescriptor2.cdTwin.cdID;
                object.nlState = columnDescriptor2.cdIsFrozen ? (byte)1 : 0;
                object.nlName = columnDescriptor2.cdShortName;
                nameListArray[object.nlID] = object;
            }
            columnDescriptor2 = columnDescriptor2.cdNext;
        }
        object = this.grr.selectedColumns;
        if (object == null) {
            object = new int[n];
            n = 0;
            columnDescriptor2 = columnDescriptor;
            while (columnDescriptor2 != null) {
                object[n] = columnDescriptor2.cdID;
                ++n;
                columnDescriptor2 = columnDescriptor2.cdNext;
            }
        }
        n = 0;
        this.selectedModel = new DefaultListModel();
        int n2 = 0;
        while (n2 < ((int[])object).length) {
            int n3 = object[n2];
            NameList nameList = nameListArray[n3];
            if (nameList != null) {
                this.selectedModel.add(n, nameList);
                ++n;
                nameListArray[n3] = null;
            }
            ++n2;
        }
        n = 0;
        this.availableModel = new DefaultListModel();
        columnDescriptor2 = columnDescriptor;
        while (columnDescriptor2 != null) {
            NameList nameList = nameListArray[columnDescriptor2.cdID];
            if (nameList != null) {
                this.availableModel.add(n, nameList);
                ++n;
            }
            columnDescriptor2 = columnDescriptor2.cdNext;
        }
    }

    private Container makeButtonPanel(AbstractButton abstractButton, AbstractButton abstractButton2) {
        abstractButton.addActionListener(this);
        abstractButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)abstractButton, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
        abstractButton2.addActionListener(this);
        abstractButton2.setEnabled(false);
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)abstractButton2, gridBagConstraints);
        return jPanel;
    }

    private static Container makeListPanel(Component component, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 3;
        jPanel.add((Component)ReportColumnSelector.makeLabel(string), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(component);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private static JLabel makeLabel(String string) {
        String string2 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        return jLabel;
    }

    public Component getPanel() {
        return this.wrhPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.selectedList) {
            this.selectedSelectionChanged();
        } else {
            this.availableSelectionChanged();
        }
    }

    private void selectedSelectionChanged() {
        boolean bl;
        if (this.selectionMightRecurse) {
            return;
        }
        ListSelectionModel listSelectionModel = this.selectedList.getSelectionModel();
        boolean bl2 = false;
        int n = 0;
        while (!bl2 && n < this.frozenColumns) {
            if (listSelectionModel.isSelectedIndex(n)) {
                bl2 = true;
                continue;
            }
            ++n;
        }
        if (bl2) {
            this.selectionMightRecurse = true;
            listSelectionModel.removeSelectionInterval(0, this.frozenColumns - 1);
            this.selectionMightRecurse = false;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl = !listSelectionModel.isSelectionEmpty();
        if (bl) {
            n = this.selectedModel.size() - 1;
            if (n >= this.frozenColumns) {
                if (listSelectionModel.isSelectedIndex(this.frozenColumns)) {
                    bl3 = true;
                }
                if (listSelectionModel.isSelectedIndex(n)) {
                    bl4 = true;
                }
            }
            this.availableList.clearSelection();
        }
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl && !bl3);
        this.downButton.setEnabled(bl && !bl4);
    }

    private void availableSelectionChanged() {
        boolean bl;
        boolean bl2 = bl = !this.availableList.isSelectionEmpty();
        if (bl) {
            this.selectedList.clearSelection();
        }
        this.addButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        char c = actionEvent.getActionCommand().charAt(0);
        switch (c) {
            case 'A': {
                this.addPressed();
                break;
            }
            case '-': {
                this.removePressed();
                break;
            }
            case 'U': {
                this.upPressed();
                break;
            }
            case 'D': {
                this.downPressed();
                break;
            }
            case 'R': {
                this.reset();
            }
        }
    }

    private void addPressed() {
        List list = ReportColumnSelector.enumSelectedIndices(this.availableList);
        this.availableList.clearSelection();
        int n = this.selectedModel.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            Object e = this.availableModel.remove(n2);
            this.selectedModel.add(n, e);
        }
    }

    private void removePressed() {
        List list = ReportColumnSelector.enumSelectedIndices(this.selectedList);
        this.selectedList.clearSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            NameList nameList = (NameList)this.selectedModel.remove(n);
            this.addToAvailable(nameList);
        }
    }

    private void addToAvailable(NameList nameList) {
        int n = this.availableModel.size();
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < n) {
            NameList nameList2 = (NameList)this.availableModel.get(n2);
            if (nameList2.nlID2 < nameList.nlID2) {
                ++n2;
                continue;
            }
            bl = false;
        }
        this.availableModel.add(n2, nameList);
    }

    private void downPressed() {
        List list = ReportColumnSelector.enumSelectedRanges(this.selectedList);
        this.selectedList.clearSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            Object e = this.selectedModel.remove(range.last + 1);
            this.selectedModel.add(range.first, e);
        }
        ReportColumnSelector.reselect(this.selectedList, list, 1);
    }

    private void upPressed() {
        List list = ReportColumnSelector.enumSelectedRanges(this.selectedList);
        this.selectedList.clearSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            Object e = this.selectedModel.remove(range.first - 1);
            this.selectedModel.add(range.last, e);
        }
        ReportColumnSelector.reselect(this.selectedList, list, -1);
    }

    private void reset() {
        this.availableList.clearSelection();
        this.selectedList.clearSelection();
        int n = this.availableModel.size();
        int n2 = this.selectedModel.size();
        Object[] objectArray = new NameList[n + n2];
        this.selectedModel.copyInto(objectArray);
        while (n > 0) {
            objectArray[n2 + --n] = (NameList)this.availableModel.getElementAt(n);
        }
        Arrays.sort(objectArray, this);
        this.selectedModel = new DefaultListModel();
        n2 = 0;
        while (n2 < objectArray.length) {
            this.selectedModel.add(n2, objectArray[n2]);
            ++n2;
        }
        this.selectedList.setModel(this.selectedModel);
        this.availableModel.clear();
    }

    private static void reselect(JList jList, List list, int n) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            listSelectionModel.addSelectionInterval(range.first + n, range.last + n);
        }
    }

    private static List enumSelectedRanges(JList jList) {
        Range range = null;
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        LinkedList<Range> linkedList = new LinkedList<Range>();
        int n = jList.getModel().getSize();
        int n2 = 0;
        while (n2 < n) {
            if (listSelectionModel.isSelectedIndex(n2)) {
                if (range != null) {
                    range.last = n2;
                } else {
                    range = new Range(n2);
                }
            } else if (range != null) {
                linkedList.add(range);
                range = null;
            }
            ++n2;
        }
        if (range != null) {
            linkedList.add(range);
        }
        return linkedList;
    }

    private static List enumSelectedIndices(JList jList) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = jList.getModel().getSize();
        while (n > 0) {
            if (!listSelectionModel.isSelectedIndex(--n)) continue;
            linkedList.add(new Integer(n));
        }
        return linkedList;
    }

    protected abstract void setSelectedColumns() throws GeneralException;

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = n < this.frozenColumns;
        if (bl3) {
            bl2 = false;
        }
        Component component = this.renderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (bl3) {
            component.setEnabled(false);
        }
        return component;
    }

    public void setEnabled(boolean bl, CustomReportDataAdjuster customReportDataAdjuster) {
        this.availableList.setEnabled(bl);
        this.selectedList.setEnabled(bl);
        this.refresh(customReportDataAdjuster);
    }

    public int compare(Object object, Object object2) {
        NameList nameList = (NameList)object;
        NameList nameList2 = (NameList)object2;
        return nameList.nlID2 - nameList2.nlID2;
    }

    static class Range {
        public int first;
        public int last;

        public Range(int n) {
            this.first = n;
            this.last = n;
        }
    }
}

