/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportColumnSelector;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTableDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.ReportFilterDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingSelectionDriver
extends JPanel
implements ActionListener,
ItemListener {
    private static final char GENERATE = 'G';
    private static final char USE_TIME_RANGE = 'T';
    private static final char SELECTION = 'S';
    private static final char FILTER = 'F';
    private ReportingSelectionTableDialog rowSelector;
    private ReportColumnSelector columnSelector;
    private ReportDataAdjuster adjuster;
    ReportingDDI ddi;
    GuiReportReq grr;
    int selectionServices;
    JButton generateButton;
    JButton selectionButton;
    JButton filterButton;
    JTextField numberRows;
    JCheckBox useTimeRange;
    JComboBox diskArrayChoices;
    DateSelector startDate;
    DateSelector endDate;
    String beforeText;
    String afterText;
    String report;
    Object[] userName = new Object[]{MessageLog.getMessageNoID("STG2019L")};
    Object[] objectName;
    Object[] errorName;
    int userType;
    boolean usersFirst;
    boolean usersLast;
    boolean usingTimes;
    private static final IntToString[] diskArrayCompViews = new IntToString[]{new IntToString(74, "STG4197L"), new IntToString(75, "STG7743L"), new IntToString(76, "STG1004L")};
    private static final IntToString[] diskArrayDiskViews = new IntToString[]{new IntToString(12, "STG1017L"), new IntToString(73, "STG4199L")};
    private static final int TOP_MARGIN = 4;
    private static final int LEFT_MARGIN = 6;

    public ReportingSelectionDriver(ReportingDDI reportingDDI, GuiReportReq guiReportReq, int n, Object[] objectArray) {
        Object object;
        this.ddi = reportingDDI;
        this.grr = guiReportReq;
        this.selectionServices = n;
        this.objectName = objectArray;
        this.columnSelector = null;
        this.rowSelector = null;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "North");
        if (this.adjuster instanceof CustomReportDataAdjuster) {
            object = this.makeCustomAdjuster();
            this.columnSelector = ReportColumnSelector.createInstance(guiReportReq, (CustomReportDataAdjuster)object);
            this.add(this.columnSelector.getPanel(), "Center");
            this.add(Box.createVerticalStrut(10), "South");
        }
        if ((object = this.adjuster.getHelpID()) != null && this.ddi != null) {
            this.ddi.helpID = object;
        }
    }

    private JPanel getPanel() {
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 4);
        Insets insets2 = new Insets(0, 0, 0, 0);
        Insets insets3 = new Insets(0, 0, 0, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets3;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = insets2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(GuiUtil.getBorder(MessageLog.getMessageNoID("STG5009L")));
        jPanel2.setLayout(new BorderLayout());
        this.adjuster = this.makeAdjuster();
        if (this.adjuster == null) {
            return null;
        }
        JPanel jPanel3 = GuiUtil.getPanel();
        this.generateButton = new JButton(MessageLog.getMessageNoID("STG5053L"));
        GuiUtil.setAccessible(this.generateButton, this.generateButton.getText(), this.generateButton.getText());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets.bottom = 6;
        gridBagConstraints4.gridheight = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 1.0;
        jPanel3.add((Component)this.generateButton, gridBagConstraints4);
        String string = MessageLog.getMessageNoID("STG3263L");
        this.selectionButton = new JButton(string);
        this.rowSelector = new ReportingSelectionTableDialog(this, this.grr, this.objectName);
        this.selectionButton.setEnabled(this.rowSelector.mainPanel != null);
        gridBagConstraints4.weightx = 0.0;
        if (this.adjuster instanceof CustomReportDataAdjuster) {
            gridBagConstraints4.insets.right = 3;
            jPanel3.add((Component)this.selectionButton, gridBagConstraints4);
            string = MessageLog.getMessageNoID("STG3264L");
            this.filterButton = new JButton(string);
            gridBagConstraints4.insets.right = 10;
            gridBagConstraints4.gridwidth = 0;
            jPanel3.add((Component)this.filterButton, gridBagConstraints4);
            if (this.selectionServices == 4) {
                this.selectionButton.setEnabled(false);
            }
            this.setFilterButtonIcon();
        } else {
            gridBagConstraints4.insets.right = 10;
            gridBagConstraints4.gridwidth = 0;
            jPanel3.add((Component)this.selectionButton, gridBagConstraints4);
        }
        if (this.ddi == null) {
            this.generateButton.setEnabled(false);
        }
        this.setSelectionButtonIcon();
        jPanel2.add((Component)jPanel3, "North");
        if (this.selectionServices == 2) {
            jPanel = GuiUtil.getPanel();
            string = MessageLog.getMessageNoID("STG4081L");
            this.useTimeRange = new JCheckBox(string);
            GuiUtil.setAccessible(this.useTimeRange, string, string);
            long l = System.currentTimeMillis();
            this.startDate = new DateSelector(l);
            this.endDate = new DateSelector(l);
            if (this.grr.startTime > 0L) {
                this.startDate.setDate(this.grr.startTime);
                this.endDate.setDate(this.grr.endTime);
                this.usingTimes = true;
            }
            this.useTimeRange.setSelected(this.usingTimes);
            this.startDate.setEnabled(this.usingTimes);
            this.endDate.setEnabled(this.usingTimes);
            serializable2 = new GridBagConstraints();
            serializable2.insets = new Insets(4, 6, 0, 0);
            serializable2.gridwidth = 0;
            serializable2.anchor = 17;
            jPanel.add((Component)this.useTimeRange, serializable2);
            serializable = new JLabel(MessageLog.getMessageNoID("STG4082L"));
            serializable2.gridwidth = 1;
            jPanel.add((Component)serializable, serializable2);
            serializable2.gridwidth = 0;
            jPanel.add((Component)this.startDate, serializable2);
            serializable = new JLabel(MessageLog.getMessageNoID("STG4083L"));
            serializable2.gridwidth = 1;
            jPanel.add((Component)serializable, serializable2);
            serializable2.gridwidth = 0;
            jPanel.add((Component)this.endDate, serializable2);
            GuiUtil.completePanel(jPanel);
            jPanel2.add((Component)jPanel, "Center");
        }
        if (this.selectionServices == 3) {
            jPanel2.add((Component)this.getDiskArrayChoices(), "Center");
        } else if (this.selectionServices < 1 && this.selectionServices != 4) {
            jPanel = GuiUtil.getPanel();
            this.beforeText = MessageLog.getMessageNoID("STG5055L");
            switch (this.grr.reportSubtype) {
                case 8: {
                    this.afterText = "STG4142L";
                    break;
                }
                case 9: {
                    this.afterText = "STG4143L";
                    break;
                }
                case 10: {
                    this.afterText = "STG4137L";
                    break;
                }
                case 11: {
                    this.afterText = "STG4138L";
                    break;
                }
                case 12: {
                    this.afterText = "STG4139L";
                    break;
                }
                case 13: {
                    this.afterText = "STG4140L";
                    break;
                }
                case 14: {
                    this.afterText = "STG4141L";
                    break;
                }
                case 6: {
                    this.afterText = "STG4144L";
                    break;
                }
                case 82: {
                    this.afterText = "STG4244L";
                    break;
                }
                default: {
                    this.afterText = "STG5056L";
                }
            }
            this.afterText = " " + MessageLog.getMessageNoID(this.afterText);
            JLabel jLabel = new JLabel(this.beforeText);
            this.numberRows = new JTextField(5);
            JLabel jLabel2 = new JLabel(this.afterText);
            serializable2 = new JLabel(" ");
            GuiUtil.setAccessibleLabel(jLabel, this.numberRows, "MNEMONIC_BEFORELABEL", "NAME_BEFORELABEL", "DESCRIPTION_BEFORELABEL");
            serializable = new SizeLimitedDocument(5, true);
            this.numberRows.setDocument((Document)((Object)serializable));
            if (this.grr.profile == 0) {
                ReportPrefs reportPrefs = ReportPrefsManager.getOne(this.grr.reportType);
                switch (this.grr.reportSubtype) {
                    case 8: {
                        this.grr.rowsToReturn = reportPrefs.rpDirMaxRows;
                        break;
                    }
                    case 9: {
                        this.grr.rowsToReturn = reportPrefs.rpDirGrpMaxRows;
                        break;
                    }
                    case 10: {
                        this.grr.rowsToReturn = reportPrefs.rpFSMaxRows;
                        break;
                    }
                    case 11: {
                        this.grr.rowsToReturn = reportPrefs.rpFSGrpMaxRows;
                        break;
                    }
                    case 12: {
                        this.grr.rowsToReturn = reportPrefs.rpComputerMaxRows;
                        break;
                    }
                    case 13: {
                        this.grr.rowsToReturn = reportPrefs.rpCompGrpMaxRows;
                        break;
                    }
                    case 14: {
                        this.grr.rowsToReturn = reportPrefs.rpDomMaxRows;
                        break;
                    }
                    case 15: {
                        this.grr.rowsToReturn = reportPrefs.rpNetMaxRows;
                        break;
                    }
                    case 16: {
                        this.grr.rowsToReturn = reportPrefs.rpQuotaMaxRows;
                    }
                }
            }
            if (this.grr.rowsToReturn != 0 && this.grr.rowsToReturn != Integer.MAX_VALUE) {
                this.numberRows.setText(Integer.toString(this.grr.rowsToReturn));
            }
            jPanel.add((Component)jLabel, gridBagConstraints);
            jPanel.add((Component)this.numberRows, gridBagConstraints2);
            jPanel.add((Component)jLabel2, gridBagConstraints2);
            jPanel.add((Component)serializable2, gridBagConstraints3);
            GuiUtil.completePanel(jPanel);
            jPanel2.add((Component)jPanel, "South");
        }
        this.addListeners();
        return jPanel2;
    }

    private JComponent getDiskArrayChoices() {
        Cloneable cloneable;
        IntToString[] intToStringArray;
        JPanel jPanel = GuiUtil.getPanel();
        this.diskArrayChoices = new TComboBox();
        if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 73) {
            this.setComboBox(this.diskArrayChoices, diskArrayCompViews, 75);
            intToStringArray = diskArrayDiskViews;
        } else {
            this.setComboBox(this.diskArrayChoices, diskArrayDiskViews, 12);
            intToStringArray = diskArrayCompViews;
        }
        this.grr.bySubtype = ((IntToString)this.diskArrayChoices.getSelectedItem()).value;
        String string = null;
        int n = 0;
        while (n < intToStringArray.length) {
            cloneable = intToStringArray[n];
            if (((IntToString)cloneable).value == this.grr.reportSubtype) {
                string = MessageLog.getMessageNoID(((IntToString)cloneable).toString());
                break;
            }
            ++n;
        }
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID("STG4200L", string));
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).insets = new Insets(4, 6, 0, 0);
        ((GridBagConstraints)cloneable).gridwidth = 0;
        ((GridBagConstraints)cloneable).anchor = 17;
        jPanel.add((Component)jLabel, cloneable);
        jPanel.add((Component)this.diskArrayChoices, cloneable);
        this.diskArrayChoices.addItemListener(this);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private void setComboBox(JComboBox jComboBox, IntToString[] intToStringArray, int n) {
        intToStringArray = (IntToString[])intToStringArray.clone();
        int n2 = 0;
        while (n2 < intToStringArray.length) {
            intToStringArray[n2] = (IntToString)intToStringArray[n2].clone();
            ++n2;
        }
        IntToString.resolveNames(intToStringArray);
        if (this.grr.bySubtype <= 0) {
            this.grr.bySubtype = n;
        }
        jComboBox.removeAllItems();
        n2 = 0;
        while (n2 < intToStringArray.length) {
            jComboBox.addItem(intToStringArray[n2]);
            if (intToStringArray[n2].value == this.grr.bySubtype) {
                jComboBox.setSelectedIndex(n2);
            }
            ++n2;
        }
    }

    private void addListeners() {
        this.addButtonListener(this.generateButton, 'G');
        this.addButtonListener(this.useTimeRange, 'T');
        this.addButtonListener(this.selectionButton, 'S');
        this.addButtonListener(this.filterButton, 'F');
    }

    private void addButtonListener(AbstractButton abstractButton, char c) {
        if (abstractButton != null) {
            abstractButton.setActionCommand(ReportingSelectionDriver.charToString(c));
            abstractButton.addActionListener(this);
        }
    }

    public void getData() throws GeneralException {
        String string;
        if (this.columnSelector != null) {
            this.columnSelector.setSelectedColumns();
        }
        this.grr.rowsToReturn = Integer.MAX_VALUE;
        if (this.numberRows != null && (string = this.numberRows.getText()).length() > 0) {
            this.grr.rowsToReturn = Integer.parseInt(string);
        }
        if (this.useTimeRange != null) {
            if (this.useTimeRange.isSelected()) {
                this.grr.startTime = this.startDate.getStartOfDay();
                this.grr.endTime = this.endDate.getEndOfDay();
                if (this.grr.startTime >= this.grr.endTime) {
                    string = MessageLog.getMessageNoTS("STG4084E", null);
                    throw new GeneralException(string);
                }
            } else {
                this.grr.startTime = 0L;
                this.grr.endTime = 0L;
            }
        }
    }

    public void setPrefs() {
        try {
            this.getData();
        }
        catch (GeneralException generalException) {}
        ReportPrefs reportPrefs = ReportPrefsManager.getOne(this.grr.reportType);
        reportPrefs.rpProfileID = this.grr.profile;
        switch (this.grr.reportSubtype) {
            case 8: {
                reportPrefs.rpDirMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 9: {
                reportPrefs.rpDirGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 10: {
                reportPrefs.rpFSMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 11: {
                reportPrefs.rpFSGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 12: {
                reportPrefs.rpComputerMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 13: {
                reportPrefs.rpCompGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 14: {
                reportPrefs.rpDomMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 15: {
                reportPrefs.rpNetMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 16: {
                reportPrefs.rpQuotaMaxRows = this.grr.rowsToReturn;
            }
        }
        ReportPrefsManager.cacheOne(reportPrefs);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        char c = actionEvent.getActionCommand().charAt(0);
        switch (c) {
            case 'G': {
                try {
                    this.getData();
                }
                catch (GeneralException generalException) {
                    GuiUtil.displayException(generalException);
                    return;
                }
                this.ddi.addFirstReport(this.grr);
                break;
            }
            case 'T': {
                boolean bl = this.useTimeRange.isSelected();
                this.startDate.setEnabled(bl);
                this.endDate.setEnabled(bl);
                break;
            }
            case 'S': {
                this.rowSelector.show();
                break;
            }
            case 'F': {
                CustomReportDataAdjuster customReportDataAdjuster = this.makeCustomAdjuster();
                ReportFilterDialog reportFilterDialog = new ReportFilterDialog(this.grr, customReportDataAdjuster);
                reportFilterDialog.show();
                this.setFilterButtonIcon();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        IntToString intToString = (IntToString)this.diskArrayChoices.getSelectedItem();
        if (this.grr.bySubtype == intToString.value) {
            return;
        }
        this.grr.bySubtype = intToString.value;
        this.grr.columnFilters = null;
        this.grr.selectedColumns = null;
        CustomReportDataAdjuster customReportDataAdjuster = this.makeCustomAdjuster();
        this.columnSelector.refresh(customReportDataAdjuster);
        this.setFilterButtonIcon();
    }

    private ReportDataAdjuster makeAdjuster() {
        ReportDataAdjuster reportDataAdjuster = null;
        try {
            reportDataAdjuster = ReportDataAdjuster.makeAdjuster(this.grr);
        }
        catch (GeneralException generalException) {
            String string = generalException.getMessage().substring(15);
            GuiUtil.displayErrorMessage(string);
        }
        return reportDataAdjuster;
    }

    private CustomReportDataAdjuster makeCustomAdjuster() {
        CustomReportDataAdjuster customReportDataAdjuster = null;
        try {
            customReportDataAdjuster = ReportDataAdjuster.makeCustomAdjuster(this.grr);
        }
        catch (GeneralException generalException) {
            throw new RuntimeException(generalException.getMessage());
        }
        return customReportDataAdjuster;
    }

    public void disableRowSelectionTableButton() {
        this.selectionButton.setEnabled(false);
    }

    void setSelectionButtonIcon() {
        if (this.selectionButton != null && this.selectionButton.isEnabled()) {
            if (this.rowSelector == null) {
                return;
            }
            ImageIcon imageIcon = null;
            if (this.rowSelector.selectionChanged()) {
                imageIcon = IconFactory.getStateUreachableIcon();
            }
            this.selectionButton.setIcon(imageIcon);
            this.selectionButton.repaint();
        }
    }

    private void setFilterButtonIcon() {
        if (this.filterButton != null) {
            ImageIcon imageIcon = null;
            if (this.grr.columnFilters != null) {
                imageIcon = IconFactory.getStateUreachableIcon();
            }
            this.filterButton.setIcon(imageIcon);
            this.filterButton.repaint();
        }
    }

    public static String charToString(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }
}

